"""Initial migration

Revision ID: 821173cf9c5d
Revises:
Create Date: 2025-01-27 18:10:55.045457

"""

from typing import Sequence, Union

import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

from alembic import op

# revision identifiers, used by Alembic.
revision: str = "821173cf9c5d"
down_revision: Union[str, None] = None
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "bi_classifier_model",
        sa.Column("id", sa.Uuid(), server_default="gen_random_uuid()", nullable=False),
        sa.Column("title", sa.String(), nullable=False),
        sa.Column("binary_treshold", sa.NUMERIC(), nullable=False),
        sa.Column("lang", sa.String(), nullable=False),
        sa.Column(
            "used_since", postgresql.TIMESTAMP(), server_default="NOW()", nullable=False
        ),
        sa.PrimaryKeyConstraint("id"),
        schema="corpus_related",
    )
    op.create_table(
        "corpus",
        sa.Column("id", sa.Uuid(), server_default="gen_random_uuid()", nullable=False),
        sa.Column("source_name", sa.String(), nullable=False),
        sa.Column("is_fix", sa.Boolean(), nullable=False),
        sa.Column("binary_treshold", sa.NUMERIC(), nullable=False),
        sa.Column("is_active", sa.Boolean(), nullable=False),
        sa.PrimaryKeyConstraint("id"),
        schema="corpus_related",
    )
    op.create_table(
        "embedding_model",
        sa.Column("id", sa.Uuid(), server_default="gen_random_uuid()", nullable=False),
        sa.Column("title", sa.String(), nullable=False),
        sa.Column("lang", sa.String(), nullable=False),
        sa.PrimaryKeyConstraint("id"),
        schema="corpus_related",
    )
    op.create_table(
        "n_classifier_model",
        sa.Column("id", sa.Uuid(), server_default="gen_random_uuid()", nullable=False),
        sa.Column("title", sa.String(), nullable=False),
        sa.Column("lang", sa.String(), nullable=False),
        sa.Column("treshold_sdg_1", sa.NUMERIC(), nullable=False),
        sa.Column("treshold_sdg_2", sa.NUMERIC(), nullable=False),
        sa.Column("treshold_sdg_3", sa.NUMERIC(), nullable=False),
        sa.Column("treshold_sdg_4", sa.NUMERIC(), nullable=False),
        sa.Column("treshold_sdg_5", sa.NUMERIC(), nullable=False),
        sa.Column("treshold_sdg_6", sa.NUMERIC(), nullable=False),
        sa.Column("treshold_sdg_7", sa.NUMERIC(), nullable=False),
        sa.Column("treshold_sdg_8", sa.NUMERIC(), nullable=False),
        sa.Column("treshold_sdg_9", sa.NUMERIC(), nullable=False),
        sa.Column("treshold_sdg_10", sa.NUMERIC(), nullable=False),
        sa.Column("treshold_sdg_11", sa.NUMERIC(), nullable=False),
        sa.Column("treshold_sdg_12", sa.NUMERIC(), nullable=False),
        sa.Column("treshold_sdg_13", sa.NUMERIC(), nullable=False),
        sa.Column("treshold_sdg_14", sa.NUMERIC(), nullable=False),
        sa.Column("treshold_sdg_15", sa.NUMERIC(), nullable=False),
        sa.Column("treshold_sdg_16", sa.NUMERIC(), nullable=False),
        sa.Column(
            "used_since", postgresql.TIMESTAMP(), server_default="NOW()", nullable=False
        ),
        sa.PrimaryKeyConstraint("id"),
        schema="corpus_related",
    )
    op.create_table(
        "keyword",
        sa.Column("id", sa.Uuid(), server_default="gen_random_uuid()", nullable=False),
        sa.Column("keyword", sa.String(), nullable=False),
        sa.Column(
            "created_at", postgresql.TIMESTAMP(), server_default="NOW()", nullable=False
        ),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint("keyword", name="keyword_unique"),
        schema="document_related",
    )
    op.create_table(
        "user_profile",
        sa.Column("id", sa.Uuid(), server_default="gen_random_uuid()", nullable=False),
        sa.Column("username", sa.String(), nullable=False),
        sa.Column("email", sa.String(), nullable=False),
        sa.Column("password_digest", sa.LargeBinary(), nullable=False),
        sa.Column(
            "created_at", postgresql.TIMESTAMP(), server_default="NOW()", nullable=False
        ),
        sa.Column(
            "updated_at", postgresql.TIMESTAMP(), server_default="NOW()", nullable=False
        ),
        sa.PrimaryKeyConstraint("id"),
        schema="user_related",
    )
    op.create_table(
        "corpus_bi_classifier_model",
        sa.Column("corpus_id", sa.Uuid(), nullable=False),
        sa.Column("bi_classifier_model_id", sa.Uuid(), nullable=False),
        sa.Column(
            "used_since", postgresql.TIMESTAMP(), server_default="NOW()", nullable=False
        ),
        sa.ForeignKeyConstraint(
            ["bi_classifier_model_id"],
            ["corpus_related.bi_classifier_model.id"],
        ),
        sa.ForeignKeyConstraint(
            ["corpus_id"],
            ["corpus_related.corpus.id"],
        ),
        sa.PrimaryKeyConstraint("corpus_id", "bi_classifier_model_id"),
        sa.UniqueConstraint(
            "corpus_id",
            "bi_classifier_model_id",
            name="unique_corpus_bi_classifier_association",
        ),
        schema="corpus_related",
    )
    op.create_table(
        "corpus_embedding_model",
        sa.Column("corpus_id", sa.Uuid(), nullable=False),
        sa.Column("embedding_model_id", sa.Uuid(), nullable=False),
        sa.ForeignKeyConstraint(
            ["corpus_id"],
            ["corpus_related.corpus.id"],
        ),
        sa.ForeignKeyConstraint(
            ["embedding_model_id"],
            ["corpus_related.embedding_model.id"],
        ),
        sa.PrimaryKeyConstraint("corpus_id", "embedding_model_id"),
        sa.UniqueConstraint(
            "corpus_id",
            "embedding_model_id",
            name="unique_corpus_embedding_association",
        ),
        schema="corpus_related",
    )
    op.create_table(
        "corpus_n_classifier_model",
        sa.Column("corpus_id", sa.Uuid(), nullable=False),
        sa.Column("n_classifier_model_id", sa.Uuid(), nullable=False),
        sa.Column(
            "used_since", postgresql.TIMESTAMP(), server_default="NOW()", nullable=False
        ),
        sa.ForeignKeyConstraint(
            ["corpus_id"],
            ["corpus_related.corpus.id"],
        ),
        sa.ForeignKeyConstraint(
            ["n_classifier_model_id"],
            ["corpus_related.n_classifier_model.id"],
        ),
        sa.PrimaryKeyConstraint("corpus_id", "n_classifier_model_id"),
        sa.UniqueConstraint(
            "corpus_id",
            "n_classifier_model_id",
            name="unique_corpus_n_classifier_association",
        ),
        schema="corpus_related",
    )
    op.create_table(
        "welearn_document",
        sa.Column("id", sa.Uuid(), server_default="gen_random_uuid()", nullable=False),
        sa.Column("url", sa.String(), nullable=False),
        sa.Column("title", sa.String(), nullable=True),
        sa.Column("lang", sa.String(), nullable=True),
        sa.Column("description", sa.String(), nullable=True),
        sa.Column("full_content", sa.String(), nullable=True),
        sa.Column("details", sa.JSON(), nullable=True),
        sa.Column("trace", sa.BIGINT(), nullable=True),
        sa.Column("corpus_id", sa.Uuid(), nullable=False),
        sa.Column(
            "created_at", postgresql.TIMESTAMP(), server_default="NOW()", nullable=False
        ),
        sa.Column(
            "updated_at", postgresql.TIMESTAMP(), server_default="NOW()", nullable=False
        ),
        sa.ForeignKeyConstraint(
            ["corpus_id"],
            ["corpus_related.corpus.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint("url", name="welearn_document_url_key"),
        schema="document_related",
    )
    op.create_table(
        "chat_message",
        sa.Column("id", sa.Uuid(), server_default="gen_random_uuid()", nullable=False),
        sa.Column("textual_content", sa.String(), nullable=False),
        sa.Column("user_id", sa.Uuid(), nullable=False),
        sa.Column(
            "created_at", postgresql.TIMESTAMP(), server_default="NOW()", nullable=False
        ),
        sa.Column(
            "updated_at", postgresql.TIMESTAMP(), server_default="NOW()", nullable=False
        ),
        sa.ForeignKeyConstraint(
            ["user_id"],
            ["user_related.user_profile.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
        schema="user_related",
    )
    op.create_table(
        "analytic_counter",
        sa.Column("id", sa.Uuid(), server_default="gen_random_uuid()", nullable=False),
        sa.Column("document_id", sa.Uuid(), nullable=False),
        sa.Column("counter_name", sa.Enum("HIT", name="counter"), nullable=False),
        sa.Column("counter_value", sa.Integer(), nullable=False),
        sa.Column(
            "created_at", postgresql.TIMESTAMP(), server_default="NOW()", nullable=False
        ),
        sa.Column(
            "updated_at", postgresql.TIMESTAMP(), server_default="NOW()", nullable=False
        ),
        sa.ForeignKeyConstraint(
            ["document_id"],
            ["document_related.welearn_document.id"],
            name="state_document_id_fkey",
        ),
        sa.PrimaryKeyConstraint("id"),
        schema="document_related",
    )
    op.create_table(
        "document_slice",
        sa.Column("id", sa.Uuid(), server_default="gen_random_uuid()", nullable=False),
        sa.Column("document_id", sa.Uuid(), nullable=False),
        sa.Column("embedding", sa.LargeBinary(), nullable=True),
        sa.Column("body", sa.String(), nullable=True),
        sa.Column("order_sequence", sa.Integer(), nullable=False),
        sa.Column("embedding_model_name", sa.String(), nullable=False),
        sa.Column("embedding_model_id", sa.Uuid(), nullable=False),
        sa.ForeignKeyConstraint(
            ["document_id"],
            ["document_related.welearn_document.id"],
            name="state_document_id_fkey",
        ),
        sa.ForeignKeyConstraint(
            ["embedding_model_id"],
            ["corpus_related.embedding_model.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
        schema="document_related",
    )
    op.create_table(
        "error_retrieval",
        sa.Column("id", sa.Uuid(), server_default="gen_random_uuid()", nullable=False),
        sa.Column("document_id", sa.Uuid(), nullable=False),
        sa.Column("http_error_code", sa.Integer(), nullable=True),
        sa.Column(
            "created_at", postgresql.TIMESTAMP(), server_default="NOW()", nullable=False
        ),
        sa.Column(
            "updated_at", postgresql.TIMESTAMP(), server_default="NOW()", nullable=False
        ),
        sa.Column("error_info", sa.String(), nullable=False),
        sa.ForeignKeyConstraint(
            ["document_id"],
            ["document_related.welearn_document.id"],
            name="state_document_id_fkey",
        ),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint(
            "document_id",
            "http_error_code",
            name="error_retrieval_document_id_http_error_code_idx",
        ),
        schema="document_related",
    )
    op.create_table(
        "process_state",
        sa.Column("id", sa.Uuid(), server_default="gen_random_uuid()", nullable=False),
        sa.Column("document_id", sa.Uuid(), nullable=False),
        sa.Column(
            "title",
            postgresql.ENUM(
                "url_retrieved",
                "document_scraped",
                "document_vectorized",
                "document_classified_sdg",
                "document_classified_non_sdg",
                "document_with_keywords",
                "document_in_qdrant",
                "document_is_invalid",
                "kept_for_trace",
                "document_is_irretrievable",
                name="step",
                schema="document_related",
            ),
            nullable=False,
        ),
        sa.Column(
            "created_at", postgresql.TIMESTAMP(), server_default="NOW()", nullable=False
        ),
        sa.Column(
            "operation_order",
            sa.BIGINT(),
            server_default="nextval('document_related.process_state_operation_order_seq",
            nullable=False,
        ),
        sa.ForeignKeyConstraint(
            ["document_id"],
            ["document_related.welearn_document.id"],
            name="state_document_id_fkey",
        ),
        sa.PrimaryKeyConstraint("id"),
        schema="document_related",
    )
    op.create_table(
        "welearn_document_keyword",
        sa.Column("id", sa.Uuid(), server_default="gen_random_uuid()", nullable=False),
        sa.Column("welearn_document_id", sa.Uuid(), nullable=False),
        sa.Column("keyword_id", sa.Uuid(), nullable=False),
        sa.ForeignKeyConstraint(
            ["keyword_id"],
            ["document_related.keyword.id"],
        ),
        sa.ForeignKeyConstraint(
            ["welearn_document_id"],
            ["document_related.welearn_document.id"],
            name="state_document_id_fkey",
        ),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint(
            "welearn_document_id",
            "keyword_id",
            name="unique_welearn_document_keyword_association",
        ),
        schema="document_related",
    )
    op.create_table(
        "bookmark",
        sa.Column("id", sa.Uuid(), server_default="gen_random_uuid()", nullable=False),
        sa.Column("document_id", sa.Uuid(), nullable=False),
        sa.Column("user_id", sa.Uuid(), nullable=False),
        sa.Column(
            "created_at", postgresql.TIMESTAMP(), server_default="NOW()", nullable=False
        ),
        sa.Column(
            "updated_at", postgresql.TIMESTAMP(), server_default="NOW()", nullable=False
        ),
        sa.ForeignKeyConstraint(
            ["document_id"],
            ["document_related.welearn_document.id"],
            name="state_document_id_fkey",
        ),
        sa.ForeignKeyConstraint(
            ["user_id"], ["user_related.user_profile.id"], name="bookmark_user_id_fkey2"
        ),
        sa.PrimaryKeyConstraint("id"),
        schema="user_related",
    )
    op.create_table(
        "returned_document",
        sa.Column("id", sa.Uuid(), server_default="gen_random_uuid()", nullable=False),
        sa.Column("message_id", sa.Uuid(), nullable=False),
        sa.Column("document_id", sa.Uuid(), nullable=False),
        sa.ForeignKeyConstraint(
            ["document_id"],
            ["document_related.welearn_document.id"],
            name="state_document_id_fkey",
        ),
        sa.ForeignKeyConstraint(
            ["message_id"],
            ["user_related.chat_message.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
        schema="user_related",
    )
    op.create_table(
        "sdg",
        sa.Column("id", sa.Uuid(), server_default="gen_random_uuid()", nullable=False),
        sa.Column("sdg_number", sa.Integer(), nullable=False),
        sa.Column("slice_id", sa.Uuid(), nullable=False),
        sa.Column(
            "created_at", postgresql.TIMESTAMP(), server_default="NOW()", nullable=False
        ),
        sa.Column("bi_classifier_model_id", sa.Uuid(), nullable=False),
        sa.Column("n_classifier_model_id", sa.Uuid(), nullable=False),
        sa.ForeignKeyConstraint(
            ["bi_classifier_model_id"],
            ["corpus_related.bi_classifier_model.id"],
        ),
        sa.ForeignKeyConstraint(
            ["n_classifier_model_id"],
            ["corpus_related.n_classifier_model.id"],
        ),
        sa.ForeignKeyConstraint(
            ["slice_id"],
            ["document_related.document_slice.id"],
            name="sdg_slice_id_fkey2",
        ),
        sa.PrimaryKeyConstraint("id"),
        schema="document_related",
    )
    op.drop_table("alembic_version")
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "alembic_version",
        sa.Column(
            "version_num", sa.VARCHAR(length=32), autoincrement=False, nullable=False
        ),
        sa.PrimaryKeyConstraint("version_num", name="alembic_version_pkc"),
    )
    op.drop_table("sdg", schema="document_related")
    op.drop_table("returned_document", schema="user_related")
    op.drop_table("bookmark", schema="user_related")
    op.drop_table("welearn_document_keyword", schema="document_related")
    op.drop_table("process_state", schema="document_related")
    op.drop_table("error_retrieval", schema="document_related")
    op.drop_table("document_slice", schema="document_related")
    op.drop_table("analytic_counter", schema="document_related")
    op.drop_table("chat_message", schema="user_related")
    op.drop_table("welearn_document", schema="document_related")
    op.drop_table("corpus_n_classifier_model", schema="corpus_related")
    op.drop_table("corpus_embedding_model", schema="corpus_related")
    op.drop_table("corpus_bi_classifier_model", schema="corpus_related")
    op.drop_table("user_profile", schema="user_related")
    op.drop_table("keyword", schema="document_related")
    op.drop_table("n_classifier_model", schema="corpus_related")
    op.drop_table("embedding_model", schema="corpus_related")
    op.drop_table("corpus", schema="corpus_related")
    op.drop_table("bi_classifier_model", schema="corpus_related")
    # ### end Alembic commands ###
