"""inferred_user

Revision ID: e354666f951d
Revises: 89920abb7ff8
Create Date: 2025-09-24 12:05:19.794659

"""

from typing import Sequence, Union

import sqlalchemy
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

from alembic import op

# revision identifiers, used by Alembic.
revision: str = "e354666f951d"
down_revision: Union[str, None] = "89920abb7ff8"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "inferred_user",
        sa.Column(
            "id",
            sa.Uuid(),
            server_default=sqlalchemy.func.gen_random_uuid(),
            nullable=False,
        ),
        sa.Column(
            "created_at", postgresql.TIMESTAMP(), server_default="NOW()", nullable=False
        ),
        sa.PrimaryKeyConstraint("id"),
        schema="user_related",
    )
    op.create_table(
        "session",
        sa.Column(
            "id",
            sa.Uuid(),
            server_default=sqlalchemy.func.gen_random_uuid(),
            nullable=False,
        ),
        sa.Column("inferred_user_id", sa.Uuid(), nullable=False),
        sa.Column(
            "created_at", postgresql.TIMESTAMP(), server_default="NOW()", nullable=False
        ),
        sa.Column("end_at", postgresql.TIMESTAMP(), nullable=False),
        sa.Column("host", sa.String(), nullable=True),
        sa.ForeignKeyConstraint(
            ["inferred_user_id"],
            ["user_related.inferred_user.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
        schema="user_related",
    )
    op.create_table(
        "endpoint_request",
        sa.Column(
            "id",
            sa.Uuid(),
            server_default=sqlalchemy.func.gen_random_uuid(),
            nullable=False,
        ),
        sa.Column("session_id", sa.Uuid(), nullable=False),
        sa.Column("endpoint_name", sa.String(), nullable=False),
        sa.Column("http_code", sa.Integer(), nullable=False),
        sa.Column("message", sa.String(), nullable=True),
        sa.Column(
            "created_at", postgresql.TIMESTAMP(), server_default="NOW()", nullable=False
        ),
        sa.ForeignKeyConstraint(
            ["session_id"],
            ["user_related.session.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
        schema="user_related",
    )


def downgrade() -> None:
    op.drop_table("endpoint_request", schema="user_related")
    op.drop_table("session", schema="user_related")
    op.drop_table("inferred_user", schema="user_related")
