# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ModelArgs', 'Model']

@pulumi.input_type
class ModelArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[str],
                 model_type: pulumi.Input[str],
                 project_id: pulumi.Input[str],
                 training_dataset: pulumi.Input['ModelTrainingDatasetArgs'],
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 is_quick_mode: Optional[pulumi.Input[bool]] = None,
                 max_training_duration_in_hours: Optional[pulumi.Input[float]] = None,
                 model_version: Optional[pulumi.Input[str]] = None,
                 testing_dataset: Optional[pulumi.Input['ModelTestingDatasetArgs']] = None,
                 validation_dataset: Optional[pulumi.Input['ModelValidationDatasetArgs']] = None):
        """
        The set of arguments for constructing a Model resource.
        :param pulumi.Input[str] compartment_id: (Updatable) Compartment Identifier
        :param pulumi.Input[str] model_type: The  type of the model.
        :param pulumi.Input[str] project_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project to associate with the model.
        :param pulumi.Input['ModelTrainingDatasetArgs'] training_dataset: The base entity for a Dataset, which is the input for Model creation.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] description: (Updatable) A short description of the Model.
        :param pulumi.Input[str] display_name: (Updatable) Model Identifier
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[bool] is_quick_mode: If It's true, Training is set for recommended epochs needed for quick training.
        :param pulumi.Input[float] max_training_duration_in_hours: The maximum duration in hours for which the training will run.
        :param pulumi.Input[str] model_version: Model version.
        :param pulumi.Input['ModelTestingDatasetArgs'] testing_dataset: The base entity for a Dataset, which is the input for Model creation.
        :param pulumi.Input['ModelValidationDatasetArgs'] validation_dataset: The base entity for a Dataset, which is the input for Model creation.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "model_type", model_type)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "training_dataset", training_dataset)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_quick_mode is not None:
            pulumi.set(__self__, "is_quick_mode", is_quick_mode)
        if max_training_duration_in_hours is not None:
            pulumi.set(__self__, "max_training_duration_in_hours", max_training_duration_in_hours)
        if model_version is not None:
            pulumi.set(__self__, "model_version", model_version)
        if testing_dataset is not None:
            pulumi.set(__self__, "testing_dataset", testing_dataset)
        if validation_dataset is not None:
            pulumi.set(__self__, "validation_dataset", validation_dataset)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        (Updatable) Compartment Identifier
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="modelType")
    def model_type(self) -> pulumi.Input[str]:
        """
        The  type of the model.
        """
        return pulumi.get(self, "model_type")

    @model_type.setter
    def model_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "model_type", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project to associate with the model.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="trainingDataset")
    def training_dataset(self) -> pulumi.Input['ModelTrainingDatasetArgs']:
        """
        The base entity for a Dataset, which is the input for Model creation.
        """
        return pulumi.get(self, "training_dataset")

    @training_dataset.setter
    def training_dataset(self, value: pulumi.Input['ModelTrainingDatasetArgs']):
        pulumi.set(self, "training_dataset", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A short description of the Model.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Model Identifier
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="isQuickMode")
    def is_quick_mode(self) -> Optional[pulumi.Input[bool]]:
        """
        If It's true, Training is set for recommended epochs needed for quick training.
        """
        return pulumi.get(self, "is_quick_mode")

    @is_quick_mode.setter
    def is_quick_mode(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_quick_mode", value)

    @property
    @pulumi.getter(name="maxTrainingDurationInHours")
    def max_training_duration_in_hours(self) -> Optional[pulumi.Input[float]]:
        """
        The maximum duration in hours for which the training will run.
        """
        return pulumi.get(self, "max_training_duration_in_hours")

    @max_training_duration_in_hours.setter
    def max_training_duration_in_hours(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "max_training_duration_in_hours", value)

    @property
    @pulumi.getter(name="modelVersion")
    def model_version(self) -> Optional[pulumi.Input[str]]:
        """
        Model version.
        """
        return pulumi.get(self, "model_version")

    @model_version.setter
    def model_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "model_version", value)

    @property
    @pulumi.getter(name="testingDataset")
    def testing_dataset(self) -> Optional[pulumi.Input['ModelTestingDatasetArgs']]:
        """
        The base entity for a Dataset, which is the input for Model creation.
        """
        return pulumi.get(self, "testing_dataset")

    @testing_dataset.setter
    def testing_dataset(self, value: Optional[pulumi.Input['ModelTestingDatasetArgs']]):
        pulumi.set(self, "testing_dataset", value)

    @property
    @pulumi.getter(name="validationDataset")
    def validation_dataset(self) -> Optional[pulumi.Input['ModelValidationDatasetArgs']]:
        """
        The base entity for a Dataset, which is the input for Model creation.
        """
        return pulumi.get(self, "validation_dataset")

    @validation_dataset.setter
    def validation_dataset(self, value: Optional[pulumi.Input['ModelValidationDatasetArgs']]):
        pulumi.set(self, "validation_dataset", value)


@pulumi.input_type
class _ModelState:
    def __init__(__self__, *,
                 average_precision: Optional[pulumi.Input[float]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 confidence_threshold: Optional[pulumi.Input[float]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 is_quick_mode: Optional[pulumi.Input[bool]] = None,
                 lifecycle_details: Optional[pulumi.Input[str]] = None,
                 max_training_duration_in_hours: Optional[pulumi.Input[float]] = None,
                 metrics: Optional[pulumi.Input[str]] = None,
                 model_type: Optional[pulumi.Input[str]] = None,
                 model_version: Optional[pulumi.Input[str]] = None,
                 precision: Optional[pulumi.Input[float]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 recall: Optional[pulumi.Input[float]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 test_image_count: Optional[pulumi.Input[int]] = None,
                 testing_dataset: Optional[pulumi.Input['ModelTestingDatasetArgs']] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_updated: Optional[pulumi.Input[str]] = None,
                 total_image_count: Optional[pulumi.Input[int]] = None,
                 trained_duration_in_hours: Optional[pulumi.Input[float]] = None,
                 training_dataset: Optional[pulumi.Input['ModelTrainingDatasetArgs']] = None,
                 validation_dataset: Optional[pulumi.Input['ModelValidationDatasetArgs']] = None):
        """
        Input properties used for looking up and filtering Model resources.
        :param pulumi.Input[float] average_precision: Average precision of the trained model
        :param pulumi.Input[str] compartment_id: (Updatable) Compartment Identifier
        :param pulumi.Input[float] confidence_threshold: Confidence ratio of the calculation
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] description: (Updatable) A short description of the Model.
        :param pulumi.Input[str] display_name: (Updatable) Model Identifier
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[bool] is_quick_mode: If It's true, Training is set for recommended epochs needed for quick training.
        :param pulumi.Input[str] lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param pulumi.Input[float] max_training_duration_in_hours: The maximum duration in hours for which the training will run.
        :param pulumi.Input[str] metrics: Complete Training Metrics for successful trained model
        :param pulumi.Input[str] model_type: The  type of the model.
        :param pulumi.Input[str] model_version: Model version.
        :param pulumi.Input[float] precision: Precision of the trained model
        :param pulumi.Input[str] project_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project to associate with the model.
        :param pulumi.Input[float] recall: Recall of the trained model
        :param pulumi.Input[str] state: The current state of the Model.
        :param pulumi.Input[Mapping[str, Any]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[int] test_image_count: Total number of testing Images
        :param pulumi.Input['ModelTestingDatasetArgs'] testing_dataset: The base entity for a Dataset, which is the input for Model creation.
        :param pulumi.Input[str] time_created: The time the Model was created. An RFC3339 formatted datetime string
        :param pulumi.Input[str] time_updated: The time the Model was updated. An RFC3339 formatted datetime string
        :param pulumi.Input[int] total_image_count: Total number of training Images
        :param pulumi.Input[float] trained_duration_in_hours: Total hours actually used for training
        :param pulumi.Input['ModelTrainingDatasetArgs'] training_dataset: The base entity for a Dataset, which is the input for Model creation.
        :param pulumi.Input['ModelValidationDatasetArgs'] validation_dataset: The base entity for a Dataset, which is the input for Model creation.
        """
        if average_precision is not None:
            pulumi.set(__self__, "average_precision", average_precision)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if confidence_threshold is not None:
            pulumi.set(__self__, "confidence_threshold", confidence_threshold)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_quick_mode is not None:
            pulumi.set(__self__, "is_quick_mode", is_quick_mode)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if max_training_duration_in_hours is not None:
            pulumi.set(__self__, "max_training_duration_in_hours", max_training_duration_in_hours)
        if metrics is not None:
            pulumi.set(__self__, "metrics", metrics)
        if model_type is not None:
            pulumi.set(__self__, "model_type", model_type)
        if model_version is not None:
            pulumi.set(__self__, "model_version", model_version)
        if precision is not None:
            pulumi.set(__self__, "precision", precision)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if recall is not None:
            pulumi.set(__self__, "recall", recall)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if test_image_count is not None:
            pulumi.set(__self__, "test_image_count", test_image_count)
        if testing_dataset is not None:
            pulumi.set(__self__, "testing_dataset", testing_dataset)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if total_image_count is not None:
            pulumi.set(__self__, "total_image_count", total_image_count)
        if trained_duration_in_hours is not None:
            pulumi.set(__self__, "trained_duration_in_hours", trained_duration_in_hours)
        if training_dataset is not None:
            pulumi.set(__self__, "training_dataset", training_dataset)
        if validation_dataset is not None:
            pulumi.set(__self__, "validation_dataset", validation_dataset)

    @property
    @pulumi.getter(name="averagePrecision")
    def average_precision(self) -> Optional[pulumi.Input[float]]:
        """
        Average precision of the trained model
        """
        return pulumi.get(self, "average_precision")

    @average_precision.setter
    def average_precision(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "average_precision", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Compartment Identifier
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="confidenceThreshold")
    def confidence_threshold(self) -> Optional[pulumi.Input[float]]:
        """
        Confidence ratio of the calculation
        """
        return pulumi.get(self, "confidence_threshold")

    @confidence_threshold.setter
    def confidence_threshold(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "confidence_threshold", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A short description of the Model.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Model Identifier
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="isQuickMode")
    def is_quick_mode(self) -> Optional[pulumi.Input[bool]]:
        """
        If It's true, Training is set for recommended epochs needed for quick training.
        """
        return pulumi.get(self, "is_quick_mode")

    @is_quick_mode.setter
    def is_quick_mode(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_quick_mode", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[str]]:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="maxTrainingDurationInHours")
    def max_training_duration_in_hours(self) -> Optional[pulumi.Input[float]]:
        """
        The maximum duration in hours for which the training will run.
        """
        return pulumi.get(self, "max_training_duration_in_hours")

    @max_training_duration_in_hours.setter
    def max_training_duration_in_hours(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "max_training_duration_in_hours", value)

    @property
    @pulumi.getter
    def metrics(self) -> Optional[pulumi.Input[str]]:
        """
        Complete Training Metrics for successful trained model
        """
        return pulumi.get(self, "metrics")

    @metrics.setter
    def metrics(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metrics", value)

    @property
    @pulumi.getter(name="modelType")
    def model_type(self) -> Optional[pulumi.Input[str]]:
        """
        The  type of the model.
        """
        return pulumi.get(self, "model_type")

    @model_type.setter
    def model_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "model_type", value)

    @property
    @pulumi.getter(name="modelVersion")
    def model_version(self) -> Optional[pulumi.Input[str]]:
        """
        Model version.
        """
        return pulumi.get(self, "model_version")

    @model_version.setter
    def model_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "model_version", value)

    @property
    @pulumi.getter
    def precision(self) -> Optional[pulumi.Input[float]]:
        """
        Precision of the trained model
        """
        return pulumi.get(self, "precision")

    @precision.setter
    def precision(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "precision", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project to associate with the model.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def recall(self) -> Optional[pulumi.Input[float]]:
        """
        Recall of the trained model
        """
        return pulumi.get(self, "recall")

    @recall.setter
    def recall(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "recall", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the Model.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="testImageCount")
    def test_image_count(self) -> Optional[pulumi.Input[int]]:
        """
        Total number of testing Images
        """
        return pulumi.get(self, "test_image_count")

    @test_image_count.setter
    def test_image_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "test_image_count", value)

    @property
    @pulumi.getter(name="testingDataset")
    def testing_dataset(self) -> Optional[pulumi.Input['ModelTestingDatasetArgs']]:
        """
        The base entity for a Dataset, which is the input for Model creation.
        """
        return pulumi.get(self, "testing_dataset")

    @testing_dataset.setter
    def testing_dataset(self, value: Optional[pulumi.Input['ModelTestingDatasetArgs']]):
        pulumi.set(self, "testing_dataset", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The time the Model was created. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[str]]:
        """
        The time the Model was updated. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_updated", value)

    @property
    @pulumi.getter(name="totalImageCount")
    def total_image_count(self) -> Optional[pulumi.Input[int]]:
        """
        Total number of training Images
        """
        return pulumi.get(self, "total_image_count")

    @total_image_count.setter
    def total_image_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "total_image_count", value)

    @property
    @pulumi.getter(name="trainedDurationInHours")
    def trained_duration_in_hours(self) -> Optional[pulumi.Input[float]]:
        """
        Total hours actually used for training
        """
        return pulumi.get(self, "trained_duration_in_hours")

    @trained_duration_in_hours.setter
    def trained_duration_in_hours(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "trained_duration_in_hours", value)

    @property
    @pulumi.getter(name="trainingDataset")
    def training_dataset(self) -> Optional[pulumi.Input['ModelTrainingDatasetArgs']]:
        """
        The base entity for a Dataset, which is the input for Model creation.
        """
        return pulumi.get(self, "training_dataset")

    @training_dataset.setter
    def training_dataset(self, value: Optional[pulumi.Input['ModelTrainingDatasetArgs']]):
        pulumi.set(self, "training_dataset", value)

    @property
    @pulumi.getter(name="validationDataset")
    def validation_dataset(self) -> Optional[pulumi.Input['ModelValidationDatasetArgs']]:
        """
        The base entity for a Dataset, which is the input for Model creation.
        """
        return pulumi.get(self, "validation_dataset")

    @validation_dataset.setter
    def validation_dataset(self, value: Optional[pulumi.Input['ModelValidationDatasetArgs']]):
        pulumi.set(self, "validation_dataset", value)


class Model(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 is_quick_mode: Optional[pulumi.Input[bool]] = None,
                 max_training_duration_in_hours: Optional[pulumi.Input[float]] = None,
                 model_type: Optional[pulumi.Input[str]] = None,
                 model_version: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 testing_dataset: Optional[pulumi.Input[pulumi.InputType['ModelTestingDatasetArgs']]] = None,
                 training_dataset: Optional[pulumi.Input[pulumi.InputType['ModelTrainingDatasetArgs']]] = None,
                 validation_dataset: Optional[pulumi.Input[pulumi.InputType['ModelValidationDatasetArgs']]] = None,
                 __props__=None):
        """
        This resource provides the Model resource in Oracle Cloud Infrastructure Ai Vision service.

        Creates a new Model.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_model = oci.ai_vision.Model("testModel",
            compartment_id=var["compartment_id"],
            model_type=var["model_model_type"],
            project_id=oci_ai_vision_project["test_project"]["id"],
            training_dataset=oci.ai_vision.ModelTrainingDatasetArgs(
                dataset_type=var["model_training_dataset_dataset_type"],
                bucket=var["model_training_dataset_bucket"],
                dataset_id=oci_data_labeling_service_dataset["test_dataset"]["id"],
                namespace_name=var["model_training_dataset_namespace"],
                object=var["model_training_dataset_object"],
            ),
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            description=var["model_description"],
            display_name=var["model_display_name"],
            freeform_tags={
                "bar-key": "value",
            },
            is_quick_mode=var["model_is_quick_mode"],
            max_training_duration_in_hours=var["model_max_training_duration_in_hours"],
            model_version=var["model_model_version"],
            testing_dataset=oci.ai_vision.ModelTestingDatasetArgs(
                dataset_type=var["model_testing_dataset_dataset_type"],
                bucket=var["model_testing_dataset_bucket"],
                dataset_id=oci_data_labeling_service_dataset["test_dataset"]["id"],
                namespace_name=var["model_testing_dataset_namespace"],
                object=var["model_testing_dataset_object"],
            ),
            validation_dataset=oci.ai_vision.ModelValidationDatasetArgs(
                dataset_type=var["model_validation_dataset_dataset_type"],
                bucket=var["model_validation_dataset_bucket"],
                dataset_id=oci_data_labeling_service_dataset["test_dataset"]["id"],
                namespace_name=var["model_validation_dataset_namespace"],
                object=var["model_validation_dataset_object"],
            ))
        ```

        ## Import

        Models can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:AiVision/model:Model test_model "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: (Updatable) Compartment Identifier
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] description: (Updatable) A short description of the Model.
        :param pulumi.Input[str] display_name: (Updatable) Model Identifier
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[bool] is_quick_mode: If It's true, Training is set for recommended epochs needed for quick training.
        :param pulumi.Input[float] max_training_duration_in_hours: The maximum duration in hours for which the training will run.
        :param pulumi.Input[str] model_type: The  type of the model.
        :param pulumi.Input[str] model_version: Model version.
        :param pulumi.Input[str] project_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project to associate with the model.
        :param pulumi.Input[pulumi.InputType['ModelTestingDatasetArgs']] testing_dataset: The base entity for a Dataset, which is the input for Model creation.
        :param pulumi.Input[pulumi.InputType['ModelTrainingDatasetArgs']] training_dataset: The base entity for a Dataset, which is the input for Model creation.
        :param pulumi.Input[pulumi.InputType['ModelValidationDatasetArgs']] validation_dataset: The base entity for a Dataset, which is the input for Model creation.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ModelArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Model resource in Oracle Cloud Infrastructure Ai Vision service.

        Creates a new Model.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_model = oci.ai_vision.Model("testModel",
            compartment_id=var["compartment_id"],
            model_type=var["model_model_type"],
            project_id=oci_ai_vision_project["test_project"]["id"],
            training_dataset=oci.ai_vision.ModelTrainingDatasetArgs(
                dataset_type=var["model_training_dataset_dataset_type"],
                bucket=var["model_training_dataset_bucket"],
                dataset_id=oci_data_labeling_service_dataset["test_dataset"]["id"],
                namespace_name=var["model_training_dataset_namespace"],
                object=var["model_training_dataset_object"],
            ),
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            description=var["model_description"],
            display_name=var["model_display_name"],
            freeform_tags={
                "bar-key": "value",
            },
            is_quick_mode=var["model_is_quick_mode"],
            max_training_duration_in_hours=var["model_max_training_duration_in_hours"],
            model_version=var["model_model_version"],
            testing_dataset=oci.ai_vision.ModelTestingDatasetArgs(
                dataset_type=var["model_testing_dataset_dataset_type"],
                bucket=var["model_testing_dataset_bucket"],
                dataset_id=oci_data_labeling_service_dataset["test_dataset"]["id"],
                namespace_name=var["model_testing_dataset_namespace"],
                object=var["model_testing_dataset_object"],
            ),
            validation_dataset=oci.ai_vision.ModelValidationDatasetArgs(
                dataset_type=var["model_validation_dataset_dataset_type"],
                bucket=var["model_validation_dataset_bucket"],
                dataset_id=oci_data_labeling_service_dataset["test_dataset"]["id"],
                namespace_name=var["model_validation_dataset_namespace"],
                object=var["model_validation_dataset_object"],
            ))
        ```

        ## Import

        Models can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:AiVision/model:Model test_model "id"
        ```

        :param str resource_name: The name of the resource.
        :param ModelArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ModelArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 is_quick_mode: Optional[pulumi.Input[bool]] = None,
                 max_training_duration_in_hours: Optional[pulumi.Input[float]] = None,
                 model_type: Optional[pulumi.Input[str]] = None,
                 model_version: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 testing_dataset: Optional[pulumi.Input[pulumi.InputType['ModelTestingDatasetArgs']]] = None,
                 training_dataset: Optional[pulumi.Input[pulumi.InputType['ModelTrainingDatasetArgs']]] = None,
                 validation_dataset: Optional[pulumi.Input[pulumi.InputType['ModelValidationDatasetArgs']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ModelArgs.__new__(ModelArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["description"] = description
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["is_quick_mode"] = is_quick_mode
            __props__.__dict__["max_training_duration_in_hours"] = max_training_duration_in_hours
            if model_type is None and not opts.urn:
                raise TypeError("Missing required property 'model_type'")
            __props__.__dict__["model_type"] = model_type
            __props__.__dict__["model_version"] = model_version
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["testing_dataset"] = testing_dataset
            if training_dataset is None and not opts.urn:
                raise TypeError("Missing required property 'training_dataset'")
            __props__.__dict__["training_dataset"] = training_dataset
            __props__.__dict__["validation_dataset"] = validation_dataset
            __props__.__dict__["average_precision"] = None
            __props__.__dict__["confidence_threshold"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["metrics"] = None
            __props__.__dict__["precision"] = None
            __props__.__dict__["recall"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["test_image_count"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
            __props__.__dict__["total_image_count"] = None
            __props__.__dict__["trained_duration_in_hours"] = None
        super(Model, __self__).__init__(
            'oci:AiVision/model:Model',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            average_precision: Optional[pulumi.Input[float]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            confidence_threshold: Optional[pulumi.Input[float]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            is_quick_mode: Optional[pulumi.Input[bool]] = None,
            lifecycle_details: Optional[pulumi.Input[str]] = None,
            max_training_duration_in_hours: Optional[pulumi.Input[float]] = None,
            metrics: Optional[pulumi.Input[str]] = None,
            model_type: Optional[pulumi.Input[str]] = None,
            model_version: Optional[pulumi.Input[str]] = None,
            precision: Optional[pulumi.Input[float]] = None,
            project_id: Optional[pulumi.Input[str]] = None,
            recall: Optional[pulumi.Input[float]] = None,
            state: Optional[pulumi.Input[str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            test_image_count: Optional[pulumi.Input[int]] = None,
            testing_dataset: Optional[pulumi.Input[pulumi.InputType['ModelTestingDatasetArgs']]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_updated: Optional[pulumi.Input[str]] = None,
            total_image_count: Optional[pulumi.Input[int]] = None,
            trained_duration_in_hours: Optional[pulumi.Input[float]] = None,
            training_dataset: Optional[pulumi.Input[pulumi.InputType['ModelTrainingDatasetArgs']]] = None,
            validation_dataset: Optional[pulumi.Input[pulumi.InputType['ModelValidationDatasetArgs']]] = None) -> 'Model':
        """
        Get an existing Model resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[float] average_precision: Average precision of the trained model
        :param pulumi.Input[str] compartment_id: (Updatable) Compartment Identifier
        :param pulumi.Input[float] confidence_threshold: Confidence ratio of the calculation
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] description: (Updatable) A short description of the Model.
        :param pulumi.Input[str] display_name: (Updatable) Model Identifier
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[bool] is_quick_mode: If It's true, Training is set for recommended epochs needed for quick training.
        :param pulumi.Input[str] lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param pulumi.Input[float] max_training_duration_in_hours: The maximum duration in hours for which the training will run.
        :param pulumi.Input[str] metrics: Complete Training Metrics for successful trained model
        :param pulumi.Input[str] model_type: The  type of the model.
        :param pulumi.Input[str] model_version: Model version.
        :param pulumi.Input[float] precision: Precision of the trained model
        :param pulumi.Input[str] project_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project to associate with the model.
        :param pulumi.Input[float] recall: Recall of the trained model
        :param pulumi.Input[str] state: The current state of the Model.
        :param pulumi.Input[Mapping[str, Any]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[int] test_image_count: Total number of testing Images
        :param pulumi.Input[pulumi.InputType['ModelTestingDatasetArgs']] testing_dataset: The base entity for a Dataset, which is the input for Model creation.
        :param pulumi.Input[str] time_created: The time the Model was created. An RFC3339 formatted datetime string
        :param pulumi.Input[str] time_updated: The time the Model was updated. An RFC3339 formatted datetime string
        :param pulumi.Input[int] total_image_count: Total number of training Images
        :param pulumi.Input[float] trained_duration_in_hours: Total hours actually used for training
        :param pulumi.Input[pulumi.InputType['ModelTrainingDatasetArgs']] training_dataset: The base entity for a Dataset, which is the input for Model creation.
        :param pulumi.Input[pulumi.InputType['ModelValidationDatasetArgs']] validation_dataset: The base entity for a Dataset, which is the input for Model creation.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ModelState.__new__(_ModelState)

        __props__.__dict__["average_precision"] = average_precision
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["confidence_threshold"] = confidence_threshold
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["is_quick_mode"] = is_quick_mode
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["max_training_duration_in_hours"] = max_training_duration_in_hours
        __props__.__dict__["metrics"] = metrics
        __props__.__dict__["model_type"] = model_type
        __props__.__dict__["model_version"] = model_version
        __props__.__dict__["precision"] = precision
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["recall"] = recall
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["test_image_count"] = test_image_count
        __props__.__dict__["testing_dataset"] = testing_dataset
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["total_image_count"] = total_image_count
        __props__.__dict__["trained_duration_in_hours"] = trained_duration_in_hours
        __props__.__dict__["training_dataset"] = training_dataset
        __props__.__dict__["validation_dataset"] = validation_dataset
        return Model(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="averagePrecision")
    def average_precision(self) -> pulumi.Output[float]:
        """
        Average precision of the trained model
        """
        return pulumi.get(self, "average_precision")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) Compartment Identifier
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="confidenceThreshold")
    def confidence_threshold(self) -> pulumi.Output[float]:
        """
        Confidence ratio of the calculation
        """
        return pulumi.get(self, "confidence_threshold")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        (Updatable) A short description of the Model.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) Model Identifier
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="isQuickMode")
    def is_quick_mode(self) -> pulumi.Output[bool]:
        """
        If It's true, Training is set for recommended epochs needed for quick training.
        """
        return pulumi.get(self, "is_quick_mode")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[str]:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="maxTrainingDurationInHours")
    def max_training_duration_in_hours(self) -> pulumi.Output[float]:
        """
        The maximum duration in hours for which the training will run.
        """
        return pulumi.get(self, "max_training_duration_in_hours")

    @property
    @pulumi.getter
    def metrics(self) -> pulumi.Output[str]:
        """
        Complete Training Metrics for successful trained model
        """
        return pulumi.get(self, "metrics")

    @property
    @pulumi.getter(name="modelType")
    def model_type(self) -> pulumi.Output[str]:
        """
        The  type of the model.
        """
        return pulumi.get(self, "model_type")

    @property
    @pulumi.getter(name="modelVersion")
    def model_version(self) -> pulumi.Output[str]:
        """
        Model version.
        """
        return pulumi.get(self, "model_version")

    @property
    @pulumi.getter
    def precision(self) -> pulumi.Output[float]:
        """
        Precision of the trained model
        """
        return pulumi.get(self, "precision")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project to associate with the model.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def recall(self) -> pulumi.Output[float]:
        """
        Recall of the trained model
        """
        return pulumi.get(self, "recall")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of the Model.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="testImageCount")
    def test_image_count(self) -> pulumi.Output[int]:
        """
        Total number of testing Images
        """
        return pulumi.get(self, "test_image_count")

    @property
    @pulumi.getter(name="testingDataset")
    def testing_dataset(self) -> pulumi.Output['outputs.ModelTestingDataset']:
        """
        The base entity for a Dataset, which is the input for Model creation.
        """
        return pulumi.get(self, "testing_dataset")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The time the Model was created. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[str]:
        """
        The time the Model was updated. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="totalImageCount")
    def total_image_count(self) -> pulumi.Output[int]:
        """
        Total number of training Images
        """
        return pulumi.get(self, "total_image_count")

    @property
    @pulumi.getter(name="trainedDurationInHours")
    def trained_duration_in_hours(self) -> pulumi.Output[float]:
        """
        Total hours actually used for training
        """
        return pulumi.get(self, "trained_duration_in_hours")

    @property
    @pulumi.getter(name="trainingDataset")
    def training_dataset(self) -> pulumi.Output['outputs.ModelTrainingDataset']:
        """
        The base entity for a Dataset, which is the input for Model creation.
        """
        return pulumi.get(self, "training_dataset")

    @property
    @pulumi.getter(name="validationDataset")
    def validation_dataset(self) -> pulumi.Output['outputs.ModelValidationDataset']:
        """
        The base entity for a Dataset, which is the input for Model creation.
        """
        return pulumi.get(self, "validation_dataset")

