# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetEventsResult',
    'AwaitableGetEventsResult',
    'get_events',
    'get_events_output',
]

@pulumi.output_type
class GetEventsResult:
    """
    A collection of values returned by getEvents.
    """
    def __init__(__self__, audit_events=None, compartment_id=None, end_time=None, filters=None, id=None, start_time=None):
        if audit_events and not isinstance(audit_events, list):
            raise TypeError("Expected argument 'audit_events' to be a list")
        pulumi.set(__self__, "audit_events", audit_events)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if end_time and not isinstance(end_time, str):
            raise TypeError("Expected argument 'end_time' to be a str")
        pulumi.set(__self__, "end_time", end_time)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if start_time and not isinstance(start_time, str):
            raise TypeError("Expected argument 'start_time' to be a str")
        pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter(name="auditEvents")
    def audit_events(self) -> Sequence['outputs.GetEventsAuditEventResult']:
        """
        The list of audit_events.
        """
        return pulumi.get(self, "audit_events")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment of the resource  emitting the event.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> str:
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetEventsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        return pulumi.get(self, "start_time")


class AwaitableGetEventsResult(GetEventsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEventsResult(
            audit_events=self.audit_events,
            compartment_id=self.compartment_id,
            end_time=self.end_time,
            filters=self.filters,
            id=self.id,
            start_time=self.start_time)


def get_events(compartment_id: Optional[str] = None,
               end_time: Optional[str] = None,
               filters: Optional[Sequence[pulumi.InputType['GetEventsFilterArgs']]] = None,
               start_time: Optional[str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEventsResult:
    """
    This data source provides the list of Audit Events in Oracle Cloud Infrastructure Audit service.

    Returns all the audit events processed for the specified compartment within the specified
    time range.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_audit_events = oci.Audit.get_events(compartment_id=var["compartment_id"],
        end_time=var["audit_event_end_time"],
        start_time=var["audit_event_start_time"])
    ```


    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param str end_time: Returns events that were processed before this end date and time, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.
           
           For example, a start value of `2017-01-01T00:00:00Z` and an end value of `2017-01-02T00:00:00Z` will retrieve a list of all events processed on January 1, 2017. Similarly, a start value of `2017-01-01T00:00:00Z` and an end value of `2017-02-01T00:00:00Z` will result in a list of all events processed between January 1, 2017 and January 31, 2017. You can specify a value with granularity to the minute. Seconds (and milliseconds, if included) must be set to `0`.
    :param str start_time: Returns events that were processed at or after this start date and time, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.
           
           For example, a start value of `2017-01-15T11:30:00Z` will retrieve a list of all events processed since 30 minutes after the 11th hour of January 15, 2017, in Coordinated Universal Time (UTC). You can specify a value with granularity to the minute. Seconds (and milliseconds, if included) must be set to `0`.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['endTime'] = end_time
    __args__['filters'] = filters
    __args__['startTime'] = start_time
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Audit/getEvents:getEvents', __args__, opts=opts, typ=GetEventsResult).value

    return AwaitableGetEventsResult(
        audit_events=pulumi.get(__ret__, 'audit_events'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        end_time=pulumi.get(__ret__, 'end_time'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        start_time=pulumi.get(__ret__, 'start_time'))


@_utilities.lift_output_func(get_events)
def get_events_output(compartment_id: Optional[pulumi.Input[str]] = None,
                      end_time: Optional[pulumi.Input[str]] = None,
                      filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetEventsFilterArgs']]]]] = None,
                      start_time: Optional[pulumi.Input[str]] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetEventsResult]:
    """
    This data source provides the list of Audit Events in Oracle Cloud Infrastructure Audit service.

    Returns all the audit events processed for the specified compartment within the specified
    time range.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_audit_events = oci.Audit.get_events(compartment_id=var["compartment_id"],
        end_time=var["audit_event_end_time"],
        start_time=var["audit_event_start_time"])
    ```


    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param str end_time: Returns events that were processed before this end date and time, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.
           
           For example, a start value of `2017-01-01T00:00:00Z` and an end value of `2017-01-02T00:00:00Z` will retrieve a list of all events processed on January 1, 2017. Similarly, a start value of `2017-01-01T00:00:00Z` and an end value of `2017-02-01T00:00:00Z` will result in a list of all events processed between January 1, 2017 and January 31, 2017. You can specify a value with granularity to the minute. Seconds (and milliseconds, if included) must be set to `0`.
    :param str start_time: Returns events that were processed at or after this start date and time, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.
           
           For example, a start value of `2017-01-15T11:30:00Z` will retrieve a list of all events processed since 30 minutes after the 11th hour of January 15, 2017, in Coordinated Universal Time (UTC). You can specify a value with granularity to the minute. Seconds (and milliseconds, if included) must be set to `0`.
    """
    ...
