# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetManagedDatabaseAddmTaskResult',
    'AwaitableGetManagedDatabaseAddmTaskResult',
    'get_managed_database_addm_task',
    'get_managed_database_addm_task_output',
]

@pulumi.output_type
class GetManagedDatabaseAddmTaskResult:
    """
    A collection of values returned by getManagedDatabaseAddmTask.
    """
    def __init__(__self__, id=None, items=None, managed_database_id=None, time_end=None, time_start=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if items and not isinstance(items, list):
            raise TypeError("Expected argument 'items' to be a list")
        pulumi.set(__self__, "items", items)
        if managed_database_id and not isinstance(managed_database_id, str):
            raise TypeError("Expected argument 'managed_database_id' to be a str")
        pulumi.set(__self__, "managed_database_id", managed_database_id)
        if time_end and not isinstance(time_end, str):
            raise TypeError("Expected argument 'time_end' to be a str")
        pulumi.set(__self__, "time_end", time_end)
        if time_start and not isinstance(time_start, str):
            raise TypeError("Expected argument 'time_start' to be a str")
        pulumi.set(__self__, "time_start", time_start)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetManagedDatabaseAddmTaskItemResult']:
        """
        The list of ADDM task metadata.
        """
        return pulumi.get(self, "items")

    @property
    @pulumi.getter(name="managedDatabaseId")
    def managed_database_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Managed Database.
        """
        return pulumi.get(self, "managed_database_id")

    @property
    @pulumi.getter(name="timeEnd")
    def time_end(self) -> str:
        return pulumi.get(self, "time_end")

    @property
    @pulumi.getter(name="timeStart")
    def time_start(self) -> str:
        return pulumi.get(self, "time_start")


class AwaitableGetManagedDatabaseAddmTaskResult(GetManagedDatabaseAddmTaskResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetManagedDatabaseAddmTaskResult(
            id=self.id,
            items=self.items,
            managed_database_id=self.managed_database_id,
            time_end=self.time_end,
            time_start=self.time_start)


def get_managed_database_addm_task(managed_database_id: Optional[str] = None,
                                   time_end: Optional[str] = None,
                                   time_start: Optional[str] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetManagedDatabaseAddmTaskResult:
    """
    This data source provides details about a specific Managed Database Addm Task resource in Oracle Cloud Infrastructure Database Management service.

    Lists the metadata for each ADDM task who's end snapshot time falls within the provided start and end time. Details include
    the name of the ADDM task, description, user, status and creation date time.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_managed_database_addm_task = oci.DatabaseManagement.get_managed_database_addm_task(managed_database_id=oci_database_management_managed_database["test_managed_database"]["id"],
        time_end=var["managed_database_addm_task_time_end"],
        time_start=var["managed_database_addm_task_time_start"])
    ```


    :param str managed_database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Managed Database.
    :param str time_end: The end of the time range to search for ADDM tasks as defined by date-time RFC3339 format.
    :param str time_start: The beginning of the time range to search for ADDM tasks as defined by date-time RFC3339 format.
    """
    __args__ = dict()
    __args__['managedDatabaseId'] = managed_database_id
    __args__['timeEnd'] = time_end
    __args__['timeStart'] = time_start
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DatabaseManagement/getManagedDatabaseAddmTask:getManagedDatabaseAddmTask', __args__, opts=opts, typ=GetManagedDatabaseAddmTaskResult).value

    return AwaitableGetManagedDatabaseAddmTaskResult(
        id=pulumi.get(__ret__, 'id'),
        items=pulumi.get(__ret__, 'items'),
        managed_database_id=pulumi.get(__ret__, 'managed_database_id'),
        time_end=pulumi.get(__ret__, 'time_end'),
        time_start=pulumi.get(__ret__, 'time_start'))


@_utilities.lift_output_func(get_managed_database_addm_task)
def get_managed_database_addm_task_output(managed_database_id: Optional[pulumi.Input[str]] = None,
                                          time_end: Optional[pulumi.Input[str]] = None,
                                          time_start: Optional[pulumi.Input[str]] = None,
                                          opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetManagedDatabaseAddmTaskResult]:
    """
    This data source provides details about a specific Managed Database Addm Task resource in Oracle Cloud Infrastructure Database Management service.

    Lists the metadata for each ADDM task who's end snapshot time falls within the provided start and end time. Details include
    the name of the ADDM task, description, user, status and creation date time.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_managed_database_addm_task = oci.DatabaseManagement.get_managed_database_addm_task(managed_database_id=oci_database_management_managed_database["test_managed_database"]["id"],
        time_end=var["managed_database_addm_task_time_end"],
        time_start=var["managed_database_addm_task_time_start"])
    ```


    :param str managed_database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Managed Database.
    :param str time_end: The end of the time range to search for ADDM tasks as defined by date-time RFC3339 format.
    :param str time_start: The beginning of the time range to search for ADDM tasks as defined by date-time RFC3339 format.
    """
    ...
