# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetRepositoryAuthorResult',
    'AwaitableGetRepositoryAuthorResult',
    'get_repository_author',
    'get_repository_author_output',
]

@pulumi.output_type
class GetRepositoryAuthorResult:
    """
    A collection of values returned by getRepositoryAuthor.
    """
    def __init__(__self__, id=None, items=None, ref_name=None, repository_id=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if items and not isinstance(items, list):
            raise TypeError("Expected argument 'items' to be a list")
        pulumi.set(__self__, "items", items)
        if ref_name and not isinstance(ref_name, str):
            raise TypeError("Expected argument 'ref_name' to be a str")
        pulumi.set(__self__, "ref_name", ref_name)
        if repository_id and not isinstance(repository_id, str):
            raise TypeError("Expected argument 'repository_id' to be a str")
        pulumi.set(__self__, "repository_id", repository_id)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetRepositoryAuthorItemResult']:
        """
        List of author objects.
        """
        return pulumi.get(self, "items")

    @property
    @pulumi.getter(name="refName")
    def ref_name(self) -> Optional[str]:
        return pulumi.get(self, "ref_name")

    @property
    @pulumi.getter(name="repositoryId")
    def repository_id(self) -> str:
        return pulumi.get(self, "repository_id")


class AwaitableGetRepositoryAuthorResult(GetRepositoryAuthorResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRepositoryAuthorResult(
            id=self.id,
            items=self.items,
            ref_name=self.ref_name,
            repository_id=self.repository_id)


def get_repository_author(ref_name: Optional[str] = None,
                          repository_id: Optional[str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRepositoryAuthorResult:
    """
    This data source provides details about a specific Repository Author resource in Oracle Cloud Infrastructure Devops service.

    Retrieve a list of all the authors.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_repository_author = oci.DevOps.get_repository_author(repository_id=oci_devops_repository["test_repository"]["id"],
        ref_name=var["repository_author_ref_name"])
    ```


    :param str ref_name: A filter to return only resources that match the given reference name.
    :param str repository_id: Unique repository identifier.
    """
    __args__ = dict()
    __args__['refName'] = ref_name
    __args__['repositoryId'] = repository_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DevOps/getRepositoryAuthor:getRepositoryAuthor', __args__, opts=opts, typ=GetRepositoryAuthorResult).value

    return AwaitableGetRepositoryAuthorResult(
        id=pulumi.get(__ret__, 'id'),
        items=pulumi.get(__ret__, 'items'),
        ref_name=pulumi.get(__ret__, 'ref_name'),
        repository_id=pulumi.get(__ret__, 'repository_id'))


@_utilities.lift_output_func(get_repository_author)
def get_repository_author_output(ref_name: Optional[pulumi.Input[Optional[str]]] = None,
                                 repository_id: Optional[pulumi.Input[str]] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetRepositoryAuthorResult]:
    """
    This data source provides details about a specific Repository Author resource in Oracle Cloud Infrastructure Devops service.

    Retrieve a list of all the authors.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_repository_author = oci.DevOps.get_repository_author(repository_id=oci_devops_repository["test_repository"]["id"],
        ref_name=var["repository_author_ref_name"])
    ```


    :param str ref_name: A filter to return only resources that match the given reference name.
    :param str repository_id: Unique repository identifier.
    """
    ...
