# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetFusionEnvironmentAdminUserResult',
    'AwaitableGetFusionEnvironmentAdminUserResult',
    'get_fusion_environment_admin_user',
    'get_fusion_environment_admin_user_output',
]

@pulumi.output_type
class GetFusionEnvironmentAdminUserResult:
    """
    A collection of values returned by getFusionEnvironmentAdminUser.
    """
    def __init__(__self__, email_address=None, first_name=None, fusion_environment_id=None, id=None, items=None, last_name=None, password=None, username=None):
        if email_address and not isinstance(email_address, str):
            raise TypeError("Expected argument 'email_address' to be a str")
        pulumi.set(__self__, "email_address", email_address)
        if first_name and not isinstance(first_name, str):
            raise TypeError("Expected argument 'first_name' to be a str")
        pulumi.set(__self__, "first_name", first_name)
        if fusion_environment_id and not isinstance(fusion_environment_id, str):
            raise TypeError("Expected argument 'fusion_environment_id' to be a str")
        pulumi.set(__self__, "fusion_environment_id", fusion_environment_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if items and not isinstance(items, list):
            raise TypeError("Expected argument 'items' to be a list")
        pulumi.set(__self__, "items", items)
        if last_name and not isinstance(last_name, str):
            raise TypeError("Expected argument 'last_name' to be a str")
        pulumi.set(__self__, "last_name", last_name)
        if password and not isinstance(password, str):
            raise TypeError("Expected argument 'password' to be a str")
        pulumi.set(__self__, "password", password)
        if username and not isinstance(username, str):
            raise TypeError("Expected argument 'username' to be a str")
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="emailAddress")
    def email_address(self) -> str:
        """
        Admin users email address
        """
        return pulumi.get(self, "email_address")

    @property
    @pulumi.getter(name="firstName")
    def first_name(self) -> str:
        """
        Admin users first name
        """
        return pulumi.get(self, "first_name")

    @property
    @pulumi.getter(name="fusionEnvironmentId")
    def fusion_environment_id(self) -> str:
        return pulumi.get(self, "fusion_environment_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetFusionEnvironmentAdminUserItemResult']:
        """
        A page of AdminUserSummary objects.
        """
        return pulumi.get(self, "items")

    @property
    @pulumi.getter(name="lastName")
    def last_name(self) -> str:
        """
        Admin users last name
        """
        return pulumi.get(self, "last_name")

    @property
    @pulumi.getter
    def password(self) -> str:
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        Admin username
        """
        return pulumi.get(self, "username")


class AwaitableGetFusionEnvironmentAdminUserResult(GetFusionEnvironmentAdminUserResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFusionEnvironmentAdminUserResult(
            email_address=self.email_address,
            first_name=self.first_name,
            fusion_environment_id=self.fusion_environment_id,
            id=self.id,
            items=self.items,
            last_name=self.last_name,
            password=self.password,
            username=self.username)


def get_fusion_environment_admin_user(fusion_environment_id: Optional[str] = None,
                                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFusionEnvironmentAdminUserResult:
    """
    This data source provides details about a specific Fusion Environment Admin User resource in Oracle Cloud Infrastructure Fusion Apps service.

    List all FusionEnvironment admin users

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_fusion_environment_admin_user = oci.Functions.get_fusion_environment_admin_user(fusion_environment_id=oci_fusion_apps_fusion_environment["test_fusion_environment"]["id"])
    ```


    :param str fusion_environment_id: unique FusionEnvironment identifier
    """
    __args__ = dict()
    __args__['fusionEnvironmentId'] = fusion_environment_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Functions/getFusionEnvironmentAdminUser:getFusionEnvironmentAdminUser', __args__, opts=opts, typ=GetFusionEnvironmentAdminUserResult).value

    return AwaitableGetFusionEnvironmentAdminUserResult(
        email_address=pulumi.get(__ret__, 'email_address'),
        first_name=pulumi.get(__ret__, 'first_name'),
        fusion_environment_id=pulumi.get(__ret__, 'fusion_environment_id'),
        id=pulumi.get(__ret__, 'id'),
        items=pulumi.get(__ret__, 'items'),
        last_name=pulumi.get(__ret__, 'last_name'),
        password=pulumi.get(__ret__, 'password'),
        username=pulumi.get(__ret__, 'username'))


@_utilities.lift_output_func(get_fusion_environment_admin_user)
def get_fusion_environment_admin_user_output(fusion_environment_id: Optional[pulumi.Input[str]] = None,
                                             opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetFusionEnvironmentAdminUserResult]:
    """
    This data source provides details about a specific Fusion Environment Admin User resource in Oracle Cloud Infrastructure Fusion Apps service.

    List all FusionEnvironment admin users

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_fusion_environment_admin_user = oci.Functions.get_fusion_environment_admin_user(fusion_environment_id=oci_fusion_apps_fusion_environment["test_fusion_environment"]["id"])
    ```


    :param str fusion_environment_id: unique FusionEnvironment identifier
    """
    ...
