# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetHttpProbeResultsResult',
    'AwaitableGetHttpProbeResultsResult',
    'get_http_probe_results',
    'get_http_probe_results_output',
]

@pulumi.output_type
class GetHttpProbeResultsResult:
    """
    A collection of values returned by getHttpProbeResults.
    """
    def __init__(__self__, filters=None, http_probe_results=None, id=None, probe_configuration_id=None, start_time_greater_than_or_equal_to=None, start_time_less_than_or_equal_to=None, target=None):
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if http_probe_results and not isinstance(http_probe_results, list):
            raise TypeError("Expected argument 'http_probe_results' to be a list")
        pulumi.set(__self__, "http_probe_results", http_probe_results)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if probe_configuration_id and not isinstance(probe_configuration_id, str):
            raise TypeError("Expected argument 'probe_configuration_id' to be a str")
        pulumi.set(__self__, "probe_configuration_id", probe_configuration_id)
        if start_time_greater_than_or_equal_to and not isinstance(start_time_greater_than_or_equal_to, float):
            raise TypeError("Expected argument 'start_time_greater_than_or_equal_to' to be a float")
        pulumi.set(__self__, "start_time_greater_than_or_equal_to", start_time_greater_than_or_equal_to)
        if start_time_less_than_or_equal_to and not isinstance(start_time_less_than_or_equal_to, float):
            raise TypeError("Expected argument 'start_time_less_than_or_equal_to' to be a float")
        pulumi.set(__self__, "start_time_less_than_or_equal_to", start_time_less_than_or_equal_to)
        if target and not isinstance(target, str):
            raise TypeError("Expected argument 'target' to be a str")
        pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetHttpProbeResultsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter(name="httpProbeResults")
    def http_probe_results(self) -> Sequence['outputs.GetHttpProbeResultsHttpProbeResultResult']:
        """
        The list of http_probe_results.
        """
        return pulumi.get(self, "http_probe_results")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="probeConfigurationId")
    def probe_configuration_id(self) -> str:
        """
        The OCID of the monitor or on-demand probe responsible for creating this result.
        """
        return pulumi.get(self, "probe_configuration_id")

    @property
    @pulumi.getter(name="startTimeGreaterThanOrEqualTo")
    def start_time_greater_than_or_equal_to(self) -> Optional[float]:
        return pulumi.get(self, "start_time_greater_than_or_equal_to")

    @property
    @pulumi.getter(name="startTimeLessThanOrEqualTo")
    def start_time_less_than_or_equal_to(self) -> Optional[float]:
        return pulumi.get(self, "start_time_less_than_or_equal_to")

    @property
    @pulumi.getter
    def target(self) -> Optional[str]:
        """
        The target hostname or IP address of the probe.
        """
        return pulumi.get(self, "target")


class AwaitableGetHttpProbeResultsResult(GetHttpProbeResultsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetHttpProbeResultsResult(
            filters=self.filters,
            http_probe_results=self.http_probe_results,
            id=self.id,
            probe_configuration_id=self.probe_configuration_id,
            start_time_greater_than_or_equal_to=self.start_time_greater_than_or_equal_to,
            start_time_less_than_or_equal_to=self.start_time_less_than_or_equal_to,
            target=self.target)


def get_http_probe_results(filters: Optional[Sequence[pulumi.InputType['GetHttpProbeResultsFilterArgs']]] = None,
                           probe_configuration_id: Optional[str] = None,
                           start_time_greater_than_or_equal_to: Optional[float] = None,
                           start_time_less_than_or_equal_to: Optional[float] = None,
                           target: Optional[str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetHttpProbeResultsResult:
    """
    This data source provides the list of Http Probe Results in Oracle Cloud Infrastructure Health Checks service.

    Gets the HTTP probe results for the specified probe or monitor, where
    the `probeConfigurationId` is the OCID of either a monitor or an
    on-demand probe.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_http_probe_results = oci.HealthChecks.get_http_probe_results(probe_configuration_id=oci_health_checks_probe_configuration["test_probe_configuration"]["id"],
        start_time_greater_than_or_equal_to=var["http_probe_result_start_time_greater_than_or_equal_to"],
        start_time_less_than_or_equal_to=var["http_probe_result_start_time_less_than_or_equal_to"],
        target=var["http_probe_result_target"])
    ```


    :param str probe_configuration_id: The OCID of a monitor or on-demand probe.
    :param float start_time_greater_than_or_equal_to: Returns results with a `startTime` equal to or greater than the specified value.
    :param float start_time_less_than_or_equal_to: Returns results with a `startTime` equal to or less than the specified value.
    :param str target: Filters results that match the `target`.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['probeConfigurationId'] = probe_configuration_id
    __args__['startTimeGreaterThanOrEqualTo'] = start_time_greater_than_or_equal_to
    __args__['startTimeLessThanOrEqualTo'] = start_time_less_than_or_equal_to
    __args__['target'] = target
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:HealthChecks/getHttpProbeResults:getHttpProbeResults', __args__, opts=opts, typ=GetHttpProbeResultsResult).value

    return AwaitableGetHttpProbeResultsResult(
        filters=pulumi.get(__ret__, 'filters'),
        http_probe_results=pulumi.get(__ret__, 'http_probe_results'),
        id=pulumi.get(__ret__, 'id'),
        probe_configuration_id=pulumi.get(__ret__, 'probe_configuration_id'),
        start_time_greater_than_or_equal_to=pulumi.get(__ret__, 'start_time_greater_than_or_equal_to'),
        start_time_less_than_or_equal_to=pulumi.get(__ret__, 'start_time_less_than_or_equal_to'),
        target=pulumi.get(__ret__, 'target'))


@_utilities.lift_output_func(get_http_probe_results)
def get_http_probe_results_output(filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetHttpProbeResultsFilterArgs']]]]] = None,
                                  probe_configuration_id: Optional[pulumi.Input[str]] = None,
                                  start_time_greater_than_or_equal_to: Optional[pulumi.Input[Optional[float]]] = None,
                                  start_time_less_than_or_equal_to: Optional[pulumi.Input[Optional[float]]] = None,
                                  target: Optional[pulumi.Input[Optional[str]]] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetHttpProbeResultsResult]:
    """
    This data source provides the list of Http Probe Results in Oracle Cloud Infrastructure Health Checks service.

    Gets the HTTP probe results for the specified probe or monitor, where
    the `probeConfigurationId` is the OCID of either a monitor or an
    on-demand probe.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_http_probe_results = oci.HealthChecks.get_http_probe_results(probe_configuration_id=oci_health_checks_probe_configuration["test_probe_configuration"]["id"],
        start_time_greater_than_or_equal_to=var["http_probe_result_start_time_greater_than_or_equal_to"],
        start_time_less_than_or_equal_to=var["http_probe_result_start_time_less_than_or_equal_to"],
        target=var["http_probe_result_target"])
    ```


    :param str probe_configuration_id: The OCID of a monitor or on-demand probe.
    :param float start_time_greater_than_or_equal_to: Returns results with a `startTime` equal to or greater than the specified value.
    :param float start_time_less_than_or_equal_to: Returns results with a `startTime` equal to or less than the specified value.
    :param str target: Filters results that match the `target`.
    """
    ...
