# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetJavaFamilyResult',
    'AwaitableGetJavaFamilyResult',
    'get_java_family',
    'get_java_family_output',
]

@pulumi.output_type
class GetJavaFamilyResult:
    """
    A collection of values returned by getJavaFamily.
    """
    def __init__(__self__, display_name=None, doc_url=None, end_of_support_life_date=None, family_version=None, id=None, is_supported_version=None, latest_release_artifacts=None, latest_release_version=None, support_type=None):
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if doc_url and not isinstance(doc_url, str):
            raise TypeError("Expected argument 'doc_url' to be a str")
        pulumi.set(__self__, "doc_url", doc_url)
        if end_of_support_life_date and not isinstance(end_of_support_life_date, str):
            raise TypeError("Expected argument 'end_of_support_life_date' to be a str")
        pulumi.set(__self__, "end_of_support_life_date", end_of_support_life_date)
        if family_version and not isinstance(family_version, str):
            raise TypeError("Expected argument 'family_version' to be a str")
        pulumi.set(__self__, "family_version", family_version)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_supported_version and not isinstance(is_supported_version, bool):
            raise TypeError("Expected argument 'is_supported_version' to be a bool")
        pulumi.set(__self__, "is_supported_version", is_supported_version)
        if latest_release_artifacts and not isinstance(latest_release_artifacts, list):
            raise TypeError("Expected argument 'latest_release_artifacts' to be a list")
        pulumi.set(__self__, "latest_release_artifacts", latest_release_artifacts)
        if latest_release_version and not isinstance(latest_release_version, str):
            raise TypeError("Expected argument 'latest_release_version' to be a str")
        pulumi.set(__self__, "latest_release_version", latest_release_version)
        if support_type and not isinstance(support_type, str):
            raise TypeError("Expected argument 'support_type' to be a str")
        pulumi.set(__self__, "support_type", support_type)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The display name of the release family.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="docUrl")
    def doc_url(self) -> str:
        """
        Link to access the documentation for the release.
        """
        return pulumi.get(self, "doc_url")

    @property
    @pulumi.getter(name="endOfSupportLifeDate")
    def end_of_support_life_date(self) -> str:
        """
        The End of Support Life (EOSL) date of the Java release family (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        """
        return pulumi.get(self, "end_of_support_life_date")

    @property
    @pulumi.getter(name="familyVersion")
    def family_version(self) -> str:
        """
        The Java release family identifier.
        """
        return pulumi.get(self, "family_version")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isSupportedVersion")
    def is_supported_version(self) -> bool:
        """
        Whether or not this Java release family is under active support. Refer [Java Support Roadmap](https://www.oracle.com/java/technologies/java-se-support-roadmap.html) for more details.
        """
        return pulumi.get(self, "is_supported_version")

    @property
    @pulumi.getter(name="latestReleaseArtifacts")
    def latest_release_artifacts(self) -> Sequence['outputs.GetJavaFamilyLatestReleaseArtifactResult']:
        """
        List of artifacts for the latest Java release version in this family. The script URLs in the response can be used from a command line, or in scripts and dockerfiles to always get the artifacts corresponding to the latest update release version.
        """
        return pulumi.get(self, "latest_release_artifacts")

    @property
    @pulumi.getter(name="latestReleaseVersion")
    def latest_release_version(self) -> str:
        """
        Latest Java release version in the family.
        """
        return pulumi.get(self, "latest_release_version")

    @property
    @pulumi.getter(name="supportType")
    def support_type(self) -> str:
        """
        This indicates the support category for the Java release family.
        """
        return pulumi.get(self, "support_type")


class AwaitableGetJavaFamilyResult(GetJavaFamilyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetJavaFamilyResult(
            display_name=self.display_name,
            doc_url=self.doc_url,
            end_of_support_life_date=self.end_of_support_life_date,
            family_version=self.family_version,
            id=self.id,
            is_supported_version=self.is_supported_version,
            latest_release_artifacts=self.latest_release_artifacts,
            latest_release_version=self.latest_release_version,
            support_type=self.support_type)


def get_java_family(family_version: Optional[str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetJavaFamilyResult:
    """
    This data source provides details about a specific Java Family resource in Oracle Cloud Infrastructure Jms service.

    Returns metadata associated with a specific Java release family.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_java_family = oci.Jms.get_java_family(family_version=var["java_family_family_version"])
    ```


    :param str family_version: Unique Java family version identifier.
    """
    __args__ = dict()
    __args__['familyVersion'] = family_version
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Jms/getJavaFamily:getJavaFamily', __args__, opts=opts, typ=GetJavaFamilyResult).value

    return AwaitableGetJavaFamilyResult(
        display_name=pulumi.get(__ret__, 'display_name'),
        doc_url=pulumi.get(__ret__, 'doc_url'),
        end_of_support_life_date=pulumi.get(__ret__, 'end_of_support_life_date'),
        family_version=pulumi.get(__ret__, 'family_version'),
        id=pulumi.get(__ret__, 'id'),
        is_supported_version=pulumi.get(__ret__, 'is_supported_version'),
        latest_release_artifacts=pulumi.get(__ret__, 'latest_release_artifacts'),
        latest_release_version=pulumi.get(__ret__, 'latest_release_version'),
        support_type=pulumi.get(__ret__, 'support_type'))


@_utilities.lift_output_func(get_java_family)
def get_java_family_output(family_version: Optional[pulumi.Input[str]] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetJavaFamilyResult]:
    """
    This data source provides details about a specific Java Family resource in Oracle Cloud Infrastructure Jms service.

    Returns metadata associated with a specific Java release family.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_java_family = oci.Jms.get_java_family(family_version=var["java_family_family_version"])
    ```


    :param str family_version: Unique Java family version identifier.
    """
    ...
