from enum import Enum
from woningwaardering.vera.bvg.generated import Referentiedata


class Inexploitatiereden(Enum):
    aankoop = Referentiedata(
        code="AAN",
        naam="Aankoop",
    )
    """
    De eenheid is in exploitatie genomen nadat deze is aangekocht
    """

    administratief = Referentiedata(
        code="ADM",
        naam="Administratief",
    )
    """
    De eenheid wordt in exploitatie genomen namens een andere partij die eigenaar is van
    de eenheid (bijvoorbeeld een andere corporatie)
    """

    hernieuwbouw = Referentiedata(
        code="HER",
        naam="Hernieuwbouw",
    )
    """
    De eenheid is (weer) in exploitatie genomen nadat deze is vernieuwbouwd
    """

    nieuwbouw = Referentiedata(
        code="NIE",
        naam="Nieuwbouw",
    )
    """
    De eenheid is in exploitatie genomen nadat deze is opgeleverd uit nieuwbouw
    """

    planmatig_onderhoud = Referentiedata(
        code="PLA",
        naam="Planmatig onderhoud",
    )
    """
    De eenheid is (weer) in exploitatie genomen nadat planmatig onderhoud heeft
    plaatsgevonden
    """

    renovatie = Referentiedata(
        code="REN",
        naam="Renovatie",
    )
    """
    De eenheid is (weer) in exploitatie genomen nadat deze is gerenoveerd
    """

    splitsing = Referentiedata(
        code="SPL",
        naam="Splitsing",
    )
    """
    De eenheid is ontstaan door splitsing van een andere eenheid
    """

    transformatie = Referentiedata(
        code="TRA",
        naam="Transformatie",
    )
    """
    De eenheid is (weer) in exploitatie genomen na een transformatie van (een gebouw
    met) een niet-woonfunctie naar een woonfunctie
    """

    teruggekocht = Referentiedata(
        code="VOV",
        naam="Teruggekocht",
    )
    """
    De eenheid is (weer) in exploitatie genomen nadat deze is teruggekocht uit een
    terugkoopplicht (VoV)
    """

    uitruil = Referentiedata(
        code="UIT",
        naam="Uitruil",
    )
    """
    De eenheid is in exploitatie genomen nadat deze is verkregen door uitruil met een
    andere vastgoedeigenaar
    """

    @property
    def code(self) -> str:
        if self.value.code is None:
            raise TypeError("de code van een Referentiedata object mag niet None zijn")
        return self.value.code

    @property
    def naam(self) -> str | None:
        return self.value.naam

    @property
    def parent(self) -> Referentiedata | None:
        return self.value.parent
