# Impresso Schemas

Repository of JSON schemas (draft 06) used in the [Impresso project](https://impresso-project.ch/).

We define schemas for:

- Newspaper
    - [Issue](docs/issue.schema.md)
    - [Page](docs/page.schema.md)
    - [Content Item](docs/contentitem.schema.md)
- Topic Model
    - [Topic Assignment](docs/topic_assignment.schema.md)
    - [Topic Description](docs/topic_description.schema.md)

## File organisation

 - `json/` subdirectory for JSON schemas
 - `examples/` subdirectory for example/test files
 - `docs/` documentation of schemas in markdown format

## Validation examples

Run:

```bash
make tests
```

## Documentation

Generated by using [`jsonschema2md`](https://github.com/adobe/jsonschema2md) with the following commands:

```bash
make documentation
```

## License

The content in this repository is licensed under an MIT license.

## Credits

The schemas resulted from the work of [Simon Clematide](https://github.com/simon-clematide), [Maud Ehrmann](https://github.com/e-maud) and [Matteo Romanello](http://github.com/mromanello/) in the context of the Impresso project, funded by the [SNF Sinergia Grant n. 173719](http://p3.snf.ch/project-173719).
