# gradientai.openapi.client.BlocksApi

All URIs are relative to *https://api.gradient.ai/api*

Method | HTTP request | Description
------------- | ------------- | -------------
[**analyze_sentiment**](BlocksApi.md#analyze_sentiment) | **POST** /blocks/analyze-sentiment | Sentiment analysis
[**extract_entity**](BlocksApi.md#extract_entity) | **POST** /blocks/extract | Entity extraction
[**generate_answer**](BlocksApi.md#generate_answer) | **POST** /blocks/answer | Document question &amp; answer
[**personalize_document**](BlocksApi.md#personalize_document) | **POST** /blocks/personalize | Document personalization
[**summarize_document**](BlocksApi.md#summarize_document) | **POST** /blocks/summarize | Document summary


# **analyze_sentiment**
> AnalyzeSentimentSuccess analyze_sentiment(x_gradient_workspace_id, analyze_sentiment_body_params)

Sentiment analysis

Analyzes text to determine the emotional tone of the message.

### Example

* Bearer Authentication (AccessToken):
```python
import time
import os
import gradientai.openapi.client
from gradientai.openapi.client.models.analyze_sentiment_body_params import AnalyzeSentimentBodyParams
from gradientai.openapi.client.models.analyze_sentiment_success import AnalyzeSentimentSuccess
from gradientai.openapi.client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.gradient.ai/api
# See configuration.py for a list of all supported configuration parameters.
configuration = gradientai.openapi.client.Configuration(
    host = "https://api.gradient.ai/api"
)

# The client must configure the authentication parameter for being able to make the call. Gradient uses
# access tokens, which can be generated by going to https://auth.gradient.ai/select-workspace and selecting
# "Access tokens" under the profile drop-down.

# Configure Bearer authorization: AccessToken
configuration = gradientai.openapi.client.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)

# Enter a context with an instance of the API client
with gradientai.openapi.client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = gradientai.openapi.client.BlocksApi(api_client)
    x_gradient_workspace_id = 'x_gradient_workspace_id_example' # str | 
    analyze_sentiment_body_params = gradientai.openapi.client.AnalyzeSentimentBodyParams() # AnalyzeSentimentBodyParams | 

    try:
        # Sentiment analysis
        api_response = api_instance.analyze_sentiment(x_gradient_workspace_id, analyze_sentiment_body_params)
        print("The response of BlocksApi->analyze_sentiment:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling BlocksApi->analyze_sentiment: %s\n" % e)
```


### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **x_gradient_workspace_id** | **str**|  | 
 **analyze_sentiment_body_params** | [**AnalyzeSentimentBodyParams**](AnalyzeSentimentBodyParams.md)|  | 

### Return type

[**AnalyzeSentimentSuccess**](AnalyzeSentimentSuccess.md)

### Authorization

[AccessToken](../README.md#AccessToken)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Success |  -  |
**4XX** | Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **extract_entity**
> ExtractEntitySuccess extract_entity(x_gradient_workspace_id, extract_entity_body_params)

Entity extraction

Extracts an entity from the document with the specified fields and types.

### Example

* Bearer Authentication (AccessToken):
```python
import time
import os
import gradientai.openapi.client
from gradientai.openapi.client.models.extract_entity_body_params import ExtractEntityBodyParams
from gradientai.openapi.client.models.extract_entity_success import ExtractEntitySuccess
from gradientai.openapi.client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.gradient.ai/api
# See configuration.py for a list of all supported configuration parameters.
configuration = gradientai.openapi.client.Configuration(
    host = "https://api.gradient.ai/api"
)

# The client must configure the authentication parameter for being able to make the call. Gradient uses
# access tokens, which can be generated by going to https://auth.gradient.ai/select-workspace and selecting
# "Access tokens" under the profile drop-down.

# Configure Bearer authorization: AccessToken
configuration = gradientai.openapi.client.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)

# Enter a context with an instance of the API client
with gradientai.openapi.client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = gradientai.openapi.client.BlocksApi(api_client)
    x_gradient_workspace_id = 'x_gradient_workspace_id_example' # str | 
    extract_entity_body_params = gradientai.openapi.client.ExtractEntityBodyParams() # ExtractEntityBodyParams | 

    try:
        # Entity extraction
        api_response = api_instance.extract_entity(x_gradient_workspace_id, extract_entity_body_params)
        print("The response of BlocksApi->extract_entity:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling BlocksApi->extract_entity: %s\n" % e)
```


### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **x_gradient_workspace_id** | **str**|  | 
 **extract_entity_body_params** | [**ExtractEntityBodyParams**](ExtractEntityBodyParams.md)|  | 

### Return type

[**ExtractEntitySuccess**](ExtractEntitySuccess.md)

### Authorization

[AccessToken](../README.md#AccessToken)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Success |  -  |
**4XX** | Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **generate_answer**
> GenerateAnswerSuccess generate_answer(x_gradient_workspace_id, generate_answer_body_params)

Document question & answer

Answers questions using the provided context.

### Example

* Bearer Authentication (AccessToken):
```python
import time
import os
import gradientai.openapi.client
from gradientai.openapi.client.models.generate_answer_body_params import GenerateAnswerBodyParams
from gradientai.openapi.client.models.generate_answer_success import GenerateAnswerSuccess
from gradientai.openapi.client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.gradient.ai/api
# See configuration.py for a list of all supported configuration parameters.
configuration = gradientai.openapi.client.Configuration(
    host = "https://api.gradient.ai/api"
)

# The client must configure the authentication parameter for being able to make the call. Gradient uses
# access tokens, which can be generated by going to https://auth.gradient.ai/select-workspace and selecting
# "Access tokens" under the profile drop-down.

# Configure Bearer authorization: AccessToken
configuration = gradientai.openapi.client.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)

# Enter a context with an instance of the API client
with gradientai.openapi.client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = gradientai.openapi.client.BlocksApi(api_client)
    x_gradient_workspace_id = 'x_gradient_workspace_id_example' # str | 
    generate_answer_body_params = gradientai.openapi.client.GenerateAnswerBodyParams() # GenerateAnswerBodyParams | 

    try:
        # Document question & answer
        api_response = api_instance.generate_answer(x_gradient_workspace_id, generate_answer_body_params)
        print("The response of BlocksApi->generate_answer:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling BlocksApi->generate_answer: %s\n" % e)
```


### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **x_gradient_workspace_id** | **str**|  | 
 **generate_answer_body_params** | [**GenerateAnswerBodyParams**](GenerateAnswerBodyParams.md)|  | 

### Return type

[**GenerateAnswerSuccess**](GenerateAnswerSuccess.md)

### Authorization

[AccessToken](../README.md#AccessToken)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Success |  -  |
**4XX** | Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **personalize_document**
> PersonalizeDocumentSuccess personalize_document(x_gradient_workspace_id, personalize_document_body_params)

Document personalization

Personalizes the document in a tone and style specific to the described target audience.

### Example

* Bearer Authentication (AccessToken):
```python
import time
import os
import gradientai.openapi.client
from gradientai.openapi.client.models.personalize_document_body_params import PersonalizeDocumentBodyParams
from gradientai.openapi.client.models.personalize_document_success import PersonalizeDocumentSuccess
from gradientai.openapi.client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.gradient.ai/api
# See configuration.py for a list of all supported configuration parameters.
configuration = gradientai.openapi.client.Configuration(
    host = "https://api.gradient.ai/api"
)

# The client must configure the authentication parameter for being able to make the call. Gradient uses
# access tokens, which can be generated by going to https://auth.gradient.ai/select-workspace and selecting
# "Access tokens" under the profile drop-down.

# Configure Bearer authorization: AccessToken
configuration = gradientai.openapi.client.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)

# Enter a context with an instance of the API client
with gradientai.openapi.client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = gradientai.openapi.client.BlocksApi(api_client)
    x_gradient_workspace_id = 'x_gradient_workspace_id_example' # str | 
    personalize_document_body_params = gradientai.openapi.client.PersonalizeDocumentBodyParams() # PersonalizeDocumentBodyParams | 

    try:
        # Document personalization
        api_response = api_instance.personalize_document(x_gradient_workspace_id, personalize_document_body_params)
        print("The response of BlocksApi->personalize_document:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling BlocksApi->personalize_document: %s\n" % e)
```


### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **x_gradient_workspace_id** | **str**|  | 
 **personalize_document_body_params** | [**PersonalizeDocumentBodyParams**](PersonalizeDocumentBodyParams.md)|  | 

### Return type

[**PersonalizeDocumentSuccess**](PersonalizeDocumentSuccess.md)

### Authorization

[AccessToken](../README.md#AccessToken)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Success |  -  |
**4XX** | Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **summarize_document**
> SummarizeDocumentSuccess summarize_document(x_gradient_workspace_id, summarize_document_body_params)

Document summary

Generates a summary of the document using the provided guidance.

### Example

* Bearer Authentication (AccessToken):
```python
import time
import os
import gradientai.openapi.client
from gradientai.openapi.client.models.summarize_document_body_params import SummarizeDocumentBodyParams
from gradientai.openapi.client.models.summarize_document_success import SummarizeDocumentSuccess
from gradientai.openapi.client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.gradient.ai/api
# See configuration.py for a list of all supported configuration parameters.
configuration = gradientai.openapi.client.Configuration(
    host = "https://api.gradient.ai/api"
)

# The client must configure the authentication parameter for being able to make the call. Gradient uses
# access tokens, which can be generated by going to https://auth.gradient.ai/select-workspace and selecting
# "Access tokens" under the profile drop-down.

# Configure Bearer authorization: AccessToken
configuration = gradientai.openapi.client.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)

# Enter a context with an instance of the API client
with gradientai.openapi.client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = gradientai.openapi.client.BlocksApi(api_client)
    x_gradient_workspace_id = 'x_gradient_workspace_id_example' # str | 
    summarize_document_body_params = gradientai.openapi.client.SummarizeDocumentBodyParams() # SummarizeDocumentBodyParams | 

    try:
        # Document summary
        api_response = api_instance.summarize_document(x_gradient_workspace_id, summarize_document_body_params)
        print("The response of BlocksApi->summarize_document:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling BlocksApi->summarize_document: %s\n" % e)
```


### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **x_gradient_workspace_id** | **str**|  | 
 **summarize_document_body_params** | [**SummarizeDocumentBodyParams**](SummarizeDocumentBodyParams.md)|  | 

### Return type

[**SummarizeDocumentSuccess**](SummarizeDocumentSuccess.md)

### Authorization

[AccessToken](../README.md#AccessToken)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Success |  -  |
**4XX** | Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

