# coding: utf-8

"""
    Gradient AI API

    Interface for interacting with Gradient AI.  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Contact: support@gradient.ai
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, List, Optional
from pydantic import BaseModel, Field, StrictStr, conlist, constr, validator
from gradientai.openapi.client.models.summarize_document_body_params_examples_inner import SummarizeDocumentBodyParamsExamplesInner

class SummarizeDocumentBodyParams(BaseModel):
    """
    SummarizeDocumentBodyParams
    """
    document: constr(strict=True, min_length=1) = Field(..., description="The document to summarize.")
    examples: conlist(SummarizeDocumentBodyParamsExamplesInner) = Field(..., description="Examples of how to summarize documents.")
    length: Optional[StrictStr] = Field(None, description="Roughly how long the summary should be.")
    additional_properties: Dict[str, Any] = {}
    __properties = ["document", "examples", "length"]

    @validator('length')
    def length_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('short', 'medium', 'long'):
            raise ValueError("must be one of enum values ('short', 'medium', 'long')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SummarizeDocumentBodyParams:
        """Create an instance of SummarizeDocumentBodyParams from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                            "additional_properties"
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in examples (list)
        _items = []
        if self.examples:
            for _item in self.examples:
                if _item:
                    _items.append(_item.to_dict())
            _dict['examples'] = _items
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if length (nullable) is None
        # and __fields_set__ contains the field
        if self.length is None and "length" in self.__fields_set__:
            _dict['length'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SummarizeDocumentBodyParams:
        """Create an instance of SummarizeDocumentBodyParams from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return SummarizeDocumentBodyParams.parse_obj(obj)

        _obj = SummarizeDocumentBodyParams.parse_obj({
            "document": obj.get("document"),
            "examples": [SummarizeDocumentBodyParamsExamplesInner.from_dict(_item) for _item in obj.get("examples")] if obj.get("examples") is not None else None,
            "length": obj.get("length")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj

