"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.NoArtifacts = void 0;
const artifacts_1 = require("./artifacts");
/**
 * A `NO_ARTIFACTS` CodeBuild Project Artifact definition.
 * This is the default artifact type,
 * if none was specified when creating the Project
 * (and the source was not specified to be CodePipeline).
 * *Note*: the `NO_ARTIFACTS` type cannot be used as a secondary artifact,
 * and because of that, you're not allowed to specify an identifier for it.
 *
 * This class is private to the @aws-codebuild package.
 */
class NoArtifacts extends artifacts_1.Artifacts {
    constructor() {
        super({});
        this.type = 'NO_ARTIFACTS';
    }
}
exports.NoArtifacts = NoArtifacts;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibm8tYXJ0aWZhY3RzLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsibm8tYXJ0aWZhY3RzLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUFBLDJDQUF3QztBQUV4Qzs7Ozs7Ozs7O0dBU0c7QUFDSCxNQUFhLFdBQVksU0FBUSxxQkFBUztJQUd4QztRQUNFLEtBQUssQ0FBQyxFQUFFLENBQUMsQ0FBQztRQUhJLFNBQUksR0FBRyxjQUFjLENBQUM7SUFJdEMsQ0FBQztDQUNGO0FBTkQsa0NBTUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBBcnRpZmFjdHMgfSBmcm9tICcuL2FydGlmYWN0cyc7XG5cbi8qKlxuICogQSBgTk9fQVJUSUZBQ1RTYCBDb2RlQnVpbGQgUHJvamVjdCBBcnRpZmFjdCBkZWZpbml0aW9uLlxuICogVGhpcyBpcyB0aGUgZGVmYXVsdCBhcnRpZmFjdCB0eXBlLFxuICogaWYgbm9uZSB3YXMgc3BlY2lmaWVkIHdoZW4gY3JlYXRpbmcgdGhlIFByb2plY3RcbiAqIChhbmQgdGhlIHNvdXJjZSB3YXMgbm90IHNwZWNpZmllZCB0byBiZSBDb2RlUGlwZWxpbmUpLlxuICogKk5vdGUqOiB0aGUgYE5PX0FSVElGQUNUU2AgdHlwZSBjYW5ub3QgYmUgdXNlZCBhcyBhIHNlY29uZGFyeSBhcnRpZmFjdCxcbiAqIGFuZCBiZWNhdXNlIG9mIHRoYXQsIHlvdSdyZSBub3QgYWxsb3dlZCB0byBzcGVjaWZ5IGFuIGlkZW50aWZpZXIgZm9yIGl0LlxuICpcbiAqIFRoaXMgY2xhc3MgaXMgcHJpdmF0ZSB0byB0aGUgQGF3cy1jb2RlYnVpbGQgcGFja2FnZS5cbiAqL1xuZXhwb3J0IGNsYXNzIE5vQXJ0aWZhY3RzIGV4dGVuZHMgQXJ0aWZhY3RzIHtcbiAgcHVibGljIHJlYWRvbmx5IHR5cGUgPSAnTk9fQVJUSUZBQ1RTJztcblxuICBjb25zdHJ1Y3RvcigpIHtcbiAgICBzdXBlcih7fSk7XG4gIH1cbn1cbiJdfQ==