/*
 * Decompiled with CFR 0.152.
 */
package com.datapps.linkoopdb.jdbc.impl;

import com.datapps.linkoopdb.jdbc.impl.JDBCCommonDataSource;
import com.datapps.linkoopdb.jdbc.impl.JDBCDriver;
import com.datapps.linkoopdb.jdbc.impl.JDBCUtil;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Wrapper;
import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.DataSource;

public class JDBCDataSource
extends JDBCCommonDataSource
implements DataSource,
Serializable,
Referenceable,
Wrapper {
    @Override
    public Connection getConnection() throws SQLException {
        if (this.url == null) {
            throw JDBCUtil.nullArgument("url");
        }
        if (this.connectionProps == null) {
            if (this.user == null) {
                throw JDBCUtil.invalidArgument("user");
            }
            if (this.password == null) {
                throw JDBCUtil.invalidArgument("password");
            }
            return this.getConnection(this.user, this.password);
        }
        return this.getConnection(this.url, this.connectionProps);
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        if (username == null) {
            throw JDBCUtil.invalidArgument("user");
        }
        if (password == null) {
            throw JDBCUtil.invalidArgument("password");
        }
        Properties props = new Properties();
        props.setProperty("user", username);
        props.setProperty("password", password);
        props.setProperty("loginTimeout", Integer.toString(this.loginTimeout));
        return this.getConnection(this.url, props);
    }

    private Connection getConnection(String url, Properties props) throws SQLException {
        if (!url.startsWith("jdbc:linkoopdb:")) {
            url = "jdbc:linkoopdb:" + url;
        }
        return JDBCDriver.getConnection(url, props);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (this.isWrapperFor(iface)) {
            return (T)this;
        }
        throw JDBCUtil.invalidArgument("iface: " + iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface != null && iface.isAssignableFrom(this.getClass());
    }

    @Override
    public Reference getReference() throws NamingException {
        String cname = "com.datapps.linkoopdb.jdbc.jdbc.JDBCDataSourceFactory";
        Reference ref = new Reference(this.getClass().getName(), cname, null);
        ref.add(new StringRefAddr("database", this.getDatabase()));
        ref.add(new StringRefAddr("user", this.getUser()));
        ref.add(new StringRefAddr("password", this.password));
        ref.add(new StringRefAddr("loginTimeout", Integer.toString(this.loginTimeout)));
        return ref;
    }
}

