/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel;

import hex.genmodel.algos.isotonic.IsotonicCalibrator;
import hex.genmodel.descriptor.ModelDescriptor;
import hex.genmodel.utils.StringEscapeUtils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public abstract class AbstractMojoWriter {
    private ModelDescriptor model;
    private String targetdir;
    private StringBuilder tmpfile;
    private String tmpname;
    private ZipOutputStream zos;
    private Map<String, String> lkv;

    public AbstractMojoWriter(ModelDescriptor model) {
        this.model = model;
        this.lkv = new LinkedHashMap<String, String>(20);
    }

    public abstract String mojoVersion();

    protected abstract void writeModelData() throws IOException;

    protected final void writekv(String key, Object value) throws IOException {
        String valStr;
        String string = valStr = value == null ? "null" : value.toString();
        if (valStr.contains("\n")) {
            throw new IOException("The `value` must not contain newline characters, got: " + valStr);
        }
        if (this.lkv.containsKey(key)) {
            throw new IOException("Key " + key + " was already written");
        }
        this.lkv.put(key, valStr);
    }

    protected final void writekv(String key, int[] value) throws IOException {
        this.writekv(key, Arrays.toString(value));
    }

    protected final void writekv(String key, double[] value) throws IOException {
        this.writekv(key, Arrays.toString(value));
    }

    protected final void writekv(String key, float[] value) throws IOException {
        this.writekv(key, Arrays.toString(value));
    }

    protected final void write(IsotonicCalibrator calibrator) throws IOException {
        this.writekv("calib_min_x", calibrator._min_x);
        this.writekv("calib_max_x", calibrator._max_x);
        this.writeblob("calib/thresholds_x", calibrator._thresholds_x);
        this.writeblob("calib/thresholds_y", calibrator._thresholds_y);
    }

    private void writeblob(String filename, double[] doubles) throws IOException {
        ByteBuffer bb = ByteBuffer.wrap(new byte[4 + doubles.length * 8]);
        bb.putInt(doubles.length);
        for (double val : doubles) {
            bb.putDouble(val);
        }
        this.writeblob(filename, bb.array());
    }

    protected final void writeblob(String filename, byte[] blob) throws IOException {
        ZipEntry archiveEntry = new ZipEntry(this.targetdir + filename);
        archiveEntry.setSize(blob.length);
        this.zos.putNextEntry(archiveEntry);
        this.zos.write(blob);
        this.zos.closeEntry();
    }

    protected final void startWritingTextFile(String filename) {
        assert (this.tmpfile == null) : "Previous text file was not closed";
        this.tmpfile = new StringBuilder();
        this.tmpname = filename;
    }

    protected final void writeln(String s, boolean escapeNewlines) {
        assert (this.tmpfile != null) : "No text file is currently being written";
        this.tmpfile.append(escapeNewlines ? StringEscapeUtils.escapeNewlines(s) : s);
        this.tmpfile.append('\n');
    }

    private void writelnkv(String key, String value, boolean escapeNewlines) {
        assert (this.tmpfile != null) : "No text file is currently being written";
        this.tmpfile.append(escapeNewlines ? StringEscapeUtils.escapeNewlines(key) : key);
        this.tmpfile.append(" = ");
        this.tmpfile.append(escapeNewlines ? StringEscapeUtils.escapeNewlines(value) : value);
        this.tmpfile.append('\n');
    }

    protected void writelnkv(String key, String value) {
        this.writelnkv(key, value, false);
    }

    protected final void writeln(String s) {
        this.writeln(s, false);
    }

    protected final void finishWritingTextFile() throws IOException {
        assert (this.tmpfile != null) : "No text file is currently being written";
        this.writeblob(this.tmpname, AbstractMojoWriter.toBytes(this.tmpfile));
        this.tmpfile = null;
    }

    protected void writeTo(ZipOutputStream zos) throws IOException {
        this.writeTo(zos, "");
    }

    public final void writeTo(ZipOutputStream zos, String zipDirectory) throws IOException {
        this.initWriting(zos, zipDirectory);
        this.addCommonModelInfo();
        this.writeModelData();
        this.writeModelInfo();
        this.writeDomains();
        this.writeExtraInfo();
    }

    protected void writeExtraInfo() throws IOException {
    }

    private void initWriting(ZipOutputStream zos, String targetdir) {
        this.zos = zos;
        this.targetdir = targetdir;
    }

    private void addCommonModelInfo() throws IOException {
        int n_categoricals = 0;
        for (String[] domain : this.model.scoringDomains()) {
            if (domain == null) continue;
            ++n_categoricals;
        }
        this.writekv("h2o_version", this.model.projectVersion());
        this.writekv("mojo_version", this.mojoVersion());
        this.writekv("license", "Apache License Version 2.0");
        this.writekv("algo", this.model.algoName().toLowerCase());
        this.writekv("algorithm", this.model.algoFullName());
        this.writekv("endianness", ByteOrder.nativeOrder());
        this.writekv("category", (Object)this.model.getModelCategory());
        this.writekv("uuid", this.model.uuid());
        this.writekv("supervised", this.model.isSupervised());
        this.writekv("n_features", this.model.nfeatures());
        this.writekv("n_classes", this.model.nclasses());
        this.writekv("n_columns", this.model.columnNames().length);
        this.writekv("n_domains", n_categoricals);
        if (this.model.offsetColumn() != null) {
            this.writekv("offset_column", this.model.offsetColumn());
        }
        if (this.model.foldColumn() != null) {
            this.writekv("fold_column", this.model.foldColumn());
        }
        this.writekv("balance_classes", this.model.balanceClasses());
        this.writekv("default_threshold", this.model.defaultThreshold());
        this.writekv("prior_class_distrib", Arrays.toString(this.model.priorClassDist()));
        this.writekv("model_class_distrib", Arrays.toString(this.model.modelClassDist()));
        this.writekv("timestamp", this.model.timestamp());
        this.writekv("escape_domain_values", true);
    }

    private void writeModelInfo() throws IOException {
        this.startWritingTextFile("model.ini");
        this.writeln("[info]");
        for (Map.Entry<String, String> kv : this.lkv.entrySet()) {
            this.writelnkv(kv.getKey(), kv.getValue());
        }
        this.writeln("\n[columns]");
        for (String name : this.model.columnNames()) {
            this.writeln(name);
        }
        this.writeln("\n[domains]");
        String format = "%d: %d d%03d.txt";
        int domIndex = 0;
        String[][] domains = this.model.scoringDomains();
        for (int colIndex = 0; colIndex < domains.length; ++colIndex) {
            if (domains[colIndex] == null) continue;
            this.writeln(String.format(format, colIndex, domains[colIndex].length, domIndex++));
        }
        this.finishWritingTextFile();
    }

    protected void writeDomains() throws IOException {
        int domIndex = 0;
        for (String[] domain : this.model.scoringDomains()) {
            if (domain == null) continue;
            this.writeStringArray(domain, String.format("domains/d%03d.txt", domIndex++));
        }
    }

    protected void writeStringArray(String[] array, String filename) throws IOException {
        this.startWritingTextFile(filename);
        for (String value : array) {
            this.writeln(value, true);
        }
        this.finishWritingTextFile();
    }

    private static byte[] toBytes(Object value) {
        return String.valueOf(value).getBytes(Charset.forName("UTF-8"));
    }
}

