/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.tree;

import hex.genmodel.algos.tree.TreeSHAPPredictor;
import java.util.Collection;

public class TreeSHAPEnsemble<R>
implements TreeSHAPPredictor<R> {
    private final TreeSHAPPredictor<R>[] _predictors;
    private final float _initPred;
    private final int _wsMakerIndex;

    public TreeSHAPEnsemble(Collection<TreeSHAPPredictor<R>> predictors, float initPred) {
        this._predictors = predictors.toArray(new TreeSHAPPredictor[0]);
        this._initPred = initPred;
        this._wsMakerIndex = TreeSHAPEnsemble.findWorkspaceMaker(this._predictors);
    }

    @Override
    public float[] calculateContributions(R feat, float[] out_contribs) {
        return this.calculateContributions(feat, out_contribs, 0, -1, this.makeWorkspace());
    }

    @Override
    public float[] calculateContributions(R feat, float[] out_contribs, int condition, int condition_feature, TreeSHAPPredictor.Workspace workspace) {
        if (condition == 0) {
            int n = out_contribs.length - 1;
            out_contribs[n] = out_contribs[n] + this._initPred;
        }
        for (TreeSHAPPredictor<R> predictor : this._predictors) {
            predictor.calculateContributions(feat, out_contribs, condition, condition_feature, workspace);
        }
        return out_contribs;
    }

    @Override
    public double[] calculateInterventionalContributions(R feat, R background, double[] out_contribs, int[] catOffsets, boolean expand) {
        int n = out_contribs.length - 1;
        out_contribs[n] = out_contribs[n] + (double)this._initPred;
        for (TreeSHAPPredictor<R> predictor : this._predictors) {
            predictor.calculateInterventionalContributions(feat, background, out_contribs, catOffsets, expand);
        }
        return out_contribs;
    }

    @Override
    public TreeSHAPPredictor.Workspace makeWorkspace() {
        return this._wsMakerIndex >= 0 ? this._predictors[this._wsMakerIndex].makeWorkspace() : null;
    }

    @Override
    public int getWorkspaceSize() {
        return this._wsMakerIndex >= 0 ? this._predictors[this._wsMakerIndex].getWorkspaceSize() : 0;
    }

    private static int findWorkspaceMaker(TreeSHAPPredictor<?>[] predictors) {
        if (predictors.length == 0) {
            return -1;
        }
        int maxSize = 0;
        int wsMakerIndex = 0;
        for (int i = 0; i < predictors.length; ++i) {
            int size = predictors[i].getWorkspaceSize();
            if (size <= maxSize) continue;
            maxSize = size;
            wsMakerIndex = i;
        }
        return wsMakerIndex;
    }
}

