/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.python;

import com.google.common.base.Function;
import java.util.Objects;
import org.jpmml.python.CastUtil;
import org.jpmml.python.PythonException;

public abstract class CastFunction<E>
implements Function<Object, E> {
    private Class<? extends E> clazz = null;

    public CastFunction(Class<? extends E> clazz) {
        this.setClazz(clazz);
    }

    protected abstract String formatMessage(Object var1);

    public E apply(Object object) {
        Class<E> clazz = this.getClazz();
        try {
            object = CastUtil.deepCastTo(object, clazz);
            return clazz.cast(object);
        }
        catch (ClassCastException cce) {
            throw this.createPythonException(this.formatMessage(object), cce).fillInStackTrace();
        }
    }

    public PythonException createPythonException(String message, ClassCastException cause) {
        return new PythonException(message, cause);
    }

    public Class<? extends E> getClazz() {
        return this.clazz;
    }

    private void setClazz(Class<? extends E> clazz) {
        this.clazz = Objects.requireNonNull(clazz);
    }
}

