/*
 * Decompiled with CFR 0.152.
 */
package pandas.core;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.jpmml.python.ClassDictUtil;
import org.jpmml.python.CythonObject;
import org.jpmml.python.HasArray;
import pandas.core.Block;
import pandas.core.Index;

public class BlockManager
extends CythonObject {
    private static final String[] INIT_ATTRIBUTES = new String[]{"blocks", "axes"};
    private static final String[] SETSTATE_ATTRIBUTES = new String[]{"axes_array", "block_values", "block_items"};

    public BlockManager(String module, String name) {
        super(module, name);
    }

    @Override
    public void __init__(Object[] args) {
        if (args.length == 0) {
            super.__init__(args);
        } else {
            super.__setstate__(INIT_ATTRIBUTES, args);
        }
    }

    @Override
    public void __setstate__(Object[] args) {
        if (args.length > 3) {
            args = ClassDictUtil.extractArgs(args, 0, 3);
        }
        super.__setstate__(SETSTATE_ATTRIBUTES, args);
    }

    public Index getColumnAxis() {
        List<Index> axesArray = this.getAxesArray();
        ClassDictUtil.checkSize(2, axesArray);
        return axesArray.get(0);
    }

    public Index getRowAxis() {
        List<Index> axesArray = this.getAxesArray();
        ClassDictUtil.checkSize(2, axesArray);
        return axesArray.get(1);
    }

    public List<Index> getAxesArray() {
        if (this.hasattr("axes_array")) {
            return this.getIndexList("axes_array");
        }
        return this.getIndexList("axes");
    }

    public List<Index> getBlockItems() {
        if (this.hasattr("block_items")) {
            return this.getIndexList("block_items");
        }
        throw new UnsupportedOperationException();
    }

    public BlockManager setBlockItems(List<Index> blockItems) {
        this.setattr("block_items", blockItems);
        return this;
    }

    public List<HasArray> getBlockValues() {
        if (this.hasattr("block_values")) {
            return this.getArrayList("block_values");
        }
        Object[] blocks = this.getTuple("blocks");
        return Arrays.stream(blocks).map(block -> ((Block)((Object)((Object)block))).get("values", HasArray.class)).collect(Collectors.toList());
    }

    public BlockManager setBlockValues(List<HasArray> blockValues) {
        this.setattr("block_values", blockValues);
        return this;
    }

    public List<Index> getIndexList(String name) {
        return this.getList(name, Index.class);
    }
}

