/*
 * Decompiled with CFR 0.152.
 */
package statsmodels.discrete;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Field;
import org.dmg.pmml.OpType;
import org.jpmml.converter.CategoricalLabel;
import org.jpmml.converter.Label;
import org.jpmml.converter.TypeUtil;
import org.jpmml.statsmodels.StatsModelsEncoder;
import statsmodels.CrossSectionalModel;

public abstract class MultinomialRegressionModel
extends CrossSectionalModel {
    public MultinomialRegressionModel(String module, String name) {
        super(module, name);
    }

    @Override
    public Label encodeLabel(List<String> yNames, StatsModelsEncoder encoder) {
        Map<Integer, ?> yNamesMap = this.getYNamesMap();
        String yName = (String)Iterables.getOnlyElement(yNames);
        ArrayList categories = new ArrayList();
        for (int i = 0; i < yNamesMap.size(); ++i) {
            Object category = yNamesMap.get(i);
            if (category == null) {
                throw new IllegalArgumentException();
            }
            categories.add(category);
        }
        DataType dataType = TypeUtil.getDataType(categories, (DataType)DataType.STRING);
        DataField dataField = encoder.createDataField(yName, OpType.CATEGORICAL, dataType, categories);
        return new CategoricalLabel((Field)dataField);
    }

    public Integer getJ() {
        return this.getInteger("J");
    }

    public Integer getK() {
        return this.getInteger("K");
    }

    public Map<Integer, ?> getYNamesMap() {
        return this.getDict("_ynames_map");
    }
}

