/*
 * Decompiled with CFR 0.152.
 */
package statsmodels.genmod;

import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.List;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Field;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.OpType;
import org.dmg.pmml.general_regression.GeneralRegressionModel;
import org.jpmml.converter.CategoricalLabel;
import org.jpmml.converter.ContinuousLabel;
import org.jpmml.converter.DiscreteLabel;
import org.jpmml.converter.Label;
import org.jpmml.converter.ModelUtil;
import org.jpmml.converter.Schema;
import org.jpmml.converter.general_regression.GeneralRegressionModelUtil;
import org.jpmml.statsmodels.StatsModelsEncoder;
import statsmodels.genmod.Family;
import statsmodels.genmod.Link;
import statsmodels.regression.RegressionModel;

public class GLM
extends RegressionModel {
    public GLM(String module, String name) {
        super(module, name);
    }

    @Override
    public Label encodeLabel(List<String> yNames, StatsModelsEncoder encoder) {
        String familyName;
        Family family = this.getFamily();
        String yName = (String)Iterables.getOnlyElement(yNames);
        switch (familyName = family.getPythonName()) {
            case "Binomial": {
                DataField dataField = encoder.createDataField(yName, OpType.CATEGORICAL, DataType.INTEGER, Arrays.asList(0, 1));
                return new CategoricalLabel((Field)dataField);
            }
            case "Gaussian": 
            case "Poisson": {
                DataField dataField = encoder.createDataField(yName, OpType.CONTINUOUS, DataType.DOUBLE);
                return new ContinuousLabel((Field)dataField);
            }
        }
        throw new IllegalArgumentException(familyName);
    }

    public GeneralRegressionModel encodeModel(List<? extends Number> coefficients, Number intercept, Schema schema) {
        Object targetCategory;
        String familyName;
        Family family = this.getFamily();
        Link link = family.getLink();
        Label label = schema.getLabel();
        List features = schema.getFeatures();
        switch (familyName = family.getPythonName()) {
            case "Binomial": {
                CategoricalLabel categoricalLabel = (CategoricalLabel)label;
                targetCategory = categoricalLabel.getValue(1);
                break;
            }
            case "Gaussian": 
            case "Poisson": {
                ContinuousLabel continuousLabel = (ContinuousLabel)label;
                targetCategory = null;
                break;
            }
            default: {
                throw new IllegalArgumentException(familyName);
            }
        }
        GeneralRegressionModel generalRegressionModel = new GeneralRegressionModel(GeneralRegressionModel.ModelType.GENERALIZED_LINEAR, targetCategory != null ? MiningFunction.CLASSIFICATION : MiningFunction.REGRESSION, ModelUtil.createMiningSchema((Label)label), null, null, null).setDistribution(GLM.parseDistribution(family)).setLinkFunction(GLM.parseLinkFunction(link)).setLinkParameter(GLM.parseLinkParameter(link));
        GeneralRegressionModelUtil.encodeRegressionTable((GeneralRegressionModel)generalRegressionModel, (List)features, coefficients, (Number)intercept, (Object)targetCategory);
        switch (familyName) {
            case "Binomial": {
                CategoricalLabel categoricalLabel = (CategoricalLabel)label;
                generalRegressionModel.setOutput(ModelUtil.createProbabilityOutput((DataType)DataType.DOUBLE, (DiscreteLabel)categoricalLabel));
                break;
            }
        }
        return generalRegressionModel;
    }

    public Family getFamily() {
        return (Family)((Object)this.get("family", Family.class));
    }

    private static GeneralRegressionModel.Distribution parseDistribution(Family family) {
        String familyName;
        switch (familyName = family.getPythonName()) {
            case "Binomial": {
                return GeneralRegressionModel.Distribution.BINOMIAL;
            }
            case "Gaussian": {
                return GeneralRegressionModel.Distribution.NORMAL;
            }
            case "Poisson": {
                return GeneralRegressionModel.Distribution.POISSON;
            }
        }
        throw new IllegalArgumentException(familyName);
    }

    private static GeneralRegressionModel.LinkFunction parseLinkFunction(Link link) {
        String linkName;
        switch (linkName = link.getPythonName()) {
            case "identity": 
            case "Identity": {
                return GeneralRegressionModel.LinkFunction.IDENTITY;
            }
            case "Log": {
                return GeneralRegressionModel.LinkFunction.LOG;
            }
            case "Logit": {
                return GeneralRegressionModel.LinkFunction.LOGIT;
            }
        }
        throw new IllegalArgumentException(linkName);
    }

    private static Number parseLinkParameter(Link link) {
        String linkName;
        switch (linkName = link.getPythonName()) {
            case "identity": 
            case "Identity": 
            case "Log": 
            case "Logit": {
                return null;
            }
        }
        throw new IllegalArgumentException(linkName);
    }
}

