/*
 * Decompiled with CFR 0.152.
 */
package statsmodels.tsa;

import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Field;
import org.dmg.pmml.OpType;
import org.jpmml.converter.ContinuousLabel;
import org.jpmml.converter.Feature;
import org.jpmml.converter.Label;
import org.jpmml.converter.ModelEncoder;
import org.jpmml.converter.Schema;
import org.jpmml.statsmodels.StatsModelsEncoder;
import statsmodels.Model;
import statsmodels.data.ModelData;

public abstract class TimeSeriesModel
extends Model {
    public TimeSeriesModel(String module, String name) {
        super(module, name);
    }

    @Override
    public Schema encodeSchema(StatsModelsEncoder encoder) {
        List<String> exogNames;
        List<String> endogNames;
        ModelData data = this.getData();
        ModelData.Cache cache = data.getCache();
        if (cache.hasNames()) {
            endogNames = cache.getYNames();
            exogNames = cache.getXNames();
        } else {
            endogNames = data.getEndogNames();
            exogNames = data.getExogNames();
        }
        Label label = this.encodeLabel(endogNames, encoder);
        List<Feature> features = this.encodeFeatures(exogNames, encoder);
        return new Schema((ModelEncoder)encoder, label, features);
    }

    public Label encodeLabel(List<String> endogNames, StatsModelsEncoder encoder) {
        String endogName = (String)Iterables.getOnlyElement(endogNames);
        DataField dataField = encoder.createDataField(endogName, OpType.CONTINUOUS, DataType.DOUBLE);
        return new ContinuousLabel((Field)dataField);
    }

    public List<Feature> encodeFeatures(List<String> exogNames, StatsModelsEncoder encoder) {
        Integer kConstant = this.getKConstant();
        if (kConstant != 0) {
            if (kConstant == 1) {
                if (!Objects.equals(Collections.singletonList("const"), exogNames)) {
                    throw new IllegalArgumentException();
                }
            } else {
                throw new IllegalArgumentException();
            }
        }
        return Collections.emptyList();
    }
}

