/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.InlineTable;
import org.dmg.pmml.PMMLElements;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.VerificationFields;
import org.dmg.pmml.Visitable;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.IntegerAdapter;
import org.jpmml.model.MissingElementException;
import org.jpmml.model.annotations.CollectionElementType;
import org.jpmml.model.annotations.Property;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name="ModelVerification", namespace="http://www.dmg.org/PMML-4_4")
@XmlType(name="", propOrder={"extensions", "verificationFields", "inlineTable"})
@JsonRootName(value="ModelVerification")
@JsonPropertyOrder(value={"recordCount", "fieldCount", "extensions", "verificationFields", "inlineTable"})
public class ModelVerification
extends PMMLObject
implements HasExtensions<ModelVerification> {
    @XmlAttribute(name="recordCount")
    @XmlJavaTypeAdapter(value=IntegerAdapter.class)
    @JsonProperty(value="recordCount")
    private Integer recordCount;
    @XmlAttribute(name="fieldCount")
    @XmlJavaTypeAdapter(value=IntegerAdapter.class)
    @JsonProperty(value="fieldCount")
    private Integer fieldCount;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="Extension")
    @CollectionElementType(value=Extension.class)
    private List<Extension> extensions;
    @XmlElement(name="VerificationFields", namespace="http://www.dmg.org/PMML-4_4", required=true)
    @JsonProperty(value="VerificationFields")
    private VerificationFields verificationFields;
    @XmlElement(name="InlineTable", namespace="http://www.dmg.org/PMML-4_4", required=true)
    @JsonProperty(value="InlineTable")
    private InlineTable inlineTable;
    private static final long serialVersionUID = 67371273L;

    public ModelVerification() {
    }

    @ValueConstructor
    public ModelVerification(@Property(value="verificationFields") VerificationFields verificationFields, @Property(value="inlineTable") InlineTable inlineTable) {
        this.verificationFields = verificationFields;
        this.inlineTable = inlineTable;
    }

    public Integer getRecordCount() {
        return this.recordCount;
    }

    public ModelVerification setRecordCount(@Property(value="recordCount") Integer recordCount) {
        this.recordCount = recordCount;
        return this;
    }

    public Integer getFieldCount() {
        return this.fieldCount;
    }

    public ModelVerification setFieldCount(@Property(value="fieldCount") Integer fieldCount) {
        this.fieldCount = fieldCount;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && !this.extensions.isEmpty();
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public ModelVerification addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public VerificationFields requireVerificationFields() {
        if (this.verificationFields == null) {
            throw new MissingElementException(this, PMMLElements.MODELVERIFICATION_VERIFICATIONFIELDS);
        }
        return this.verificationFields;
    }

    public VerificationFields getVerificationFields() {
        return this.verificationFields;
    }

    public ModelVerification setVerificationFields(@Property(value="verificationFields") VerificationFields verificationFields) {
        this.verificationFields = verificationFields;
        return this;
    }

    public InlineTable requireInlineTable() {
        if (this.inlineTable == null) {
            throw new MissingElementException(this, PMMLElements.MODELVERIFICATION_INLINETABLE);
        }
        return this.inlineTable;
    }

    public InlineTable getInlineTable() {
        return this.inlineTable;
    }

    public ModelVerification setInlineTable(@Property(value="inlineTable") InlineTable inlineTable) {
        this.inlineTable = inlineTable;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, (Visitable)this.getVerificationFields(), (Visitable)this.getInlineTable());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }
}

