/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElements;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.dmg.pmml.DataDictionary;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Header;
import org.dmg.pmml.MiningBuildTask;
import org.dmg.pmml.Model;
import org.dmg.pmml.PMMLAttributes;
import org.dmg.pmml.PMMLElements;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.TransformationDictionary;
import org.dmg.pmml.Version;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.anomaly_detection.AnomalyDetectionModel;
import org.dmg.pmml.association.AssociationModel;
import org.dmg.pmml.baseline.BaselineModel;
import org.dmg.pmml.bayesian_network.BayesianNetworkModel;
import org.dmg.pmml.clustering.ClusteringModel;
import org.dmg.pmml.gaussian_process.GaussianProcessModel;
import org.dmg.pmml.general_regression.GeneralRegressionModel;
import org.dmg.pmml.mining.MiningModel;
import org.dmg.pmml.naive_bayes.NaiveBayesModel;
import org.dmg.pmml.nearest_neighbor.NearestNeighborModel;
import org.dmg.pmml.neural_network.NeuralNetwork;
import org.dmg.pmml.regression.RegressionModel;
import org.dmg.pmml.rule_set.RuleSetModel;
import org.dmg.pmml.scorecard.Scorecard;
import org.dmg.pmml.sequence.SequenceModel;
import org.dmg.pmml.support_vector_machine.SupportVectorMachineModel;
import org.dmg.pmml.text.TextModel;
import org.dmg.pmml.time_series.TimeSeriesModel;
import org.dmg.pmml.tree.TreeModel;
import org.jpmml.model.MissingAttributeException;
import org.jpmml.model.MissingElementException;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.CollectionElementType;
import org.jpmml.model.annotations.Property;
import org.jpmml.model.annotations.Since;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name="PMML", namespace="http://www.dmg.org/PMML-4_4")
@XmlType(name="", propOrder={"header", "miningBuildTask", "dataDictionary", "transformationDictionary", "models", "extensions"})
@JsonRootName(value="PMML")
@JsonPropertyOrder(value={"version", "baseVersion", "header", "miningBuildTask", "dataDictionary", "transformationDictionary", "models", "extensions"})
public class PMML
extends PMMLObject
implements HasExtensions<PMML> {
    @XmlAttribute(name="version", required=true)
    @JsonProperty(value="version")
    private String version;
    @XmlAttribute(name="x-baseVersion")
    @JsonProperty(value="x-baseVersion")
    @Added(value=Version.XPMML, removable=true)
    @Since(value="1.3.3")
    private String baseVersion;
    @XmlElement(name="Header", namespace="http://www.dmg.org/PMML-4_4", required=true)
    @JsonProperty(value="Header")
    private Header header;
    @XmlElement(name="MiningBuildTask", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="MiningBuildTask")
    private MiningBuildTask miningBuildTask;
    @XmlElement(name="DataDictionary", namespace="http://www.dmg.org/PMML-4_4", required=true)
    @JsonProperty(value="DataDictionary")
    private DataDictionary dataDictionary;
    @XmlElement(name="TransformationDictionary", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="TransformationDictionary")
    private TransformationDictionary transformationDictionary;
    @XmlElements(value={@XmlElement(name="AnomalyDetectionModel", namespace="http://www.dmg.org/PMML-4_4", type=AnomalyDetectionModel.class), @XmlElement(name="AssociationModel", namespace="http://www.dmg.org/PMML-4_4", type=AssociationModel.class), @XmlElement(name="BayesianNetworkModel", namespace="http://www.dmg.org/PMML-4_4", type=BayesianNetworkModel.class), @XmlElement(name="BaselineModel", namespace="http://www.dmg.org/PMML-4_4", type=BaselineModel.class), @XmlElement(name="ClusteringModel", namespace="http://www.dmg.org/PMML-4_4", type=ClusteringModel.class), @XmlElement(name="GaussianProcessModel", namespace="http://www.dmg.org/PMML-4_4", type=GaussianProcessModel.class), @XmlElement(name="GeneralRegressionModel", namespace="http://www.dmg.org/PMML-4_4", type=GeneralRegressionModel.class), @XmlElement(name="MiningModel", namespace="http://www.dmg.org/PMML-4_4", type=MiningModel.class), @XmlElement(name="NaiveBayesModel", namespace="http://www.dmg.org/PMML-4_4", type=NaiveBayesModel.class), @XmlElement(name="NearestNeighborModel", namespace="http://www.dmg.org/PMML-4_4", type=NearestNeighborModel.class), @XmlElement(name="NeuralNetwork", namespace="http://www.dmg.org/PMML-4_4", type=NeuralNetwork.class), @XmlElement(name="RegressionModel", namespace="http://www.dmg.org/PMML-4_4", type=RegressionModel.class), @XmlElement(name="RuleSetModel", namespace="http://www.dmg.org/PMML-4_4", type=RuleSetModel.class), @XmlElement(name="SequenceModel", namespace="http://www.dmg.org/PMML-4_4", type=SequenceModel.class), @XmlElement(name="Scorecard", namespace="http://www.dmg.org/PMML-4_4", type=Scorecard.class), @XmlElement(name="SupportVectorMachineModel", namespace="http://www.dmg.org/PMML-4_4", type=SupportVectorMachineModel.class), @XmlElement(name="TextModel", namespace="http://www.dmg.org/PMML-4_4", type=TextModel.class), @XmlElement(name="TimeSeriesModel", namespace="http://www.dmg.org/PMML-4_4", type=TimeSeriesModel.class), @XmlElement(name="TreeModel", namespace="http://www.dmg.org/PMML-4_4", type=TreeModel.class)})
    @JsonProperty(value="Model")
    @JsonTypeInfo(include=JsonTypeInfo.As.WRAPPER_OBJECT, use=JsonTypeInfo.Id.NAME)
    @JsonSubTypes(value={@JsonSubTypes.Type(name="AnomalyDetectionModel", value=AnomalyDetectionModel.class), @JsonSubTypes.Type(name="AssociationModel", value=AssociationModel.class), @JsonSubTypes.Type(name="BayesianNetworkModel", value=BayesianNetworkModel.class), @JsonSubTypes.Type(name="BaselineModel", value=BaselineModel.class), @JsonSubTypes.Type(name="ClusteringModel", value=ClusteringModel.class), @JsonSubTypes.Type(name="GaussianProcessModel", value=GaussianProcessModel.class), @JsonSubTypes.Type(name="GeneralRegressionModel", value=GeneralRegressionModel.class), @JsonSubTypes.Type(name="MiningModel", value=MiningModel.class), @JsonSubTypes.Type(name="NaiveBayesModel", value=NaiveBayesModel.class), @JsonSubTypes.Type(name="NearestNeighborModel", value=NearestNeighborModel.class), @JsonSubTypes.Type(name="NeuralNetwork", value=NeuralNetwork.class), @JsonSubTypes.Type(name="RegressionModel", value=RegressionModel.class), @JsonSubTypes.Type(name="RuleSetModel", value=RuleSetModel.class), @JsonSubTypes.Type(name="SequenceModel", value=SequenceModel.class), @JsonSubTypes.Type(name="Scorecard", value=Scorecard.class), @JsonSubTypes.Type(name="SupportVectorMachineModel", value=SupportVectorMachineModel.class), @JsonSubTypes.Type(name="TextModel", value=TextModel.class), @JsonSubTypes.Type(name="TimeSeriesModel", value=TimeSeriesModel.class), @JsonSubTypes.Type(name="TreeModel", value=TreeModel.class)})
    @CollectionElementType(value=Model.class)
    private List<Model> models;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="Extension")
    @CollectionElementType(value=Extension.class)
    private List<Extension> extensions;
    private static final long serialVersionUID = 67371273L;

    public PMML() {
    }

    @ValueConstructor
    public PMML(@Property(value="version") String version, @Property(value="header") Header header, @Property(value="dataDictionary") DataDictionary dataDictionary) {
        this.version = version;
        this.header = header;
        this.dataDictionary = dataDictionary;
    }

    public String requireVersion() {
        if (this.version == null) {
            throw new MissingAttributeException(this, PMMLAttributes.PMML_VERSION);
        }
        return this.version;
    }

    public String getVersion() {
        return this.version;
    }

    public PMML setVersion(@Property(value="version") String version) {
        this.version = version;
        return this;
    }

    public String getBaseVersion() {
        return this.baseVersion;
    }

    public PMML setBaseVersion(@Property(value="baseVersion") String baseVersion) {
        this.baseVersion = baseVersion;
        return this;
    }

    public Header requireHeader() {
        if (this.header == null) {
            throw new MissingElementException(this, PMMLElements.PMML_HEADER);
        }
        return this.header;
    }

    public Header getHeader() {
        return this.header;
    }

    public PMML setHeader(@Property(value="header") Header header) {
        this.header = header;
        return this;
    }

    public MiningBuildTask getMiningBuildTask() {
        return this.miningBuildTask;
    }

    public PMML setMiningBuildTask(@Property(value="miningBuildTask") MiningBuildTask miningBuildTask) {
        this.miningBuildTask = miningBuildTask;
        return this;
    }

    public DataDictionary requireDataDictionary() {
        if (this.dataDictionary == null) {
            throw new MissingElementException(this, PMMLElements.PMML_DATADICTIONARY);
        }
        return this.dataDictionary;
    }

    public DataDictionary getDataDictionary() {
        return this.dataDictionary;
    }

    public PMML setDataDictionary(@Property(value="dataDictionary") DataDictionary dataDictionary) {
        this.dataDictionary = dataDictionary;
        return this;
    }

    public TransformationDictionary getTransformationDictionary() {
        return this.transformationDictionary;
    }

    public PMML setTransformationDictionary(@Property(value="transformationDictionary") TransformationDictionary transformationDictionary) {
        this.transformationDictionary = transformationDictionary;
        return this;
    }

    public boolean hasModels() {
        return this.models != null && !this.models.isEmpty();
    }

    public List<Model> getModels() {
        if (this.models == null) {
            this.models = new ArrayList<Model>();
        }
        return this.models;
    }

    public PMML addModels(Model ... models) {
        this.getModels().addAll(Arrays.asList(models));
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && !this.extensions.isEmpty();
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public PMML addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, this.getHeader(), this.getMiningBuildTask(), this.getDataDictionary(), this.getTransformationDictionary());
            }
            if (status == VisitorAction.CONTINUE && this.hasModels()) {
                status = PMMLObject.traverse(visitor, this.getModels());
            }
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }
}

