/*
 * Decompiled with CFR 0.152.
 */
package sklearn.ensemble.voting;

import java.util.ArrayList;
import java.util.List;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.Model;
import org.dmg.pmml.mining.MiningModel;
import org.dmg.pmml.mining.Segmentation;
import org.jpmml.converter.Label;
import org.jpmml.converter.ModelUtil;
import org.jpmml.converter.Schema;
import org.jpmml.converter.mining.MiningModelUtil;
import sklearn.HasEstimatorEnsemble;
import sklearn.Regressor;
import sklearn.SkLearnRegressor;
import sklearn.StepUtil;

public class VotingRegressor
extends SkLearnRegressor
implements HasEstimatorEnsemble<Regressor> {
    public VotingRegressor(String module, String name) {
        super(module, name);
    }

    @Override
    public int getNumberOfFeatures() {
        List<Regressor> estimators = this.getEstimators();
        return StepUtil.getNumberOfFeatures(estimators);
    }

    @Override
    public Model encodeModel(Schema schema) {
        List<Regressor> estimators = this.getEstimators();
        List<Number> weights = this.getWeights();
        ArrayList<Model> models = new ArrayList<Model>();
        for (Regressor estimator : estimators) {
            Model model = estimator.encode(schema);
            models.add(model);
        }
        Segmentation.MultipleModelMethod multipleModelMethod = weights != null && !weights.isEmpty() ? Segmentation.MultipleModelMethod.WEIGHTED_AVERAGE : Segmentation.MultipleModelMethod.AVERAGE;
        MiningModel miningModel = new MiningModel(MiningFunction.REGRESSION, ModelUtil.createMiningSchema((Label)schema.getLabel())).setSegmentation(MiningModelUtil.createSegmentation((Segmentation.MultipleModelMethod)multipleModelMethod, (Segmentation.MissingPredictionTreatment)Segmentation.MissingPredictionTreatment.RETURN_MISSING, models, weights));
        return miningModel;
    }

    @Override
    public List<Regressor> getEstimators() {
        return this.getList("estimators_", Regressor.class);
    }

    public List<Number> getWeights() {
        Object weights = this.getOptionalObject("weights");
        if (weights == null || weights instanceof List) {
            return (List)weights;
        }
        return this.getNumberArray("weights");
    }
}

