/*
 * Decompiled with CFR 0.152.
 */
package sklearn.isotonic;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Field;
import org.dmg.pmml.LinearNorm;
import org.dmg.pmml.NormContinuous;
import org.dmg.pmml.OpType;
import org.dmg.pmml.OutlierTreatmentMethod;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.SchemaUtil;
import org.jpmml.python.ClassDictUtil;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn.Calibrator;

public class IsotonicRegression
extends Calibrator {
    private static final String OUTOFBOUNDS_CLIP = "clip";
    private static final String OUTOFBOUNDS_NAN = "nan";

    public IsotonicRegression(String module, String name) {
        super(module, name);
    }

    @Override
    public List<Feature> encodeFeatures(List<Feature> features, SkLearnEncoder encoder) {
        List<Number> xThresholds = this.getXThresholds();
        List<Number> yThresholds = this.getYThresholds();
        String outOfBounds = this.getOutOfBounds();
        ClassDictUtil.checkSize((Collection[])new Collection[]{xThresholds, yThresholds});
        SchemaUtil.checkSize((int)1, features);
        Feature feature = features.get(0);
        OutlierTreatmentMethod outlierTreatment = IsotonicRegression.parseOutlierTreatment(outOfBounds);
        NormContinuous normContinuous = new NormContinuous(feature.getName(), null).setOutlierTreatment(outlierTreatment);
        for (int i = 0; i < xThresholds.size(); ++i) {
            Number orig = xThresholds.get(i);
            Number norm = yThresholds.get(i);
            normContinuous.addLinearNorms(new LinearNorm[]{new LinearNorm(orig, norm)});
        }
        DerivedField derivedField = encoder.createDerivedField(this.createFieldName("isotonicRegression", feature), OpType.CONTINUOUS, DataType.DOUBLE, (Expression)normContinuous);
        return Collections.singletonList(new ContinuousFeature((PMMLEncoder)encoder, (Field)derivedField));
    }

    public Boolean getIncreasing() {
        return this.getBoolean("increasing_");
    }

    public List<Number> getXThresholds() {
        if (this.hasattr("_necessary_X_")) {
            return this.getNumberArray("_necessary_X_");
        }
        return this.getNumberArray("X_thresholds_");
    }

    public List<Number> getYThresholds() {
        if (this.hasattr("_necessary_y_")) {
            this.getNumberArray("_necessary_y_");
        }
        return this.getNumberArray("y_thresholds_");
    }

    public String getOutOfBounds() {
        return (String)this.getEnum("out_of_bounds", arg_0 -> ((IsotonicRegression)this).getString(arg_0), Arrays.asList(OUTOFBOUNDS_CLIP, OUTOFBOUNDS_NAN));
    }

    public static OutlierTreatmentMethod parseOutlierTreatment(String outOfBounds) {
        switch (outOfBounds) {
            case "clip": {
                return OutlierTreatmentMethod.AS_EXTREME_VALUES;
            }
            case "nan": {
                return OutlierTreatmentMethod.AS_MISSING_VALUES;
            }
        }
        throw new IllegalArgumentException(outOfBounds);
    }
}

