/*
 * Decompiled with CFR 0.152.
 */
package sklearn2pmml.decoration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Field;
import org.dmg.pmml.Interval;
import org.dmg.pmml.NumericInfo;
import org.dmg.pmml.OpType;
import org.dmg.pmml.OutlierTreatmentMethod;
import org.dmg.pmml.UnivariateStats;
import org.jpmml.converter.Decorator;
import org.jpmml.converter.Feature;
import org.jpmml.converter.OutlierDecorator;
import org.jpmml.converter.WildcardFeature;
import org.jpmml.python.ClassDictUtil;
import org.jpmml.python.TypeInfo;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn2pmml.decoration.Domain;

public class ContinuousDomain
extends Domain {
    private static final String OUTLIERTREATMENT_AS_IS = "as_is";
    private static final String OUTLIERTREATMENT_AS_EXTREME_VALUES = "as_extreme_values";
    private static final String OUTLIERTREATMENT_AS_MISSING_VALUES = "as_missing_values";

    public ContinuousDomain(String module, String name) {
        super(module, name);
    }

    @Override
    public int getNumberOfFeatures() {
        int[] dataMaxShape;
        int[] dataMinShape;
        Boolean withData = this.getWithData();
        if (withData.booleanValue() && (dataMinShape = this.getDataMinShape())[0] == (dataMaxShape = this.getDataMaxShape())[0]) {
            return dataMinShape[0];
        }
        return -1;
    }

    @Override
    public OpType getOpType() {
        return OpType.CONTINUOUS;
    }

    @Override
    public DataType getDataType() {
        TypeInfo dtype = this.getDType();
        if (dtype != null) {
            return dtype.getDataType();
        }
        return DataType.DOUBLE;
    }

    @Override
    public List<Feature> encodeFeatures(List<Feature> features, SkLearnEncoder encoder) {
        Number highValue;
        Number lowValue;
        features = super.encodeFeatures(features, encoder);
        OutlierTreatmentMethod outlierTreatment = ContinuousDomain.parseOutlierTreatment(this.getOutlierTreatment());
        if (outlierTreatment != null) {
            switch (outlierTreatment) {
                case AS_EXTREME_VALUES: 
                case AS_MISSING_VALUES: {
                    lowValue = this.getLowValue();
                    highValue = this.getHighValue();
                    break;
                }
                default: {
                    lowValue = null;
                    highValue = null;
                    break;
                }
            }
        } else {
            lowValue = null;
            highValue = null;
        }
        Boolean withData = this.getWithData();
        Boolean withStatistics = this.getWithStatistics();
        List<Number> dataMin = null;
        List<Number> dataMax = null;
        if (withData.booleanValue()) {
            dataMin = this.getDataMin();
            dataMax = this.getDataMax();
            ClassDictUtil.checkSize((Collection[])new Collection[]{features, dataMin, dataMax});
        }
        Map<String, ?> counts = null;
        Map<String, ?> numericInfo = null;
        if (withStatistics.booleanValue()) {
            counts = this.getCounts();
            numericInfo = this.getNumericInfo();
        }
        ArrayList<Feature> result = new ArrayList<Feature>();
        for (int i = 0; i < features.size(); ++i) {
            Feature feature = features.get(i);
            WildcardFeature wildcardFeature = ContinuousDomain.asWildcardFeature(feature);
            DataField dataField = wildcardFeature.getField();
            if (outlierTreatment != null) {
                encoder.addDecorator((Field)dataField, (Decorator)new OutlierDecorator(outlierTreatment, lowValue, highValue));
            }
            if (withData.booleanValue()) {
                Interval interval = new Interval(Interval.Closure.CLOSED_CLOSED).setLeftMargin(dataMin.get(i)).setRightMargin(dataMax.get(i));
                dataField.addIntervals(new Interval[]{interval});
                feature = wildcardFeature.toContinuousFeature();
            }
            if (withStatistics.booleanValue()) {
                UnivariateStats univariateStats = ((UnivariateStats)new UnivariateStats().setField((Field)dataField)).setCounts(ContinuousDomain.createCounts(ContinuousDomain.extractMap(counts, i))).setNumericInfo(ContinuousDomain.createNumericInfo(wildcardFeature.getDataType(), ContinuousDomain.extractMap(numericInfo, i)));
                encoder.addUnivariateStats(univariateStats);
            }
            result.add(feature);
        }
        return result;
    }

    public int[] getArrayShape(String name) {
        int[] shape = super.getArrayShape(name);
        if (shape.length == 0) {
            return new int[]{1};
        }
        return shape;
    }

    public String getOutlierTreatment() {
        return (String)this.getOptionalEnum("outlier_treatment", arg_0 -> ((ContinuousDomain)this).getOptionalString(arg_0), Arrays.asList(OUTLIERTREATMENT_AS_IS, OUTLIERTREATMENT_AS_EXTREME_VALUES, OUTLIERTREATMENT_AS_MISSING_VALUES));
    }

    public Number getLowValue() {
        return this.getNumber("low_value");
    }

    public Number getHighValue() {
        return this.getNumber("high_value");
    }

    public List<Number> getDataMin() {
        return this.getNumberArray("data_min_");
    }

    public int[] getDataMinShape() {
        return this.getArrayShape("data_min_", 1);
    }

    public List<Number> getDataMax() {
        return this.getNumberArray("data_max_");
    }

    public int[] getDataMaxShape() {
        return this.getArrayShape("data_max_", 1);
    }

    public Map<String, ?> getNumericInfo() {
        return this.getDict("numeric_info_");
    }

    public static OutlierTreatmentMethod parseOutlierTreatment(String outlierTreatment) {
        if (outlierTreatment == null) {
            return null;
        }
        switch (outlierTreatment) {
            case "as_is": {
                return OutlierTreatmentMethod.AS_IS;
            }
            case "as_missing_values": {
                return OutlierTreatmentMethod.AS_MISSING_VALUES;
            }
            case "as_extreme_values": {
                return OutlierTreatmentMethod.AS_EXTREME_VALUES;
            }
        }
        throw new IllegalArgumentException(outlierTreatment);
    }

    public static NumericInfo createNumericInfo(DataType dataType, Map<String, ?> values) {
        NumericInfo numericInfo = new NumericInfo().setMinimum(ContinuousDomain.selectValue(values, "minimum")).setMaximum(ContinuousDomain.selectValue(values, "maximum")).setMean(ContinuousDomain.selectValue(values, "mean")).setStandardDeviation(ContinuousDomain.selectValue(values, "standardDeviation")).setMedian(ContinuousDomain.selectValue(values, "median")).setInterQuartileRange(ContinuousDomain.selectValue(values, "interQuartileRange"));
        return numericInfo;
    }
}

