/*
 * Decompiled with CFR 0.152.
 */
package interpret.glassbox.ebm;

import interpret.glassbox.ebm.ExplainableBoostingUtil;
import interpret.glassbox.ebm.HasExplainableBooster;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.List;
import org.dmg.pmml.Model;
import org.dmg.pmml.regression.RegressionModel;
import org.jpmml.converter.Feature;
import org.jpmml.converter.Schema;
import org.jpmml.converter.regression.RegressionModelUtil;
import org.jpmml.python.HasArray;
import sklearn.Regressor;

public class ExplainableBoostingRegressor
extends Regressor
implements HasExplainableBooster {
    private static final String LINK_IDENTITY = "identity";
    private static final String LINK_LOG = "log";

    public ExplainableBoostingRegressor(String module, String name) {
        super(module, name);
    }

    public Model encodeModel(Schema schema) {
        Number intercept = this.getIntercept();
        RegressionModel.NormalizationMethod normalizationMethod = ExplainableBoostingRegressor.parseLink(this.getLink());
        final List<Feature> features = ExplainableBoostingUtil.encodeExplainableBooster(this, schema);
        AbstractList<Number> coefficients = new AbstractList<Number>(){

            @Override
            public int size() {
                return features.size();
            }

            @Override
            public Number get(int index) {
                return 1.0;
            }
        };
        return RegressionModelUtil.createRegression(features, (List)coefficients, (Number)intercept, (RegressionModel.NormalizationMethod)normalizationMethod, (Schema)schema);
    }

    @Override
    public List<List<?>> getBins() {
        return this.getList("bins_", List.class);
    }

    @Override
    public List<String> getFeatureTypesIn() {
        return this.getEnumList("feature_types_in_", arg_0 -> ((ExplainableBoostingRegressor)this).getStringList(arg_0), Arrays.asList("continuous", "nominal"));
    }

    public Number getIntercept() {
        return this.getNumber("intercept_");
    }

    public String getLink() {
        return (String)this.getEnum("link_", arg_0 -> ((ExplainableBoostingRegressor)this).getString(arg_0), Arrays.asList(LINK_IDENTITY, LINK_LOG));
    }

    @Override
    public List<Object[]> getTermFeatures() {
        return this.getTupleList("term_features_");
    }

    @Override
    public List<HasArray> getTermScores() {
        return this.getArrayList("term_scores_");
    }

    private static RegressionModel.NormalizationMethod parseLink(String link) {
        switch (link) {
            case "identity": {
                return RegressionModel.NormalizationMethod.NONE;
            }
            case "log": {
                return RegressionModel.NormalizationMethod.EXP;
            }
        }
        throw new IllegalArgumentException(link);
    }
}

