/*
 * Decompiled with CFR 0.152.
 */
package sktree.tree;

import java.util.Map;
import org.dmg.pmml.DataType;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.Model;
import org.dmg.pmml.tree.TreeModel;
import org.jpmml.converter.CategoricalLabel;
import org.jpmml.converter.DiscreteLabel;
import org.jpmml.converter.PredicateManager;
import org.jpmml.converter.Schema;
import org.jpmml.converter.ScoreDistributionManager;
import sklearn.Classifier;
import sklearn.Estimator;
import sklearn.tree.HasTree;
import sklearn.tree.TreeUtil;
import sktree.tree.ObliqueTree;
import sktree.tree.ProjectionManager;

public class ObliqueDecisionTreeClassifier
extends Classifier
implements HasTree {
    public ObliqueDecisionTreeClassifier(String module, String name) {
        super(module, name);
    }

    public ObliqueDecisionTreeClassifier(ObliqueDecisionTreeClassifier that) {
        this(that.getPythonModule(), that.getPythonName());
        this.update((Map)((Object)that));
    }

    public DataType getDataType() {
        return DataType.FLOAT;
    }

    public TreeModel encodeModel(Schema schema) {
        PredicateManager predicateManager = new PredicateManager();
        ScoreDistributionManager scoreDistributionManager = new ScoreDistributionManager();
        ProjectionManager projectionManager = new ProjectionManager();
        return this.encodeModel(predicateManager, scoreDistributionManager, projectionManager, schema);
    }

    public TreeModel encodeModel(PredicateManager predicateManager, ScoreDistributionManager scoreDistributionManager, ProjectionManager projectionManager, Schema schema) {
        final ObliqueTree tree = this.getTree();
        if (tree.hasProjVecs()) {
            Object segmentId = this.getPMMLSegmentId();
            final Schema sklearnSchema = tree.transformSchema(segmentId, projectionManager, schema);
            ObliqueDecisionTreeClassifier sklearnClassifier = new ObliqueDecisionTreeClassifier(this){
                private ObliqueTree sklearnTree;
                {
                    super(that);
                    this.sklearnTree = tree.transform(sklearnSchema);
                }

                @Override
                public ObliqueTree getTree() {
                    return this.sklearnTree;
                }
            };
            return sklearnClassifier.encodeModel(predicateManager, scoreDistributionManager, projectionManager, sklearnSchema);
        }
        CategoricalLabel categoricalLabel = (CategoricalLabel)schema.getLabel();
        TreeModel treeModel = TreeUtil.encodeTreeModel((Estimator)this, (MiningFunction)MiningFunction.CLASSIFICATION, (PredicateManager)predicateManager, (ScoreDistributionManager)scoreDistributionManager, (Schema)schema);
        this.encodePredictProbaOutput((Model)treeModel, DataType.DOUBLE, (DiscreteLabel)categoricalLabel);
        return treeModel;
    }

    public ObliqueTree getTree() {
        return (ObliqueTree)((Object)this.get("tree_", ObliqueTree.class));
    }

    public boolean hasMissingValueSupport() {
        return false;
    }
}

