from time import sleep
from bs4 import BeautifulSoup
from uc_sso import get_ticket
from selenium import webdriver
from selenium.webdriver.common.by import By
from selenium.webdriver.support.ui import Select
from webdriver_manager.firefox import GeckoDriverManager

class Student:

    def __init__(self, name, password):
        """
        First Step:
        Given the name and password, access the URL of "Seguimiento Curricular UC" 
        and submit the form.
        """

        # Choose the webdriver
        self.driver = webdriver.Firefox(executable_path=GeckoDriverManager().install())

        # Get tickets from the SSO UC
        ticket = get_ticket(name, password, "https://seguimientocurricular.uc.cl/")

        # We need to check that the ticket returns a 200

        # Access the URL
        self.driver.get(ticket.service_url)

        # Find the drop-down element by id and select the value of the option
        select = Select(self.driver.find_element(By.ID, "j_idt49:_t52"))
        select.select_by_value("050014")

        # Submit the drop-down form
        self.driver.find_element(By.ID, "j_idt49:_t55").click()

        """
        Second Step:
        Obtain the HTML from the page solving the problem of the nested Javascript
        """

        # Wait for the page to load and execute the scripts in order to obtain the HTML
        sleep(5)
        html_text = self.driver.execute_script("return document.getElementsByTagName('html')[0].innerHTML")

        # Read the html text
        self.soup = BeautifulSoup(html_text, "lxml")

    def actual_courses(self):
        """
        Return the actual courses that the student is coursing.
        This function will return a dictionary specifing the section that the student is;
        in the form of {COURSE: SECTION}
        """

        # Initialization of variables
        actual_courses = {}
        i = 0

        # Loop until we can't find any more courses
        while True:
            
            # Find the raw course
            raw_course = self.soup.find("span", id=f"j_idt49:_t253:{i}:_t257")

            # Break statement
            if raw_course is None:
                break

            # Find the raw section of the raw course
            raw_section = self.soup.find("span", id=f"j_idt49:_t253:{i}:_t277")
            
            course = raw_course.text
            section = raw_section.text
            actual_courses[course] = section
            i += 1

        return actual_courses