/*
 * Decompiled with CFR 0.152.
 */
package com.datapps.linkoopdb.jdbc.rowio;

import com.datapps.linkoopdb.jdbc.ColumnSchema;
import com.datapps.linkoopdb.jdbc.Row;
import com.datapps.linkoopdb.jdbc.SessionInterface;
import com.datapps.linkoopdb.jdbc.error.Error;
import com.datapps.linkoopdb.jdbc.lib.HashMappedList;
import com.datapps.linkoopdb.jdbc.lib.LdbSqlByteArrayOutputStream;
import com.datapps.linkoopdb.jdbc.rowio.RowOutputInterface;
import com.datapps.linkoopdb.jdbc.types.BinaryData;
import com.datapps.linkoopdb.jdbc.types.BlobData;
import com.datapps.linkoopdb.jdbc.types.ClobData;
import com.datapps.linkoopdb.jdbc.types.IntervalMonthData;
import com.datapps.linkoopdb.jdbc.types.IntervalSecondData;
import com.datapps.linkoopdb.jdbc.types.JavaObjectData;
import com.datapps.linkoopdb.jdbc.types.TimeData;
import com.datapps.linkoopdb.jdbc.types.TimestampData;
import com.datapps.linkoopdb.jdbc.types.Type;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;

public abstract class RowOutputBase
extends LdbSqlByteArrayOutputStream
implements RowOutputInterface {
    public static final int CACHED_ROW_160 = 0;
    public static final int CACHED_ROW_170 = 1;
    protected boolean skipSystemId = false;
    protected SessionInterface session;

    public RowOutputBase() {
    }

    public RowOutputBase(int initialSize) {
        super(initialSize);
    }

    public RowOutputBase(byte[] buffer) {
        super(buffer);
    }

    public abstract long scalePosition(long var1);

    @Override
    public abstract void setStorageSize(int var1);

    @Override
    public abstract void writeEnd();

    @Override
    public abstract void writeSize(int var1);

    @Override
    public abstract void writeType(int var1);

    @Override
    public abstract void writeString(String var1);

    protected void writeFieldPrefix() {
    }

    protected abstract void writeFieldType(Type var1);

    protected abstract void writeNull(Type var1);

    protected abstract void writeChar(String var1, Type var2);

    protected abstract void writeSmallint(Number var1);

    protected abstract void writeInteger(Number var1);

    protected abstract void writeBigint(Number var1);

    protected abstract void writeReal(Double var1);

    protected abstract void writeFloat(Float var1);

    protected abstract void writeDecimal(BigDecimal var1, Type var2);

    protected abstract void writeBoolean(Boolean var1);

    protected abstract void writeDate(TimestampData var1, Type var2);

    protected abstract void writeTime(TimeData var1, Type var2);

    protected abstract void writeTimestamp(TimestampData var1, Type var2);

    protected abstract void writeYearMonthInterval(IntervalMonthData var1, Type var2);

    protected abstract void writeDaySecondInterval(IntervalSecondData var1, Type var2);

    protected abstract void writeOther(JavaObjectData var1);

    protected abstract void writeBit(BinaryData var1);

    protected abstract void writeUUID(BinaryData var1);

    protected abstract void writeBinary(BinaryData var1);

    protected abstract void writeClob(ClobData var1, Type var2);

    protected abstract void writeBlob(BlobData var1, Type var2);

    protected abstract void writeArray(Object[] var1, Type var2);

    protected abstract void writeStruct(Object[] var1, Type var2);

    @Override
    public void writeData(Row row, Type[] types) {
        this.writeData(types.length, types, row.getData(), null, null);
    }

    @Override
    public void writeData(int l, Type[] types, Object[] data, HashMappedList cols, int[] primaryKeys) {
        boolean hasPK = primaryKeys != null && primaryKeys.length != 0;
        int limit = hasPK ? primaryKeys.length : l;
        for (int i = 0; i < limit; ++i) {
            int j = hasPK ? primaryKeys[i] : i;
            Object o = data[j];
            Type t = types[j];
            if (cols != null) {
                ColumnSchema col = (ColumnSchema)cols.get(j);
                this.writeFieldPrefix();
                this.writeString(col.getName().statementName);
            }
            this.writeData(o, t);
        }
    }

    @Override
    public void writeData(Object o, Type t) {
        if (o == null) {
            this.writeNull(t);
            return;
        }
        this.writeFieldType(t);
        switch (t.typeCode) {
            case 0: {
                break;
            }
            case 1: 
            case 12: {
                this.writeChar((String)o, t);
                break;
            }
            case -6: 
            case 5: {
                this.writeSmallint((Number)o);
                break;
            }
            case 4: {
                this.writeInteger((Number)o);
                break;
            }
            case 25: {
                this.writeBigint((Number)o);
                break;
            }
            case 6: {
                if (o instanceof Float) {
                    this.writeFloat(((Float)o).floatValue());
                    break;
                }
                this.writeFloat(Float.valueOf(o.toString()));
                break;
            }
            case 7: 
            case 8: {
                if (o instanceof Double) {
                    this.writeReal((double)((Double)o));
                    break;
                }
                this.writeReal(Double.valueOf(o.toString()));
                break;
            }
            case 2: 
            case 3: {
                this.writeDecimal((BigDecimal)o, t);
                break;
            }
            case 16: {
                this.writeBoolean((Boolean)o);
                break;
            }
            case 91: {
                if (o instanceof Date && this.getSession() != null) {
                    o = Type.SQL_DATE.convertWorkerToDb(this.getSession(), o, t);
                }
                this.writeDate((TimestampData)o, t);
                break;
            }
            case 92: 
            case 94: {
                this.writeTime((TimeData)o, t);
                break;
            }
            case 93: 
            case 95: {
                if (o instanceof Timestamp && this.getSession() != null) {
                    o = Type.SQL_TIMESTAMP.convertWorkerToDb(this.getSession(), o, t);
                }
                this.writeTimestamp((TimestampData)o, t);
                break;
            }
            case 101: 
            case 102: 
            case 107: {
                this.writeYearMonthInterval((IntervalMonthData)o, t);
                break;
            }
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: {
                this.writeDaySecondInterval((IntervalSecondData)o, t);
                break;
            }
            case 1111: {
                this.writeOther((JavaObjectData)o);
                break;
            }
            case 30: {
                this.writeBlob((BlobData)o, t);
                break;
            }
            case 40: {
                this.writeClob((ClobData)o, t);
                break;
            }
            case 50: {
                this.writeArray((Object[])o, t);
                break;
            }
            case 17: {
                this.writeStruct((Object[])o, t);
                break;
            }
            case -11: {
                this.writeUUID((BinaryData)o);
                break;
            }
            case 60: 
            case 61: {
                this.writeBinary((BinaryData)o);
                break;
            }
            case 14: 
            case 15: {
                this.writeBit((BinaryData)o);
                break;
            }
            default: {
                throw Error.runtimeError(201, "RowOutputBase - " + t.getNameString());
            }
        }
    }

    @Override
    public LdbSqlByteArrayOutputStream getOutputStream() {
        return this;
    }

    @Override
    public abstract RowOutputInterface duplicate();

    public SessionInterface getSession() {
        return this.session;
    }

    @Override
    public void setSession(SessionInterface session) {
        this.session = session;
    }
}

