# The Harmonization Package

This package contains functions useful in the normalization and sanitization of raw data (i.e. text strings) and data entries within structures (such as lists of raw data). The `__init__.py` defines the publicly-available namespace functions available within the package; functions within other files should typically not be imported directly, as they are helper functions that operate under the hood. This package allows operation on raw HL7v2 data in the form of timestamp normalization and batch processing (`standardize_hl7_datetimes` and `convert_hl7_batch_messages_to_list`, respectively), and on raw string data in the form of name and phone number standardization (`standardize_country_code`, `standardize_phone`, and `standardize_name`). For an overview of the package as well as common use cases, see the _harmonization-tutorial_ in `/tutorials` at the project root. For a more in-depth explanation of specific formatting and parameters, see the docstrings and comments for each function.