
import time
from germanium.impl import _ensure_list


def _current_time_in_millis():
    return int(round(time.time() * 1000))


def wait(closure, *args, **kw):
    """
    Executes a function given as argument every 400 milliseconds until it returns true.

    If it goes more than the timeout in seconds, then this function throws an exception.

    If the waiting closures throw exception, then it is assumed as a temporary false
    result, but the wait will continue. This is intentional so you can wait for an element
    even if the page is still loading.

    :param closures:
    :param while_not:
    :param timeout:
    :param extra_closures:
    """
    while_not = kw.get("while_not", [])
    extra_closures = kw.get("extra_closures", [])
    timeout = kw.get("timeout", 10)

    while_not = _ensure_list(while_not)

    closures = _ensure_list(closure)
    closures.extend(args)
    closures.extend(extra_closures)

    def closure_try_catch():
        for closure in closures:
            try:
                result = closure()
                if result:
                    return result
            except Exception as e:
                print("WARNING: waiting as false since: %s" % e)

    starting_time = _current_time_in_millis()
    current_time = starting_time
    delta = float(timeout) * 1000

    if delta <= 0:
        raise Exception("You need to specify a timeout that is greater than 0. The timeout is expressed in seconds.")

    closure_result = False

    while current_time - starting_time < delta:
        starting_closure_eval_time = current_time

        for while_not_closure in while_not:
            try:
                if while_not_closure():
                    raise Exception("Waiting failed, since while_not condition matched")
            except Exception as e:
                raise Exception("Waiting failed, since while_not condition raised exception", e)

        closure_result = closure_try_catch()

        if closure_result:
            break

        current_time = _current_time_in_millis()
        ending_closure_eval_time = current_time

        # Execution times don't count, and must be substracted from the
        # potential delay.
        actual_execution_time = ending_closure_eval_time - starting_closure_eval_time

        # we do the sleep only if the execution time is quicker than 400ms,
        # otherwise we already waited for the response from the server.

        if actual_execution_time < 400:
            time.sleep(float(400 - actual_execution_time) / 1000.0)

        if current_time - starting_time >= 2000:
            print("Running takes more than 2 seconds.")

    if not closure_result:
        raise Exception("Waiting has failed")
