"use strict";
// import { expect, haveResource, haveResourceLike, SynthUtils } from '@aws-cdk/assert';
const assert_1 = require("@aws-cdk/assert");
const cdk = require("@aws-cdk/core");
const s3 = require("../lib");
class BucketVersioningChecker {
    visit(node) {
        if (node instanceof s3.CfnBucket) {
            if (!node.versioningConfiguration ||
                (!cdk.Tokenization.isResolvable(node.versioningConfiguration) && node.versioningConfiguration.status !== 'Enabled')) {
                node.node.addError('Bucket versioning is not enabled');
            }
        }
    }
}
module.exports = {
    'bucket must have versioning: failure'(test) {
        // GIVEN
        const stack = new cdk.Stack();
        new s3.Bucket(stack, 'MyBucket');
        // WHEN
        stack.node.applyAspect(new BucketVersioningChecker());
        // THEN
        const assembly = assert_1.SynthUtils.synthesize(stack);
        const errorMessage = assembly.messages.find(m => m.entry.data === 'Bucket versioning is not enabled');
        test.ok(errorMessage, 'Error message not reported');
        test.done();
    },
    'bucket must have versioning: success'(test) {
        // GIVEN
        const stack = new cdk.Stack();
        new s3.Bucket(stack, 'MyBucket', {
            versioned: true,
        });
        // WHEN
        stack.node.applyAspect(new BucketVersioningChecker());
        // THEN
        const assembly = assert_1.SynthUtils.synthesize(stack);
        test.deepEqual(assembly.messages, []);
        test.done();
    },
};
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidGVzdC5hc3BlY3QuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJ0ZXN0LmFzcGVjdC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiO0FBQUEsd0ZBQXdGO0FBQ3hGLDRDQUE2QztBQUM3QyxxQ0FBcUM7QUFFckMsNkJBQTZCO0FBcUM3QixNQUFNLHVCQUF1QjtJQUNwQixLQUFLLENBQUMsSUFBb0I7UUFDL0IsSUFBSSxJQUFJLFlBQVksRUFBRSxDQUFDLFNBQVMsRUFBRTtZQUNoQyxJQUFJLENBQUMsSUFBSSxDQUFDLHVCQUF1QjtnQkFDL0IsQ0FBQyxDQUFDLEdBQUcsQ0FBQyxZQUFZLENBQUMsWUFBWSxDQUFDLElBQUksQ0FBQyx1QkFBdUIsQ0FBQyxJQUFJLElBQUksQ0FBQyx1QkFBdUIsQ0FBQyxNQUFNLEtBQUssU0FBUyxDQUFDLEVBQUU7Z0JBQ3JILElBQUksQ0FBQyxJQUFJLENBQUMsUUFBUSxDQUFDLGtDQUFrQyxDQUFDLENBQUM7YUFDeEQ7U0FDRjtJQUNILENBQUM7Q0FDRjtBQTVDRCxpQkFBUztJQUNQLHNDQUFzQyxDQUFDLElBQVU7UUFDL0MsUUFBUTtRQUNSLE1BQU0sS0FBSyxHQUFHLElBQUksR0FBRyxDQUFDLEtBQUssRUFBRSxDQUFDO1FBQzlCLElBQUksRUFBRSxDQUFDLE1BQU0sQ0FBQyxLQUFLLEVBQUUsVUFBVSxDQUFDLENBQUM7UUFFakMsT0FBTztRQUNQLEtBQUssQ0FBQyxJQUFJLENBQUMsV0FBVyxDQUFDLElBQUksdUJBQXVCLEVBQUUsQ0FBQyxDQUFDO1FBRXRELE9BQU87UUFDUCxNQUFNLFFBQVEsR0FBRyxtQkFBVSxDQUFDLFVBQVUsQ0FBQyxLQUFLLENBQUMsQ0FBQztRQUM5QyxNQUFNLFlBQVksR0FBRyxRQUFRLENBQUMsUUFBUSxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxLQUFLLENBQUMsSUFBSSxLQUFLLGtDQUFrQyxDQUFDLENBQUM7UUFDdEcsSUFBSSxDQUFDLEVBQUUsQ0FBQyxZQUFZLEVBQUUsNEJBQTRCLENBQUMsQ0FBQztRQUVwRCxJQUFJLENBQUMsSUFBSSxFQUFFLENBQUM7SUFDZCxDQUFDO0lBRUQsc0NBQXNDLENBQUMsSUFBVTtRQUMvQyxRQUFRO1FBQ1IsTUFBTSxLQUFLLEdBQUcsSUFBSSxHQUFHLENBQUMsS0FBSyxFQUFFLENBQUM7UUFDOUIsSUFBSSxFQUFFLENBQUMsTUFBTSxDQUFDLEtBQUssRUFBRSxVQUFVLEVBQUU7WUFDL0IsU0FBUyxFQUFFLElBQUk7U0FDaEIsQ0FBQyxDQUFDO1FBRUgsT0FBTztRQUNQLEtBQUssQ0FBQyxJQUFJLENBQUMsV0FBVyxDQUFDLElBQUksdUJBQXVCLEVBQUUsQ0FBQyxDQUFDO1FBRXRELE9BQU87UUFDUCxNQUFNLFFBQVEsR0FBRyxtQkFBVSxDQUFDLFVBQVUsQ0FBQyxLQUFLLENBQUMsQ0FBQztRQUM5QyxJQUFJLENBQUMsU0FBUyxDQUFDLFFBQVEsQ0FBQyxRQUFRLEVBQUUsRUFBRSxDQUFDLENBQUM7UUFFdEMsSUFBSSxDQUFDLElBQUksRUFBRSxDQUFDO0lBQ2QsQ0FBQztDQUNGLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyIvLyBpbXBvcnQgeyBleHBlY3QsIGhhdmVSZXNvdXJjZSwgaGF2ZVJlc291cmNlTGlrZSwgU3ludGhVdGlscyB9IGZyb20gJ0Bhd3MtY2RrL2Fzc2VydCc7XG5pbXBvcnQgeyBTeW50aFV0aWxzIH0gZnJvbSAnQGF3cy1jZGsvYXNzZXJ0JztcbmltcG9ydCAqIGFzIGNkayBmcm9tICdAYXdzLWNkay9jb3JlJztcbmltcG9ydCB7IFRlc3QgfSBmcm9tICdub2RldW5pdCc7XG5pbXBvcnQgKiBhcyBzMyBmcm9tICcuLi9saWInO1xuXG5leHBvcnQgPSB7XG4gICdidWNrZXQgbXVzdCBoYXZlIHZlcnNpb25pbmc6IGZhaWx1cmUnKHRlc3Q6IFRlc3QpIHtcbiAgICAvLyBHSVZFTlxuICAgIGNvbnN0IHN0YWNrID0gbmV3IGNkay5TdGFjaygpO1xuICAgIG5ldyBzMy5CdWNrZXQoc3RhY2ssICdNeUJ1Y2tldCcpO1xuXG4gICAgLy8gV0hFTlxuICAgIHN0YWNrLm5vZGUuYXBwbHlBc3BlY3QobmV3IEJ1Y2tldFZlcnNpb25pbmdDaGVja2VyKCkpO1xuXG4gICAgLy8gVEhFTlxuICAgIGNvbnN0IGFzc2VtYmx5ID0gU3ludGhVdGlscy5zeW50aGVzaXplKHN0YWNrKTtcbiAgICBjb25zdCBlcnJvck1lc3NhZ2UgPSBhc3NlbWJseS5tZXNzYWdlcy5maW5kKG0gPT4gbS5lbnRyeS5kYXRhID09PSAnQnVja2V0IHZlcnNpb25pbmcgaXMgbm90IGVuYWJsZWQnKTtcbiAgICB0ZXN0Lm9rKGVycm9yTWVzc2FnZSwgJ0Vycm9yIG1lc3NhZ2Ugbm90IHJlcG9ydGVkJyk7XG5cbiAgICB0ZXN0LmRvbmUoKTtcbiAgfSxcblxuICAnYnVja2V0IG11c3QgaGF2ZSB2ZXJzaW9uaW5nOiBzdWNjZXNzJyh0ZXN0OiBUZXN0KSB7XG4gICAgLy8gR0lWRU5cbiAgICBjb25zdCBzdGFjayA9IG5ldyBjZGsuU3RhY2soKTtcbiAgICBuZXcgczMuQnVja2V0KHN0YWNrLCAnTXlCdWNrZXQnLCB7XG4gICAgICB2ZXJzaW9uZWQ6IHRydWUsXG4gICAgfSk7XG5cbiAgICAvLyBXSEVOXG4gICAgc3RhY2subm9kZS5hcHBseUFzcGVjdChuZXcgQnVja2V0VmVyc2lvbmluZ0NoZWNrZXIoKSk7XG5cbiAgICAvLyBUSEVOXG4gICAgY29uc3QgYXNzZW1ibHkgPSBTeW50aFV0aWxzLnN5bnRoZXNpemUoc3RhY2spO1xuICAgIHRlc3QuZGVlcEVxdWFsKGFzc2VtYmx5Lm1lc3NhZ2VzLCBbXSk7XG5cbiAgICB0ZXN0LmRvbmUoKTtcbiAgfSxcbn07XG5cbmNsYXNzIEJ1Y2tldFZlcnNpb25pbmdDaGVja2VyIGltcGxlbWVudHMgY2RrLklBc3BlY3Qge1xuICBwdWJsaWMgdmlzaXQobm9kZTogY2RrLklDb25zdHJ1Y3QpOiB2b2lkIHtcbiAgICBpZiAobm9kZSBpbnN0YW5jZW9mIHMzLkNmbkJ1Y2tldCkge1xuICAgICAgaWYgKCFub2RlLnZlcnNpb25pbmdDb25maWd1cmF0aW9uIHx8XG4gICAgICAgICghY2RrLlRva2VuaXphdGlvbi5pc1Jlc29sdmFibGUobm9kZS52ZXJzaW9uaW5nQ29uZmlndXJhdGlvbikgJiYgbm9kZS52ZXJzaW9uaW5nQ29uZmlndXJhdGlvbi5zdGF0dXMgIT09ICdFbmFibGVkJykpIHtcbiAgICAgICAgbm9kZS5ub2RlLmFkZEVycm9yKCdCdWNrZXQgdmVyc2lvbmluZyBpcyBub3QgZW5hYmxlZCcpO1xuICAgICAgfVxuICAgIH1cbiAgfVxufVxuIl19