/*
 * Decompiled with CFR 0.152.
 */
package ee.ut.soras.wrappers.mudel;

import java.util.List;
import java.util.StringTokenizer;

public class MorfAnRida {
    private String lemma;
    private String lopp;
    private String sonaliik;
    private String vormiNimetused;
    private String normaliseeritudLemma;
    private String lemmaIlmaVahemarkideta;
    private static final String[][] SONALIIK = new String[][]{{"_A_", "omaduss\u0106\u00b5na - algv\u0106\u00b5rre, nii k\u0106\u00a4\u0106\u00a4nduvad kui k\u0106\u00a4\u0106\u00a4ndumatud"}, {"_C_", "omaduss\u0106\u00b5na - keskv\u0106\u00b5rre (adjektiiv - komparatiiv)"}, {"_D_", "m\u0106\u00a4\u0106\u00a4rs\u0106\u00b5na (adverb), nt k\u0106\u00b5rvuti"}, {"_G_", "genitiivatribuut (k\u0106\u00a4\u0106\u00a4ndumatu omaduss\u0106\u00b5na)"}, {"_H_", "p\u0106\u00a4risnimi"}, {"_I_", "h\u0106\u00bc\u0106\u00bcds\u0106\u00b5na (interjektsioon), nt tere"}, {"_J_", "sides\u0106\u00b5na (konjunktsioon)"}, {"_K_", "kaass\u0106\u00b5na (pre/postpositsioon), nt kaudu"}, {"_N_", "p\u0106\u00b5hiarvs\u0106\u00b5na (kardinaalnumeraal), nt kaks"}, {"_O_", "j\u0106\u00a4rgarvs\u0106\u00b5na (ordinaalnumeraal), nt teine"}, {"_P_", "ases\u0106\u00b5na (pronoomen), nt see"}, {"_S_", "nimis\u0106\u00b5na (substantiiv), nt asi"}, {"_U_", "omaduss\u0106\u00b5na - \u0106\u00bcliv\u0106\u00b5rre (adjektiiv - superlatiiv), nt pikim"}, {"_V_", "tegus\u0106\u00b5na (verb), nt lugema"}, {"_X_", "verbi juurde kuuluv s\u0106\u00b5na, eraldi s\u0106\u00b5naliigi t\u0106\u00a4histus puudub, nt plehku"}, {"_Y_", "l\u0106\u00bchend, nt USA"}, {"_Z_", "lausem\u0106\u00a4rk"}};
    private static final String[][] NOMKAT_VORMINIMETUS = new String[][]{{"ab", "abessiiv - ilmayltev"}, {"abl", "ablatiiv - alaltytlev"}, {"ad", "adessiiv - alalytlev"}, {"adt", "aditiiv - suunduv (lyhike sisseytlev)"}, {"all", "allatiiv - alaleytlev"}, {"el", "elatiiv - seestytlev"}, {"es", "essiiv - olev"}, {"g", "genitiiv - omastav"}, {"ill", "illatiiv - sisseytlev"}, {"in", "inessiiv - seesytlev"}, {"kom", "komitatiiv - kaasaytlev"}, {"n", "nominatiiv - nimetav"}, {"p", "partitiiv - osastav"}, {"pl", "pluural - mitmus"}, {"sg", "singulaar - ainusus"}, {"ter", "terminatiiv - rajav"}, {"tr", "translatiiv - saav"}};

    public MorfAnRida(String string) {
        this.eraldaReastElemendid(string);
        this.normaliseeriLemmaNingLeiaVahemarkidetaKuju();
    }

    public MorfAnRida(List<String> list) throws Exception {
        if (list.size() % 2 != 0) {
            throw new Exception(" Unexpected size of input key-value pairs - should be even-size list: " + list.toString());
        }
        for (int i = 0; i < list.size(); i += 2) {
            String string = list.get(i);
            String string2 = list.get(i + 1);
            if (string.equalsIgnoreCase("root")) {
                this.lemma = string2;
            }
            if (string.equalsIgnoreCase("ending")) {
                this.lopp = string2;
            }
            if (string.equalsIgnoreCase("form")) {
                this.vormiNimetused = string2;
                if (this.vormiNimetused != null && this.vormiNimetused.length() > 0 && !this.vormiNimetused.endsWith(",")) {
                    this.vormiNimetused = this.vormiNimetused + ",";
                }
            }
            if (!string.equalsIgnoreCase("partofspeech")) continue;
            this.sonaliik = "_" + string2 + "_";
        }
        this.normaliseeriLemmaNingLeiaVahemarkidetaKuju();
    }

    private void eraldaReastElemendid(String string) {
        int n = MorfAnRida.leiaEsimeseKaldkriipsuIndex(string);
        if (string.lastIndexOf("+") > -1) {
            this.lemma = string.substring(0, string.lastIndexOf("+"));
            this.lopp = string.substring(string.lastIndexOf("+") + 1, n - 1);
        } else {
            this.lemma = string.substring(0, n - 1);
            this.lopp = "0";
        }
        int n2 = string.lastIndexOf("_");
        int n3 = string.lastIndexOf("/");
        this.sonaliik = string.substring(n2 - 2, n2 + 1);
        this.vormiNimetused = n3 - 2 - (n2 + 2) > 0 ? string.substring(n2 + 2, n3 - 2) : "";
    }

    private static int leiaEsimeseKaldkriipsuIndex(String string) {
        int n;
        int n2 = 0;
        for (n = string.length() - 1; n > -1; --n) {
            if (string.charAt(n) == '/') {
                ++n2;
            }
            if (n2 == 4) break;
        }
        return n;
    }

    public String getLemma() {
        return this.lemma;
    }

    public void normaliseeriLemmaNingLeiaVahemarkidetaKuju() {
        if (this.lemma != null) {
            this.normaliseeritudLemma = new String(this.lemma);
            StringTokenizer stringTokenizer = new StringTokenizer(this.normaliseeritudLemma, "=+_");
            StringBuilder stringBuilder = new StringBuilder();
            while (stringTokenizer.hasMoreElements()) {
                stringBuilder.append((String)stringTokenizer.nextElement());
            }
            this.lemmaIlmaVahemarkideta = stringBuilder.toString();
        }
    }

    public String getLemmaIlmaVahemarkideta() {
        return this.lemmaIlmaVahemarkideta;
    }

    public String getSonaLiikPikalt() {
        String string = "";
        for (String[] stringArray : SONALIIK) {
            if (!stringArray[0].equals(this.sonaliik)) continue;
            string = stringArray[1];
        }
        return string;
    }

    public String getLopp() {
        return this.lopp;
    }

    public String getSonaliik() {
        return this.sonaliik;
    }

    public boolean isVerb() {
        return this.sonaliik.equals("_V_");
    }

    public String getVormiNimetused() {
        return this.vormiNimetused;
    }

    public String getVormiNimetusedPikalt(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.vormiNimetused.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(this.vormiNimetused, ",");
            while (stringTokenizer.hasMoreElements()) {
                String string2 = (String)stringTokenizer.nextElement();
                if (this.isVerb()) {
                    stringBuilder.append(string);
                    stringBuilder.append(string2);
                    stringBuilder.append("\n");
                    continue;
                }
                StringTokenizer stringTokenizer2 = new StringTokenizer(string2, " ");
                while (stringTokenizer2.hasMoreElements()) {
                    String string3 = (String)stringTokenizer2.nextElement();
                    for (String[] stringArray : NOMKAT_VORMINIMETUS) {
                        if (!stringArray[0].equals(string3)) continue;
                        stringBuilder.append(string);
                        stringBuilder.append(stringArray[1]);
                        stringBuilder.append(" (");
                        stringBuilder.append(stringArray[0]);
                        stringBuilder.append(")");
                        stringBuilder.append("\n");
                    }
                }
            }
        }
        return stringBuilder.toString();
    }

    public boolean leiaKasMorfTunnusEsineb(String string) {
        if (string.startsWith("^")) {
            return !this.leiaKasMorfTunnusEsineb(string.replaceAll("\\^", ""));
        }
        if (string.startsWith("_")) {
            if (this.sonaliik != null) {
                return this.sonaliik.equals(string);
            }
            return false;
        }
        if (this.vormiNimetused != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(this.vormiNimetused, ",");
            while (stringTokenizer.hasMoreElements()) {
                String[] stringArray;
                String string2 = (String)stringTokenizer.nextElement();
                for (String string3 : stringArray = string2.split("(\\s+)")) {
                    if (!string3.equals(string)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.lemma);
        stringBuilder.append("+");
        stringBuilder.append(this.lopp);
        stringBuilder.append(" ");
        stringBuilder.append(this.sonaliik);
        stringBuilder.append(" ");
        stringBuilder.append(this.vormiNimetused);
        return stringBuilder.toString();
    }
}

