"""
Mantarix Cupertino Icons

To generate/update these values run:

sh ci/generate_cupertino_icons_python.sh
"""

import random
from enum import Enum, EnumMeta
from typing import Dict, List, Optional
from warnings import warn

from mantarix.utils import deprecated


class CupertinoIconsDeprecated(EnumMeta):
    def __getattribute__(self, item):
        if not item.startswith("_") and item.isupper():
            warn(
                "cupertino_icons enum is deprecated since version 0.25.0 and will be removed in version 0.28.0. "
                "Use CupertinoIcons enum instead.",
                DeprecationWarning,
                stacklevel=2,
            )
        return EnumMeta.__getattribute__(self, item)


class cupertino_icons(str, Enum, metaclass=CupertinoIconsDeprecated):
    @staticmethod
    def random():
        return random.choice(list(cupertino_icons))

    @staticmethod
    @deprecated(
        reason="Use cupertino_icons.random() method instead.",
        version="0.25.0",
        delete_version="0.28.0",
    )
    def random_icon():
        return random.choice(list(cupertino_icons))

    LEFT_CHEVRON = "cupertino_left_chevron"
    RIGHT_CHEVRON = "cupertino_right_chevron"
    SHARE = "cupertino_share"
    SHARE_SOLID = "cupertino_share_solid"
    BOOK = "cupertino_book"
    BOOK_SOLID = "cupertino_book_solid"
    BOOKMARK = "cupertino_bookmark"
    BOOKMARK_SOLID = "cupertino_bookmark_solid"
    INFO = "cupertino_info"
    REPLY = "cupertino_reply"
    CONVERSATION_BUBBLE = "cupertino_conversation_bubble"
    PROFILE_CIRCLED = "cupertino_profile_circled"
    PLUS_CIRCLED = "cupertino_plus_circled"
    MINUS_CIRCLED = "cupertino_minus_circled"
    FLAG = "cupertino_flag"
    SEARCH = "cupertino_search"
    CHECK_MARK = "cupertino_check_mark"
    CHECK_MARK_CIRCLED = "cupertino_check_mark_circled"
    CHECK_MARK_CIRCLED_SOLID = "cupertino_check_mark_circled_solid"
    CIRCLE = "cupertino_circle"
    CIRCLE_FILLED = "cupertino_circle_filled"
    BACK = "cupertino_back"
    FORWARD = "cupertino_forward"
    HOME = "cupertino_home"
    SHOPPING_CART = "cupertino_shopping_cart"
    ELLIPSIS = "cupertino_ellipsis"
    PHONE = "cupertino_phone"
    PHONE_SOLID = "cupertino_phone_solid"
    DOWN_ARROW = "cupertino_down_arrow"
    UP_ARROW = "cupertino_up_arrow"
    BATTERY_CHARGING = "cupertino_battery_charging"
    BATTERY_EMPTY = "cupertino_battery_empty"
    BATTERY_FULL = "cupertino_battery_full"
    BATTERY_75_PERCENT = "cupertino_battery_75_percent"
    BATTERY_25_PERCENT = "cupertino_battery_25_percent"
    BLUETOOTH = "cupertino_bluetooth"
    RESTART = "cupertino_restart"
    REPLY_ALL = "cupertino_reply_all"
    REPLY_THICK_SOLID = "cupertino_reply_thick_solid"
    SHARE_UP = "cupertino_share_up"
    SHUFFLE = "cupertino_shuffle"
    SHUFFLE_MEDIUM = "cupertino_shuffle_medium"
    SHUFFLE_THICK = "cupertino_shuffle_thick"
    PHOTO_CAMERA = "cupertino_photo_camera"
    PHOTO_CAMERA_SOLID = "cupertino_photo_camera_solid"
    VIDEO_CAMERA = "cupertino_video_camera"
    VIDEO_CAMERA_SOLID = "cupertino_video_camera_solid"
    SWITCH_CAMERA = "cupertino_switch_camera"
    SWITCH_CAMERA_SOLID = "cupertino_switch_camera_solid"
    COLLECTIONS = "cupertino_collections"
    COLLECTIONS_SOLID = "cupertino_collections_solid"
    FOLDER = "cupertino_folder"
    FOLDER_SOLID = "cupertino_folder_solid"
    FOLDER_OPEN = "cupertino_folder_open"
    DELETE = "cupertino_delete"
    DELETE_SOLID = "cupertino_delete_solid"
    DELETE_SIMPLE = "cupertino_delete_simple"
    PEN = "cupertino_pen"
    PENCIL = "cupertino_pencil"
    CREATE = "cupertino_create"
    CREATE_SOLID = "cupertino_create_solid"
    REFRESH = "cupertino_refresh"
    REFRESH_CIRCLED = "cupertino_refresh_circled"
    REFRESH_CIRCLED_SOLID = "cupertino_refresh_circled_solid"
    REFRESH_THIN = "cupertino_refresh_thin"
    REFRESH_THICK = "cupertino_refresh_thick"
    REFRESH_BOLD = "cupertino_refresh_bold"
    CLEAR_THICK = "cupertino_clear_thick"
    CLEAR_THICK_CIRCLED = "cupertino_clear_thick_circled"
    CLEAR = "cupertino_clear"
    CLEAR_CIRCLED = "cupertino_clear_circled"
    CLEAR_CIRCLED_SOLID = "cupertino_clear_circled_solid"
    ADD = "cupertino_add"
    ADD_CIRCLED = "cupertino_add_circled"
    ADD_CIRCLED_SOLID = "cupertino_add_circled_solid"
    GEAR = "cupertino_gear"
    GEAR_SOLID = "cupertino_gear_solid"
    GEAR_BIG = "cupertino_gear_big"
    SETTINGS = "cupertino_settings"
    SETTINGS_SOLID = "cupertino_settings_solid"
    MUSIC_NOTE = "cupertino_music_note"
    DOUBLE_MUSIC_NOTE = "cupertino_double_music_note"
    PLAY_ARROW = "cupertino_play_arrow"
    PLAY_ARROW_SOLID = "cupertino_play_arrow_solid"
    PAUSE = "cupertino_pause"
    PAUSE_SOLID = "cupertino_pause_solid"
    LOOP = "cupertino_loop"
    LOOP_THICK = "cupertino_loop_thick"
    VOLUME_DOWN = "cupertino_volume_down"
    VOLUME_MUTE = "cupertino_volume_mute"
    VOLUME_OFF = "cupertino_volume_off"
    VOLUME_UP = "cupertino_volume_up"
    FULLSCREEN = "cupertino_fullscreen"
    FULLSCREEN_EXIT = "cupertino_fullscreen_exit"
    MIC_OFF = "cupertino_mic_off"
    MIC = "cupertino_mic"
    MIC_SOLID = "cupertino_mic_solid"
    CLOCK = "cupertino_clock"
    CLOCK_SOLID = "cupertino_clock_solid"
    TIME = "cupertino_time"
    TIME_SOLID = "cupertino_time_solid"
    PADLOCK = "cupertino_padlock"
    PADLOCK_SOLID = "cupertino_padlock_solid"
    EYE = "cupertino_eye"
    EYE_SOLID = "cupertino_eye_solid"
    PERSON = "cupertino_person"
    PERSON_SOLID = "cupertino_person_solid"
    PERSON_ADD = "cupertino_person_add"
    PERSON_ADD_SOLID = "cupertino_person_add_solid"
    GROUP = "cupertino_group"
    GROUP_SOLID = "cupertino_group_solid"
    MAIL = "cupertino_mail"
    MAIL_SOLID = "cupertino_mail_solid"
    LOCATION = "cupertino_location"
    LOCATION_SOLID = "cupertino_location_solid"
    TAG = "cupertino_tag"
    TAG_SOLID = "cupertino_tag_solid"
    TAGS = "cupertino_tags"
    TAGS_SOLID = "cupertino_tags_solid"
    BUS = "cupertino_bus"
    CAR = "cupertino_car"
    CAR_DETAILED = "cupertino_car_detailed"
    TRAIN_STYLE_ONE = "cupertino_train_style_one"
    TRAIN_STYLE_TWO = "cupertino_train_style_two"
    PAW = "cupertino_paw"
    PAW_SOLID = "cupertino_paw_solid"
    GAME_CONTROLLER = "cupertino_game_controller"
    GAME_CONTROLLER_SOLID = "cupertino_game_controller_solid"
    LAB_FLASK = "cupertino_lab_flask"
    LAB_FLASK_SOLID = "cupertino_lab_flask_solid"
    HEART = "cupertino_heart"
    HEART_SOLID = "cupertino_heart_solid"
    BELL = "cupertino_bell"
    BELL_SOLID = "cupertino_bell_solid"
    NEWS = "cupertino_news"
    NEWS_SOLID = "cupertino_news_solid"
    BRIGHTNESS = "cupertino_brightness"
    BRIGHTNESS_SOLID = "cupertino_brightness_solid"
    AIRPLANE = "cupertino_airplane"
    ALARM = "cupertino_alarm"
    ALARM_FILL = "cupertino_alarm_fill"
    ALT = "cupertino_alt"
    ANT = "cupertino_ant"
    ANT_CIRCLE = "cupertino_ant_circle"
    ANT_CIRCLE_FILL = "cupertino_ant_circle_fill"
    ANT_FILL = "cupertino_ant_fill"
    ANTENNA_RADIOWAVES_LEFT_RIGHT = "cupertino_antenna_radiowaves_left_right"
    APP = "cupertino_app"
    APP_BADGE = "cupertino_app_badge"
    APP_BADGE_FILL = "cupertino_app_badge_fill"
    APP_FILL = "cupertino_app_fill"
    ARCHIVEBOX = "cupertino_archivebox"
    ARCHIVEBOX_FILL = "cupertino_archivebox_fill"
    ARROW_2_CIRCLEPATH = "cupertino_arrow_2_circlepath"
    ARROW_2_CIRCLEPATH_CIRCLE = "cupertino_arrow_2_circlepath_circle"
    ARROW_2_CIRCLEPATH_CIRCLE_FILL = "cupertino_arrow_2_circlepath_circle_fill"
    ARROW_2_SQUAREPATH = "cupertino_arrow_2_squarepath"
    ARROW_3_TRIANGLEPATH = "cupertino_arrow_3_trianglepath"
    ARROW_BRANCH = "cupertino_arrow_branch"
    ARROW_CLOCKWISE = "cupertino_arrow_clockwise"
    ARROW_CLOCKWISE_CIRCLE = "cupertino_arrow_clockwise_circle"
    ARROW_CLOCKWISE_CIRCLE_FILL = "cupertino_arrow_clockwise_circle_fill"
    ARROW_COUNTERCLOCKWISE = "cupertino_arrow_counterclockwise"
    ARROW_COUNTERCLOCKWISE_CIRCLE = "cupertino_arrow_counterclockwise_circle"
    ARROW_COUNTERCLOCKWISE_CIRCLE_FILL = "cupertino_arrow_counterclockwise_circle_fill"
    ARROW_DOWN = "cupertino_arrow_down"
    ARROW_DOWN_CIRCLE = "cupertino_arrow_down_circle"
    ARROW_DOWN_CIRCLE_FILL = "cupertino_arrow_down_circle_fill"
    ARROW_DOWN_DOC = "cupertino_arrow_down_doc"
    ARROW_DOWN_DOC_FILL = "cupertino_arrow_down_doc_fill"
    ARROW_DOWN_LEFT = "cupertino_arrow_down_left"
    ARROW_DOWN_LEFT_CIRCLE = "cupertino_arrow_down_left_circle"
    ARROW_DOWN_LEFT_CIRCLE_FILL = "cupertino_arrow_down_left_circle_fill"
    ARROW_DOWN_LEFT_SQUARE = "cupertino_arrow_down_left_square"
    ARROW_DOWN_LEFT_SQUARE_FILL = "cupertino_arrow_down_left_square_fill"
    ARROW_DOWN_RIGHT = "cupertino_arrow_down_right"
    ARROW_DOWN_RIGHT_ARROW_UP_LEFT = "cupertino_arrow_down_right_arrow_up_left"
    ARROW_DOWN_RIGHT_CIRCLE = "cupertino_arrow_down_right_circle"
    ARROW_DOWN_RIGHT_CIRCLE_FILL = "cupertino_arrow_down_right_circle_fill"
    ARROW_DOWN_RIGHT_SQUARE = "cupertino_arrow_down_right_square"
    ARROW_DOWN_RIGHT_SQUARE_FILL = "cupertino_arrow_down_right_square_fill"
    ARROW_DOWN_SQUARE = "cupertino_arrow_down_square"
    ARROW_DOWN_SQUARE_FILL = "cupertino_arrow_down_square_fill"
    ARROW_DOWN_TO_LINE = "cupertino_arrow_down_to_line"
    ARROW_DOWN_TO_LINE_ALT = "cupertino_arrow_down_to_line_alt"
    ARROW_LEFT = "cupertino_arrow_left"
    ARROW_LEFT_CIRCLE = "cupertino_arrow_left_circle"
    ARROW_LEFT_CIRCLE_FILL = "cupertino_arrow_left_circle_fill"
    ARROW_LEFT_RIGHT = "cupertino_arrow_left_right"
    ARROW_LEFT_RIGHT_CIRCLE = "cupertino_arrow_left_right_circle"
    ARROW_LEFT_RIGHT_CIRCLE_FILL = "cupertino_arrow_left_right_circle_fill"
    ARROW_LEFT_RIGHT_SQUARE = "cupertino_arrow_left_right_square"
    ARROW_LEFT_RIGHT_SQUARE_FILL = "cupertino_arrow_left_right_square_fill"
    ARROW_LEFT_SQUARE = "cupertino_arrow_left_square"
    ARROW_LEFT_SQUARE_FILL = "cupertino_arrow_left_square_fill"
    ARROW_LEFT_TO_LINE = "cupertino_arrow_left_to_line"
    ARROW_LEFT_TO_LINE_ALT = "cupertino_arrow_left_to_line_alt"
    ARROW_MERGE = "cupertino_arrow_merge"
    ARROW_RIGHT = "cupertino_arrow_right"
    ARROW_RIGHT_ARROW_LEFT = "cupertino_arrow_right_arrow_left"
    ARROW_RIGHT_ARROW_LEFT_CIRCLE = "cupertino_arrow_right_arrow_left_circle"
    ARROW_RIGHT_ARROW_LEFT_CIRCLE_FILL = "cupertino_arrow_right_arrow_left_circle_fill"
    ARROW_RIGHT_ARROW_LEFT_SQUARE = "cupertino_arrow_right_arrow_left_square"
    ARROW_RIGHT_ARROW_LEFT_SQUARE_FILL = "cupertino_arrow_right_arrow_left_square_fill"
    ARROW_RIGHT_CIRCLE = "cupertino_arrow_right_circle"
    ARROW_RIGHT_CIRCLE_FILL = "cupertino_arrow_right_circle_fill"
    ARROW_RIGHT_SQUARE = "cupertino_arrow_right_square"
    ARROW_RIGHT_SQUARE_FILL = "cupertino_arrow_right_square_fill"
    ARROW_RIGHT_TO_LINE = "cupertino_arrow_right_to_line"
    ARROW_RIGHT_TO_LINE_ALT = "cupertino_arrow_right_to_line_alt"
    ARROW_SWAP = "cupertino_arrow_swap"
    ARROW_TURN_DOWN_LEFT = "cupertino_arrow_turn_down_left"
    ARROW_TURN_DOWN_RIGHT = "cupertino_arrow_turn_down_right"
    ARROW_TURN_LEFT_DOWN = "cupertino_arrow_turn_left_down"
    ARROW_TURN_LEFT_UP = "cupertino_arrow_turn_left_up"
    ARROW_TURN_RIGHT_DOWN = "cupertino_arrow_turn_right_down"
    ARROW_TURN_RIGHT_UP = "cupertino_arrow_turn_right_up"
    ARROW_TURN_UP_LEFT = "cupertino_arrow_turn_up_left"
    ARROW_TURN_UP_RIGHT = "cupertino_arrow_turn_up_right"
    ARROW_UP = "cupertino_arrow_up"
    ARROW_UP_ARROW_DOWN = "cupertino_arrow_up_arrow_down"
    ARROW_UP_ARROW_DOWN_CIRCLE = "cupertino_arrow_up_arrow_down_circle"
    ARROW_UP_ARROW_DOWN_CIRCLE_FILL = "cupertino_arrow_up_arrow_down_circle_fill"
    ARROW_UP_ARROW_DOWN_SQUARE = "cupertino_arrow_up_arrow_down_square"
    ARROW_UP_ARROW_DOWN_SQUARE_FILL = "cupertino_arrow_up_arrow_down_square_fill"
    ARROW_UP_BIN = "cupertino_arrow_up_bin"
    ARROW_UP_BIN_FILL = "cupertino_arrow_up_bin_fill"
    ARROW_UP_CIRCLE = "cupertino_arrow_up_circle"
    ARROW_UP_CIRCLE_FILL = "cupertino_arrow_up_circle_fill"
    ARROW_UP_DOC = "cupertino_arrow_up_doc"
    ARROW_UP_DOC_FILL = "cupertino_arrow_up_doc_fill"
    ARROW_UP_DOWN = "cupertino_arrow_up_down"
    ARROW_UP_DOWN_CIRCLE = "cupertino_arrow_up_down_circle"
    ARROW_UP_DOWN_CIRCLE_FILL = "cupertino_arrow_up_down_circle_fill"
    ARROW_UP_DOWN_SQUARE = "cupertino_arrow_up_down_square"
    ARROW_UP_DOWN_SQUARE_FILL = "cupertino_arrow_up_down_square_fill"
    ARROW_UP_LEFT = "cupertino_arrow_up_left"
    ARROW_UP_LEFT_ARROW_DOWN_RIGHT = "cupertino_arrow_up_left_arrow_down_right"
    ARROW_UP_LEFT_CIRCLE = "cupertino_arrow_up_left_circle"
    ARROW_UP_LEFT_CIRCLE_FILL = "cupertino_arrow_up_left_circle_fill"
    ARROW_UP_LEFT_SQUARE = "cupertino_arrow_up_left_square"
    ARROW_UP_LEFT_SQUARE_FILL = "cupertino_arrow_up_left_square_fill"
    ARROW_UP_RIGHT = "cupertino_arrow_up_right"
    ARROW_UP_RIGHT_CIRCLE = "cupertino_arrow_up_right_circle"
    ARROW_UP_RIGHT_CIRCLE_FILL = "cupertino_arrow_up_right_circle_fill"
    ARROW_UP_RIGHT_DIAMOND = "cupertino_arrow_up_right_diamond"
    ARROW_UP_RIGHT_DIAMOND_FILL = "cupertino_arrow_up_right_diamond_fill"
    ARROW_UP_RIGHT_SQUARE = "cupertino_arrow_up_right_square"
    ARROW_UP_RIGHT_SQUARE_FILL = "cupertino_arrow_up_right_square_fill"
    ARROW_UP_SQUARE = "cupertino_arrow_up_square"
    ARROW_UP_SQUARE_FILL = "cupertino_arrow_up_square_fill"
    ARROW_UP_TO_LINE = "cupertino_arrow_up_to_line"
    ARROW_UP_TO_LINE_ALT = "cupertino_arrow_up_to_line_alt"
    ARROW_UTURN_DOWN = "cupertino_arrow_uturn_down"
    ARROW_UTURN_DOWN_CIRCLE = "cupertino_arrow_uturn_down_circle"
    ARROW_UTURN_DOWN_CIRCLE_FILL = "cupertino_arrow_uturn_down_circle_fill"
    ARROW_UTURN_DOWN_SQUARE = "cupertino_arrow_uturn_down_square"
    ARROW_UTURN_DOWN_SQUARE_FILL = "cupertino_arrow_uturn_down_square_fill"
    ARROW_UTURN_LEFT = "cupertino_arrow_uturn_left"
    ARROW_UTURN_LEFT_CIRCLE = "cupertino_arrow_uturn_left_circle"
    ARROW_UTURN_LEFT_CIRCLE_FILL = "cupertino_arrow_uturn_left_circle_fill"
    ARROW_UTURN_LEFT_SQUARE = "cupertino_arrow_uturn_left_square"
    ARROW_UTURN_LEFT_SQUARE_FILL = "cupertino_arrow_uturn_left_square_fill"
    ARROW_UTURN_RIGHT = "cupertino_arrow_uturn_right"
    ARROW_UTURN_RIGHT_CIRCLE = "cupertino_arrow_uturn_right_circle"
    ARROW_UTURN_RIGHT_CIRCLE_FILL = "cupertino_arrow_uturn_right_circle_fill"
    ARROW_UTURN_RIGHT_SQUARE = "cupertino_arrow_uturn_right_square"
    ARROW_UTURN_RIGHT_SQUARE_FILL = "cupertino_arrow_uturn_right_square_fill"
    ARROW_UTURN_UP = "cupertino_arrow_uturn_up"
    ARROW_UTURN_UP_CIRCLE = "cupertino_arrow_uturn_up_circle"
    ARROW_UTURN_UP_CIRCLE_FILL = "cupertino_arrow_uturn_up_circle_fill"
    ARROW_UTURN_UP_SQUARE = "cupertino_arrow_uturn_up_square"
    ARROW_UTURN_UP_SQUARE_FILL = "cupertino_arrow_uturn_up_square_fill"
    ARROWSHAPE_TURN_UP_LEFT = "cupertino_arrowshape_turn_up_left"
    ARROWSHAPE_TURN_UP_LEFT_2 = "cupertino_arrowshape_turn_up_left_2"
    ARROWSHAPE_TURN_UP_LEFT_2_FILL = "cupertino_arrowshape_turn_up_left_2_fill"
    ARROWSHAPE_TURN_UP_LEFT_CIRCLE = "cupertino_arrowshape_turn_up_left_circle"
    ARROWSHAPE_TURN_UP_LEFT_CIRCLE_FILL = (
        "cupertino_arrowshape_turn_up_left_circle_fill"
    )
    ARROWSHAPE_TURN_UP_LEFT_FILL = "cupertino_arrowshape_turn_up_left_fill"
    ARROWSHAPE_TURN_UP_RIGHT = "cupertino_arrowshape_turn_up_right"
    ARROWSHAPE_TURN_UP_RIGHT_CIRCLE = "cupertino_arrowshape_turn_up_right_circle"
    ARROWSHAPE_TURN_UP_RIGHT_CIRCLE_FILL = (
        "cupertino_arrowshape_turn_up_right_circle_fill"
    )
    ARROWSHAPE_TURN_UP_RIGHT_FILL = "cupertino_arrowshape_turn_up_right_fill"
    ARROWTRIANGLE_DOWN = "cupertino_arrowtriangle_down"
    ARROWTRIANGLE_DOWN_CIRCLE = "cupertino_arrowtriangle_down_circle"
    ARROWTRIANGLE_DOWN_CIRCLE_FILL = "cupertino_arrowtriangle_down_circle_fill"
    ARROWTRIANGLE_DOWN_FILL = "cupertino_arrowtriangle_down_fill"
    ARROWTRIANGLE_DOWN_SQUARE = "cupertino_arrowtriangle_down_square"
    ARROWTRIANGLE_DOWN_SQUARE_FILL = "cupertino_arrowtriangle_down_square_fill"
    ARROWTRIANGLE_LEFT = "cupertino_arrowtriangle_left"
    ARROWTRIANGLE_LEFT_CIRCLE = "cupertino_arrowtriangle_left_circle"
    ARROWTRIANGLE_LEFT_CIRCLE_FILL = "cupertino_arrowtriangle_left_circle_fill"
    ARROWTRIANGLE_LEFT_FILL = "cupertino_arrowtriangle_left_fill"
    ARROWTRIANGLE_LEFT_SQUARE = "cupertino_arrowtriangle_left_square"
    ARROWTRIANGLE_LEFT_SQUARE_FILL = "cupertino_arrowtriangle_left_square_fill"
    ARROWTRIANGLE_RIGHT = "cupertino_arrowtriangle_right"
    ARROWTRIANGLE_RIGHT_CIRCLE = "cupertino_arrowtriangle_right_circle"
    ARROWTRIANGLE_RIGHT_CIRCLE_FILL = "cupertino_arrowtriangle_right_circle_fill"
    ARROWTRIANGLE_RIGHT_FILL = "cupertino_arrowtriangle_right_fill"
    ARROWTRIANGLE_RIGHT_SQUARE = "cupertino_arrowtriangle_right_square"
    ARROWTRIANGLE_RIGHT_SQUARE_FILL = "cupertino_arrowtriangle_right_square_fill"
    ARROWTRIANGLE_UP = "cupertino_arrowtriangle_up"
    ARROWTRIANGLE_UP_CIRCLE = "cupertino_arrowtriangle_up_circle"
    ARROWTRIANGLE_UP_CIRCLE_FILL = "cupertino_arrowtriangle_up_circle_fill"
    ARROWTRIANGLE_UP_FILL = "cupertino_arrowtriangle_up_fill"
    ARROWTRIANGLE_UP_SQUARE = "cupertino_arrowtriangle_up_square"
    ARROWTRIANGLE_UP_SQUARE_FILL = "cupertino_arrowtriangle_up_square_fill"
    ASTERISK_CIRCLE = "cupertino_asterisk_circle"
    ASTERISK_CIRCLE_FILL = "cupertino_asterisk_circle_fill"
    AT = "cupertino_at"
    AT_BADGE_MINUS = "cupertino_at_badge_minus"
    AT_BADGE_PLUS = "cupertino_at_badge_plus"
    AT_CIRCLE = "cupertino_at_circle"
    AT_CIRCLE_FILL = "cupertino_at_circle_fill"
    BACKWARD = "cupertino_backward"
    BACKWARD_END = "cupertino_backward_end"
    BACKWARD_END_ALT = "cupertino_backward_end_alt"
    BACKWARD_END_ALT_FILL = "cupertino_backward_end_alt_fill"
    BACKWARD_END_FILL = "cupertino_backward_end_fill"
    BACKWARD_FILL = "cupertino_backward_fill"
    BADGE_PLUS_RADIOWAVES_RIGHT = "cupertino_badge_plus_radiowaves_right"
    BAG = "cupertino_bag"
    BAG_BADGE_MINUS = "cupertino_bag_badge_minus"
    BAG_BADGE_PLUS = "cupertino_bag_badge_plus"
    BAG_FILL = "cupertino_bag_fill"
    BAG_FILL_BADGE_MINUS = "cupertino_bag_fill_badge_minus"
    BAG_FILL_BADGE_PLUS = "cupertino_bag_fill_badge_plus"
    BANDAGE = "cupertino_bandage"
    BANDAGE_FILL = "cupertino_bandage_fill"
    BARCODE = "cupertino_barcode"
    BARCODE_VIEWFINDER = "cupertino_barcode_viewfinder"
    BARS = "cupertino_bars"
    BATTERY_0 = "cupertino_battery_0"
    BATTERY_100 = "cupertino_battery_100"
    BATTERY_25 = "cupertino_battery_25"
    BED_DOUBLE = "cupertino_bed_double"
    BED_DOUBLE_FILL = "cupertino_bed_double_fill"
    BELL_CIRCLE = "cupertino_bell_circle"
    BELL_CIRCLE_FILL = "cupertino_bell_circle_fill"
    BELL_FILL = "cupertino_bell_fill"
    BELL_SLASH = "cupertino_bell_slash"
    BELL_SLASH_FILL = "cupertino_bell_slash_fill"
    BIN_XMARK = "cupertino_bin_xmark"
    BIN_XMARK_FILL = "cupertino_bin_xmark_fill"
    BITCOIN = "cupertino_bitcoin"
    BITCOIN_CIRCLE = "cupertino_bitcoin_circle"
    BITCOIN_CIRCLE_FILL = "cupertino_bitcoin_circle_fill"
    BOLD = "cupertino_bold"
    BOLD_ITALIC_UNDERLINE = "cupertino_bold_italic_underline"
    BOLD_UNDERLINE = "cupertino_bold_underline"
    BOLT = "cupertino_bolt"
    BOLT_BADGE_A = "cupertino_bolt_badge_a"
    BOLT_BADGE_A_FILL = "cupertino_bolt_badge_a_fill"
    BOLT_CIRCLE = "cupertino_bolt_circle"
    BOLT_CIRCLE_FILL = "cupertino_bolt_circle_fill"
    BOLT_FILL = "cupertino_bolt_fill"
    BOLT_HORIZONTAL = "cupertino_bolt_horizontal"
    BOLT_HORIZONTAL_CIRCLE = "cupertino_bolt_horizontal_circle"
    BOLT_HORIZONTAL_CIRCLE_FILL = "cupertino_bolt_horizontal_circle_fill"
    BOLT_HORIZONTAL_FILL = "cupertino_bolt_horizontal_fill"
    BOLT_SLASH = "cupertino_bolt_slash"
    BOLT_SLASH_FILL = "cupertino_bolt_slash_fill"
    BOOK_CIRCLE = "cupertino_book_circle"
    BOOK_CIRCLE_FILL = "cupertino_book_circle_fill"
    BOOK_FILL = "cupertino_book_fill"
    BOOKMARK_FILL = "cupertino_bookmark_fill"
    BRIEFCASE = "cupertino_briefcase"
    BRIEFCASE_FILL = "cupertino_briefcase_fill"
    BUBBLE_LEFT = "cupertino_bubble_left"
    BUBBLE_LEFT_BUBBLE_RIGHT = "cupertino_bubble_left_bubble_right"
    BUBBLE_LEFT_BUBBLE_RIGHT_FILL = "cupertino_bubble_left_bubble_right_fill"
    BUBBLE_LEFT_FILL = "cupertino_bubble_left_fill"
    BUBBLE_MIDDLE_BOTTOM = "cupertino_bubble_middle_bottom"
    BUBBLE_MIDDLE_BOTTOM_FILL = "cupertino_bubble_middle_bottom_fill"
    BUBBLE_MIDDLE_TOP = "cupertino_bubble_middle_top"
    BUBBLE_MIDDLE_TOP_FILL = "cupertino_bubble_middle_top_fill"
    BUBBLE_RIGHT = "cupertino_bubble_right"
    BUBBLE_RIGHT_FILL = "cupertino_bubble_right_fill"
    BUILDING_2_FILL = "cupertino_building_2_fill"
    BURN = "cupertino_burn"
    BURST = "cupertino_burst"
    BURST_FILL = "cupertino_burst_fill"
    CALENDAR = "cupertino_calendar"
    CALENDAR_BADGE_MINUS = "cupertino_calendar_badge_minus"
    CALENDAR_BADGE_PLUS = "cupertino_calendar_badge_plus"
    CALENDAR_CIRCLE = "cupertino_calendar_circle"
    CALENDAR_CIRCLE_FILL = "cupertino_calendar_circle_fill"
    CALENDAR_TODAY = "cupertino_calendar_today"
    CAMERA = "cupertino_camera"
    CAMERA_CIRCLE = "cupertino_camera_circle"
    CAMERA_CIRCLE_FILL = "cupertino_camera_circle_fill"
    CAMERA_FILL = "cupertino_camera_fill"
    CAMERA_ON_RECTANGLE = "cupertino_camera_on_rectangle"
    CAMERA_ON_RECTANGLE_FILL = "cupertino_camera_on_rectangle_fill"
    CAMERA_ROTATE = "cupertino_camera_rotate"
    CAMERA_ROTATE_FILL = "cupertino_camera_rotate_fill"
    CAMERA_VIEWFINDER = "cupertino_camera_viewfinder"
    CAPSLOCK = "cupertino_capslock"
    CAPSLOCK_FILL = "cupertino_capslock_fill"
    CAPSULE = "cupertino_capsule"
    CAPSULE_FILL = "cupertino_capsule_fill"
    CAPTIONS_BUBBLE = "cupertino_captions_bubble"
    CAPTIONS_BUBBLE_FILL = "cupertino_captions_bubble_fill"
    CAR_FILL = "cupertino_car_fill"
    CART = "cupertino_cart"
    CART_BADGE_MINUS = "cupertino_cart_badge_minus"
    CART_BADGE_PLUS = "cupertino_cart_badge_plus"
    CART_FILL = "cupertino_cart_fill"
    CART_FILL_BADGE_MINUS = "cupertino_cart_fill_badge_minus"
    CART_FILL_BADGE_PLUS = "cupertino_cart_fill_badge_plus"
    CHART_BAR = "cupertino_chart_bar"
    CHART_BAR_ALT_FILL = "cupertino_chart_bar_alt_fill"
    CHART_BAR_CIRCLE = "cupertino_chart_bar_circle"
    CHART_BAR_CIRCLE_FILL = "cupertino_chart_bar_circle_fill"
    CHART_BAR_FILL = "cupertino_chart_bar_fill"
    CHART_BAR_SQUARE = "cupertino_chart_bar_square"
    CHART_BAR_SQUARE_FILL = "cupertino_chart_bar_square_fill"
    CHART_PIE = "cupertino_chart_pie"
    CHART_PIE_FILL = "cupertino_chart_pie_fill"
    CHAT_BUBBLE = "cupertino_chat_bubble"
    CHAT_BUBBLE_2 = "cupertino_chat_bubble_2"
    CHAT_BUBBLE_2_FILL = "cupertino_chat_bubble_2_fill"
    CHAT_BUBBLE_FILL = "cupertino_chat_bubble_fill"
    CHAT_BUBBLE_TEXT = "cupertino_chat_bubble_text"
    CHAT_BUBBLE_TEXT_FILL = "cupertino_chat_bubble_text_fill"
    CHECKMARK = "cupertino_checkmark"
    CHECKMARK_ALT = "cupertino_checkmark_alt"
    CHECKMARK_ALT_CIRCLE = "cupertino_checkmark_alt_circle"
    CHECKMARK_ALT_CIRCLE_FILL = "cupertino_checkmark_alt_circle_fill"
    CHECKMARK_CIRCLE = "cupertino_checkmark_circle"
    CHECKMARK_CIRCLE_FILL = "cupertino_checkmark_circle_fill"
    CHECKMARK_RECTANGLE = "cupertino_checkmark_rectangle"
    CHECKMARK_RECTANGLE_FILL = "cupertino_checkmark_rectangle_fill"
    CHECKMARK_SEAL = "cupertino_checkmark_seal"
    CHECKMARK_SEAL_FILL = "cupertino_checkmark_seal_fill"
    CHECKMARK_SHIELD = "cupertino_checkmark_shield"
    CHECKMARK_SHIELD_FILL = "cupertino_checkmark_shield_fill"
    CHECKMARK_SQUARE = "cupertino_checkmark_square"
    CHECKMARK_SQUARE_FILL = "cupertino_checkmark_square_fill"
    CHEVRON_BACK = "cupertino_chevron_back"
    CHEVRON_COMPACT_DOWN = "cupertino_chevron_compact_down"
    CHEVRON_COMPACT_LEFT = "cupertino_chevron_compact_left"
    CHEVRON_COMPACT_RIGHT = "cupertino_chevron_compact_right"
    CHEVRON_COMPACT_UP = "cupertino_chevron_compact_up"
    CHEVRON_DOWN = "cupertino_chevron_down"
    CHEVRON_DOWN_CIRCLE = "cupertino_chevron_down_circle"
    CHEVRON_DOWN_CIRCLE_FILL = "cupertino_chevron_down_circle_fill"
    CHEVRON_DOWN_SQUARE = "cupertino_chevron_down_square"
    CHEVRON_DOWN_SQUARE_FILL = "cupertino_chevron_down_square_fill"
    CHEVRON_FORWARD = "cupertino_chevron_forward"
    CHEVRON_LEFT = "cupertino_chevron_left"
    CHEVRON_LEFT_2 = "cupertino_chevron_left_2"
    CHEVRON_LEFT_CIRCLE = "cupertino_chevron_left_circle"
    CHEVRON_LEFT_CIRCLE_FILL = "cupertino_chevron_left_circle_fill"
    CHEVRON_LEFT_SLASH_CHEVRON_RIGHT = "cupertino_chevron_left_slash_chevron_right"
    CHEVRON_LEFT_SQUARE = "cupertino_chevron_left_square"
    CHEVRON_LEFT_SQUARE_FILL = "cupertino_chevron_left_square_fill"
    CHEVRON_RIGHT = "cupertino_chevron_right"
    CHEVRON_RIGHT_2 = "cupertino_chevron_right_2"
    CHEVRON_RIGHT_CIRCLE = "cupertino_chevron_right_circle"
    CHEVRON_RIGHT_CIRCLE_FILL = "cupertino_chevron_right_circle_fill"
    CHEVRON_RIGHT_SQUARE = "cupertino_chevron_right_square"
    CHEVRON_RIGHT_SQUARE_FILL = "cupertino_chevron_right_square_fill"
    CHEVRON_UP = "cupertino_chevron_up"
    CHEVRON_UP_CHEVRON_DOWN = "cupertino_chevron_up_chevron_down"
    CHEVRON_UP_CIRCLE = "cupertino_chevron_up_circle"
    CHEVRON_UP_CIRCLE_FILL = "cupertino_chevron_up_circle_fill"
    CHEVRON_UP_SQUARE = "cupertino_chevron_up_square"
    CHEVRON_UP_SQUARE_FILL = "cupertino_chevron_up_square_fill"
    CIRCLE_BOTTOMTHIRD_SPLIT = "cupertino_circle_bottomthird_split"
    CIRCLE_FILL = "cupertino_circle_fill"
    CIRCLE_GRID_3X3 = "cupertino_circle_grid_3x3"
    CIRCLE_GRID_3X3_FILL = "cupertino_circle_grid_3x3_fill"
    CIRCLE_GRID_HEX = "cupertino_circle_grid_hex"
    CIRCLE_GRID_HEX_FILL = "cupertino_circle_grid_hex_fill"
    CIRCLE_LEFTHALF_FILL = "cupertino_circle_lefthalf_fill"
    CIRCLE_RIGHTHALF_FILL = "cupertino_circle_righthalf_fill"
    CLEAR_FILL = "cupertino_clear_fill"
    CLOCK_FILL = "cupertino_clock_fill"
    CLOUD = "cupertino_cloud"
    CLOUD_BOLT = "cupertino_cloud_bolt"
    CLOUD_BOLT_FILL = "cupertino_cloud_bolt_fill"
    CLOUD_BOLT_RAIN = "cupertino_cloud_bolt_rain"
    CLOUD_BOLT_RAIN_FILL = "cupertino_cloud_bolt_rain_fill"
    CLOUD_DOWNLOAD = "cupertino_cloud_download"
    CLOUD_DOWNLOAD_FILL = "cupertino_cloud_download_fill"
    CLOUD_DRIZZLE = "cupertino_cloud_drizzle"
    CLOUD_DRIZZLE_FILL = "cupertino_cloud_drizzle_fill"
    CLOUD_FILL = "cupertino_cloud_fill"
    CLOUD_FOG = "cupertino_cloud_fog"
    CLOUD_FOG_FILL = "cupertino_cloud_fog_fill"
    CLOUD_HAIL = "cupertino_cloud_hail"
    CLOUD_HAIL_FILL = "cupertino_cloud_hail_fill"
    CLOUD_HEAVYRAIN = "cupertino_cloud_heavyrain"
    CLOUD_HEAVYRAIN_FILL = "cupertino_cloud_heavyrain_fill"
    CLOUD_MOON = "cupertino_cloud_moon"
    CLOUD_MOON_BOLT = "cupertino_cloud_moon_bolt"
    CLOUD_MOON_BOLT_FILL = "cupertino_cloud_moon_bolt_fill"
    CLOUD_MOON_FILL = "cupertino_cloud_moon_fill"
    CLOUD_MOON_RAIN = "cupertino_cloud_moon_rain"
    CLOUD_MOON_RAIN_FILL = "cupertino_cloud_moon_rain_fill"
    CLOUD_RAIN = "cupertino_cloud_rain"
    CLOUD_RAIN_FILL = "cupertino_cloud_rain_fill"
    CLOUD_SLEET = "cupertino_cloud_sleet"
    CLOUD_SLEET_FILL = "cupertino_cloud_sleet_fill"
    CLOUD_SNOW = "cupertino_cloud_snow"
    CLOUD_SNOW_FILL = "cupertino_cloud_snow_fill"
    CLOUD_SUN = "cupertino_cloud_sun"
    CLOUD_SUN_BOLT = "cupertino_cloud_sun_bolt"
    CLOUD_SUN_BOLT_FILL = "cupertino_cloud_sun_bolt_fill"
    CLOUD_SUN_FILL = "cupertino_cloud_sun_fill"
    CLOUD_SUN_RAIN = "cupertino_cloud_sun_rain"
    CLOUD_SUN_RAIN_FILL = "cupertino_cloud_sun_rain_fill"
    CLOUD_UPLOAD = "cupertino_cloud_upload"
    CLOUD_UPLOAD_FILL = "cupertino_cloud_upload_fill"
    COLOR_FILTER = "cupertino_color_filter"
    COLOR_FILTER_FILL = "cupertino_color_filter_fill"
    COMMAND = "cupertino_command"
    COMPASS = "cupertino_compass"
    COMPASS_FILL = "cupertino_compass_fill"
    CONTROL = "cupertino_control"
    CREDITCARD = "cupertino_creditcard"
    CREDITCARD_FILL = "cupertino_creditcard_fill"
    CROP = "cupertino_crop"
    CROP_ROTATE = "cupertino_crop_rotate"
    CUBE = "cupertino_cube"
    CUBE_BOX = "cupertino_cube_box"
    CUBE_BOX_FILL = "cupertino_cube_box_fill"
    CUBE_FILL = "cupertino_cube_fill"
    CURSOR_RAYS = "cupertino_cursor_rays"
    DECREASE_INDENT = "cupertino_decrease_indent"
    DECREASE_QUOTELEVEL = "cupertino_decrease_quotelevel"
    DELETE_LEFT = "cupertino_delete_left"
    DELETE_LEFT_FILL = "cupertino_delete_left_fill"
    DELETE_RIGHT = "cupertino_delete_right"
    DELETE_RIGHT_FILL = "cupertino_delete_right_fill"
    DESKTOPCOMPUTER = "cupertino_desktopcomputer"
    DEVICE_DESKTOP = "cupertino_device_desktop"
    DEVICE_LAPTOP = "cupertino_device_laptop"
    DEVICE_PHONE_LANDSCAPE = "cupertino_device_phone_landscape"
    DEVICE_PHONE_PORTRAIT = "cupertino_device_phone_portrait"
    DIAL = "cupertino_dial"
    DIAL_FILL = "cupertino_dial_fill"
    DIVIDE = "cupertino_divide"
    DIVIDE_CIRCLE = "cupertino_divide_circle"
    DIVIDE_CIRCLE_FILL = "cupertino_divide_circle_fill"
    DIVIDE_SQUARE = "cupertino_divide_square"
    DIVIDE_SQUARE_FILL = "cupertino_divide_square_fill"
    DOC = "cupertino_doc"
    DOC_APPEND = "cupertino_doc_append"
    DOC_CHART = "cupertino_doc_chart"
    DOC_CHART_FILL = "cupertino_doc_chart_fill"
    DOC_CHECKMARK = "cupertino_doc_checkmark"
    DOC_CHECKMARK_FILL = "cupertino_doc_checkmark_fill"
    DOC_CIRCLE = "cupertino_doc_circle"
    DOC_CIRCLE_FILL = "cupertino_doc_circle_fill"
    DOC_FILL = "cupertino_doc_fill"
    DOC_ON_CLIPBOARD = "cupertino_doc_on_clipboard"
    DOC_ON_CLIPBOARD_FILL = "cupertino_doc_on_clipboard_fill"
    DOC_ON_DOC = "cupertino_doc_on_doc"
    DOC_ON_DOC_FILL = "cupertino_doc_on_doc_fill"
    DOC_PERSON = "cupertino_doc_person"
    DOC_PERSON_FILL = "cupertino_doc_person_fill"
    DOC_PLAINTEXT = "cupertino_doc_plaintext"
    DOC_RICHTEXT = "cupertino_doc_richtext"
    DOC_TEXT = "cupertino_doc_text"
    DOC_TEXT_FILL = "cupertino_doc_text_fill"
    DOC_TEXT_SEARCH = "cupertino_doc_text_search"
    DOC_TEXT_VIEWFINDER = "cupertino_doc_text_viewfinder"
    DOT_RADIOWAVES_LEFT_RIGHT = "cupertino_dot_radiowaves_left_right"
    DOT_RADIOWAVES_RIGHT = "cupertino_dot_radiowaves_right"
    DOT_SQUARE = "cupertino_dot_square"
    DOT_SQUARE_FILL = "cupertino_dot_square_fill"
    DOWNLOAD_CIRCLE = "cupertino_download_circle"
    DOWNLOAD_CIRCLE_FILL = "cupertino_download_circle_fill"
    DROP = "cupertino_drop"
    DROP_FILL = "cupertino_drop_fill"
    DROP_TRIANGLE = "cupertino_drop_triangle"
    DROP_TRIANGLE_FILL = "cupertino_drop_triangle_fill"
    EAR = "cupertino_ear"
    EJECT = "cupertino_eject"
    EJECT_FILL = "cupertino_eject_fill"
    ELLIPSES_BUBBLE = "cupertino_ellipses_bubble"
    ELLIPSES_BUBBLE_FILL = "cupertino_ellipses_bubble_fill"
    ELLIPSIS_CIRCLE = "cupertino_ellipsis_circle"
    ELLIPSIS_CIRCLE_FILL = "cupertino_ellipsis_circle_fill"
    ELLIPSIS_VERTICAL = "cupertino_ellipsis_vertical"
    ELLIPSIS_VERTICAL_CIRCLE = "cupertino_ellipsis_vertical_circle"
    ELLIPSIS_VERTICAL_CIRCLE_FILL = "cupertino_ellipsis_vertical_circle_fill"
    ENVELOPE = "cupertino_envelope"
    ENVELOPE_BADGE = "cupertino_envelope_badge"
    ENVELOPE_BADGE_FILL = "cupertino_envelope_badge_fill"
    ENVELOPE_CIRCLE = "cupertino_envelope_circle"
    ENVELOPE_CIRCLE_FILL = "cupertino_envelope_circle_fill"
    ENVELOPE_FILL = "cupertino_envelope_fill"
    ENVELOPE_OPEN = "cupertino_envelope_open"
    ENVELOPE_OPEN_FILL = "cupertino_envelope_open_fill"
    EQUAL = "cupertino_equal"
    EQUAL_CIRCLE = "cupertino_equal_circle"
    EQUAL_CIRCLE_FILL = "cupertino_equal_circle_fill"
    EQUAL_SQUARE = "cupertino_equal_square"
    EQUAL_SQUARE_FILL = "cupertino_equal_square_fill"
    ESCAPE = "cupertino_escape"
    EXCLAMATIONMARK = "cupertino_exclamationmark"
    EXCLAMATIONMARK_BUBBLE = "cupertino_exclamationmark_bubble"
    EXCLAMATIONMARK_BUBBLE_FILL = "cupertino_exclamationmark_bubble_fill"
    EXCLAMATIONMARK_CIRCLE = "cupertino_exclamationmark_circle"
    EXCLAMATIONMARK_CIRCLE_FILL = "cupertino_exclamationmark_circle_fill"
    EXCLAMATIONMARK_OCTAGON = "cupertino_exclamationmark_octagon"
    EXCLAMATIONMARK_OCTAGON_FILL = "cupertino_exclamationmark_octagon_fill"
    EXCLAMATIONMARK_SHIELD = "cupertino_exclamationmark_shield"
    EXCLAMATIONMARK_SHIELD_FILL = "cupertino_exclamationmark_shield_fill"
    EXCLAMATIONMARK_SQUARE = "cupertino_exclamationmark_square"
    EXCLAMATIONMARK_SQUARE_FILL = "cupertino_exclamationmark_square_fill"
    EXCLAMATIONMARK_TRIANGLE = "cupertino_exclamationmark_triangle"
    EXCLAMATIONMARK_TRIANGLE_FILL = "cupertino_exclamationmark_triangle_fill"
    EYE_FILL = "cupertino_eye_fill"
    EYE_SLASH = "cupertino_eye_slash"
    EYE_SLASH_FILL = "cupertino_eye_slash_fill"
    EYEDROPPER = "cupertino_eyedropper"
    EYEDROPPER_FULL = "cupertino_eyedropper_full"
    EYEDROPPER_HALFFULL = "cupertino_eyedropper_halffull"
    EYEGLASSES = "cupertino_eyeglasses"
    F_CURSIVE = "cupertino_f_cursive"
    F_CURSIVE_CIRCLE = "cupertino_f_cursive_circle"
    F_CURSIVE_CIRCLE_FILL = "cupertino_f_cursive_circle_fill"
    FILM = "cupertino_film"
    FILM_FILL = "cupertino_film_fill"
    FLAG_CIRCLE = "cupertino_flag_circle"
    FLAG_CIRCLE_FILL = "cupertino_flag_circle_fill"
    FLAG_FILL = "cupertino_flag_fill"
    FLAG_SLASH = "cupertino_flag_slash"
    FLAG_SLASH_FILL = "cupertino_flag_slash_fill"
    FLAME = "cupertino_flame"
    FLAME_FILL = "cupertino_flame_fill"
    FLOPPY_DISK = "cupertino_floppy_disk"
    FLOWCHART = "cupertino_flowchart"
    FLOWCHART_FILL = "cupertino_flowchart_fill"
    FOLDER_BADGE_MINUS = "cupertino_folder_badge_minus"
    FOLDER_BADGE_PERSON_CROP = "cupertino_folder_badge_person_crop"
    FOLDER_BADGE_PLUS = "cupertino_folder_badge_plus"
    FOLDER_CIRCLE = "cupertino_folder_circle"
    FOLDER_CIRCLE_FILL = "cupertino_folder_circle_fill"
    FOLDER_FILL = "cupertino_folder_fill"
    FOLDER_FILL_BADGE_MINUS = "cupertino_folder_fill_badge_minus"
    FOLDER_FILL_BADGE_PERSON_CROP = "cupertino_folder_fill_badge_person_crop"
    FOLDER_FILL_BADGE_PLUS = "cupertino_folder_fill_badge_plus"
    FORWARD_END = "cupertino_forward_end"
    FORWARD_END_ALT = "cupertino_forward_end_alt"
    FORWARD_END_ALT_FILL = "cupertino_forward_end_alt_fill"
    FORWARD_END_FILL = "cupertino_forward_end_fill"
    FORWARD_FILL = "cupertino_forward_fill"
    FUNCTION = "cupertino_function"
    FX = "cupertino_fx"
    GAMECONTROLLER = "cupertino_gamecontroller"
    GAMECONTROLLER_ALT_FILL = "cupertino_gamecontroller_alt_fill"
    GAMECONTROLLER_FILL = "cupertino_gamecontroller_fill"
    GAUGE = "cupertino_gauge"
    GAUGE_BADGE_MINUS = "cupertino_gauge_badge_minus"
    GAUGE_BADGE_PLUS = "cupertino_gauge_badge_plus"
    GEAR_ALT = "cupertino_gear_alt"
    GEAR_ALT_FILL = "cupertino_gear_alt_fill"
    GIFT = "cupertino_gift"
    GIFT_ALT = "cupertino_gift_alt"
    GIFT_ALT_FILL = "cupertino_gift_alt_fill"
    GIFT_FILL = "cupertino_gift_fill"
    GLOBE = "cupertino_globe"
    GOBACKWARD = "cupertino_gobackward"
    GOBACKWARD_10 = "cupertino_gobackward_10"
    GOBACKWARD_15 = "cupertino_gobackward_15"
    GOBACKWARD_30 = "cupertino_gobackward_30"
    GOBACKWARD_45 = "cupertino_gobackward_45"
    GOBACKWARD_60 = "cupertino_gobackward_60"
    GOBACKWARD_75 = "cupertino_gobackward_75"
    GOBACKWARD_90 = "cupertino_gobackward_90"
    GOBACKWARD_MINUS = "cupertino_gobackward_minus"
    GOFORWARD = "cupertino_goforward"
    GOFORWARD_10 = "cupertino_goforward_10"
    GOFORWARD_15 = "cupertino_goforward_15"
    GOFORWARD_30 = "cupertino_goforward_30"
    GOFORWARD_45 = "cupertino_goforward_45"
    GOFORWARD_60 = "cupertino_goforward_60"
    GOFORWARD_75 = "cupertino_goforward_75"
    GOFORWARD_90 = "cupertino_goforward_90"
    GOFORWARD_PLUS = "cupertino_goforward_plus"
    GRAPH_CIRCLE = "cupertino_graph_circle"
    GRAPH_CIRCLE_FILL = "cupertino_graph_circle_fill"
    GRAPH_SQUARE = "cupertino_graph_square"
    GRAPH_SQUARE_FILL = "cupertino_graph_square_fill"
    GREATERTHAN = "cupertino_greaterthan"
    GREATERTHAN_CIRCLE = "cupertino_greaterthan_circle"
    GREATERTHAN_CIRCLE_FILL = "cupertino_greaterthan_circle_fill"
    GREATERTHAN_SQUARE = "cupertino_greaterthan_square"
    GREATERTHAN_SQUARE_FILL = "cupertino_greaterthan_square_fill"
    GRID = "cupertino_grid"
    GRID_CIRCLE = "cupertino_grid_circle"
    GRID_CIRCLE_FILL = "cupertino_grid_circle_fill"
    GUITARS = "cupertino_guitars"
    HAMMER = "cupertino_hammer"
    HAMMER_FILL = "cupertino_hammer_fill"
    HAND_DRAW = "cupertino_hand_draw"
    HAND_DRAW_FILL = "cupertino_hand_draw_fill"
    HAND_POINT_LEFT = "cupertino_hand_point_left"
    HAND_POINT_LEFT_FILL = "cupertino_hand_point_left_fill"
    HAND_POINT_RIGHT = "cupertino_hand_point_right"
    HAND_POINT_RIGHT_FILL = "cupertino_hand_point_right_fill"
    HAND_RAISED = "cupertino_hand_raised"
    HAND_RAISED_FILL = "cupertino_hand_raised_fill"
    HAND_RAISED_SLASH = "cupertino_hand_raised_slash"
    HAND_RAISED_SLASH_FILL = "cupertino_hand_raised_slash_fill"
    HAND_THUMBSDOWN = "cupertino_hand_thumbsdown"
    HAND_THUMBSDOWN_FILL = "cupertino_hand_thumbsdown_fill"
    HAND_THUMBSUP = "cupertino_hand_thumbsup"
    HAND_THUMBSUP_FILL = "cupertino_hand_thumbsup_fill"
    HARE = "cupertino_hare"
    HARE_FILL = "cupertino_hare_fill"
    HEADPHONES = "cupertino_headphones"
    HEART_CIRCLE = "cupertino_heart_circle"
    HEART_CIRCLE_FILL = "cupertino_heart_circle_fill"
    HEART_FILL = "cupertino_heart_fill"
    HEART_SLASH = "cupertino_heart_slash"
    HEART_SLASH_CIRCLE = "cupertino_heart_slash_circle"
    HEART_SLASH_CIRCLE_FILL = "cupertino_heart_slash_circle_fill"
    HEART_SLASH_FILL = "cupertino_heart_slash_fill"
    HELM = "cupertino_helm"
    HEXAGON = "cupertino_hexagon"
    HEXAGON_FILL = "cupertino_hexagon_fill"
    HIFISPEAKER = "cupertino_hifispeaker"
    HIFISPEAKER_FILL = "cupertino_hifispeaker_fill"
    HOURGLASS = "cupertino_hourglass"
    HOURGLASS_BOTTOMHALF_FILL = "cupertino_hourglass_bottomhalf_fill"
    HOURGLASS_TOPHALF_FILL = "cupertino_hourglass_tophalf_fill"
    HOUSE = "cupertino_house"
    HOUSE_ALT = "cupertino_house_alt"
    HOUSE_ALT_FILL = "cupertino_house_alt_fill"
    HOUSE_FILL = "cupertino_house_fill"
    HURRICANE = "cupertino_hurricane"
    INCREASE_INDENT = "cupertino_increase_indent"
    INCREASE_QUOTELEVEL = "cupertino_increase_quotelevel"
    INFINITE = "cupertino_infinite"
    INFO_CIRCLE = "cupertino_info_circle"
    INFO_CIRCLE_FILL = "cupertino_info_circle_fill"
    ITALIC = "cupertino_italic"
    KEYBOARD = "cupertino_keyboard"
    KEYBOARD_CHEVRON_COMPACT_DOWN = "cupertino_keyboard_chevron_compact_down"
    LARGECIRCLE_FILL_CIRCLE = "cupertino_largecircle_fill_circle"
    LASSO = "cupertino_lasso"
    LAYERS = "cupertino_layers"
    LAYERS_ALT = "cupertino_layers_alt"
    LAYERS_ALT_FILL = "cupertino_layers_alt_fill"
    LAYERS_FILL = "cupertino_layers_fill"
    LEAF_ARROW_CIRCLEPATH = "cupertino_leaf_arrow_circlepath"
    LESSTHAN = "cupertino_lessthan"
    LESSTHAN_CIRCLE = "cupertino_lessthan_circle"
    LESSTHAN_CIRCLE_FILL = "cupertino_lessthan_circle_fill"
    LESSTHAN_SQUARE = "cupertino_lessthan_square"
    LESSTHAN_SQUARE_FILL = "cupertino_lessthan_square_fill"
    LIGHT_MAX = "cupertino_light_max"
    LIGHT_MIN = "cupertino_light_min"
    LIGHTBULB = "cupertino_lightbulb"
    LIGHTBULB_FILL = "cupertino_lightbulb_fill"
    LIGHTBULB_SLASH = "cupertino_lightbulb_slash"
    LIGHTBULB_SLASH_FILL = "cupertino_lightbulb_slash_fill"
    LINE_HORIZONTAL_3 = "cupertino_line_horizontal_3"
    LINE_HORIZONTAL_3_DECREASE = "cupertino_line_horizontal_3_decrease"
    LINE_HORIZONTAL_3_DECREASE_CIRCLE = "cupertino_line_horizontal_3_decrease_circle"
    LINE_HORIZONTAL_3_DECREASE_CIRCLE_FILL = (
        "cupertino_line_horizontal_3_decrease_circle_fill"
    )
    LINK = "cupertino_link"
    LINK_CIRCLE = "cupertino_link_circle"
    LINK_CIRCLE_FILL = "cupertino_link_circle_fill"
    LIST_BULLET = "cupertino_list_bullet"
    LIST_BULLET_BELOW_RECTANGLE = "cupertino_list_bullet_below_rectangle"
    LIST_BULLET_INDENT = "cupertino_list_bullet_indent"
    LIST_DASH = "cupertino_list_dash"
    LIST_NUMBER = "cupertino_list_number"
    LIST_NUMBER_RTL = "cupertino_list_number_rtl"
    LOCATION_CIRCLE = "cupertino_location_circle"
    LOCATION_CIRCLE_FILL = "cupertino_location_circle_fill"
    LOCATION_FILL = "cupertino_location_fill"
    LOCATION_NORTH = "cupertino_location_north"
    LOCATION_NORTH_FILL = "cupertino_location_north_fill"
    LOCATION_NORTH_LINE = "cupertino_location_north_line"
    LOCATION_NORTH_LINE_FILL = "cupertino_location_north_line_fill"
    LOCATION_SLASH = "cupertino_location_slash"
    LOCATION_SLASH_FILL = "cupertino_location_slash_fill"
    LOCK = "cupertino_lock"
    LOCK_CIRCLE = "cupertino_lock_circle"
    LOCK_CIRCLE_FILL = "cupertino_lock_circle_fill"
    LOCK_FILL = "cupertino_lock_fill"
    LOCK_OPEN = "cupertino_lock_open"
    LOCK_OPEN_FILL = "cupertino_lock_open_fill"
    LOCK_ROTATION = "cupertino_lock_rotation"
    LOCK_ROTATION_OPEN = "cupertino_lock_rotation_open"
    LOCK_SHIELD = "cupertino_lock_shield"
    LOCK_SHIELD_FILL = "cupertino_lock_shield_fill"
    LOCK_SLASH = "cupertino_lock_slash"
    LOCK_SLASH_FILL = "cupertino_lock_slash_fill"
    MACWINDOW = "cupertino_macwindow"
    MAP = "cupertino_map"
    MAP_FILL = "cupertino_map_fill"
    MAP_PIN = "cupertino_map_pin"
    MAP_PIN_ELLIPSE = "cupertino_map_pin_ellipse"
    MAP_PIN_SLASH = "cupertino_map_pin_slash"
    MEMORIES = "cupertino_memories"
    MEMORIES_BADGE_MINUS = "cupertino_memories_badge_minus"
    MEMORIES_BADGE_PLUS = "cupertino_memories_badge_plus"
    METRONOME = "cupertino_metronome"
    MIC_CIRCLE = "cupertino_mic_circle"
    MIC_CIRCLE_FILL = "cupertino_mic_circle_fill"
    MIC_FILL = "cupertino_mic_fill"
    MIC_SLASH = "cupertino_mic_slash"
    MIC_SLASH_FILL = "cupertino_mic_slash_fill"
    MINUS = "cupertino_minus"
    MINUS_CIRCLE = "cupertino_minus_circle"
    MINUS_CIRCLE_FILL = "cupertino_minus_circle_fill"
    MINUS_RECTANGLE = "cupertino_minus_rectangle"
    MINUS_RECTANGLE_FILL = "cupertino_minus_rectangle_fill"
    MINUS_SLASH_PLUS = "cupertino_minus_slash_plus"
    MINUS_SQUARE = "cupertino_minus_square"
    MINUS_SQUARE_FILL = "cupertino_minus_square_fill"
    MONEY_DOLLAR = "cupertino_money_dollar"
    MONEY_DOLLAR_CIRCLE = "cupertino_money_dollar_circle"
    MONEY_DOLLAR_CIRCLE_FILL = "cupertino_money_dollar_circle_fill"
    MONEY_EURO = "cupertino_money_euro"
    MONEY_EURO_CIRCLE = "cupertino_money_euro_circle"
    MONEY_EURO_CIRCLE_FILL = "cupertino_money_euro_circle_fill"
    MONEY_POUND = "cupertino_money_pound"
    MONEY_POUND_CIRCLE = "cupertino_money_pound_circle"
    MONEY_POUND_CIRCLE_FILL = "cupertino_money_pound_circle_fill"
    MONEY_RUBL = "cupertino_money_rubl"
    MONEY_RUBL_CIRCLE = "cupertino_money_rubl_circle"
    MONEY_RUBL_CIRCLE_FILL = "cupertino_money_rubl_circle_fill"
    MONEY_YEN = "cupertino_money_yen"
    MONEY_YEN_CIRCLE = "cupertino_money_yen_circle"
    MONEY_YEN_CIRCLE_FILL = "cupertino_money_yen_circle_fill"
    MOON = "cupertino_moon"
    MOON_CIRCLE = "cupertino_moon_circle"
    MOON_CIRCLE_FILL = "cupertino_moon_circle_fill"
    MOON_FILL = "cupertino_moon_fill"
    MOON_STARS = "cupertino_moon_stars"
    MOON_STARS_FILL = "cupertino_moon_stars_fill"
    MOON_ZZZ = "cupertino_moon_zzz"
    MOON_ZZZ_FILL = "cupertino_moon_zzz_fill"
    MOVE = "cupertino_move"
    MULTIPLY = "cupertino_multiply"
    MULTIPLY_CIRCLE = "cupertino_multiply_circle"
    MULTIPLY_CIRCLE_FILL = "cupertino_multiply_circle_fill"
    MULTIPLY_SQUARE = "cupertino_multiply_square"
    MULTIPLY_SQUARE_FILL = "cupertino_multiply_square_fill"
    MUSIC_ALBUMS = "cupertino_music_albums"
    MUSIC_ALBUMS_FILL = "cupertino_music_albums_fill"
    MUSIC_HOUSE = "cupertino_music_house"
    MUSIC_HOUSE_FILL = "cupertino_music_house_fill"
    MUSIC_MIC = "cupertino_music_mic"
    MUSIC_NOTE_2 = "cupertino_music_note_2"
    MUSIC_NOTE_LIST = "cupertino_music_note_list"
    NOSIGN = "cupertino_nosign"
    NUMBER = "cupertino_number"
    NUMBER_CIRCLE = "cupertino_number_circle"
    NUMBER_CIRCLE_FILL = "cupertino_number_circle_fill"
    NUMBER_SQUARE = "cupertino_number_square"
    NUMBER_SQUARE_FILL = "cupertino_number_square_fill"
    OPTION = "cupertino_option"
    PAINTBRUSH = "cupertino_paintbrush"
    PAINTBRUSH_FILL = "cupertino_paintbrush_fill"
    PANO = "cupertino_pano"
    PANO_FILL = "cupertino_pano_fill"
    PAPERCLIP = "cupertino_paperclip"
    PAPERPLANE = "cupertino_paperplane"
    PAPERPLANE_FILL = "cupertino_paperplane_fill"
    PARAGRAPH = "cupertino_paragraph"
    PAUSE_CIRCLE = "cupertino_pause_circle"
    PAUSE_CIRCLE_FILL = "cupertino_pause_circle_fill"
    PAUSE_FILL = "cupertino_pause_fill"
    PAUSE_RECTANGLE = "cupertino_pause_rectangle"
    PAUSE_RECTANGLE_FILL = "cupertino_pause_rectangle_fill"
    PENCIL_CIRCLE = "cupertino_pencil_circle"
    PENCIL_CIRCLE_FILL = "cupertino_pencil_circle_fill"
    PENCIL_ELLIPSIS_RECTANGLE = "cupertino_pencil_ellipsis_rectangle"
    PENCIL_OUTLINE = "cupertino_pencil_outline"
    PENCIL_SLASH = "cupertino_pencil_slash"
    PERCENT = "cupertino_percent"
    PERSON_2 = "cupertino_person_2"
    PERSON_2_ALT = "cupertino_person_2_alt"
    PERSON_2_FILL = "cupertino_person_2_fill"
    PERSON_2_SQUARE_STACK = "cupertino_person_2_square_stack"
    PERSON_2_SQUARE_STACK_FILL = "cupertino_person_2_square_stack_fill"
    PERSON_3 = "cupertino_person_3"
    PERSON_3_FILL = "cupertino_person_3_fill"
    PERSON_ALT = "cupertino_person_alt"
    PERSON_ALT_CIRCLE = "cupertino_person_alt_circle"
    PERSON_ALT_CIRCLE_FILL = "cupertino_person_alt_circle_fill"
    PERSON_BADGE_MINUS = "cupertino_person_badge_minus"
    PERSON_BADGE_MINUS_FILL = "cupertino_person_badge_minus_fill"
    PERSON_BADGE_PLUS = "cupertino_person_badge_plus"
    PERSON_BADGE_PLUS_FILL = "cupertino_person_badge_plus_fill"
    PERSON_CIRCLE = "cupertino_person_circle"
    PERSON_CIRCLE_FILL = "cupertino_person_circle_fill"
    PERSON_CROP_CIRCLE = "cupertino_person_crop_circle"
    PERSON_CROP_CIRCLE_BADGE_CHECKMARK = "cupertino_person_crop_circle_badge_checkmark"
    PERSON_CROP_CIRCLE_BADGE_EXCLAM = "cupertino_person_crop_circle_badge_exclam"
    PERSON_CROP_CIRCLE_BADGE_MINUS = "cupertino_person_crop_circle_badge_minus"
    PERSON_CROP_CIRCLE_BADGE_PLUS = "cupertino_person_crop_circle_badge_plus"
    PERSON_CROP_CIRCLE_BADGE_XMARK = "cupertino_person_crop_circle_badge_xmark"
    PERSON_CROP_CIRCLE_FILL = "cupertino_person_crop_circle_fill"
    PERSON_CROP_CIRCLE_FILL_BADGE_CHECKMARK = (
        "cupertino_person_crop_circle_fill_badge_checkmark"
    )
    PERSON_CROP_CIRCLE_FILL_BADGE_EXCLAM = (
        "cupertino_person_crop_circle_fill_badge_exclam"
    )
    PERSON_CROP_CIRCLE_FILL_BADGE_MINUS = (
        "cupertino_person_crop_circle_fill_badge_minus"
    )
    PERSON_CROP_CIRCLE_FILL_BADGE_PLUS = "cupertino_person_crop_circle_fill_badge_plus"
    PERSON_CROP_CIRCLE_FILL_BADGE_XMARK = (
        "cupertino_person_crop_circle_fill_badge_xmark"
    )
    PERSON_CROP_RECTANGLE = "cupertino_person_crop_rectangle"
    PERSON_CROP_RECTANGLE_FILL = "cupertino_person_crop_rectangle_fill"
    PERSON_CROP_SQUARE = "cupertino_person_crop_square"
    PERSON_CROP_SQUARE_FILL = "cupertino_person_crop_square_fill"
    PERSON_FILL = "cupertino_person_fill"
    PERSONALHOTSPOT = "cupertino_personalhotspot"
    PERSPECTIVE = "cupertino_perspective"
    PHONE_ARROW_DOWN_LEFT = "cupertino_phone_arrow_down_left"
    PHONE_ARROW_RIGHT = "cupertino_phone_arrow_right"
    PHONE_ARROW_UP_RIGHT = "cupertino_phone_arrow_up_right"
    PHONE_BADGE_PLUS = "cupertino_phone_badge_plus"
    PHONE_CIRCLE = "cupertino_phone_circle"
    PHONE_CIRCLE_FILL = "cupertino_phone_circle_fill"
    PHONE_DOWN = "cupertino_phone_down"
    PHONE_DOWN_CIRCLE = "cupertino_phone_down_circle"
    PHONE_DOWN_CIRCLE_FILL = "cupertino_phone_down_circle_fill"
    PHONE_DOWN_FILL = "cupertino_phone_down_fill"
    PHONE_FILL = "cupertino_phone_fill"
    PHONE_FILL_ARROW_DOWN_LEFT = "cupertino_phone_fill_arrow_down_left"
    PHONE_FILL_ARROW_RIGHT = "cupertino_phone_fill_arrow_right"
    PHONE_FILL_ARROW_UP_RIGHT = "cupertino_phone_fill_arrow_up_right"
    PHONE_FILL_BADGE_PLUS = "cupertino_phone_fill_badge_plus"
    PHOTO = "cupertino_photo"
    PHOTO_FILL = "cupertino_photo_fill"
    PHOTO_FILL_ON_RECTANGLE_FILL = "cupertino_photo_fill_on_rectangle_fill"
    PHOTO_ON_RECTANGLE = "cupertino_photo_on_rectangle"
    PIANO = "cupertino_piano"
    PIN = "cupertino_pin"
    PIN_FILL = "cupertino_pin_fill"
    PIN_SLASH = "cupertino_pin_slash"
    PIN_SLASH_FILL = "cupertino_pin_slash_fill"
    PLACEMARK = "cupertino_placemark"
    PLACEMARK_FILL = "cupertino_placemark_fill"
    PLAY = "cupertino_play"
    PLAY_CIRCLE = "cupertino_play_circle"
    PLAY_CIRCLE_FILL = "cupertino_play_circle_fill"
    PLAY_FILL = "cupertino_play_fill"
    PLAY_RECTANGLE = "cupertino_play_rectangle"
    PLAY_RECTANGLE_FILL = "cupertino_play_rectangle_fill"
    PLAYPAUSE = "cupertino_playpause"
    PLAYPAUSE_FILL = "cupertino_playpause_fill"
    PLUS = "cupertino_plus"
    PLUS_APP = "cupertino_plus_app"
    PLUS_APP_FILL = "cupertino_plus_app_fill"
    PLUS_BUBBLE = "cupertino_plus_bubble"
    PLUS_BUBBLE_FILL = "cupertino_plus_bubble_fill"
    PLUS_CIRCLE = "cupertino_plus_circle"
    PLUS_CIRCLE_FILL = "cupertino_plus_circle_fill"
    PLUS_RECTANGLE = "cupertino_plus_rectangle"
    PLUS_RECTANGLE_FILL = "cupertino_plus_rectangle_fill"
    PLUS_RECTANGLE_FILL_ON_RECTANGLE_FILL = (
        "cupertino_plus_rectangle_fill_on_rectangle_fill"
    )
    PLUS_RECTANGLE_ON_RECTANGLE = "cupertino_plus_rectangle_on_rectangle"
    PLUS_SLASH_MINUS = "cupertino_plus_slash_minus"
    PLUS_SQUARE = "cupertino_plus_square"
    PLUS_SQUARE_FILL = "cupertino_plus_square_fill"
    PLUS_SQUARE_FILL_ON_SQUARE_FILL = "cupertino_plus_square_fill_on_square_fill"
    PLUS_SQUARE_ON_SQUARE = "cupertino_plus_square_on_square"
    PLUSMINUS = "cupertino_plusminus"
    PLUSMINUS_CIRCLE = "cupertino_plusminus_circle"
    PLUSMINUS_CIRCLE_FILL = "cupertino_plusminus_circle_fill"
    POWER = "cupertino_power"
    PRINTER = "cupertino_printer"
    PRINTER_FILL = "cupertino_printer_fill"
    PROJECTIVE = "cupertino_projective"
    PURCHASED = "cupertino_purchased"
    PURCHASED_CIRCLE = "cupertino_purchased_circle"
    PURCHASED_CIRCLE_FILL = "cupertino_purchased_circle_fill"
    QRCODE = "cupertino_qrcode"
    QRCODE_VIEWFINDER = "cupertino_qrcode_viewfinder"
    QUESTION = "cupertino_question"
    QUESTION_CIRCLE = "cupertino_question_circle"
    QUESTION_CIRCLE_FILL = "cupertino_question_circle_fill"
    QUESTION_DIAMOND = "cupertino_question_diamond"
    QUESTION_DIAMOND_FILL = "cupertino_question_diamond_fill"
    QUESTION_SQUARE = "cupertino_question_square"
    QUESTION_SQUARE_FILL = "cupertino_question_square_fill"
    QUOTE_BUBBLE = "cupertino_quote_bubble"
    QUOTE_BUBBLE_FILL = "cupertino_quote_bubble_fill"
    RADIOWAVES_LEFT = "cupertino_radiowaves_left"
    RADIOWAVES_RIGHT = "cupertino_radiowaves_right"
    RAYS = "cupertino_rays"
    RECORDINGTAPE = "cupertino_recordingtape"
    RECTANGLE = "cupertino_rectangle"
    RECTANGLE_3_OFFGRID = "cupertino_rectangle_3_offgrid"
    RECTANGLE_3_OFFGRID_FILL = "cupertino_rectangle_3_offgrid_fill"
    RECTANGLE_ARROW_UP_RIGHT_ARROW_DOWN_LEFT = (
        "cupertino_rectangle_arrow_up_right_arrow_down_left"
    )
    RECTANGLE_ARROW_UP_RIGHT_ARROW_DOWN_LEFT_SLASH = (
        "cupertino_rectangle_arrow_up_right_arrow_down_left_slash"
    )
    RECTANGLE_BADGE_CHECKMARK = "cupertino_rectangle_badge_checkmark"
    RECTANGLE_BADGE_XMARK = "cupertino_rectangle_badge_xmark"
    RECTANGLE_COMPRESS_VERTICAL = "cupertino_rectangle_compress_vertical"
    RECTANGLE_DOCK = "cupertino_rectangle_dock"
    RECTANGLE_EXPAND_VERTICAL = "cupertino_rectangle_expand_vertical"
    RECTANGLE_FILL = "cupertino_rectangle_fill"
    RECTANGLE_FILL_BADGE_CHECKMARK = "cupertino_rectangle_fill_badge_checkmark"
    RECTANGLE_FILL_BADGE_XMARK = "cupertino_rectangle_fill_badge_xmark"
    RECTANGLE_FILL_ON_RECTANGLE_ANGLED_FILL = (
        "cupertino_rectangle_fill_on_rectangle_angled_fill"
    )
    RECTANGLE_FILL_ON_RECTANGLE_FILL = "cupertino_rectangle_fill_on_rectangle_fill"
    RECTANGLE_GRID_1X2 = "cupertino_rectangle_grid_1x2"
    RECTANGLE_GRID_1X2_FILL = "cupertino_rectangle_grid_1x2_fill"
    RECTANGLE_GRID_2X2 = "cupertino_rectangle_grid_2x2"
    RECTANGLE_GRID_2X2_FILL = "cupertino_rectangle_grid_2x2_fill"
    RECTANGLE_GRID_3X2 = "cupertino_rectangle_grid_3x2"
    RECTANGLE_GRID_3X2_FILL = "cupertino_rectangle_grid_3x2_fill"
    RECTANGLE_ON_RECTANGLE = "cupertino_rectangle_on_rectangle"
    RECTANGLE_ON_RECTANGLE_ANGLED = "cupertino_rectangle_on_rectangle_angled"
    RECTANGLE_PAPERCLIP = "cupertino_rectangle_paperclip"
    RECTANGLE_SPLIT_3X1 = "cupertino_rectangle_split_3x1"
    RECTANGLE_SPLIT_3X1_FILL = "cupertino_rectangle_split_3x1_fill"
    RECTANGLE_SPLIT_3X3 = "cupertino_rectangle_split_3x3"
    RECTANGLE_SPLIT_3X3_FILL = "cupertino_rectangle_split_3x3_fill"
    RECTANGLE_STACK = "cupertino_rectangle_stack"
    RECTANGLE_STACK_BADGE_MINUS = "cupertino_rectangle_stack_badge_minus"
    RECTANGLE_STACK_BADGE_PERSON_CROP = "cupertino_rectangle_stack_badge_person_crop"
    RECTANGLE_STACK_BADGE_PLUS = "cupertino_rectangle_stack_badge_plus"
    RECTANGLE_STACK_FILL = "cupertino_rectangle_stack_fill"
    RECTANGLE_STACK_FILL_BADGE_MINUS = "cupertino_rectangle_stack_fill_badge_minus"
    RECTANGLE_STACK_FILL_BADGE_PERSON_CROP = (
        "cupertino_rectangle_stack_fill_badge_person_crop"
    )
    RECTANGLE_STACK_FILL_BADGE_PLUS = "cupertino_rectangle_stack_fill_badge_plus"
    RECTANGLE_STACK_PERSON_CROP = "cupertino_rectangle_stack_person_crop"
    RECTANGLE_STACK_PERSON_CROP_FILL = "cupertino_rectangle_stack_person_crop_fill"
    REPEAT = "cupertino_repeat"
    REPEAT_1 = "cupertino_repeat_1"
    RESIZE = "cupertino_resize"
    RESIZE_H = "cupertino_resize_h"
    RESIZE_V = "cupertino_resize_v"
    RETURN_ICON = "cupertino_return_icon"
    RHOMBUS = "cupertino_rhombus"
    RHOMBUS_FILL = "cupertino_rhombus_fill"
    ROCKET = "cupertino_rocket"
    ROCKET_FILL = "cupertino_rocket_fill"
    ROSETTE = "cupertino_rosette"
    ROTATE_LEFT = "cupertino_rotate_left"
    ROTATE_LEFT_FILL = "cupertino_rotate_left_fill"
    ROTATE_RIGHT = "cupertino_rotate_right"
    ROTATE_RIGHT_FILL = "cupertino_rotate_right_fill"
    SCISSORS = "cupertino_scissors"
    SCISSORS_ALT = "cupertino_scissors_alt"
    SCOPE = "cupertino_scope"
    SCRIBBLE = "cupertino_scribble"
    SEARCH_CIRCLE = "cupertino_search_circle"
    SEARCH_CIRCLE_FILL = "cupertino_search_circle_fill"
    SELECTION_PIN_IN_OUT = "cupertino_selection_pin_in_out"
    SHIELD = "cupertino_shield"
    SHIELD_FILL = "cupertino_shield_fill"
    SHIELD_LEFTHALF_FILL = "cupertino_shield_lefthalf_fill"
    SHIELD_SLASH = "cupertino_shield_slash"
    SHIELD_SLASH_FILL = "cupertino_shield_slash_fill"
    SHIFT = "cupertino_shift"
    SHIFT_FILL = "cupertino_shift_fill"
    SIDEBAR_LEFT = "cupertino_sidebar_left"
    SIDEBAR_RIGHT = "cupertino_sidebar_right"
    SIGNATURE = "cupertino_signature"
    SKEW = "cupertino_skew"
    SLASH_CIRCLE = "cupertino_slash_circle"
    SLASH_CIRCLE_FILL = "cupertino_slash_circle_fill"
    SLIDER_HORIZONTAL_3 = "cupertino_slider_horizontal_3"
    SLIDER_HORIZONTAL_BELOW_RECTANGLE = "cupertino_slider_horizontal_below_rectangle"
    SLOWMO = "cupertino_slowmo"
    SMALLCIRCLE_CIRCLE = "cupertino_smallcircle_circle"
    SMALLCIRCLE_CIRCLE_FILL = "cupertino_smallcircle_circle_fill"
    SMALLCIRCLE_FILL_CIRCLE = "cupertino_smallcircle_fill_circle"
    SMALLCIRCLE_FILL_CIRCLE_FILL = "cupertino_smallcircle_fill_circle_fill"
    SMILEY = "cupertino_smiley"
    SMILEY_FILL = "cupertino_smiley_fill"
    SMOKE = "cupertino_smoke"
    SMOKE_FILL = "cupertino_smoke_fill"
    SNOW = "cupertino_snow"
    SORT_DOWN = "cupertino_sort_down"
    SORT_DOWN_CIRCLE = "cupertino_sort_down_circle"
    SORT_DOWN_CIRCLE_FILL = "cupertino_sort_down_circle_fill"
    SORT_UP = "cupertino_sort_up"
    SORT_UP_CIRCLE = "cupertino_sort_up_circle"
    SORT_UP_CIRCLE_FILL = "cupertino_sort_up_circle_fill"
    SPARKLES = "cupertino_sparkles"
    SPEAKER = "cupertino_speaker"
    SPEAKER_1 = "cupertino_speaker_1"
    SPEAKER_1_FILL = "cupertino_speaker_1_fill"
    SPEAKER_2 = "cupertino_speaker_2"
    SPEAKER_2_FILL = "cupertino_speaker_2_fill"
    SPEAKER_3 = "cupertino_speaker_3"
    SPEAKER_3_FILL = "cupertino_speaker_3_fill"
    SPEAKER_FILL = "cupertino_speaker_fill"
    SPEAKER_SLASH = "cupertino_speaker_slash"
    SPEAKER_SLASH_FILL = "cupertino_speaker_slash_fill"
    SPEAKER_SLASH_FILL_RTL = "cupertino_speaker_slash_fill_rtl"
    SPEAKER_SLASH_RTL = "cupertino_speaker_slash_rtl"
    SPEAKER_ZZZ = "cupertino_speaker_zzz"
    SPEAKER_ZZZ_FILL = "cupertino_speaker_zzz_fill"
    SPEAKER_ZZZ_FILL_RTL = "cupertino_speaker_zzz_fill_rtl"
    SPEAKER_ZZZ_RTL = "cupertino_speaker_zzz_rtl"
    SPEEDOMETER = "cupertino_speedometer"
    SPORTSCOURT = "cupertino_sportscourt"
    SPORTSCOURT_FILL = "cupertino_sportscourt_fill"
    SQUARE = "cupertino_square"
    SQUARE_ARROW_DOWN = "cupertino_square_arrow_down"
    SQUARE_ARROW_DOWN_FILL = "cupertino_square_arrow_down_fill"
    SQUARE_ARROW_DOWN_ON_SQUARE = "cupertino_square_arrow_down_on_square"
    SQUARE_ARROW_DOWN_ON_SQUARE_FILL = "cupertino_square_arrow_down_on_square_fill"
    SQUARE_ARROW_LEFT = "cupertino_square_arrow_left"
    SQUARE_ARROW_LEFT_FILL = "cupertino_square_arrow_left_fill"
    SQUARE_ARROW_RIGHT = "cupertino_square_arrow_right"
    SQUARE_ARROW_RIGHT_FILL = "cupertino_square_arrow_right_fill"
    SQUARE_ARROW_UP = "cupertino_square_arrow_up"
    SQUARE_ARROW_UP_FILL = "cupertino_square_arrow_up_fill"
    SQUARE_ARROW_UP_ON_SQUARE = "cupertino_square_arrow_up_on_square"
    SQUARE_ARROW_UP_ON_SQUARE_FILL = "cupertino_square_arrow_up_on_square_fill"
    SQUARE_FAVORITES = "cupertino_square_favorites"
    SQUARE_FAVORITES_ALT = "cupertino_square_favorites_alt"
    SQUARE_FAVORITES_ALT_FILL = "cupertino_square_favorites_alt_fill"
    SQUARE_FAVORITES_FILL = "cupertino_square_favorites_fill"
    SQUARE_FILL = "cupertino_square_fill"
    SQUARE_FILL_LINE_VERTICAL_SQUARE = "cupertino_square_fill_line_vertical_square"
    SQUARE_FILL_LINE_VERTICAL_SQUARE_FILL = (
        "cupertino_square_fill_line_vertical_square_fill"
    )
    SQUARE_FILL_ON_CIRCLE_FILL = "cupertino_square_fill_on_circle_fill"
    SQUARE_FILL_ON_SQUARE_FILL = "cupertino_square_fill_on_square_fill"
    SQUARE_GRID_2X2 = "cupertino_square_grid_2x2"
    SQUARE_GRID_2X2_FILL = "cupertino_square_grid_2x2_fill"
    SQUARE_GRID_3X2 = "cupertino_square_grid_3x2"
    SQUARE_GRID_3X2_FILL = "cupertino_square_grid_3x2_fill"
    SQUARE_GRID_4X3_FILL = "cupertino_square_grid_4x3_fill"
    SQUARE_LEFTHALF_FILL = "cupertino_square_lefthalf_fill"
    SQUARE_LINE_VERTICAL_SQUARE = "cupertino_square_line_vertical_square"
    SQUARE_LINE_VERTICAL_SQUARE_FILL = "cupertino_square_line_vertical_square_fill"
    SQUARE_LIST = "cupertino_square_list"
    SQUARE_LIST_FILL = "cupertino_square_list_fill"
    SQUARE_ON_CIRCLE = "cupertino_square_on_circle"
    SQUARE_ON_SQUARE = "cupertino_square_on_square"
    SQUARE_PENCIL = "cupertino_square_pencil"
    SQUARE_PENCIL_FILL = "cupertino_square_pencil_fill"
    SQUARE_RIGHTHALF_FILL = "cupertino_square_righthalf_fill"
    SQUARE_SPLIT_1X2 = "cupertino_square_split_1x2"
    SQUARE_SPLIT_1X2_FILL = "cupertino_square_split_1x2_fill"
    SQUARE_SPLIT_2X1 = "cupertino_square_split_2x1"
    SQUARE_SPLIT_2X1_FILL = "cupertino_square_split_2x1_fill"
    SQUARE_SPLIT_2X2 = "cupertino_square_split_2x2"
    SQUARE_SPLIT_2X2_FILL = "cupertino_square_split_2x2_fill"
    SQUARE_STACK = "cupertino_square_stack"
    SQUARE_STACK_3D_DOWN_DOTTEDLINE = "cupertino_square_stack_3d_down_dottedline"
    SQUARE_STACK_3D_DOWN_RIGHT = "cupertino_square_stack_3d_down_right"
    SQUARE_STACK_3D_DOWN_RIGHT_FILL = "cupertino_square_stack_3d_down_right_fill"
    SQUARE_STACK_3D_UP = "cupertino_square_stack_3d_up"
    SQUARE_STACK_3D_UP_FILL = "cupertino_square_stack_3d_up_fill"
    SQUARE_STACK_3D_UP_SLASH = "cupertino_square_stack_3d_up_slash"
    SQUARE_STACK_3D_UP_SLASH_FILL = "cupertino_square_stack_3d_up_slash_fill"
    SQUARE_STACK_FILL = "cupertino_square_stack_fill"
    SQUARES_BELOW_RECTANGLE = "cupertino_squares_below_rectangle"
    STAR = "cupertino_star"
    STAR_CIRCLE = "cupertino_star_circle"
    STAR_CIRCLE_FILL = "cupertino_star_circle_fill"
    STAR_FILL = "cupertino_star_fill"
    STAR_LEFTHALF_FILL = "cupertino_star_lefthalf_fill"
    STAR_SLASH = "cupertino_star_slash"
    STAR_SLASH_FILL = "cupertino_star_slash_fill"
    STAROFLIFE = "cupertino_staroflife"
    STAROFLIFE_FILL = "cupertino_staroflife_fill"
    STOP = "cupertino_stop"
    STOP_CIRCLE = "cupertino_stop_circle"
    STOP_CIRCLE_FILL = "cupertino_stop_circle_fill"
    STOP_FILL = "cupertino_stop_fill"
    STOPWATCH = "cupertino_stopwatch"
    STOPWATCH_FILL = "cupertino_stopwatch_fill"
    STRIKETHROUGH = "cupertino_strikethrough"
    SUIT_CLUB = "cupertino_suit_club"
    SUIT_CLUB_FILL = "cupertino_suit_club_fill"
    SUIT_DIAMOND = "cupertino_suit_diamond"
    SUIT_DIAMOND_FILL = "cupertino_suit_diamond_fill"
    SUIT_HEART = "cupertino_suit_heart"
    SUIT_HEART_FILL = "cupertino_suit_heart_fill"
    SUIT_SPADE = "cupertino_suit_spade"
    SUIT_SPADE_FILL = "cupertino_suit_spade_fill"
    SUM = "cupertino_sum"
    SUN_DUST = "cupertino_sun_dust"
    SUN_DUST_FILL = "cupertino_sun_dust_fill"
    SUN_HAZE = "cupertino_sun_haze"
    SUN_HAZE_FILL = "cupertino_sun_haze_fill"
    SUN_MAX = "cupertino_sun_max"
    SUN_MAX_FILL = "cupertino_sun_max_fill"
    SUN_MIN = "cupertino_sun_min"
    SUN_MIN_FILL = "cupertino_sun_min_fill"
    SUNRISE = "cupertino_sunrise"
    SUNRISE_FILL = "cupertino_sunrise_fill"
    SUNSET = "cupertino_sunset"
    SUNSET_FILL = "cupertino_sunset_fill"
    T_BUBBLE = "cupertino_t_bubble"
    T_BUBBLE_FILL = "cupertino_t_bubble_fill"
    TABLE = "cupertino_table"
    TABLE_BADGE_MORE = "cupertino_table_badge_more"
    TABLE_BADGE_MORE_FILL = "cupertino_table_badge_more_fill"
    TABLE_FILL = "cupertino_table_fill"
    TAG_CIRCLE = "cupertino_tag_circle"
    TAG_CIRCLE_FILL = "cupertino_tag_circle_fill"
    TAG_FILL = "cupertino_tag_fill"
    TEXT_ALIGNCENTER = "cupertino_text_aligncenter"
    TEXT_ALIGNLEFT = "cupertino_text_alignleft"
    TEXT_ALIGNRIGHT = "cupertino_text_alignright"
    TEXT_APPEND = "cupertino_text_append"
    TEXT_BADGE_CHECKMARK = "cupertino_text_badge_checkmark"
    TEXT_BADGE_MINUS = "cupertino_text_badge_minus"
    TEXT_BADGE_PLUS = "cupertino_text_badge_plus"
    TEXT_BADGE_STAR = "cupertino_text_badge_star"
    TEXT_BADGE_XMARK = "cupertino_text_badge_xmark"
    TEXT_BUBBLE = "cupertino_text_bubble"
    TEXT_BUBBLE_FILL = "cupertino_text_bubble_fill"
    TEXT_CURSOR = "cupertino_text_cursor"
    TEXT_INSERT = "cupertino_text_insert"
    TEXT_JUSTIFY = "cupertino_text_justify"
    TEXT_JUSTIFYLEFT = "cupertino_text_justifyleft"
    TEXT_JUSTIFYRIGHT = "cupertino_text_justifyright"
    TEXT_QUOTE = "cupertino_text_quote"
    TEXTBOX = "cupertino_textbox"
    TEXTFORMAT = "cupertino_textformat"
    TEXTFORMAT_123 = "cupertino_textformat_123"
    TEXTFORMAT_ABC = "cupertino_textformat_abc"
    TEXTFORMAT_ABC_DOTTEDUNDERLINE = "cupertino_textformat_abc_dottedunderline"
    TEXTFORMAT_ALT = "cupertino_textformat_alt"
    TEXTFORMAT_SIZE = "cupertino_textformat_size"
    TEXTFORMAT_SUBSCRIPT = "cupertino_textformat_subscript"
    TEXTFORMAT_SUPERSCRIPT = "cupertino_textformat_superscript"
    THERMOMETER = "cupertino_thermometer"
    THERMOMETER_SNOWFLAKE = "cupertino_thermometer_snowflake"
    THERMOMETER_SUN = "cupertino_thermometer_sun"
    TICKET = "cupertino_ticket"
    TICKET_FILL = "cupertino_ticket_fill"
    TICKETS = "cupertino_tickets"
    TICKETS_FILL = "cupertino_tickets_fill"
    TIMELAPSE = "cupertino_timelapse"
    TIMER = "cupertino_timer"
    TIMER_FILL = "cupertino_timer_fill"
    TODAY = "cupertino_today"
    TODAY_FILL = "cupertino_today_fill"
    TORNADO = "cupertino_tornado"
    TORTOISE = "cupertino_tortoise"
    TORTOISE_FILL = "cupertino_tortoise_fill"
    TRAM_FILL = "cupertino_tram_fill"
    TRASH = "cupertino_trash"
    TRASH_CIRCLE = "cupertino_trash_circle"
    TRASH_CIRCLE_FILL = "cupertino_trash_circle_fill"
    TRASH_FILL = "cupertino_trash_fill"
    TRASH_SLASH = "cupertino_trash_slash"
    TRASH_SLASH_FILL = "cupertino_trash_slash_fill"
    TRAY = "cupertino_tray"
    TRAY_2 = "cupertino_tray_2"
    TRAY_2_FILL = "cupertino_tray_2_fill"
    TRAY_ARROW_DOWN = "cupertino_tray_arrow_down"
    TRAY_ARROW_DOWN_FILL = "cupertino_tray_arrow_down_fill"
    TRAY_ARROW_UP = "cupertino_tray_arrow_up"
    TRAY_ARROW_UP_FILL = "cupertino_tray_arrow_up_fill"
    TRAY_FILL = "cupertino_tray_fill"
    TRAY_FULL = "cupertino_tray_full"
    TRAY_FULL_FILL = "cupertino_tray_full_fill"
    TREE = "cupertino_tree"
    TRIANGLE = "cupertino_triangle"
    TRIANGLE_FILL = "cupertino_triangle_fill"
    TRIANGLE_LEFTHALF_FILL = "cupertino_triangle_lefthalf_fill"
    TRIANGLE_RIGHTHALF_FILL = "cupertino_triangle_righthalf_fill"
    TROPICALSTORM = "cupertino_tropicalstorm"
    TUNINGFORK = "cupertino_tuningfork"
    TV = "cupertino_tv"
    TV_CIRCLE = "cupertino_tv_circle"
    TV_CIRCLE_FILL = "cupertino_tv_circle_fill"
    TV_FILL = "cupertino_tv_fill"
    TV_MUSIC_NOTE = "cupertino_tv_music_note"
    TV_MUSIC_NOTE_FILL = "cupertino_tv_music_note_fill"
    UIWINDOW_SPLIT_2X1 = "cupertino_uiwindow_split_2x1"
    UMBRELLA = "cupertino_umbrella"
    UMBRELLA_FILL = "cupertino_umbrella_fill"
    UNDERLINE = "cupertino_underline"
    UPLOAD_CIRCLE = "cupertino_upload_circle"
    UPLOAD_CIRCLE_FILL = "cupertino_upload_circle_fill"
    VIDEOCAM = "cupertino_videocam"
    VIDEOCAM_CIRCLE = "cupertino_videocam_circle"
    VIDEOCAM_CIRCLE_FILL = "cupertino_videocam_circle_fill"
    VIDEOCAM_FILL = "cupertino_videocam_fill"
    VIEW_2D = "cupertino_view_2d"
    VIEW_3D = "cupertino_view_3d"
    VIEWFINDER = "cupertino_viewfinder"
    VIEWFINDER_CIRCLE = "cupertino_viewfinder_circle"
    VIEWFINDER_CIRCLE_FILL = "cupertino_viewfinder_circle_fill"
    WAND_RAYS = "cupertino_wand_rays"
    WAND_RAYS_INVERSE = "cupertino_wand_rays_inverse"
    WAND_STARS = "cupertino_wand_stars"
    WAND_STARS_INVERSE = "cupertino_wand_stars_inverse"
    WAVEFORM = "cupertino_waveform"
    WAVEFORM_CIRCLE = "cupertino_waveform_circle"
    WAVEFORM_CIRCLE_FILL = "cupertino_waveform_circle_fill"
    WAVEFORM_PATH = "cupertino_waveform_path"
    WAVEFORM_PATH_BADGE_MINUS = "cupertino_waveform_path_badge_minus"
    WAVEFORM_PATH_BADGE_PLUS = "cupertino_waveform_path_badge_plus"
    WAVEFORM_PATH_ECG = "cupertino_waveform_path_ecg"
    WIFI = "cupertino_wifi"
    WIFI_EXCLAMATIONMARK = "cupertino_wifi_exclamationmark"
    WIFI_SLASH = "cupertino_wifi_slash"
    WIND = "cupertino_wind"
    WIND_SNOW = "cupertino_wind_snow"
    WRENCH = "cupertino_wrench"
    WRENCH_FILL = "cupertino_wrench_fill"
    XMARK = "cupertino_xmark"
    XMARK_CIRCLE = "cupertino_xmark_circle"
    XMARK_CIRCLE_FILL = "cupertino_xmark_circle_fill"
    XMARK_OCTAGON = "cupertino_xmark_octagon"
    XMARK_OCTAGON_FILL = "cupertino_xmark_octagon_fill"
    XMARK_RECTANGLE = "cupertino_xmark_rectangle"
    XMARK_RECTANGLE_FILL = "cupertino_xmark_rectangle_fill"
    XMARK_SEAL = "cupertino_xmark_seal"
    XMARK_SEAL_FILL = "cupertino_xmark_seal_fill"
    XMARK_SHIELD = "cupertino_xmark_shield"
    XMARK_SHIELD_FILL = "cupertino_xmark_shield_fill"
    XMARK_SQUARE = "cupertino_xmark_square"
    XMARK_SQUARE_FILL = "cupertino_xmark_square_fill"
    ZOOM_IN = "cupertino_zoom_in"
    ZOOM_OUT = "cupertino_zoom_out"
    ZZZ = "cupertino_zzz"


class CupertinoIcons(str, Enum):
    @staticmethod
    def random(
        exclude: Optional[List["CupertinoIcons"]] = None,
        weights: Optional[Dict["CupertinoIcons", int]] = None,
    ) -> Optional["CupertinoIcons"]:
        """
        Selects a random icon, with optional exclusions and weights.

        Args:
            exclude: A list of icons members to exclude from the selection.
            weights: A dictionary mapping icon members to their respective weights for weighted random selection.

        Returns:
            A randomly selected icon, or None if all members are excluded.
        """
        choices = list(CupertinoIcons)
        if exclude:
            choices = [member for member in choices if member not in exclude]
            if not choices:
                return None
        if weights:
            weights_list = [weights.get(c, 1) for c in choices]
            return random.choices(choices, weights=weights_list)[0]
        return random.choice(choices)

    LEFT_CHEVRON = "cupertino_left_chevron"
    RIGHT_CHEVRON = "cupertino_right_chevron"
    SHARE = "cupertino_share"
    SHARE_SOLID = "cupertino_share_solid"
    BOOK = "cupertino_book"
    BOOK_SOLID = "cupertino_book_solid"
    BOOKMARK = "cupertino_bookmark"
    BOOKMARK_SOLID = "cupertino_bookmark_solid"
    INFO = "cupertino_info"
    REPLY = "cupertino_reply"
    CONVERSATION_BUBBLE = "cupertino_conversation_bubble"
    PROFILE_CIRCLED = "cupertino_profile_circled"
    PLUS_CIRCLED = "cupertino_plus_circled"
    MINUS_CIRCLED = "cupertino_minus_circled"
    FLAG = "cupertino_flag"
    SEARCH = "cupertino_search"
    CHECK_MARK = "cupertino_check_mark"
    CHECK_MARK_CIRCLED = "cupertino_check_mark_circled"
    CHECK_MARK_CIRCLED_SOLID = "cupertino_check_mark_circled_solid"
    CIRCLE = "cupertino_circle"
    CIRCLE_FILLED = "cupertino_circle_filled"
    BACK = "cupertino_back"
    FORWARD = "cupertino_forward"
    HOME = "cupertino_home"
    SHOPPING_CART = "cupertino_shopping_cart"
    ELLIPSIS = "cupertino_ellipsis"
    PHONE = "cupertino_phone"
    PHONE_SOLID = "cupertino_phone_solid"
    DOWN_ARROW = "cupertino_down_arrow"
    UP_ARROW = "cupertino_up_arrow"
    BATTERY_CHARGING = "cupertino_battery_charging"
    BATTERY_EMPTY = "cupertino_battery_empty"
    BATTERY_FULL = "cupertino_battery_full"
    BATTERY_75_PERCENT = "cupertino_battery_75_percent"
    BATTERY_25_PERCENT = "cupertino_battery_25_percent"
    BLUETOOTH = "cupertino_bluetooth"
    RESTART = "cupertino_restart"
    REPLY_ALL = "cupertino_reply_all"
    REPLY_THICK_SOLID = "cupertino_reply_thick_solid"
    SHARE_UP = "cupertino_share_up"
    SHUFFLE = "cupertino_shuffle"
    SHUFFLE_MEDIUM = "cupertino_shuffle_medium"
    SHUFFLE_THICK = "cupertino_shuffle_thick"
    PHOTO_CAMERA = "cupertino_photo_camera"
    PHOTO_CAMERA_SOLID = "cupertino_photo_camera_solid"
    VIDEO_CAMERA = "cupertino_video_camera"
    VIDEO_CAMERA_SOLID = "cupertino_video_camera_solid"
    SWITCH_CAMERA = "cupertino_switch_camera"
    SWITCH_CAMERA_SOLID = "cupertino_switch_camera_solid"
    COLLECTIONS = "cupertino_collections"
    COLLECTIONS_SOLID = "cupertino_collections_solid"
    FOLDER = "cupertino_folder"
    FOLDER_SOLID = "cupertino_folder_solid"
    FOLDER_OPEN = "cupertino_folder_open"
    DELETE = "cupertino_delete"
    DELETE_SOLID = "cupertino_delete_solid"
    DELETE_SIMPLE = "cupertino_delete_simple"
    PEN = "cupertino_pen"
    PENCIL = "cupertino_pencil"
    CREATE = "cupertino_create"
    CREATE_SOLID = "cupertino_create_solid"
    REFRESH = "cupertino_refresh"
    REFRESH_CIRCLED = "cupertino_refresh_circled"
    REFRESH_CIRCLED_SOLID = "cupertino_refresh_circled_solid"
    REFRESH_THIN = "cupertino_refresh_thin"
    REFRESH_THICK = "cupertino_refresh_thick"
    REFRESH_BOLD = "cupertino_refresh_bold"
    CLEAR_THICK = "cupertino_clear_thick"
    CLEAR_THICK_CIRCLED = "cupertino_clear_thick_circled"
    CLEAR = "cupertino_clear"
    CLEAR_CIRCLED = "cupertino_clear_circled"
    CLEAR_CIRCLED_SOLID = "cupertino_clear_circled_solid"
    ADD = "cupertino_add"
    ADD_CIRCLED = "cupertino_add_circled"
    ADD_CIRCLED_SOLID = "cupertino_add_circled_solid"
    GEAR = "cupertino_gear"
    GEAR_SOLID = "cupertino_gear_solid"
    GEAR_BIG = "cupertino_gear_big"
    SETTINGS = "cupertino_settings"
    SETTINGS_SOLID = "cupertino_settings_solid"
    MUSIC_NOTE = "cupertino_music_note"
    DOUBLE_MUSIC_NOTE = "cupertino_double_music_note"
    PLAY_ARROW = "cupertino_play_arrow"
    PLAY_ARROW_SOLID = "cupertino_play_arrow_solid"
    PAUSE = "cupertino_pause"
    PAUSE_SOLID = "cupertino_pause_solid"
    LOOP = "cupertino_loop"
    LOOP_THICK = "cupertino_loop_thick"
    VOLUME_DOWN = "cupertino_volume_down"
    VOLUME_MUTE = "cupertino_volume_mute"
    VOLUME_OFF = "cupertino_volume_off"
    VOLUME_UP = "cupertino_volume_up"
    FULLSCREEN = "cupertino_fullscreen"
    FULLSCREEN_EXIT = "cupertino_fullscreen_exit"
    MIC_OFF = "cupertino_mic_off"
    MIC = "cupertino_mic"
    MIC_SOLID = "cupertino_mic_solid"
    CLOCK = "cupertino_clock"
    CLOCK_SOLID = "cupertino_clock_solid"
    TIME = "cupertino_time"
    TIME_SOLID = "cupertino_time_solid"
    PADLOCK = "cupertino_padlock"
    PADLOCK_SOLID = "cupertino_padlock_solid"
    EYE = "cupertino_eye"
    EYE_SOLID = "cupertino_eye_solid"
    PERSON = "cupertino_person"
    PERSON_SOLID = "cupertino_person_solid"
    PERSON_ADD = "cupertino_person_add"
    PERSON_ADD_SOLID = "cupertino_person_add_solid"
    GROUP = "cupertino_group"
    GROUP_SOLID = "cupertino_group_solid"
    MAIL = "cupertino_mail"
    MAIL_SOLID = "cupertino_mail_solid"
    LOCATION = "cupertino_location"
    LOCATION_SOLID = "cupertino_location_solid"
    TAG = "cupertino_tag"
    TAG_SOLID = "cupertino_tag_solid"
    TAGS = "cupertino_tags"
    TAGS_SOLID = "cupertino_tags_solid"
    BUS = "cupertino_bus"
    CAR = "cupertino_car"
    CAR_DETAILED = "cupertino_car_detailed"
    TRAIN_STYLE_ONE = "cupertino_train_style_one"
    TRAIN_STYLE_TWO = "cupertino_train_style_two"
    PAW = "cupertino_paw"
    PAW_SOLID = "cupertino_paw_solid"
    GAME_CONTROLLER = "cupertino_game_controller"
    GAME_CONTROLLER_SOLID = "cupertino_game_controller_solid"
    LAB_FLASK = "cupertino_lab_flask"
    LAB_FLASK_SOLID = "cupertino_lab_flask_solid"
    HEART = "cupertino_heart"
    HEART_SOLID = "cupertino_heart_solid"
    BELL = "cupertino_bell"
    BELL_SOLID = "cupertino_bell_solid"
    NEWS = "cupertino_news"
    NEWS_SOLID = "cupertino_news_solid"
    BRIGHTNESS = "cupertino_brightness"
    BRIGHTNESS_SOLID = "cupertino_brightness_solid"
    AIRPLANE = "cupertino_airplane"
    ALARM = "cupertino_alarm"
    ALARM_FILL = "cupertino_alarm_fill"
    ALT = "cupertino_alt"
    ANT = "cupertino_ant"
    ANT_CIRCLE = "cupertino_ant_circle"
    ANT_CIRCLE_FILL = "cupertino_ant_circle_fill"
    ANT_FILL = "cupertino_ant_fill"
    ANTENNA_RADIOWAVES_LEFT_RIGHT = "cupertino_antenna_radiowaves_left_right"
    APP = "cupertino_app"
    APP_BADGE = "cupertino_app_badge"
    APP_BADGE_FILL = "cupertino_app_badge_fill"
    APP_FILL = "cupertino_app_fill"
    ARCHIVEBOX = "cupertino_archivebox"
    ARCHIVEBOX_FILL = "cupertino_archivebox_fill"
    ARROW_2_CIRCLEPATH = "cupertino_arrow_2_circlepath"
    ARROW_2_CIRCLEPATH_CIRCLE = "cupertino_arrow_2_circlepath_circle"
    ARROW_2_CIRCLEPATH_CIRCLE_FILL = "cupertino_arrow_2_circlepath_circle_fill"
    ARROW_2_SQUAREPATH = "cupertino_arrow_2_squarepath"
    ARROW_3_TRIANGLEPATH = "cupertino_arrow_3_trianglepath"
    ARROW_BRANCH = "cupertino_arrow_branch"
    ARROW_CLOCKWISE = "cupertino_arrow_clockwise"
    ARROW_CLOCKWISE_CIRCLE = "cupertino_arrow_clockwise_circle"
    ARROW_CLOCKWISE_CIRCLE_FILL = "cupertino_arrow_clockwise_circle_fill"
    ARROW_COUNTERCLOCKWISE = "cupertino_arrow_counterclockwise"
    ARROW_COUNTERCLOCKWISE_CIRCLE = "cupertino_arrow_counterclockwise_circle"
    ARROW_COUNTERCLOCKWISE_CIRCLE_FILL = "cupertino_arrow_counterclockwise_circle_fill"
    ARROW_DOWN = "cupertino_arrow_down"
    ARROW_DOWN_CIRCLE = "cupertino_arrow_down_circle"
    ARROW_DOWN_CIRCLE_FILL = "cupertino_arrow_down_circle_fill"
    ARROW_DOWN_DOC = "cupertino_arrow_down_doc"
    ARROW_DOWN_DOC_FILL = "cupertino_arrow_down_doc_fill"
    ARROW_DOWN_LEFT = "cupertino_arrow_down_left"
    ARROW_DOWN_LEFT_CIRCLE = "cupertino_arrow_down_left_circle"
    ARROW_DOWN_LEFT_CIRCLE_FILL = "cupertino_arrow_down_left_circle_fill"
    ARROW_DOWN_LEFT_SQUARE = "cupertino_arrow_down_left_square"
    ARROW_DOWN_LEFT_SQUARE_FILL = "cupertino_arrow_down_left_square_fill"
    ARROW_DOWN_RIGHT = "cupertino_arrow_down_right"
    ARROW_DOWN_RIGHT_ARROW_UP_LEFT = "cupertino_arrow_down_right_arrow_up_left"
    ARROW_DOWN_RIGHT_CIRCLE = "cupertino_arrow_down_right_circle"
    ARROW_DOWN_RIGHT_CIRCLE_FILL = "cupertino_arrow_down_right_circle_fill"
    ARROW_DOWN_RIGHT_SQUARE = "cupertino_arrow_down_right_square"
    ARROW_DOWN_RIGHT_SQUARE_FILL = "cupertino_arrow_down_right_square_fill"
    ARROW_DOWN_SQUARE = "cupertino_arrow_down_square"
    ARROW_DOWN_SQUARE_FILL = "cupertino_arrow_down_square_fill"
    ARROW_DOWN_TO_LINE = "cupertino_arrow_down_to_line"
    ARROW_DOWN_TO_LINE_ALT = "cupertino_arrow_down_to_line_alt"
    ARROW_LEFT = "cupertino_arrow_left"
    ARROW_LEFT_CIRCLE = "cupertino_arrow_left_circle"
    ARROW_LEFT_CIRCLE_FILL = "cupertino_arrow_left_circle_fill"
    ARROW_LEFT_RIGHT = "cupertino_arrow_left_right"
    ARROW_LEFT_RIGHT_CIRCLE = "cupertino_arrow_left_right_circle"
    ARROW_LEFT_RIGHT_CIRCLE_FILL = "cupertino_arrow_left_right_circle_fill"
    ARROW_LEFT_RIGHT_SQUARE = "cupertino_arrow_left_right_square"
    ARROW_LEFT_RIGHT_SQUARE_FILL = "cupertino_arrow_left_right_square_fill"
    ARROW_LEFT_SQUARE = "cupertino_arrow_left_square"
    ARROW_LEFT_SQUARE_FILL = "cupertino_arrow_left_square_fill"
    ARROW_LEFT_TO_LINE = "cupertino_arrow_left_to_line"
    ARROW_LEFT_TO_LINE_ALT = "cupertino_arrow_left_to_line_alt"
    ARROW_MERGE = "cupertino_arrow_merge"
    ARROW_RIGHT = "cupertino_arrow_right"
    ARROW_RIGHT_ARROW_LEFT = "cupertino_arrow_right_arrow_left"
    ARROW_RIGHT_ARROW_LEFT_CIRCLE = "cupertino_arrow_right_arrow_left_circle"
    ARROW_RIGHT_ARROW_LEFT_CIRCLE_FILL = "cupertino_arrow_right_arrow_left_circle_fill"
    ARROW_RIGHT_ARROW_LEFT_SQUARE = "cupertino_arrow_right_arrow_left_square"
    ARROW_RIGHT_ARROW_LEFT_SQUARE_FILL = "cupertino_arrow_right_arrow_left_square_fill"
    ARROW_RIGHT_CIRCLE = "cupertino_arrow_right_circle"
    ARROW_RIGHT_CIRCLE_FILL = "cupertino_arrow_right_circle_fill"
    ARROW_RIGHT_SQUARE = "cupertino_arrow_right_square"
    ARROW_RIGHT_SQUARE_FILL = "cupertino_arrow_right_square_fill"
    ARROW_RIGHT_TO_LINE = "cupertino_arrow_right_to_line"
    ARROW_RIGHT_TO_LINE_ALT = "cupertino_arrow_right_to_line_alt"
    ARROW_SWAP = "cupertino_arrow_swap"
    ARROW_TURN_DOWN_LEFT = "cupertino_arrow_turn_down_left"
    ARROW_TURN_DOWN_RIGHT = "cupertino_arrow_turn_down_right"
    ARROW_TURN_LEFT_DOWN = "cupertino_arrow_turn_left_down"
    ARROW_TURN_LEFT_UP = "cupertino_arrow_turn_left_up"
    ARROW_TURN_RIGHT_DOWN = "cupertino_arrow_turn_right_down"
    ARROW_TURN_RIGHT_UP = "cupertino_arrow_turn_right_up"
    ARROW_TURN_UP_LEFT = "cupertino_arrow_turn_up_left"
    ARROW_TURN_UP_RIGHT = "cupertino_arrow_turn_up_right"
    ARROW_UP = "cupertino_arrow_up"
    ARROW_UP_ARROW_DOWN = "cupertino_arrow_up_arrow_down"
    ARROW_UP_ARROW_DOWN_CIRCLE = "cupertino_arrow_up_arrow_down_circle"
    ARROW_UP_ARROW_DOWN_CIRCLE_FILL = "cupertino_arrow_up_arrow_down_circle_fill"
    ARROW_UP_ARROW_DOWN_SQUARE = "cupertino_arrow_up_arrow_down_square"
    ARROW_UP_ARROW_DOWN_SQUARE_FILL = "cupertino_arrow_up_arrow_down_square_fill"
    ARROW_UP_BIN = "cupertino_arrow_up_bin"
    ARROW_UP_BIN_FILL = "cupertino_arrow_up_bin_fill"
    ARROW_UP_CIRCLE = "cupertino_arrow_up_circle"
    ARROW_UP_CIRCLE_FILL = "cupertino_arrow_up_circle_fill"
    ARROW_UP_DOC = "cupertino_arrow_up_doc"
    ARROW_UP_DOC_FILL = "cupertino_arrow_up_doc_fill"
    ARROW_UP_DOWN = "cupertino_arrow_up_down"
    ARROW_UP_DOWN_CIRCLE = "cupertino_arrow_up_down_circle"
    ARROW_UP_DOWN_CIRCLE_FILL = "cupertino_arrow_up_down_circle_fill"
    ARROW_UP_DOWN_SQUARE = "cupertino_arrow_up_down_square"
    ARROW_UP_DOWN_SQUARE_FILL = "cupertino_arrow_up_down_square_fill"
    ARROW_UP_LEFT = "cupertino_arrow_up_left"
    ARROW_UP_LEFT_ARROW_DOWN_RIGHT = "cupertino_arrow_up_left_arrow_down_right"
    ARROW_UP_LEFT_CIRCLE = "cupertino_arrow_up_left_circle"
    ARROW_UP_LEFT_CIRCLE_FILL = "cupertino_arrow_up_left_circle_fill"
    ARROW_UP_LEFT_SQUARE = "cupertino_arrow_up_left_square"
    ARROW_UP_LEFT_SQUARE_FILL = "cupertino_arrow_up_left_square_fill"
    ARROW_UP_RIGHT = "cupertino_arrow_up_right"
    ARROW_UP_RIGHT_CIRCLE = "cupertino_arrow_up_right_circle"
    ARROW_UP_RIGHT_CIRCLE_FILL = "cupertino_arrow_up_right_circle_fill"
    ARROW_UP_RIGHT_DIAMOND = "cupertino_arrow_up_right_diamond"
    ARROW_UP_RIGHT_DIAMOND_FILL = "cupertino_arrow_up_right_diamond_fill"
    ARROW_UP_RIGHT_SQUARE = "cupertino_arrow_up_right_square"
    ARROW_UP_RIGHT_SQUARE_FILL = "cupertino_arrow_up_right_square_fill"
    ARROW_UP_SQUARE = "cupertino_arrow_up_square"
    ARROW_UP_SQUARE_FILL = "cupertino_arrow_up_square_fill"
    ARROW_UP_TO_LINE = "cupertino_arrow_up_to_line"
    ARROW_UP_TO_LINE_ALT = "cupertino_arrow_up_to_line_alt"
    ARROW_UTURN_DOWN = "cupertino_arrow_uturn_down"
    ARROW_UTURN_DOWN_CIRCLE = "cupertino_arrow_uturn_down_circle"
    ARROW_UTURN_DOWN_CIRCLE_FILL = "cupertino_arrow_uturn_down_circle_fill"
    ARROW_UTURN_DOWN_SQUARE = "cupertino_arrow_uturn_down_square"
    ARROW_UTURN_DOWN_SQUARE_FILL = "cupertino_arrow_uturn_down_square_fill"
    ARROW_UTURN_LEFT = "cupertino_arrow_uturn_left"
    ARROW_UTURN_LEFT_CIRCLE = "cupertino_arrow_uturn_left_circle"
    ARROW_UTURN_LEFT_CIRCLE_FILL = "cupertino_arrow_uturn_left_circle_fill"
    ARROW_UTURN_LEFT_SQUARE = "cupertino_arrow_uturn_left_square"
    ARROW_UTURN_LEFT_SQUARE_FILL = "cupertino_arrow_uturn_left_square_fill"
    ARROW_UTURN_RIGHT = "cupertino_arrow_uturn_right"
    ARROW_UTURN_RIGHT_CIRCLE = "cupertino_arrow_uturn_right_circle"
    ARROW_UTURN_RIGHT_CIRCLE_FILL = "cupertino_arrow_uturn_right_circle_fill"
    ARROW_UTURN_RIGHT_SQUARE = "cupertino_arrow_uturn_right_square"
    ARROW_UTURN_RIGHT_SQUARE_FILL = "cupertino_arrow_uturn_right_square_fill"
    ARROW_UTURN_UP = "cupertino_arrow_uturn_up"
    ARROW_UTURN_UP_CIRCLE = "cupertino_arrow_uturn_up_circle"
    ARROW_UTURN_UP_CIRCLE_FILL = "cupertino_arrow_uturn_up_circle_fill"
    ARROW_UTURN_UP_SQUARE = "cupertino_arrow_uturn_up_square"
    ARROW_UTURN_UP_SQUARE_FILL = "cupertino_arrow_uturn_up_square_fill"
    ARROWSHAPE_TURN_UP_LEFT = "cupertino_arrowshape_turn_up_left"
    ARROWSHAPE_TURN_UP_LEFT_2 = "cupertino_arrowshape_turn_up_left_2"
    ARROWSHAPE_TURN_UP_LEFT_2_FILL = "cupertino_arrowshape_turn_up_left_2_fill"
    ARROWSHAPE_TURN_UP_LEFT_CIRCLE = "cupertino_arrowshape_turn_up_left_circle"
    ARROWSHAPE_TURN_UP_LEFT_CIRCLE_FILL = (
        "cupertino_arrowshape_turn_up_left_circle_fill"
    )
    ARROWSHAPE_TURN_UP_LEFT_FILL = "cupertino_arrowshape_turn_up_left_fill"
    ARROWSHAPE_TURN_UP_RIGHT = "cupertino_arrowshape_turn_up_right"
    ARROWSHAPE_TURN_UP_RIGHT_CIRCLE = "cupertino_arrowshape_turn_up_right_circle"
    ARROWSHAPE_TURN_UP_RIGHT_CIRCLE_FILL = (
        "cupertino_arrowshape_turn_up_right_circle_fill"
    )
    ARROWSHAPE_TURN_UP_RIGHT_FILL = "cupertino_arrowshape_turn_up_right_fill"
    ARROWTRIANGLE_DOWN = "cupertino_arrowtriangle_down"
    ARROWTRIANGLE_DOWN_CIRCLE = "cupertino_arrowtriangle_down_circle"
    ARROWTRIANGLE_DOWN_CIRCLE_FILL = "cupertino_arrowtriangle_down_circle_fill"
    ARROWTRIANGLE_DOWN_FILL = "cupertino_arrowtriangle_down_fill"
    ARROWTRIANGLE_DOWN_SQUARE = "cupertino_arrowtriangle_down_square"
    ARROWTRIANGLE_DOWN_SQUARE_FILL = "cupertino_arrowtriangle_down_square_fill"
    ARROWTRIANGLE_LEFT = "cupertino_arrowtriangle_left"
    ARROWTRIANGLE_LEFT_CIRCLE = "cupertino_arrowtriangle_left_circle"
    ARROWTRIANGLE_LEFT_CIRCLE_FILL = "cupertino_arrowtriangle_left_circle_fill"
    ARROWTRIANGLE_LEFT_FILL = "cupertino_arrowtriangle_left_fill"
    ARROWTRIANGLE_LEFT_SQUARE = "cupertino_arrowtriangle_left_square"
    ARROWTRIANGLE_LEFT_SQUARE_FILL = "cupertino_arrowtriangle_left_square_fill"
    ARROWTRIANGLE_RIGHT = "cupertino_arrowtriangle_right"
    ARROWTRIANGLE_RIGHT_CIRCLE = "cupertino_arrowtriangle_right_circle"
    ARROWTRIANGLE_RIGHT_CIRCLE_FILL = "cupertino_arrowtriangle_right_circle_fill"
    ARROWTRIANGLE_RIGHT_FILL = "cupertino_arrowtriangle_right_fill"
    ARROWTRIANGLE_RIGHT_SQUARE = "cupertino_arrowtriangle_right_square"
    ARROWTRIANGLE_RIGHT_SQUARE_FILL = "cupertino_arrowtriangle_right_square_fill"
    ARROWTRIANGLE_UP = "cupertino_arrowtriangle_up"
    ARROWTRIANGLE_UP_CIRCLE = "cupertino_arrowtriangle_up_circle"
    ARROWTRIANGLE_UP_CIRCLE_FILL = "cupertino_arrowtriangle_up_circle_fill"
    ARROWTRIANGLE_UP_FILL = "cupertino_arrowtriangle_up_fill"
    ARROWTRIANGLE_UP_SQUARE = "cupertino_arrowtriangle_up_square"
    ARROWTRIANGLE_UP_SQUARE_FILL = "cupertino_arrowtriangle_up_square_fill"
    ASTERISK_CIRCLE = "cupertino_asterisk_circle"
    ASTERISK_CIRCLE_FILL = "cupertino_asterisk_circle_fill"
    AT = "cupertino_at"
    AT_BADGE_MINUS = "cupertino_at_badge_minus"
    AT_BADGE_PLUS = "cupertino_at_badge_plus"
    AT_CIRCLE = "cupertino_at_circle"
    AT_CIRCLE_FILL = "cupertino_at_circle_fill"
    BACKWARD = "cupertino_backward"
    BACKWARD_END = "cupertino_backward_end"
    BACKWARD_END_ALT = "cupertino_backward_end_alt"
    BACKWARD_END_ALT_FILL = "cupertino_backward_end_alt_fill"
    BACKWARD_END_FILL = "cupertino_backward_end_fill"
    BACKWARD_FILL = "cupertino_backward_fill"
    BADGE_PLUS_RADIOWAVES_RIGHT = "cupertino_badge_plus_radiowaves_right"
    BAG = "cupertino_bag"
    BAG_BADGE_MINUS = "cupertino_bag_badge_minus"
    BAG_BADGE_PLUS = "cupertino_bag_badge_plus"
    BAG_FILL = "cupertino_bag_fill"
    BAG_FILL_BADGE_MINUS = "cupertino_bag_fill_badge_minus"
    BAG_FILL_BADGE_PLUS = "cupertino_bag_fill_badge_plus"
    BANDAGE = "cupertino_bandage"
    BANDAGE_FILL = "cupertino_bandage_fill"
    BARCODE = "cupertino_barcode"
    BARCODE_VIEWFINDER = "cupertino_barcode_viewfinder"
    BARS = "cupertino_bars"
    BATTERY_0 = "cupertino_battery_0"
    BATTERY_100 = "cupertino_battery_100"
    BATTERY_25 = "cupertino_battery_25"
    BED_DOUBLE = "cupertino_bed_double"
    BED_DOUBLE_FILL = "cupertino_bed_double_fill"
    BELL_CIRCLE = "cupertino_bell_circle"
    BELL_CIRCLE_FILL = "cupertino_bell_circle_fill"
    BELL_FILL = "cupertino_bell_fill"
    BELL_SLASH = "cupertino_bell_slash"
    BELL_SLASH_FILL = "cupertino_bell_slash_fill"
    BIN_XMARK = "cupertino_bin_xmark"
    BIN_XMARK_FILL = "cupertino_bin_xmark_fill"
    BITCOIN = "cupertino_bitcoin"
    BITCOIN_CIRCLE = "cupertino_bitcoin_circle"
    BITCOIN_CIRCLE_FILL = "cupertino_bitcoin_circle_fill"
    BOLD = "cupertino_bold"
    BOLD_ITALIC_UNDERLINE = "cupertino_bold_italic_underline"
    BOLD_UNDERLINE = "cupertino_bold_underline"
    BOLT = "cupertino_bolt"
    BOLT_BADGE_A = "cupertino_bolt_badge_a"
    BOLT_BADGE_A_FILL = "cupertino_bolt_badge_a_fill"
    BOLT_CIRCLE = "cupertino_bolt_circle"
    BOLT_CIRCLE_FILL = "cupertino_bolt_circle_fill"
    BOLT_FILL = "cupertino_bolt_fill"
    BOLT_HORIZONTAL = "cupertino_bolt_horizontal"
    BOLT_HORIZONTAL_CIRCLE = "cupertino_bolt_horizontal_circle"
    BOLT_HORIZONTAL_CIRCLE_FILL = "cupertino_bolt_horizontal_circle_fill"
    BOLT_HORIZONTAL_FILL = "cupertino_bolt_horizontal_fill"
    BOLT_SLASH = "cupertino_bolt_slash"
    BOLT_SLASH_FILL = "cupertino_bolt_slash_fill"
    BOOK_CIRCLE = "cupertino_book_circle"
    BOOK_CIRCLE_FILL = "cupertino_book_circle_fill"
    BOOK_FILL = "cupertino_book_fill"
    BOOKMARK_FILL = "cupertino_bookmark_fill"
    BRIEFCASE = "cupertino_briefcase"
    BRIEFCASE_FILL = "cupertino_briefcase_fill"
    BUBBLE_LEFT = "cupertino_bubble_left"
    BUBBLE_LEFT_BUBBLE_RIGHT = "cupertino_bubble_left_bubble_right"
    BUBBLE_LEFT_BUBBLE_RIGHT_FILL = "cupertino_bubble_left_bubble_right_fill"
    BUBBLE_LEFT_FILL = "cupertino_bubble_left_fill"
    BUBBLE_MIDDLE_BOTTOM = "cupertino_bubble_middle_bottom"
    BUBBLE_MIDDLE_BOTTOM_FILL = "cupertino_bubble_middle_bottom_fill"
    BUBBLE_MIDDLE_TOP = "cupertino_bubble_middle_top"
    BUBBLE_MIDDLE_TOP_FILL = "cupertino_bubble_middle_top_fill"
    BUBBLE_RIGHT = "cupertino_bubble_right"
    BUBBLE_RIGHT_FILL = "cupertino_bubble_right_fill"
    BUILDING_2_FILL = "cupertino_building_2_fill"
    BURN = "cupertino_burn"
    BURST = "cupertino_burst"
    BURST_FILL = "cupertino_burst_fill"
    CALENDAR = "cupertino_calendar"
    CALENDAR_BADGE_MINUS = "cupertino_calendar_badge_minus"
    CALENDAR_BADGE_PLUS = "cupertino_calendar_badge_plus"
    CALENDAR_CIRCLE = "cupertino_calendar_circle"
    CALENDAR_CIRCLE_FILL = "cupertino_calendar_circle_fill"
    CALENDAR_TODAY = "cupertino_calendar_today"
    CAMERA = "cupertino_camera"
    CAMERA_CIRCLE = "cupertino_camera_circle"
    CAMERA_CIRCLE_FILL = "cupertino_camera_circle_fill"
    CAMERA_FILL = "cupertino_camera_fill"
    CAMERA_ON_RECTANGLE = "cupertino_camera_on_rectangle"
    CAMERA_ON_RECTANGLE_FILL = "cupertino_camera_on_rectangle_fill"
    CAMERA_ROTATE = "cupertino_camera_rotate"
    CAMERA_ROTATE_FILL = "cupertino_camera_rotate_fill"
    CAMERA_VIEWFINDER = "cupertino_camera_viewfinder"
    CAPSLOCK = "cupertino_capslock"
    CAPSLOCK_FILL = "cupertino_capslock_fill"
    CAPSULE = "cupertino_capsule"
    CAPSULE_FILL = "cupertino_capsule_fill"
    CAPTIONS_BUBBLE = "cupertino_captions_bubble"
    CAPTIONS_BUBBLE_FILL = "cupertino_captions_bubble_fill"
    CAR_FILL = "cupertino_car_fill"
    CART = "cupertino_cart"
    CART_BADGE_MINUS = "cupertino_cart_badge_minus"
    CART_BADGE_PLUS = "cupertino_cart_badge_plus"
    CART_FILL = "cupertino_cart_fill"
    CART_FILL_BADGE_MINUS = "cupertino_cart_fill_badge_minus"
    CART_FILL_BADGE_PLUS = "cupertino_cart_fill_badge_plus"
    CHART_BAR = "cupertino_chart_bar"
    CHART_BAR_ALT_FILL = "cupertino_chart_bar_alt_fill"
    CHART_BAR_CIRCLE = "cupertino_chart_bar_circle"
    CHART_BAR_CIRCLE_FILL = "cupertino_chart_bar_circle_fill"
    CHART_BAR_FILL = "cupertino_chart_bar_fill"
    CHART_BAR_SQUARE = "cupertino_chart_bar_square"
    CHART_BAR_SQUARE_FILL = "cupertino_chart_bar_square_fill"
    CHART_PIE = "cupertino_chart_pie"
    CHART_PIE_FILL = "cupertino_chart_pie_fill"
    CHAT_BUBBLE = "cupertino_chat_bubble"
    CHAT_BUBBLE_2 = "cupertino_chat_bubble_2"
    CHAT_BUBBLE_2_FILL = "cupertino_chat_bubble_2_fill"
    CHAT_BUBBLE_FILL = "cupertino_chat_bubble_fill"
    CHAT_BUBBLE_TEXT = "cupertino_chat_bubble_text"
    CHAT_BUBBLE_TEXT_FILL = "cupertino_chat_bubble_text_fill"
    CHECKMARK = "cupertino_checkmark"
    CHECKMARK_ALT = "cupertino_checkmark_alt"
    CHECKMARK_ALT_CIRCLE = "cupertino_checkmark_alt_circle"
    CHECKMARK_ALT_CIRCLE_FILL = "cupertino_checkmark_alt_circle_fill"
    CHECKMARK_CIRCLE = "cupertino_checkmark_circle"
    CHECKMARK_CIRCLE_FILL = "cupertino_checkmark_circle_fill"
    CHECKMARK_RECTANGLE = "cupertino_checkmark_rectangle"
    CHECKMARK_RECTANGLE_FILL = "cupertino_checkmark_rectangle_fill"
    CHECKMARK_SEAL = "cupertino_checkmark_seal"
    CHECKMARK_SEAL_FILL = "cupertino_checkmark_seal_fill"
    CHECKMARK_SHIELD = "cupertino_checkmark_shield"
    CHECKMARK_SHIELD_FILL = "cupertino_checkmark_shield_fill"
    CHECKMARK_SQUARE = "cupertino_checkmark_square"
    CHECKMARK_SQUARE_FILL = "cupertino_checkmark_square_fill"
    CHEVRON_BACK = "cupertino_chevron_back"
    CHEVRON_COMPACT_DOWN = "cupertino_chevron_compact_down"
    CHEVRON_COMPACT_LEFT = "cupertino_chevron_compact_left"
    CHEVRON_COMPACT_RIGHT = "cupertino_chevron_compact_right"
    CHEVRON_COMPACT_UP = "cupertino_chevron_compact_up"
    CHEVRON_DOWN = "cupertino_chevron_down"
    CHEVRON_DOWN_CIRCLE = "cupertino_chevron_down_circle"
    CHEVRON_DOWN_CIRCLE_FILL = "cupertino_chevron_down_circle_fill"
    CHEVRON_DOWN_SQUARE = "cupertino_chevron_down_square"
    CHEVRON_DOWN_SQUARE_FILL = "cupertino_chevron_down_square_fill"
    CHEVRON_FORWARD = "cupertino_chevron_forward"
    CHEVRON_LEFT = "cupertino_chevron_left"
    CHEVRON_LEFT_2 = "cupertino_chevron_left_2"
    CHEVRON_LEFT_CIRCLE = "cupertino_chevron_left_circle"
    CHEVRON_LEFT_CIRCLE_FILL = "cupertino_chevron_left_circle_fill"
    CHEVRON_LEFT_SLASH_CHEVRON_RIGHT = "cupertino_chevron_left_slash_chevron_right"
    CHEVRON_LEFT_SQUARE = "cupertino_chevron_left_square"
    CHEVRON_LEFT_SQUARE_FILL = "cupertino_chevron_left_square_fill"
    CHEVRON_RIGHT = "cupertino_chevron_right"
    CHEVRON_RIGHT_2 = "cupertino_chevron_right_2"
    CHEVRON_RIGHT_CIRCLE = "cupertino_chevron_right_circle"
    CHEVRON_RIGHT_CIRCLE_FILL = "cupertino_chevron_right_circle_fill"
    CHEVRON_RIGHT_SQUARE = "cupertino_chevron_right_square"
    CHEVRON_RIGHT_SQUARE_FILL = "cupertino_chevron_right_square_fill"
    CHEVRON_UP = "cupertino_chevron_up"
    CHEVRON_UP_CHEVRON_DOWN = "cupertino_chevron_up_chevron_down"
    CHEVRON_UP_CIRCLE = "cupertino_chevron_up_circle"
    CHEVRON_UP_CIRCLE_FILL = "cupertino_chevron_up_circle_fill"
    CHEVRON_UP_SQUARE = "cupertino_chevron_up_square"
    CHEVRON_UP_SQUARE_FILL = "cupertino_chevron_up_square_fill"
    CIRCLE_BOTTOMTHIRD_SPLIT = "cupertino_circle_bottomthird_split"
    CIRCLE_FILL = "cupertino_circle_fill"
    CIRCLE_GRID_3X3 = "cupertino_circle_grid_3x3"
    CIRCLE_GRID_3X3_FILL = "cupertino_circle_grid_3x3_fill"
    CIRCLE_GRID_HEX = "cupertino_circle_grid_hex"
    CIRCLE_GRID_HEX_FILL = "cupertino_circle_grid_hex_fill"
    CIRCLE_LEFTHALF_FILL = "cupertino_circle_lefthalf_fill"
    CIRCLE_RIGHTHALF_FILL = "cupertino_circle_righthalf_fill"
    CLEAR_FILL = "cupertino_clear_fill"
    CLOCK_FILL = "cupertino_clock_fill"
    CLOUD = "cupertino_cloud"
    CLOUD_BOLT = "cupertino_cloud_bolt"
    CLOUD_BOLT_FILL = "cupertino_cloud_bolt_fill"
    CLOUD_BOLT_RAIN = "cupertino_cloud_bolt_rain"
    CLOUD_BOLT_RAIN_FILL = "cupertino_cloud_bolt_rain_fill"
    CLOUD_DOWNLOAD = "cupertino_cloud_download"
    CLOUD_DOWNLOAD_FILL = "cupertino_cloud_download_fill"
    CLOUD_DRIZZLE = "cupertino_cloud_drizzle"
    CLOUD_DRIZZLE_FILL = "cupertino_cloud_drizzle_fill"
    CLOUD_FILL = "cupertino_cloud_fill"
    CLOUD_FOG = "cupertino_cloud_fog"
    CLOUD_FOG_FILL = "cupertino_cloud_fog_fill"
    CLOUD_HAIL = "cupertino_cloud_hail"
    CLOUD_HAIL_FILL = "cupertino_cloud_hail_fill"
    CLOUD_HEAVYRAIN = "cupertino_cloud_heavyrain"
    CLOUD_HEAVYRAIN_FILL = "cupertino_cloud_heavyrain_fill"
    CLOUD_MOON = "cupertino_cloud_moon"
    CLOUD_MOON_BOLT = "cupertino_cloud_moon_bolt"
    CLOUD_MOON_BOLT_FILL = "cupertino_cloud_moon_bolt_fill"
    CLOUD_MOON_FILL = "cupertino_cloud_moon_fill"
    CLOUD_MOON_RAIN = "cupertino_cloud_moon_rain"
    CLOUD_MOON_RAIN_FILL = "cupertino_cloud_moon_rain_fill"
    CLOUD_RAIN = "cupertino_cloud_rain"
    CLOUD_RAIN_FILL = "cupertino_cloud_rain_fill"
    CLOUD_SLEET = "cupertino_cloud_sleet"
    CLOUD_SLEET_FILL = "cupertino_cloud_sleet_fill"
    CLOUD_SNOW = "cupertino_cloud_snow"
    CLOUD_SNOW_FILL = "cupertino_cloud_snow_fill"
    CLOUD_SUN = "cupertino_cloud_sun"
    CLOUD_SUN_BOLT = "cupertino_cloud_sun_bolt"
    CLOUD_SUN_BOLT_FILL = "cupertino_cloud_sun_bolt_fill"
    CLOUD_SUN_FILL = "cupertino_cloud_sun_fill"
    CLOUD_SUN_RAIN = "cupertino_cloud_sun_rain"
    CLOUD_SUN_RAIN_FILL = "cupertino_cloud_sun_rain_fill"
    CLOUD_UPLOAD = "cupertino_cloud_upload"
    CLOUD_UPLOAD_FILL = "cupertino_cloud_upload_fill"
    COLOR_FILTER = "cupertino_color_filter"
    COLOR_FILTER_FILL = "cupertino_color_filter_fill"
    COMMAND = "cupertino_command"
    COMPASS = "cupertino_compass"
    COMPASS_FILL = "cupertino_compass_fill"
    CONTROL = "cupertino_control"
    CREDITCARD = "cupertino_creditcard"
    CREDITCARD_FILL = "cupertino_creditcard_fill"
    CROP = "cupertino_crop"
    CROP_ROTATE = "cupertino_crop_rotate"
    CUBE = "cupertino_cube"
    CUBE_BOX = "cupertino_cube_box"
    CUBE_BOX_FILL = "cupertino_cube_box_fill"
    CUBE_FILL = "cupertino_cube_fill"
    CURSOR_RAYS = "cupertino_cursor_rays"
    DECREASE_INDENT = "cupertino_decrease_indent"
    DECREASE_QUOTELEVEL = "cupertino_decrease_quotelevel"
    DELETE_LEFT = "cupertino_delete_left"
    DELETE_LEFT_FILL = "cupertino_delete_left_fill"
    DELETE_RIGHT = "cupertino_delete_right"
    DELETE_RIGHT_FILL = "cupertino_delete_right_fill"
    DESKTOPCOMPUTER = "cupertino_desktopcomputer"
    DEVICE_DESKTOP = "cupertino_device_desktop"
    DEVICE_LAPTOP = "cupertino_device_laptop"
    DEVICE_PHONE_LANDSCAPE = "cupertino_device_phone_landscape"
    DEVICE_PHONE_PORTRAIT = "cupertino_device_phone_portrait"
    DIAL = "cupertino_dial"
    DIAL_FILL = "cupertino_dial_fill"
    DIVIDE = "cupertino_divide"
    DIVIDE_CIRCLE = "cupertino_divide_circle"
    DIVIDE_CIRCLE_FILL = "cupertino_divide_circle_fill"
    DIVIDE_SQUARE = "cupertino_divide_square"
    DIVIDE_SQUARE_FILL = "cupertino_divide_square_fill"
    DOC = "cupertino_doc"
    DOC_APPEND = "cupertino_doc_append"
    DOC_CHART = "cupertino_doc_chart"
    DOC_CHART_FILL = "cupertino_doc_chart_fill"
    DOC_CHECKMARK = "cupertino_doc_checkmark"
    DOC_CHECKMARK_FILL = "cupertino_doc_checkmark_fill"
    DOC_CIRCLE = "cupertino_doc_circle"
    DOC_CIRCLE_FILL = "cupertino_doc_circle_fill"
    DOC_FILL = "cupertino_doc_fill"
    DOC_ON_CLIPBOARD = "cupertino_doc_on_clipboard"
    DOC_ON_CLIPBOARD_FILL = "cupertino_doc_on_clipboard_fill"
    DOC_ON_DOC = "cupertino_doc_on_doc"
    DOC_ON_DOC_FILL = "cupertino_doc_on_doc_fill"
    DOC_PERSON = "cupertino_doc_person"
    DOC_PERSON_FILL = "cupertino_doc_person_fill"
    DOC_PLAINTEXT = "cupertino_doc_plaintext"
    DOC_RICHTEXT = "cupertino_doc_richtext"
    DOC_TEXT = "cupertino_doc_text"
    DOC_TEXT_FILL = "cupertino_doc_text_fill"
    DOC_TEXT_SEARCH = "cupertino_doc_text_search"
    DOC_TEXT_VIEWFINDER = "cupertino_doc_text_viewfinder"
    DOT_RADIOWAVES_LEFT_RIGHT = "cupertino_dot_radiowaves_left_right"
    DOT_RADIOWAVES_RIGHT = "cupertino_dot_radiowaves_right"
    DOT_SQUARE = "cupertino_dot_square"
    DOT_SQUARE_FILL = "cupertino_dot_square_fill"
    DOWNLOAD_CIRCLE = "cupertino_download_circle"
    DOWNLOAD_CIRCLE_FILL = "cupertino_download_circle_fill"
    DROP = "cupertino_drop"
    DROP_FILL = "cupertino_drop_fill"
    DROP_TRIANGLE = "cupertino_drop_triangle"
    DROP_TRIANGLE_FILL = "cupertino_drop_triangle_fill"
    EAR = "cupertino_ear"
    EJECT = "cupertino_eject"
    EJECT_FILL = "cupertino_eject_fill"
    ELLIPSES_BUBBLE = "cupertino_ellipses_bubble"
    ELLIPSES_BUBBLE_FILL = "cupertino_ellipses_bubble_fill"
    ELLIPSIS_CIRCLE = "cupertino_ellipsis_circle"
    ELLIPSIS_CIRCLE_FILL = "cupertino_ellipsis_circle_fill"
    ELLIPSIS_VERTICAL = "cupertino_ellipsis_vertical"
    ELLIPSIS_VERTICAL_CIRCLE = "cupertino_ellipsis_vertical_circle"
    ELLIPSIS_VERTICAL_CIRCLE_FILL = "cupertino_ellipsis_vertical_circle_fill"
    ENVELOPE = "cupertino_envelope"
    ENVELOPE_BADGE = "cupertino_envelope_badge"
    ENVELOPE_BADGE_FILL = "cupertino_envelope_badge_fill"
    ENVELOPE_CIRCLE = "cupertino_envelope_circle"
    ENVELOPE_CIRCLE_FILL = "cupertino_envelope_circle_fill"
    ENVELOPE_FILL = "cupertino_envelope_fill"
    ENVELOPE_OPEN = "cupertino_envelope_open"
    ENVELOPE_OPEN_FILL = "cupertino_envelope_open_fill"
    EQUAL = "cupertino_equal"
    EQUAL_CIRCLE = "cupertino_equal_circle"
    EQUAL_CIRCLE_FILL = "cupertino_equal_circle_fill"
    EQUAL_SQUARE = "cupertino_equal_square"
    EQUAL_SQUARE_FILL = "cupertino_equal_square_fill"
    ESCAPE = "cupertino_escape"
    EXCLAMATIONMARK = "cupertino_exclamationmark"
    EXCLAMATIONMARK_BUBBLE = "cupertino_exclamationmark_bubble"
    EXCLAMATIONMARK_BUBBLE_FILL = "cupertino_exclamationmark_bubble_fill"
    EXCLAMATIONMARK_CIRCLE = "cupertino_exclamationmark_circle"
    EXCLAMATIONMARK_CIRCLE_FILL = "cupertino_exclamationmark_circle_fill"
    EXCLAMATIONMARK_OCTAGON = "cupertino_exclamationmark_octagon"
    EXCLAMATIONMARK_OCTAGON_FILL = "cupertino_exclamationmark_octagon_fill"
    EXCLAMATIONMARK_SHIELD = "cupertino_exclamationmark_shield"
    EXCLAMATIONMARK_SHIELD_FILL = "cupertino_exclamationmark_shield_fill"
    EXCLAMATIONMARK_SQUARE = "cupertino_exclamationmark_square"
    EXCLAMATIONMARK_SQUARE_FILL = "cupertino_exclamationmark_square_fill"
    EXCLAMATIONMARK_TRIANGLE = "cupertino_exclamationmark_triangle"
    EXCLAMATIONMARK_TRIANGLE_FILL = "cupertino_exclamationmark_triangle_fill"
    EYE_FILL = "cupertino_eye_fill"
    EYE_SLASH = "cupertino_eye_slash"
    EYE_SLASH_FILL = "cupertino_eye_slash_fill"
    EYEDROPPER = "cupertino_eyedropper"
    EYEDROPPER_FULL = "cupertino_eyedropper_full"
    EYEDROPPER_HALFFULL = "cupertino_eyedropper_halffull"
    EYEGLASSES = "cupertino_eyeglasses"
    F_CURSIVE = "cupertino_f_cursive"
    F_CURSIVE_CIRCLE = "cupertino_f_cursive_circle"
    F_CURSIVE_CIRCLE_FILL = "cupertino_f_cursive_circle_fill"
    FILM = "cupertino_film"
    FILM_FILL = "cupertino_film_fill"
    FLAG_CIRCLE = "cupertino_flag_circle"
    FLAG_CIRCLE_FILL = "cupertino_flag_circle_fill"
    FLAG_FILL = "cupertino_flag_fill"
    FLAG_SLASH = "cupertino_flag_slash"
    FLAG_SLASH_FILL = "cupertino_flag_slash_fill"
    FLAME = "cupertino_flame"
    FLAME_FILL = "cupertino_flame_fill"
    FLOPPY_DISK = "cupertino_floppy_disk"
    FLOWCHART = "cupertino_flowchart"
    FLOWCHART_FILL = "cupertino_flowchart_fill"
    FOLDER_BADGE_MINUS = "cupertino_folder_badge_minus"
    FOLDER_BADGE_PERSON_CROP = "cupertino_folder_badge_person_crop"
    FOLDER_BADGE_PLUS = "cupertino_folder_badge_plus"
    FOLDER_CIRCLE = "cupertino_folder_circle"
    FOLDER_CIRCLE_FILL = "cupertino_folder_circle_fill"
    FOLDER_FILL = "cupertino_folder_fill"
    FOLDER_FILL_BADGE_MINUS = "cupertino_folder_fill_badge_minus"
    FOLDER_FILL_BADGE_PERSON_CROP = "cupertino_folder_fill_badge_person_crop"
    FOLDER_FILL_BADGE_PLUS = "cupertino_folder_fill_badge_plus"
    FORWARD_END = "cupertino_forward_end"
    FORWARD_END_ALT = "cupertino_forward_end_alt"
    FORWARD_END_ALT_FILL = "cupertino_forward_end_alt_fill"
    FORWARD_END_FILL = "cupertino_forward_end_fill"
    FORWARD_FILL = "cupertino_forward_fill"
    FUNCTION = "cupertino_function"
    FX = "cupertino_fx"
    GAMECONTROLLER = "cupertino_gamecontroller"
    GAMECONTROLLER_ALT_FILL = "cupertino_gamecontroller_alt_fill"
    GAMECONTROLLER_FILL = "cupertino_gamecontroller_fill"
    GAUGE = "cupertino_gauge"
    GAUGE_BADGE_MINUS = "cupertino_gauge_badge_minus"
    GAUGE_BADGE_PLUS = "cupertino_gauge_badge_plus"
    GEAR_ALT = "cupertino_gear_alt"
    GEAR_ALT_FILL = "cupertino_gear_alt_fill"
    GIFT = "cupertino_gift"
    GIFT_ALT = "cupertino_gift_alt"
    GIFT_ALT_FILL = "cupertino_gift_alt_fill"
    GIFT_FILL = "cupertino_gift_fill"
    GLOBE = "cupertino_globe"
    GOBACKWARD = "cupertino_gobackward"
    GOBACKWARD_10 = "cupertino_gobackward_10"
    GOBACKWARD_15 = "cupertino_gobackward_15"
    GOBACKWARD_30 = "cupertino_gobackward_30"
    GOBACKWARD_45 = "cupertino_gobackward_45"
    GOBACKWARD_60 = "cupertino_gobackward_60"
    GOBACKWARD_75 = "cupertino_gobackward_75"
    GOBACKWARD_90 = "cupertino_gobackward_90"
    GOBACKWARD_MINUS = "cupertino_gobackward_minus"
    GOFORWARD = "cupertino_goforward"
    GOFORWARD_10 = "cupertino_goforward_10"
    GOFORWARD_15 = "cupertino_goforward_15"
    GOFORWARD_30 = "cupertino_goforward_30"
    GOFORWARD_45 = "cupertino_goforward_45"
    GOFORWARD_60 = "cupertino_goforward_60"
    GOFORWARD_75 = "cupertino_goforward_75"
    GOFORWARD_90 = "cupertino_goforward_90"
    GOFORWARD_PLUS = "cupertino_goforward_plus"
    GRAPH_CIRCLE = "cupertino_graph_circle"
    GRAPH_CIRCLE_FILL = "cupertino_graph_circle_fill"
    GRAPH_SQUARE = "cupertino_graph_square"
    GRAPH_SQUARE_FILL = "cupertino_graph_square_fill"
    GREATERTHAN = "cupertino_greaterthan"
    GREATERTHAN_CIRCLE = "cupertino_greaterthan_circle"
    GREATERTHAN_CIRCLE_FILL = "cupertino_greaterthan_circle_fill"
    GREATERTHAN_SQUARE = "cupertino_greaterthan_square"
    GREATERTHAN_SQUARE_FILL = "cupertino_greaterthan_square_fill"
    GRID = "cupertino_grid"
    GRID_CIRCLE = "cupertino_grid_circle"
    GRID_CIRCLE_FILL = "cupertino_grid_circle_fill"
    GUITARS = "cupertino_guitars"
    HAMMER = "cupertino_hammer"
    HAMMER_FILL = "cupertino_hammer_fill"
    HAND_DRAW = "cupertino_hand_draw"
    HAND_DRAW_FILL = "cupertino_hand_draw_fill"
    HAND_POINT_LEFT = "cupertino_hand_point_left"
    HAND_POINT_LEFT_FILL = "cupertino_hand_point_left_fill"
    HAND_POINT_RIGHT = "cupertino_hand_point_right"
    HAND_POINT_RIGHT_FILL = "cupertino_hand_point_right_fill"
    HAND_RAISED = "cupertino_hand_raised"
    HAND_RAISED_FILL = "cupertino_hand_raised_fill"
    HAND_RAISED_SLASH = "cupertino_hand_raised_slash"
    HAND_RAISED_SLASH_FILL = "cupertino_hand_raised_slash_fill"
    HAND_THUMBSDOWN = "cupertino_hand_thumbsdown"
    HAND_THUMBSDOWN_FILL = "cupertino_hand_thumbsdown_fill"
    HAND_THUMBSUP = "cupertino_hand_thumbsup"
    HAND_THUMBSUP_FILL = "cupertino_hand_thumbsup_fill"
    HARE = "cupertino_hare"
    HARE_FILL = "cupertino_hare_fill"
    HEADPHONES = "cupertino_headphones"
    HEART_CIRCLE = "cupertino_heart_circle"
    HEART_CIRCLE_FILL = "cupertino_heart_circle_fill"
    HEART_FILL = "cupertino_heart_fill"
    HEART_SLASH = "cupertino_heart_slash"
    HEART_SLASH_CIRCLE = "cupertino_heart_slash_circle"
    HEART_SLASH_CIRCLE_FILL = "cupertino_heart_slash_circle_fill"
    HEART_SLASH_FILL = "cupertino_heart_slash_fill"
    HELM = "cupertino_helm"
    HEXAGON = "cupertino_hexagon"
    HEXAGON_FILL = "cupertino_hexagon_fill"
    HIFISPEAKER = "cupertino_hifispeaker"
    HIFISPEAKER_FILL = "cupertino_hifispeaker_fill"
    HOURGLASS = "cupertino_hourglass"
    HOURGLASS_BOTTOMHALF_FILL = "cupertino_hourglass_bottomhalf_fill"
    HOURGLASS_TOPHALF_FILL = "cupertino_hourglass_tophalf_fill"
    HOUSE = "cupertino_house"
    HOUSE_ALT = "cupertino_house_alt"
    HOUSE_ALT_FILL = "cupertino_house_alt_fill"
    HOUSE_FILL = "cupertino_house_fill"
    HURRICANE = "cupertino_hurricane"
    INCREASE_INDENT = "cupertino_increase_indent"
    INCREASE_QUOTELEVEL = "cupertino_increase_quotelevel"
    INFINITE = "cupertino_infinite"
    INFO_CIRCLE = "cupertino_info_circle"
    INFO_CIRCLE_FILL = "cupertino_info_circle_fill"
    ITALIC = "cupertino_italic"
    KEYBOARD = "cupertino_keyboard"
    KEYBOARD_CHEVRON_COMPACT_DOWN = "cupertino_keyboard_chevron_compact_down"
    LARGECIRCLE_FILL_CIRCLE = "cupertino_largecircle_fill_circle"
    LASSO = "cupertino_lasso"
    LAYERS = "cupertino_layers"
    LAYERS_ALT = "cupertino_layers_alt"
    LAYERS_ALT_FILL = "cupertino_layers_alt_fill"
    LAYERS_FILL = "cupertino_layers_fill"
    LEAF_ARROW_CIRCLEPATH = "cupertino_leaf_arrow_circlepath"
    LESSTHAN = "cupertino_lessthan"
    LESSTHAN_CIRCLE = "cupertino_lessthan_circle"
    LESSTHAN_CIRCLE_FILL = "cupertino_lessthan_circle_fill"
    LESSTHAN_SQUARE = "cupertino_lessthan_square"
    LESSTHAN_SQUARE_FILL = "cupertino_lessthan_square_fill"
    LIGHT_MAX = "cupertino_light_max"
    LIGHT_MIN = "cupertino_light_min"
    LIGHTBULB = "cupertino_lightbulb"
    LIGHTBULB_FILL = "cupertino_lightbulb_fill"
    LIGHTBULB_SLASH = "cupertino_lightbulb_slash"
    LIGHTBULB_SLASH_FILL = "cupertino_lightbulb_slash_fill"
    LINE_HORIZONTAL_3 = "cupertino_line_horizontal_3"
    LINE_HORIZONTAL_3_DECREASE = "cupertino_line_horizontal_3_decrease"
    LINE_HORIZONTAL_3_DECREASE_CIRCLE = "cupertino_line_horizontal_3_decrease_circle"
    LINE_HORIZONTAL_3_DECREASE_CIRCLE_FILL = (
        "cupertino_line_horizontal_3_decrease_circle_fill"
    )
    LINK = "cupertino_link"
    LINK_CIRCLE = "cupertino_link_circle"
    LINK_CIRCLE_FILL = "cupertino_link_circle_fill"
    LIST_BULLET = "cupertino_list_bullet"
    LIST_BULLET_BELOW_RECTANGLE = "cupertino_list_bullet_below_rectangle"
    LIST_BULLET_INDENT = "cupertino_list_bullet_indent"
    LIST_DASH = "cupertino_list_dash"
    LIST_NUMBER = "cupertino_list_number"
    LIST_NUMBER_RTL = "cupertino_list_number_rtl"
    LOCATION_CIRCLE = "cupertino_location_circle"
    LOCATION_CIRCLE_FILL = "cupertino_location_circle_fill"
    LOCATION_FILL = "cupertino_location_fill"
    LOCATION_NORTH = "cupertino_location_north"
    LOCATION_NORTH_FILL = "cupertino_location_north_fill"
    LOCATION_NORTH_LINE = "cupertino_location_north_line"
    LOCATION_NORTH_LINE_FILL = "cupertino_location_north_line_fill"
    LOCATION_SLASH = "cupertino_location_slash"
    LOCATION_SLASH_FILL = "cupertino_location_slash_fill"
    LOCK = "cupertino_lock"
    LOCK_CIRCLE = "cupertino_lock_circle"
    LOCK_CIRCLE_FILL = "cupertino_lock_circle_fill"
    LOCK_FILL = "cupertino_lock_fill"
    LOCK_OPEN = "cupertino_lock_open"
    LOCK_OPEN_FILL = "cupertino_lock_open_fill"
    LOCK_ROTATION = "cupertino_lock_rotation"
    LOCK_ROTATION_OPEN = "cupertino_lock_rotation_open"
    LOCK_SHIELD = "cupertino_lock_shield"
    LOCK_SHIELD_FILL = "cupertino_lock_shield_fill"
    LOCK_SLASH = "cupertino_lock_slash"
    LOCK_SLASH_FILL = "cupertino_lock_slash_fill"
    MACWINDOW = "cupertino_macwindow"
    MAP = "cupertino_map"
    MAP_FILL = "cupertino_map_fill"
    MAP_PIN = "cupertino_map_pin"
    MAP_PIN_ELLIPSE = "cupertino_map_pin_ellipse"
    MAP_PIN_SLASH = "cupertino_map_pin_slash"
    MEMORIES = "cupertino_memories"
    MEMORIES_BADGE_MINUS = "cupertino_memories_badge_minus"
    MEMORIES_BADGE_PLUS = "cupertino_memories_badge_plus"
    METRONOME = "cupertino_metronome"
    MIC_CIRCLE = "cupertino_mic_circle"
    MIC_CIRCLE_FILL = "cupertino_mic_circle_fill"
    MIC_FILL = "cupertino_mic_fill"
    MIC_SLASH = "cupertino_mic_slash"
    MIC_SLASH_FILL = "cupertino_mic_slash_fill"
    MINUS = "cupertino_minus"
    MINUS_CIRCLE = "cupertino_minus_circle"
    MINUS_CIRCLE_FILL = "cupertino_minus_circle_fill"
    MINUS_RECTANGLE = "cupertino_minus_rectangle"
    MINUS_RECTANGLE_FILL = "cupertino_minus_rectangle_fill"
    MINUS_SLASH_PLUS = "cupertino_minus_slash_plus"
    MINUS_SQUARE = "cupertino_minus_square"
    MINUS_SQUARE_FILL = "cupertino_minus_square_fill"
    MONEY_DOLLAR = "cupertino_money_dollar"
    MONEY_DOLLAR_CIRCLE = "cupertino_money_dollar_circle"
    MONEY_DOLLAR_CIRCLE_FILL = "cupertino_money_dollar_circle_fill"
    MONEY_EURO = "cupertino_money_euro"
    MONEY_EURO_CIRCLE = "cupertino_money_euro_circle"
    MONEY_EURO_CIRCLE_FILL = "cupertino_money_euro_circle_fill"
    MONEY_POUND = "cupertino_money_pound"
    MONEY_POUND_CIRCLE = "cupertino_money_pound_circle"
    MONEY_POUND_CIRCLE_FILL = "cupertino_money_pound_circle_fill"
    MONEY_RUBL = "cupertino_money_rubl"
    MONEY_RUBL_CIRCLE = "cupertino_money_rubl_circle"
    MONEY_RUBL_CIRCLE_FILL = "cupertino_money_rubl_circle_fill"
    MONEY_YEN = "cupertino_money_yen"
    MONEY_YEN_CIRCLE = "cupertino_money_yen_circle"
    MONEY_YEN_CIRCLE_FILL = "cupertino_money_yen_circle_fill"
    MOON = "cupertino_moon"
    MOON_CIRCLE = "cupertino_moon_circle"
    MOON_CIRCLE_FILL = "cupertino_moon_circle_fill"
    MOON_FILL = "cupertino_moon_fill"
    MOON_STARS = "cupertino_moon_stars"
    MOON_STARS_FILL = "cupertino_moon_stars_fill"
    MOON_ZZZ = "cupertino_moon_zzz"
    MOON_ZZZ_FILL = "cupertino_moon_zzz_fill"
    MOVE = "cupertino_move"
    MULTIPLY = "cupertino_multiply"
    MULTIPLY_CIRCLE = "cupertino_multiply_circle"
    MULTIPLY_CIRCLE_FILL = "cupertino_multiply_circle_fill"
    MULTIPLY_SQUARE = "cupertino_multiply_square"
    MULTIPLY_SQUARE_FILL = "cupertino_multiply_square_fill"
    MUSIC_ALBUMS = "cupertino_music_albums"
    MUSIC_ALBUMS_FILL = "cupertino_music_albums_fill"
    MUSIC_HOUSE = "cupertino_music_house"
    MUSIC_HOUSE_FILL = "cupertino_music_house_fill"
    MUSIC_MIC = "cupertino_music_mic"
    MUSIC_NOTE_2 = "cupertino_music_note_2"
    MUSIC_NOTE_LIST = "cupertino_music_note_list"
    NOSIGN = "cupertino_nosign"
    NUMBER = "cupertino_number"
    NUMBER_CIRCLE = "cupertino_number_circle"
    NUMBER_CIRCLE_FILL = "cupertino_number_circle_fill"
    NUMBER_SQUARE = "cupertino_number_square"
    NUMBER_SQUARE_FILL = "cupertino_number_square_fill"
    OPTION = "cupertino_option"
    PAINTBRUSH = "cupertino_paintbrush"
    PAINTBRUSH_FILL = "cupertino_paintbrush_fill"
    PANO = "cupertino_pano"
    PANO_FILL = "cupertino_pano_fill"
    PAPERCLIP = "cupertino_paperclip"
    PAPERPLANE = "cupertino_paperplane"
    PAPERPLANE_FILL = "cupertino_paperplane_fill"
    PARAGRAPH = "cupertino_paragraph"
    PAUSE_CIRCLE = "cupertino_pause_circle"
    PAUSE_CIRCLE_FILL = "cupertino_pause_circle_fill"
    PAUSE_FILL = "cupertino_pause_fill"
    PAUSE_RECTANGLE = "cupertino_pause_rectangle"
    PAUSE_RECTANGLE_FILL = "cupertino_pause_rectangle_fill"
    PENCIL_CIRCLE = "cupertino_pencil_circle"
    PENCIL_CIRCLE_FILL = "cupertino_pencil_circle_fill"
    PENCIL_ELLIPSIS_RECTANGLE = "cupertino_pencil_ellipsis_rectangle"
    PENCIL_OUTLINE = "cupertino_pencil_outline"
    PENCIL_SLASH = "cupertino_pencil_slash"
    PERCENT = "cupertino_percent"
    PERSON_2 = "cupertino_person_2"
    PERSON_2_ALT = "cupertino_person_2_alt"
    PERSON_2_FILL = "cupertino_person_2_fill"
    PERSON_2_SQUARE_STACK = "cupertino_person_2_square_stack"
    PERSON_2_SQUARE_STACK_FILL = "cupertino_person_2_square_stack_fill"
    PERSON_3 = "cupertino_person_3"
    PERSON_3_FILL = "cupertino_person_3_fill"
    PERSON_ALT = "cupertino_person_alt"
    PERSON_ALT_CIRCLE = "cupertino_person_alt_circle"
    PERSON_ALT_CIRCLE_FILL = "cupertino_person_alt_circle_fill"
    PERSON_BADGE_MINUS = "cupertino_person_badge_minus"
    PERSON_BADGE_MINUS_FILL = "cupertino_person_badge_minus_fill"
    PERSON_BADGE_PLUS = "cupertino_person_badge_plus"
    PERSON_BADGE_PLUS_FILL = "cupertino_person_badge_plus_fill"
    PERSON_CIRCLE = "cupertino_person_circle"
    PERSON_CIRCLE_FILL = "cupertino_person_circle_fill"
    PERSON_CROP_CIRCLE = "cupertino_person_crop_circle"
    PERSON_CROP_CIRCLE_BADGE_CHECKMARK = "cupertino_person_crop_circle_badge_checkmark"
    PERSON_CROP_CIRCLE_BADGE_EXCLAM = "cupertino_person_crop_circle_badge_exclam"
    PERSON_CROP_CIRCLE_BADGE_MINUS = "cupertino_person_crop_circle_badge_minus"
    PERSON_CROP_CIRCLE_BADGE_PLUS = "cupertino_person_crop_circle_badge_plus"
    PERSON_CROP_CIRCLE_BADGE_XMARK = "cupertino_person_crop_circle_badge_xmark"
    PERSON_CROP_CIRCLE_FILL = "cupertino_person_crop_circle_fill"
    PERSON_CROP_CIRCLE_FILL_BADGE_CHECKMARK = (
        "cupertino_person_crop_circle_fill_badge_checkmark"
    )
    PERSON_CROP_CIRCLE_FILL_BADGE_EXCLAM = (
        "cupertino_person_crop_circle_fill_badge_exclam"
    )
    PERSON_CROP_CIRCLE_FILL_BADGE_MINUS = (
        "cupertino_person_crop_circle_fill_badge_minus"
    )
    PERSON_CROP_CIRCLE_FILL_BADGE_PLUS = "cupertino_person_crop_circle_fill_badge_plus"
    PERSON_CROP_CIRCLE_FILL_BADGE_XMARK = (
        "cupertino_person_crop_circle_fill_badge_xmark"
    )
    PERSON_CROP_RECTANGLE = "cupertino_person_crop_rectangle"
    PERSON_CROP_RECTANGLE_FILL = "cupertino_person_crop_rectangle_fill"
    PERSON_CROP_SQUARE = "cupertino_person_crop_square"
    PERSON_CROP_SQUARE_FILL = "cupertino_person_crop_square_fill"
    PERSON_FILL = "cupertino_person_fill"
    PERSONALHOTSPOT = "cupertino_personalhotspot"
    PERSPECTIVE = "cupertino_perspective"
    PHONE_ARROW_DOWN_LEFT = "cupertino_phone_arrow_down_left"
    PHONE_ARROW_RIGHT = "cupertino_phone_arrow_right"
    PHONE_ARROW_UP_RIGHT = "cupertino_phone_arrow_up_right"
    PHONE_BADGE_PLUS = "cupertino_phone_badge_plus"
    PHONE_CIRCLE = "cupertino_phone_circle"
    PHONE_CIRCLE_FILL = "cupertino_phone_circle_fill"
    PHONE_DOWN = "cupertino_phone_down"
    PHONE_DOWN_CIRCLE = "cupertino_phone_down_circle"
    PHONE_DOWN_CIRCLE_FILL = "cupertino_phone_down_circle_fill"
    PHONE_DOWN_FILL = "cupertino_phone_down_fill"
    PHONE_FILL = "cupertino_phone_fill"
    PHONE_FILL_ARROW_DOWN_LEFT = "cupertino_phone_fill_arrow_down_left"
    PHONE_FILL_ARROW_RIGHT = "cupertino_phone_fill_arrow_right"
    PHONE_FILL_ARROW_UP_RIGHT = "cupertino_phone_fill_arrow_up_right"
    PHONE_FILL_BADGE_PLUS = "cupertino_phone_fill_badge_plus"
    PHOTO = "cupertino_photo"
    PHOTO_FILL = "cupertino_photo_fill"
    PHOTO_FILL_ON_RECTANGLE_FILL = "cupertino_photo_fill_on_rectangle_fill"
    PHOTO_ON_RECTANGLE = "cupertino_photo_on_rectangle"
    PIANO = "cupertino_piano"
    PIN = "cupertino_pin"
    PIN_FILL = "cupertino_pin_fill"
    PIN_SLASH = "cupertino_pin_slash"
    PIN_SLASH_FILL = "cupertino_pin_slash_fill"
    PLACEMARK = "cupertino_placemark"
    PLACEMARK_FILL = "cupertino_placemark_fill"
    PLAY = "cupertino_play"
    PLAY_CIRCLE = "cupertino_play_circle"
    PLAY_CIRCLE_FILL = "cupertino_play_circle_fill"
    PLAY_FILL = "cupertino_play_fill"
    PLAY_RECTANGLE = "cupertino_play_rectangle"
    PLAY_RECTANGLE_FILL = "cupertino_play_rectangle_fill"
    PLAYPAUSE = "cupertino_playpause"
    PLAYPAUSE_FILL = "cupertino_playpause_fill"
    PLUS = "cupertino_plus"
    PLUS_APP = "cupertino_plus_app"
    PLUS_APP_FILL = "cupertino_plus_app_fill"
    PLUS_BUBBLE = "cupertino_plus_bubble"
    PLUS_BUBBLE_FILL = "cupertino_plus_bubble_fill"
    PLUS_CIRCLE = "cupertino_plus_circle"
    PLUS_CIRCLE_FILL = "cupertino_plus_circle_fill"
    PLUS_RECTANGLE = "cupertino_plus_rectangle"
    PLUS_RECTANGLE_FILL = "cupertino_plus_rectangle_fill"
    PLUS_RECTANGLE_FILL_ON_RECTANGLE_FILL = (
        "cupertino_plus_rectangle_fill_on_rectangle_fill"
    )
    PLUS_RECTANGLE_ON_RECTANGLE = "cupertino_plus_rectangle_on_rectangle"
    PLUS_SLASH_MINUS = "cupertino_plus_slash_minus"
    PLUS_SQUARE = "cupertino_plus_square"
    PLUS_SQUARE_FILL = "cupertino_plus_square_fill"
    PLUS_SQUARE_FILL_ON_SQUARE_FILL = "cupertino_plus_square_fill_on_square_fill"
    PLUS_SQUARE_ON_SQUARE = "cupertino_plus_square_on_square"
    PLUSMINUS = "cupertino_plusminus"
    PLUSMINUS_CIRCLE = "cupertino_plusminus_circle"
    PLUSMINUS_CIRCLE_FILL = "cupertino_plusminus_circle_fill"
    POWER = "cupertino_power"
    PRINTER = "cupertino_printer"
    PRINTER_FILL = "cupertino_printer_fill"
    PROJECTIVE = "cupertino_projective"
    PURCHASED = "cupertino_purchased"
    PURCHASED_CIRCLE = "cupertino_purchased_circle"
    PURCHASED_CIRCLE_FILL = "cupertino_purchased_circle_fill"
    QRCODE = "cupertino_qrcode"
    QRCODE_VIEWFINDER = "cupertino_qrcode_viewfinder"
    QUESTION = "cupertino_question"
    QUESTION_CIRCLE = "cupertino_question_circle"
    QUESTION_CIRCLE_FILL = "cupertino_question_circle_fill"
    QUESTION_DIAMOND = "cupertino_question_diamond"
    QUESTION_DIAMOND_FILL = "cupertino_question_diamond_fill"
    QUESTION_SQUARE = "cupertino_question_square"
    QUESTION_SQUARE_FILL = "cupertino_question_square_fill"
    QUOTE_BUBBLE = "cupertino_quote_bubble"
    QUOTE_BUBBLE_FILL = "cupertino_quote_bubble_fill"
    RADIOWAVES_LEFT = "cupertino_radiowaves_left"
    RADIOWAVES_RIGHT = "cupertino_radiowaves_right"
    RAYS = "cupertino_rays"
    RECORDINGTAPE = "cupertino_recordingtape"
    RECTANGLE = "cupertino_rectangle"
    RECTANGLE_3_OFFGRID = "cupertino_rectangle_3_offgrid"
    RECTANGLE_3_OFFGRID_FILL = "cupertino_rectangle_3_offgrid_fill"
    RECTANGLE_ARROW_UP_RIGHT_ARROW_DOWN_LEFT = (
        "cupertino_rectangle_arrow_up_right_arrow_down_left"
    )
    RECTANGLE_ARROW_UP_RIGHT_ARROW_DOWN_LEFT_SLASH = (
        "cupertino_rectangle_arrow_up_right_arrow_down_left_slash"
    )
    RECTANGLE_BADGE_CHECKMARK = "cupertino_rectangle_badge_checkmark"
    RECTANGLE_BADGE_XMARK = "cupertino_rectangle_badge_xmark"
    RECTANGLE_COMPRESS_VERTICAL = "cupertino_rectangle_compress_vertical"
    RECTANGLE_DOCK = "cupertino_rectangle_dock"
    RECTANGLE_EXPAND_VERTICAL = "cupertino_rectangle_expand_vertical"
    RECTANGLE_FILL = "cupertino_rectangle_fill"
    RECTANGLE_FILL_BADGE_CHECKMARK = "cupertino_rectangle_fill_badge_checkmark"
    RECTANGLE_FILL_BADGE_XMARK = "cupertino_rectangle_fill_badge_xmark"
    RECTANGLE_FILL_ON_RECTANGLE_ANGLED_FILL = (
        "cupertino_rectangle_fill_on_rectangle_angled_fill"
    )
    RECTANGLE_FILL_ON_RECTANGLE_FILL = "cupertino_rectangle_fill_on_rectangle_fill"
    RECTANGLE_GRID_1X2 = "cupertino_rectangle_grid_1x2"
    RECTANGLE_GRID_1X2_FILL = "cupertino_rectangle_grid_1x2_fill"
    RECTANGLE_GRID_2X2 = "cupertino_rectangle_grid_2x2"
    RECTANGLE_GRID_2X2_FILL = "cupertino_rectangle_grid_2x2_fill"
    RECTANGLE_GRID_3X2 = "cupertino_rectangle_grid_3x2"
    RECTANGLE_GRID_3X2_FILL = "cupertino_rectangle_grid_3x2_fill"
    RECTANGLE_ON_RECTANGLE = "cupertino_rectangle_on_rectangle"
    RECTANGLE_ON_RECTANGLE_ANGLED = "cupertino_rectangle_on_rectangle_angled"
    RECTANGLE_PAPERCLIP = "cupertino_rectangle_paperclip"
    RECTANGLE_SPLIT_3X1 = "cupertino_rectangle_split_3x1"
    RECTANGLE_SPLIT_3X1_FILL = "cupertino_rectangle_split_3x1_fill"
    RECTANGLE_SPLIT_3X3 = "cupertino_rectangle_split_3x3"
    RECTANGLE_SPLIT_3X3_FILL = "cupertino_rectangle_split_3x3_fill"
    RECTANGLE_STACK = "cupertino_rectangle_stack"
    RECTANGLE_STACK_BADGE_MINUS = "cupertino_rectangle_stack_badge_minus"
    RECTANGLE_STACK_BADGE_PERSON_CROP = "cupertino_rectangle_stack_badge_person_crop"
    RECTANGLE_STACK_BADGE_PLUS = "cupertino_rectangle_stack_badge_plus"
    RECTANGLE_STACK_FILL = "cupertino_rectangle_stack_fill"
    RECTANGLE_STACK_FILL_BADGE_MINUS = "cupertino_rectangle_stack_fill_badge_minus"
    RECTANGLE_STACK_FILL_BADGE_PERSON_CROP = (
        "cupertino_rectangle_stack_fill_badge_person_crop"
    )
    RECTANGLE_STACK_FILL_BADGE_PLUS = "cupertino_rectangle_stack_fill_badge_plus"
    RECTANGLE_STACK_PERSON_CROP = "cupertino_rectangle_stack_person_crop"
    RECTANGLE_STACK_PERSON_CROP_FILL = "cupertino_rectangle_stack_person_crop_fill"
    REPEAT = "cupertino_repeat"
    REPEAT_1 = "cupertino_repeat_1"
    RESIZE = "cupertino_resize"
    RESIZE_H = "cupertino_resize_h"
    RESIZE_V = "cupertino_resize_v"
    RETURN_ICON = "cupertino_return_icon"
    RHOMBUS = "cupertino_rhombus"
    RHOMBUS_FILL = "cupertino_rhombus_fill"
    ROCKET = "cupertino_rocket"
    ROCKET_FILL = "cupertino_rocket_fill"
    ROSETTE = "cupertino_rosette"
    ROTATE_LEFT = "cupertino_rotate_left"
    ROTATE_LEFT_FILL = "cupertino_rotate_left_fill"
    ROTATE_RIGHT = "cupertino_rotate_right"
    ROTATE_RIGHT_FILL = "cupertino_rotate_right_fill"
    SCISSORS = "cupertino_scissors"
    SCISSORS_ALT = "cupertino_scissors_alt"
    SCOPE = "cupertino_scope"
    SCRIBBLE = "cupertino_scribble"
    SEARCH_CIRCLE = "cupertino_search_circle"
    SEARCH_CIRCLE_FILL = "cupertino_search_circle_fill"
    SELECTION_PIN_IN_OUT = "cupertino_selection_pin_in_out"
    SHIELD = "cupertino_shield"
    SHIELD_FILL = "cupertino_shield_fill"
    SHIELD_LEFTHALF_FILL = "cupertino_shield_lefthalf_fill"
    SHIELD_SLASH = "cupertino_shield_slash"
    SHIELD_SLASH_FILL = "cupertino_shield_slash_fill"
    SHIFT = "cupertino_shift"
    SHIFT_FILL = "cupertino_shift_fill"
    SIDEBAR_LEFT = "cupertino_sidebar_left"
    SIDEBAR_RIGHT = "cupertino_sidebar_right"
    SIGNATURE = "cupertino_signature"
    SKEW = "cupertino_skew"
    SLASH_CIRCLE = "cupertino_slash_circle"
    SLASH_CIRCLE_FILL = "cupertino_slash_circle_fill"
    SLIDER_HORIZONTAL_3 = "cupertino_slider_horizontal_3"
    SLIDER_HORIZONTAL_BELOW_RECTANGLE = "cupertino_slider_horizontal_below_rectangle"
    SLOWMO = "cupertino_slowmo"
    SMALLCIRCLE_CIRCLE = "cupertino_smallcircle_circle"
    SMALLCIRCLE_CIRCLE_FILL = "cupertino_smallcircle_circle_fill"
    SMALLCIRCLE_FILL_CIRCLE = "cupertino_smallcircle_fill_circle"
    SMALLCIRCLE_FILL_CIRCLE_FILL = "cupertino_smallcircle_fill_circle_fill"
    SMILEY = "cupertino_smiley"
    SMILEY_FILL = "cupertino_smiley_fill"
    SMOKE = "cupertino_smoke"
    SMOKE_FILL = "cupertino_smoke_fill"
    SNOW = "cupertino_snow"
    SORT_DOWN = "cupertino_sort_down"
    SORT_DOWN_CIRCLE = "cupertino_sort_down_circle"
    SORT_DOWN_CIRCLE_FILL = "cupertino_sort_down_circle_fill"
    SORT_UP = "cupertino_sort_up"
    SORT_UP_CIRCLE = "cupertino_sort_up_circle"
    SORT_UP_CIRCLE_FILL = "cupertino_sort_up_circle_fill"
    SPARKLES = "cupertino_sparkles"
    SPEAKER = "cupertino_speaker"
    SPEAKER_1 = "cupertino_speaker_1"
    SPEAKER_1_FILL = "cupertino_speaker_1_fill"
    SPEAKER_2 = "cupertino_speaker_2"
    SPEAKER_2_FILL = "cupertino_speaker_2_fill"
    SPEAKER_3 = "cupertino_speaker_3"
    SPEAKER_3_FILL = "cupertino_speaker_3_fill"
    SPEAKER_FILL = "cupertino_speaker_fill"
    SPEAKER_SLASH = "cupertino_speaker_slash"
    SPEAKER_SLASH_FILL = "cupertino_speaker_slash_fill"
    SPEAKER_SLASH_FILL_RTL = "cupertino_speaker_slash_fill_rtl"
    SPEAKER_SLASH_RTL = "cupertino_speaker_slash_rtl"
    SPEAKER_ZZZ = "cupertino_speaker_zzz"
    SPEAKER_ZZZ_FILL = "cupertino_speaker_zzz_fill"
    SPEAKER_ZZZ_FILL_RTL = "cupertino_speaker_zzz_fill_rtl"
    SPEAKER_ZZZ_RTL = "cupertino_speaker_zzz_rtl"
    SPEEDOMETER = "cupertino_speedometer"
    SPORTSCOURT = "cupertino_sportscourt"
    SPORTSCOURT_FILL = "cupertino_sportscourt_fill"
    SQUARE = "cupertino_square"
    SQUARE_ARROW_DOWN = "cupertino_square_arrow_down"
    SQUARE_ARROW_DOWN_FILL = "cupertino_square_arrow_down_fill"
    SQUARE_ARROW_DOWN_ON_SQUARE = "cupertino_square_arrow_down_on_square"
    SQUARE_ARROW_DOWN_ON_SQUARE_FILL = "cupertino_square_arrow_down_on_square_fill"
    SQUARE_ARROW_LEFT = "cupertino_square_arrow_left"
    SQUARE_ARROW_LEFT_FILL = "cupertino_square_arrow_left_fill"
    SQUARE_ARROW_RIGHT = "cupertino_square_arrow_right"
    SQUARE_ARROW_RIGHT_FILL = "cupertino_square_arrow_right_fill"
    SQUARE_ARROW_UP = "cupertino_square_arrow_up"
    SQUARE_ARROW_UP_FILL = "cupertino_square_arrow_up_fill"
    SQUARE_ARROW_UP_ON_SQUARE = "cupertino_square_arrow_up_on_square"
    SQUARE_ARROW_UP_ON_SQUARE_FILL = "cupertino_square_arrow_up_on_square_fill"
    SQUARE_FAVORITES = "cupertino_square_favorites"
    SQUARE_FAVORITES_ALT = "cupertino_square_favorites_alt"
    SQUARE_FAVORITES_ALT_FILL = "cupertino_square_favorites_alt_fill"
    SQUARE_FAVORITES_FILL = "cupertino_square_favorites_fill"
    SQUARE_FILL = "cupertino_square_fill"
    SQUARE_FILL_LINE_VERTICAL_SQUARE = "cupertino_square_fill_line_vertical_square"
    SQUARE_FILL_LINE_VERTICAL_SQUARE_FILL = (
        "cupertino_square_fill_line_vertical_square_fill"
    )
    SQUARE_FILL_ON_CIRCLE_FILL = "cupertino_square_fill_on_circle_fill"
    SQUARE_FILL_ON_SQUARE_FILL = "cupertino_square_fill_on_square_fill"
    SQUARE_GRID_2X2 = "cupertino_square_grid_2x2"
    SQUARE_GRID_2X2_FILL = "cupertino_square_grid_2x2_fill"
    SQUARE_GRID_3X2 = "cupertino_square_grid_3x2"
    SQUARE_GRID_3X2_FILL = "cupertino_square_grid_3x2_fill"
    SQUARE_GRID_4X3_FILL = "cupertino_square_grid_4x3_fill"
    SQUARE_LEFTHALF_FILL = "cupertino_square_lefthalf_fill"
    SQUARE_LINE_VERTICAL_SQUARE = "cupertino_square_line_vertical_square"
    SQUARE_LINE_VERTICAL_SQUARE_FILL = "cupertino_square_line_vertical_square_fill"
    SQUARE_LIST = "cupertino_square_list"
    SQUARE_LIST_FILL = "cupertino_square_list_fill"
    SQUARE_ON_CIRCLE = "cupertino_square_on_circle"
    SQUARE_ON_SQUARE = "cupertino_square_on_square"
    SQUARE_PENCIL = "cupertino_square_pencil"
    SQUARE_PENCIL_FILL = "cupertino_square_pencil_fill"
    SQUARE_RIGHTHALF_FILL = "cupertino_square_righthalf_fill"
    SQUARE_SPLIT_1X2 = "cupertino_square_split_1x2"
    SQUARE_SPLIT_1X2_FILL = "cupertino_square_split_1x2_fill"
    SQUARE_SPLIT_2X1 = "cupertino_square_split_2x1"
    SQUARE_SPLIT_2X1_FILL = "cupertino_square_split_2x1_fill"
    SQUARE_SPLIT_2X2 = "cupertino_square_split_2x2"
    SQUARE_SPLIT_2X2_FILL = "cupertino_square_split_2x2_fill"
    SQUARE_STACK = "cupertino_square_stack"
    SQUARE_STACK_3D_DOWN_DOTTEDLINE = "cupertino_square_stack_3d_down_dottedline"
    SQUARE_STACK_3D_DOWN_RIGHT = "cupertino_square_stack_3d_down_right"
    SQUARE_STACK_3D_DOWN_RIGHT_FILL = "cupertino_square_stack_3d_down_right_fill"
    SQUARE_STACK_3D_UP = "cupertino_square_stack_3d_up"
    SQUARE_STACK_3D_UP_FILL = "cupertino_square_stack_3d_up_fill"
    SQUARE_STACK_3D_UP_SLASH = "cupertino_square_stack_3d_up_slash"
    SQUARE_STACK_3D_UP_SLASH_FILL = "cupertino_square_stack_3d_up_slash_fill"
    SQUARE_STACK_FILL = "cupertino_square_stack_fill"
    SQUARES_BELOW_RECTANGLE = "cupertino_squares_below_rectangle"
    STAR = "cupertino_star"
    STAR_CIRCLE = "cupertino_star_circle"
    STAR_CIRCLE_FILL = "cupertino_star_circle_fill"
    STAR_FILL = "cupertino_star_fill"
    STAR_LEFTHALF_FILL = "cupertino_star_lefthalf_fill"
    STAR_SLASH = "cupertino_star_slash"
    STAR_SLASH_FILL = "cupertino_star_slash_fill"
    STAROFLIFE = "cupertino_staroflife"
    STAROFLIFE_FILL = "cupertino_staroflife_fill"
    STOP = "cupertino_stop"
    STOP_CIRCLE = "cupertino_stop_circle"
    STOP_CIRCLE_FILL = "cupertino_stop_circle_fill"
    STOP_FILL = "cupertino_stop_fill"
    STOPWATCH = "cupertino_stopwatch"
    STOPWATCH_FILL = "cupertino_stopwatch_fill"
    STRIKETHROUGH = "cupertino_strikethrough"
    SUIT_CLUB = "cupertino_suit_club"
    SUIT_CLUB_FILL = "cupertino_suit_club_fill"
    SUIT_DIAMOND = "cupertino_suit_diamond"
    SUIT_DIAMOND_FILL = "cupertino_suit_diamond_fill"
    SUIT_HEART = "cupertino_suit_heart"
    SUIT_HEART_FILL = "cupertino_suit_heart_fill"
    SUIT_SPADE = "cupertino_suit_spade"
    SUIT_SPADE_FILL = "cupertino_suit_spade_fill"
    SUM = "cupertino_sum"
    SUN_DUST = "cupertino_sun_dust"
    SUN_DUST_FILL = "cupertino_sun_dust_fill"
    SUN_HAZE = "cupertino_sun_haze"
    SUN_HAZE_FILL = "cupertino_sun_haze_fill"
    SUN_MAX = "cupertino_sun_max"
    SUN_MAX_FILL = "cupertino_sun_max_fill"
    SUN_MIN = "cupertino_sun_min"
    SUN_MIN_FILL = "cupertino_sun_min_fill"
    SUNRISE = "cupertino_sunrise"
    SUNRISE_FILL = "cupertino_sunrise_fill"
    SUNSET = "cupertino_sunset"
    SUNSET_FILL = "cupertino_sunset_fill"
    T_BUBBLE = "cupertino_t_bubble"
    T_BUBBLE_FILL = "cupertino_t_bubble_fill"
    TABLE = "cupertino_table"
    TABLE_BADGE_MORE = "cupertino_table_badge_more"
    TABLE_BADGE_MORE_FILL = "cupertino_table_badge_more_fill"
    TABLE_FILL = "cupertino_table_fill"
    TAG_CIRCLE = "cupertino_tag_circle"
    TAG_CIRCLE_FILL = "cupertino_tag_circle_fill"
    TAG_FILL = "cupertino_tag_fill"
    TEXT_ALIGNCENTER = "cupertino_text_aligncenter"
    TEXT_ALIGNLEFT = "cupertino_text_alignleft"
    TEXT_ALIGNRIGHT = "cupertino_text_alignright"
    TEXT_APPEND = "cupertino_text_append"
    TEXT_BADGE_CHECKMARK = "cupertino_text_badge_checkmark"
    TEXT_BADGE_MINUS = "cupertino_text_badge_minus"
    TEXT_BADGE_PLUS = "cupertino_text_badge_plus"
    TEXT_BADGE_STAR = "cupertino_text_badge_star"
    TEXT_BADGE_XMARK = "cupertino_text_badge_xmark"
    TEXT_BUBBLE = "cupertino_text_bubble"
    TEXT_BUBBLE_FILL = "cupertino_text_bubble_fill"
    TEXT_CURSOR = "cupertino_text_cursor"
    TEXT_INSERT = "cupertino_text_insert"
    TEXT_JUSTIFY = "cupertino_text_justify"
    TEXT_JUSTIFYLEFT = "cupertino_text_justifyleft"
    TEXT_JUSTIFYRIGHT = "cupertino_text_justifyright"
    TEXT_QUOTE = "cupertino_text_quote"
    TEXTBOX = "cupertino_textbox"
    TEXTFORMAT = "cupertino_textformat"
    TEXTFORMAT_123 = "cupertino_textformat_123"
    TEXTFORMAT_ABC = "cupertino_textformat_abc"
    TEXTFORMAT_ABC_DOTTEDUNDERLINE = "cupertino_textformat_abc_dottedunderline"
    TEXTFORMAT_ALT = "cupertino_textformat_alt"
    TEXTFORMAT_SIZE = "cupertino_textformat_size"
    TEXTFORMAT_SUBSCRIPT = "cupertino_textformat_subscript"
    TEXTFORMAT_SUPERSCRIPT = "cupertino_textformat_superscript"
    THERMOMETER = "cupertino_thermometer"
    THERMOMETER_SNOWFLAKE = "cupertino_thermometer_snowflake"
    THERMOMETER_SUN = "cupertino_thermometer_sun"
    TICKET = "cupertino_ticket"
    TICKET_FILL = "cupertino_ticket_fill"
    TICKETS = "cupertino_tickets"
    TICKETS_FILL = "cupertino_tickets_fill"
    TIMELAPSE = "cupertino_timelapse"
    TIMER = "cupertino_timer"
    TIMER_FILL = "cupertino_timer_fill"
    TODAY = "cupertino_today"
    TODAY_FILL = "cupertino_today_fill"
    TORNADO = "cupertino_tornado"
    TORTOISE = "cupertino_tortoise"
    TORTOISE_FILL = "cupertino_tortoise_fill"
    TRAM_FILL = "cupertino_tram_fill"
    TRASH = "cupertino_trash"
    TRASH_CIRCLE = "cupertino_trash_circle"
    TRASH_CIRCLE_FILL = "cupertino_trash_circle_fill"
    TRASH_FILL = "cupertino_trash_fill"
    TRASH_SLASH = "cupertino_trash_slash"
    TRASH_SLASH_FILL = "cupertino_trash_slash_fill"
    TRAY = "cupertino_tray"
    TRAY_2 = "cupertino_tray_2"
    TRAY_2_FILL = "cupertino_tray_2_fill"
    TRAY_ARROW_DOWN = "cupertino_tray_arrow_down"
    TRAY_ARROW_DOWN_FILL = "cupertino_tray_arrow_down_fill"
    TRAY_ARROW_UP = "cupertino_tray_arrow_up"
    TRAY_ARROW_UP_FILL = "cupertino_tray_arrow_up_fill"
    TRAY_FILL = "cupertino_tray_fill"
    TRAY_FULL = "cupertino_tray_full"
    TRAY_FULL_FILL = "cupertino_tray_full_fill"
    TREE = "cupertino_tree"
    TRIANGLE = "cupertino_triangle"
    TRIANGLE_FILL = "cupertino_triangle_fill"
    TRIANGLE_LEFTHALF_FILL = "cupertino_triangle_lefthalf_fill"
    TRIANGLE_RIGHTHALF_FILL = "cupertino_triangle_righthalf_fill"
    TROPICALSTORM = "cupertino_tropicalstorm"
    TUNINGFORK = "cupertino_tuningfork"
    TV = "cupertino_tv"
    TV_CIRCLE = "cupertino_tv_circle"
    TV_CIRCLE_FILL = "cupertino_tv_circle_fill"
    TV_FILL = "cupertino_tv_fill"
    TV_MUSIC_NOTE = "cupertino_tv_music_note"
    TV_MUSIC_NOTE_FILL = "cupertino_tv_music_note_fill"
    UIWINDOW_SPLIT_2X1 = "cupertino_uiwindow_split_2x1"
    UMBRELLA = "cupertino_umbrella"
    UMBRELLA_FILL = "cupertino_umbrella_fill"
    UNDERLINE = "cupertino_underline"
    UPLOAD_CIRCLE = "cupertino_upload_circle"
    UPLOAD_CIRCLE_FILL = "cupertino_upload_circle_fill"
    VIDEOCAM = "cupertino_videocam"
    VIDEOCAM_CIRCLE = "cupertino_videocam_circle"
    VIDEOCAM_CIRCLE_FILL = "cupertino_videocam_circle_fill"
    VIDEOCAM_FILL = "cupertino_videocam_fill"
    VIEW_2D = "cupertino_view_2d"
    VIEW_3D = "cupertino_view_3d"
    VIEWFINDER = "cupertino_viewfinder"
    VIEWFINDER_CIRCLE = "cupertino_viewfinder_circle"
    VIEWFINDER_CIRCLE_FILL = "cupertino_viewfinder_circle_fill"
    WAND_RAYS = "cupertino_wand_rays"
    WAND_RAYS_INVERSE = "cupertino_wand_rays_inverse"
    WAND_STARS = "cupertino_wand_stars"
    WAND_STARS_INVERSE = "cupertino_wand_stars_inverse"
    WAVEFORM = "cupertino_waveform"
    WAVEFORM_CIRCLE = "cupertino_waveform_circle"
    WAVEFORM_CIRCLE_FILL = "cupertino_waveform_circle_fill"
    WAVEFORM_PATH = "cupertino_waveform_path"
    WAVEFORM_PATH_BADGE_MINUS = "cupertino_waveform_path_badge_minus"
    WAVEFORM_PATH_BADGE_PLUS = "cupertino_waveform_path_badge_plus"
    WAVEFORM_PATH_ECG = "cupertino_waveform_path_ecg"
    WIFI = "cupertino_wifi"
    WIFI_EXCLAMATIONMARK = "cupertino_wifi_exclamationmark"
    WIFI_SLASH = "cupertino_wifi_slash"
    WIND = "cupertino_wind"
    WIND_SNOW = "cupertino_wind_snow"
    WRENCH = "cupertino_wrench"
    WRENCH_FILL = "cupertino_wrench_fill"
    XMARK = "cupertino_xmark"
    XMARK_CIRCLE = "cupertino_xmark_circle"
    XMARK_CIRCLE_FILL = "cupertino_xmark_circle_fill"
    XMARK_OCTAGON = "cupertino_xmark_octagon"
    XMARK_OCTAGON_FILL = "cupertino_xmark_octagon_fill"
    XMARK_RECTANGLE = "cupertino_xmark_rectangle"
    XMARK_RECTANGLE_FILL = "cupertino_xmark_rectangle_fill"
    XMARK_SEAL = "cupertino_xmark_seal"
    XMARK_SEAL_FILL = "cupertino_xmark_seal_fill"
    XMARK_SHIELD = "cupertino_xmark_shield"
    XMARK_SHIELD_FILL = "cupertino_xmark_shield_fill"
    XMARK_SQUARE = "cupertino_xmark_square"
    XMARK_SQUARE_FILL = "cupertino_xmark_square_fill"
    ZOOM_IN = "cupertino_zoom_in"
    ZOOM_OUT = "cupertino_zoom_out"
    ZZZ = "cupertino_zzz"
