"use strict";
var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r, _s, _t, _u;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CompositePrincipal = exports.StarPrincipal = exports.Anyone = exports.AnyPrincipal = exports.AccountRootPrincipal = exports.SamlConsolePrincipal = exports.SamlPrincipal = exports.OpenIdConnectPrincipal = exports.WebIdentityPrincipal = exports.FederatedPrincipal = exports.CanonicalUserPrincipal = exports.OrganizationPrincipal = exports.ServicePrincipal = exports.AccountPrincipal = exports.ArnPrincipal = exports.PrincipalPolicyFragment = exports.SessionTagsPrincipal = exports.PrincipalWithConditions = exports.PrincipalBase = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("@aws-cdk/core");
const region_info_1 = require("@aws-cdk/region-info");
const policy_statement_1 = require("./policy-statement");
const assume_role_policy_1 = require("./private/assume-role-policy");
const util_1 = require("./util");
/**
 * Base class for policy principals
 */
class PrincipalBase {
    constructor() {
        this.grantPrincipal = this;
        this.principalAccount = undefined;
        /**
         * When this Principal is used in an AssumeRole policy, the action to use.
         */
        this.assumeRoleAction = 'sts:AssumeRole';
    }
    addToPolicy(statement) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iam_PolicyStatement(statement);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addToPolicy);
            }
            throw error;
        }
        return this.addToPrincipalPolicy(statement).statementAdded;
    }
    addToPrincipalPolicy(_statement) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iam_PolicyStatement(_statement);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addToPrincipalPolicy);
            }
            throw error;
        }
        // This base class is used for non-identity principals. None of them
        // have a PolicyDocument to add to.
        return { statementAdded: false };
    }
    addToAssumeRolePolicy(document) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iam_PolicyDocument(document);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addToAssumeRolePolicy);
            }
            throw error;
        }
        // Default implementation of this protocol, compatible with the legacy behavior
        document.addStatements(new policy_statement_1.PolicyStatement({
            actions: [this.assumeRoleAction],
            principals: [this],
        }));
    }
    toString() {
        // This is a first pass to make the object readable. Descendant principals
        // should return something nicer.
        return JSON.stringify(this.policyFragment.principalJson);
    }
    /**
     * JSON-ify the principal
     *
     * Used when JSON.stringify() is called
     */
    toJSON() {
        // Have to implement toJSON() because the default will lead to infinite recursion.
        return this.policyFragment.principalJson;
    }
    /**
     * Returns a new PrincipalWithConditions using this principal as the base, with the
     * passed conditions added.
     *
     * When there is a value for the same operator and key in both the principal and the
     * conditions parameter, the value from the conditions parameter will be used.
     *
     * @returns a new PrincipalWithConditions object.
     */
    withConditions(conditions) {
        return new PrincipalWithConditions(this, conditions);
    }
    /**
     * Returns a new principal using this principal as the base, with session tags enabled.
     *
     * @returns a new SessionTagsPrincipal object.
     */
    withSessionTags() {
        return new SessionTagsPrincipal(this);
    }
}
exports.PrincipalBase = PrincipalBase;
_a = JSII_RTTI_SYMBOL_1;
PrincipalBase[_a] = { fqn: "@aws-cdk/aws-iam.PrincipalBase", version: "1.153.0" };
/**
 * Base class for Principals that wrap other principals
 */
class PrincipalAdapter extends PrincipalBase {
    constructor(wrapped) {
        super();
        this.wrapped = wrapped;
        this.assumeRoleAction = this.wrapped.assumeRoleAction;
        this.principalAccount = this.wrapped.principalAccount;
    }
    get policyFragment() { return this.wrapped.policyFragment; }
    addToPolicy(statement) {
        return this.wrapped.addToPolicy(statement);
    }
    addToPrincipalPolicy(statement) {
        return this.wrapped.addToPrincipalPolicy(statement);
    }
}
/**
 * An IAM principal with additional conditions specifying when the policy is in effect.
 *
 * For more information about conditions, see:
 * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition.html
 */
class PrincipalWithConditions extends PrincipalAdapter {
    constructor(principal, conditions) {
        super(principal);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iam_IPrincipal(principal);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        this.additionalConditions = conditions;
    }
    /**
     * Add a condition to the principal
     */
    addCondition(key, value) {
        const existingValue = this.additionalConditions[key];
        this.additionalConditions[key] = existingValue ? { ...existingValue, ...value } : value;
    }
    /**
     * Adds multiple conditions to the principal
     *
     * Values from the conditions parameter will overwrite existing values with the same operator
     * and key.
     */
    addConditions(conditions) {
        Object.entries(conditions).forEach(([key, value]) => {
            this.addCondition(key, value);
        });
    }
    /**
     * The conditions under which the policy is in effect.
     * See [the IAM documentation](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition.html).
     */
    get conditions() {
        return this.mergeConditions(this.wrapped.policyFragment.conditions, this.additionalConditions);
    }
    get policyFragment() {
        return new PrincipalPolicyFragment(this.wrapped.policyFragment.principalJson, this.conditions);
    }
    toString() {
        return this.wrapped.toString();
    }
    /**
     * JSON-ify the principal
     *
     * Used when JSON.stringify() is called
     */
    toJSON() {
        // Have to implement toJSON() because the default will lead to infinite recursion.
        return this.policyFragment.principalJson;
    }
    mergeConditions(principalConditions, additionalConditions) {
        const mergedConditions = {};
        Object.entries(principalConditions).forEach(([operator, condition]) => {
            mergedConditions[operator] = condition;
        });
        Object.entries(additionalConditions).forEach(([operator, condition]) => {
            // merge the conditions if one of the additional conditions uses an
            // operator that's already used by the principal's conditions merge the
            // inner structure.
            const existing = mergedConditions[operator];
            if (!existing) {
                mergedConditions[operator] = condition;
                return; // continue
            }
            // if either the existing condition or the new one contain unresolved
            // tokens, fail the merge. this is as far as we go at this point.
            if (cdk.Token.isUnresolved(condition) || cdk.Token.isUnresolved(existing)) {
                throw new Error(`multiple "${operator}" conditions cannot be merged if one of them contains an unresolved token`);
            }
            mergedConditions[operator] = { ...existing, ...condition };
        });
        return mergedConditions;
    }
}
exports.PrincipalWithConditions = PrincipalWithConditions;
_b = JSII_RTTI_SYMBOL_1;
PrincipalWithConditions[_b] = { fqn: "@aws-cdk/aws-iam.PrincipalWithConditions", version: "1.153.0" };
/**
 * Enables session tags on role assumptions from a principal
 *
 * For more information on session tags, see:
 * https://docs.aws.amazon.com/IAM/latest/UserGuide/id_session-tags.html
 */
class SessionTagsPrincipal extends PrincipalAdapter {
    constructor(principal) {
        super(principal);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iam_IPrincipal(principal);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
    }
    addToAssumeRolePolicy(doc) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iam_PolicyDocument(doc);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addToAssumeRolePolicy);
            }
            throw error;
        }
        // Lazy import to avoid circular import dependencies during startup
        // eslint-disable-next-line @typescript-eslint/no-require-imports
        const adapter = require('./private/policydoc-adapter');
        assume_role_policy_1.defaultAddPrincipalToAssumeRole(this.wrapped, new adapter.MutatingPolicyDocumentAdapter(doc, (statement) => {
            statement.addActions('sts:TagSession');
            return statement;
        }));
    }
}
exports.SessionTagsPrincipal = SessionTagsPrincipal;
_c = JSII_RTTI_SYMBOL_1;
SessionTagsPrincipal[_c] = { fqn: "@aws-cdk/aws-iam.SessionTagsPrincipal", version: "1.153.0" };
/**
 * A collection of the fields in a PolicyStatement that can be used to identify a principal.
 *
 * This consists of the JSON used in the "Principal" field, and optionally a
 * set of "Condition"s that need to be applied to the policy.
 *
 * Generally, a principal looks like:
 *
 *     { '<TYPE>': ['ID', 'ID', ...] }
 *
 * And this is also the type of the field `principalJson`.  However, there is a
 * special type of principal that is just the string '*', which is treated
 * differently by some services. To represent that principal, `principalJson`
 * should contain `{ 'LiteralString': ['*'] }`.
 */
class PrincipalPolicyFragment {
    /**
     *
     * @param principalJson JSON of the "Principal" section in a policy statement
     * @param conditions conditions that need to be applied to this policy
     */
    constructor(principalJson, 
    /**
     * The conditions under which the policy is in effect.
     * See [the IAM documentation](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition.html).
     */
    conditions = {}) {
        this.principalJson = principalJson;
        this.conditions = conditions;
    }
}
exports.PrincipalPolicyFragment = PrincipalPolicyFragment;
_d = JSII_RTTI_SYMBOL_1;
PrincipalPolicyFragment[_d] = { fqn: "@aws-cdk/aws-iam.PrincipalPolicyFragment", version: "1.153.0" };
/**
 * Specify a principal by the Amazon Resource Name (ARN).
 * You can specify AWS accounts, IAM users, Federated SAML users, IAM roles, and specific assumed-role sessions.
 * You cannot specify IAM groups or instance profiles as principals
 *
 * @see https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html
 */
class ArnPrincipal extends PrincipalBase {
    /**
     *
     * @param arn Amazon Resource Name (ARN) of the principal entity (i.e. arn:aws:iam::123456789012:user/user-name)
     */
    constructor(arn) {
        super();
        this.arn = arn;
    }
    get policyFragment() {
        return new PrincipalPolicyFragment({ AWS: [this.arn] });
    }
    toString() {
        return `ArnPrincipal(${this.arn})`;
    }
}
exports.ArnPrincipal = ArnPrincipal;
_e = JSII_RTTI_SYMBOL_1;
ArnPrincipal[_e] = { fqn: "@aws-cdk/aws-iam.ArnPrincipal", version: "1.153.0" };
/**
 * Specify AWS account ID as the principal entity in a policy to delegate authority to the account.
 */
class AccountPrincipal extends ArnPrincipal {
    /**
     *
     * @param accountId AWS account ID (i.e. 123456789012)
     */
    constructor(accountId) {
        super(new StackDependentToken(stack => `arn:${stack.partition}:iam::${accountId}:root`).toString());
        this.accountId = accountId;
        this.principalAccount = accountId;
    }
    toString() {
        return `AccountPrincipal(${this.accountId})`;
    }
}
exports.AccountPrincipal = AccountPrincipal;
_f = JSII_RTTI_SYMBOL_1;
AccountPrincipal[_f] = { fqn: "@aws-cdk/aws-iam.AccountPrincipal", version: "1.153.0" };
/**
 * An IAM principal that represents an AWS service (i.e. sqs.amazonaws.com).
 */
class ServicePrincipal extends PrincipalBase {
    /**
     *
     * @param service AWS service (i.e. sqs.amazonaws.com)
     */
    constructor(service, opts = {}) {
        super();
        this.service = service;
        this.opts = opts;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iam_ServicePrincipalOpts(opts);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
    }
    get policyFragment() {
        return new PrincipalPolicyFragment({
            Service: [
                new ServicePrincipalToken(this.service, this.opts).toString(),
            ],
        }, this.opts.conditions);
    }
    toString() {
        return `ServicePrincipal(${this.service})`;
    }
}
exports.ServicePrincipal = ServicePrincipal;
_g = JSII_RTTI_SYMBOL_1;
ServicePrincipal[_g] = { fqn: "@aws-cdk/aws-iam.ServicePrincipal", version: "1.153.0" };
/**
 * A principal that represents an AWS Organization
 */
class OrganizationPrincipal extends PrincipalBase {
    /**
     *
     * @param organizationId The unique identifier (ID) of an organization (i.e. o-12345abcde)
     */
    constructor(organizationId) {
        super();
        this.organizationId = organizationId;
    }
    get policyFragment() {
        return new PrincipalPolicyFragment({ AWS: ['*'] }, { StringEquals: { 'aws:PrincipalOrgID': this.organizationId } });
    }
    toString() {
        return `OrganizationPrincipal(${this.organizationId})`;
    }
}
exports.OrganizationPrincipal = OrganizationPrincipal;
_h = JSII_RTTI_SYMBOL_1;
OrganizationPrincipal[_h] = { fqn: "@aws-cdk/aws-iam.OrganizationPrincipal", version: "1.153.0" };
/**
 * A policy principal for canonicalUserIds - useful for S3 bucket policies that use
 * Origin Access identities.
 *
 * See https://docs.aws.amazon.com/general/latest/gr/acct-identifiers.html
 *
 * and
 *
 * https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-restricting-access-to-s3.html
 *
 * for more details.
 *
 */
class CanonicalUserPrincipal extends PrincipalBase {
    /**
     *
     * @param canonicalUserId unique identifier assigned by AWS for every account.
     *   root user and IAM users for an account all see the same ID.
     *   (i.e. 79a59df900b949e55d96a1e698fbacedfd6e09d98eacf8f8d5218e7cd47ef2be)
     */
    constructor(canonicalUserId) {
        super();
        this.canonicalUserId = canonicalUserId;
    }
    get policyFragment() {
        return new PrincipalPolicyFragment({ CanonicalUser: [this.canonicalUserId] });
    }
    toString() {
        return `CanonicalUserPrincipal(${this.canonicalUserId})`;
    }
}
exports.CanonicalUserPrincipal = CanonicalUserPrincipal;
_j = JSII_RTTI_SYMBOL_1;
CanonicalUserPrincipal[_j] = { fqn: "@aws-cdk/aws-iam.CanonicalUserPrincipal", version: "1.153.0" };
/**
 * Principal entity that represents a federated identity provider such as Amazon Cognito,
 * that can be used to provide temporary security credentials to users who have been authenticated.
 * Additional condition keys are available when the temporary security credentials are used to make a request.
 * You can use these keys to write policies that limit the access of federated users.
 *
 * @see https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_iam-condition-keys.html#condition-keys-wif
 */
class FederatedPrincipal extends PrincipalBase {
    /**
     *
     * @param federated federated identity provider (i.e. 'cognito-identity.amazonaws.com' for users authenticated through Cognito)
     * @param conditions The conditions under which the policy is in effect.
     *   See [the IAM documentation](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition.html).
     * @param sessionTags Whether to enable session tagging (see https://docs.aws.amazon.com/IAM/latest/UserGuide/id_session-tags.html)
     */
    constructor(federated, conditions, assumeRoleAction = 'sts:AssumeRole') {
        super();
        this.federated = federated;
        this.conditions = conditions;
        this.assumeRoleAction = assumeRoleAction;
    }
    get policyFragment() {
        return new PrincipalPolicyFragment({ Federated: [this.federated] }, this.conditions);
    }
    toString() {
        return `FederatedPrincipal(${this.federated})`;
    }
}
exports.FederatedPrincipal = FederatedPrincipal;
_k = JSII_RTTI_SYMBOL_1;
FederatedPrincipal[_k] = { fqn: "@aws-cdk/aws-iam.FederatedPrincipal", version: "1.153.0" };
/**
 * A principal that represents a federated identity provider as Web Identity such as Cognito, Amazon,
 * Facebook, Google, etc.
 */
class WebIdentityPrincipal extends FederatedPrincipal {
    /**
     *
     * @param identityProvider identity provider (i.e. 'cognito-identity.amazonaws.com' for users authenticated through Cognito)
     * @param conditions The conditions under which the policy is in effect.
     *   See [the IAM documentation](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition.html).
     * @param sessionTags Whether to enable session tagging (see https://docs.aws.amazon.com/IAM/latest/UserGuide/id_session-tags.html)
     */
    constructor(identityProvider, conditions = {}) {
        super(identityProvider, conditions !== null && conditions !== void 0 ? conditions : {}, 'sts:AssumeRoleWithWebIdentity');
    }
    get policyFragment() {
        return new PrincipalPolicyFragment({ Federated: [this.federated] }, this.conditions);
    }
    toString() {
        return `WebIdentityPrincipal(${this.federated})`;
    }
}
exports.WebIdentityPrincipal = WebIdentityPrincipal;
_l = JSII_RTTI_SYMBOL_1;
WebIdentityPrincipal[_l] = { fqn: "@aws-cdk/aws-iam.WebIdentityPrincipal", version: "1.153.0" };
/**
 * A principal that represents a federated identity provider as from a OpenID Connect provider.
 */
class OpenIdConnectPrincipal extends WebIdentityPrincipal {
    /**
     *
     * @param openIdConnectProvider OpenID Connect provider
     * @param conditions The conditions under which the policy is in effect.
     *   See [the IAM documentation](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition.html).
     */
    constructor(openIdConnectProvider, conditions = {}) {
        super(openIdConnectProvider.openIdConnectProviderArn, conditions !== null && conditions !== void 0 ? conditions : {});
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iam_IOpenIdConnectProvider(openIdConnectProvider);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
    }
    get policyFragment() {
        return new PrincipalPolicyFragment({ Federated: [this.federated] }, this.conditions);
    }
    toString() {
        return `OpenIdConnectPrincipal(${this.federated})`;
    }
}
exports.OpenIdConnectPrincipal = OpenIdConnectPrincipal;
_m = JSII_RTTI_SYMBOL_1;
OpenIdConnectPrincipal[_m] = { fqn: "@aws-cdk/aws-iam.OpenIdConnectPrincipal", version: "1.153.0" };
/**
 * Principal entity that represents a SAML federated identity provider
 */
class SamlPrincipal extends FederatedPrincipal {
    constructor(samlProvider, conditions) {
        super(samlProvider.samlProviderArn, conditions, 'sts:AssumeRoleWithSAML');
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iam_ISamlProvider(samlProvider);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
    }
    toString() {
        return `SamlPrincipal(${this.federated})`;
    }
}
exports.SamlPrincipal = SamlPrincipal;
_o = JSII_RTTI_SYMBOL_1;
SamlPrincipal[_o] = { fqn: "@aws-cdk/aws-iam.SamlPrincipal", version: "1.153.0" };
/**
 * Principal entity that represents a SAML federated identity provider for
 * programmatic and AWS Management Console access.
 */
class SamlConsolePrincipal extends SamlPrincipal {
    constructor(samlProvider, conditions = {}) {
        super(samlProvider, {
            ...conditions,
            StringEquals: {
                'SAML:aud': 'https://signin.aws.amazon.com/saml',
            },
        });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iam_ISamlProvider(samlProvider);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
    }
    toString() {
        return `SamlConsolePrincipal(${this.federated})`;
    }
}
exports.SamlConsolePrincipal = SamlConsolePrincipal;
_p = JSII_RTTI_SYMBOL_1;
SamlConsolePrincipal[_p] = { fqn: "@aws-cdk/aws-iam.SamlConsolePrincipal", version: "1.153.0" };
/**
 * Use the AWS account into which a stack is deployed as the principal entity in a policy
 */
class AccountRootPrincipal extends AccountPrincipal {
    constructor() {
        super(new StackDependentToken(stack => stack.account).toString());
    }
    toString() {
        return 'AccountRootPrincipal()';
    }
}
exports.AccountRootPrincipal = AccountRootPrincipal;
_q = JSII_RTTI_SYMBOL_1;
AccountRootPrincipal[_q] = { fqn: "@aws-cdk/aws-iam.AccountRootPrincipal", version: "1.153.0" };
/**
 * A principal representing all AWS identities in all accounts
 *
 * Some services behave differently when you specify `Principal: '*'`
 * or `Principal: { AWS: "*" }` in their resource policy.
 *
 * `AnyPrincipal` renders to `Principal: { AWS: "*" }`. This is correct
 * most of the time, but in cases where you need the other principal,
 * use `StarPrincipal` instead.
 */
class AnyPrincipal extends ArnPrincipal {
    constructor() {
        super('*');
    }
    toString() {
        return 'AnyPrincipal()';
    }
}
exports.AnyPrincipal = AnyPrincipal;
_r = JSII_RTTI_SYMBOL_1;
AnyPrincipal[_r] = { fqn: "@aws-cdk/aws-iam.AnyPrincipal", version: "1.153.0" };
/**
 * A principal representing all identities in all accounts
 * @deprecated use `AnyPrincipal`
 */
class Anyone extends AnyPrincipal {
}
exports.Anyone = Anyone;
_s = JSII_RTTI_SYMBOL_1;
Anyone[_s] = { fqn: "@aws-cdk/aws-iam.Anyone", version: "1.153.0" };
/**
 * A principal that uses a literal '*' in the IAM JSON language
 *
 * Some services behave differently when you specify `Principal: "*"`
 * or `Principal: { AWS: "*" }` in their resource policy.
 *
 * `StarPrincipal` renders to `Principal: *`. Most of the time, you
 * should use `AnyPrincipal` instead.
 */
class StarPrincipal extends PrincipalBase {
    constructor() {
        super(...arguments);
        this.policyFragment = {
            principalJson: { [util_1.LITERAL_STRING_KEY]: ['*'] },
            conditions: {},
        };
    }
    toString() {
        return 'StarPrincipal()';
    }
}
exports.StarPrincipal = StarPrincipal;
_t = JSII_RTTI_SYMBOL_1;
StarPrincipal[_t] = { fqn: "@aws-cdk/aws-iam.StarPrincipal", version: "1.153.0" };
/**
 * Represents a principal that has multiple types of principals. A composite principal cannot
 * have conditions. i.e. multiple ServicePrincipals that form a composite principal
 */
class CompositePrincipal extends PrincipalBase {
    constructor(...principals) {
        super();
        this.principals = new Array();
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iam_IPrincipal(principals);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        if (principals.length === 0) {
            throw new Error('CompositePrincipals must be constructed with at least 1 Principal but none were passed.');
        }
        this.assumeRoleAction = principals[0].assumeRoleAction;
        this.addPrincipals(...principals);
    }
    /**
     * Adds IAM principals to the composite principal. Composite principals cannot have
     * conditions.
     *
     * @param principals IAM principals that will be added to the composite principal
     */
    addPrincipals(...principals) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iam_IPrincipal(principals);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addPrincipals);
            }
            throw error;
        }
        this.principals.push(...principals);
        return this;
    }
    addToAssumeRolePolicy(doc) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iam_PolicyDocument(doc);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addToAssumeRolePolicy);
            }
            throw error;
        }
        for (const p of this.principals) {
            assume_role_policy_1.defaultAddPrincipalToAssumeRole(p, doc);
        }
    }
    get policyFragment() {
        // We only have a problem with conditions if we are trying to render composite
        // princpals into a single statement (which is when `policyFragment` would get called)
        for (const p of this.principals) {
            const fragment = p.policyFragment;
            if (fragment.conditions && Object.keys(fragment.conditions).length > 0) {
                throw new Error('Components of a CompositePrincipal must not have conditions. ' +
                    `Tried to add the following fragment: ${JSON.stringify(fragment)}`);
            }
        }
        const principalJson = {};
        for (const p of this.principals) {
            util_1.mergePrincipal(principalJson, p.policyFragment.principalJson);
        }
        return new PrincipalPolicyFragment(principalJson);
    }
    toString() {
        return `CompositePrincipal(${this.principals})`;
    }
}
exports.CompositePrincipal = CompositePrincipal;
_u = JSII_RTTI_SYMBOL_1;
CompositePrincipal[_u] = { fqn: "@aws-cdk/aws-iam.CompositePrincipal", version: "1.153.0" };
/**
 * A lazy token that requires an instance of Stack to evaluate
 */
class StackDependentToken {
    constructor(fn) {
        this.fn = fn;
        this.creationStack = cdk.captureStackTrace();
    }
    resolve(context) {
        return this.fn(cdk.Stack.of(context.scope));
    }
    toString() {
        return cdk.Token.asString(this);
    }
    /**
     * JSON-ify the token
     *
     * Used when JSON.stringify() is called
     */
    toJSON() {
        return '<unresolved-token>';
    }
}
class ServicePrincipalToken {
    constructor(service, opts) {
        this.service = service;
        this.opts = opts;
        this.creationStack = cdk.captureStackTrace();
    }
    resolve(ctx) {
        var _v;
        if (this.opts.region) {
            // Special case, handle it separately to not break legacy behavior.
            return (_v = region_info_1.RegionInfo.get(this.opts.region).servicePrincipal(this.service)) !== null && _v !== void 0 ? _v : region_info_1.Default.servicePrincipal(this.service, this.opts.region, cdk.Aws.URL_SUFFIX);
        }
        const stack = cdk.Stack.of(ctx.scope);
        return stack.regionalFact(region_info_1.FactName.servicePrincipal(this.service), region_info_1.Default.servicePrincipal(this.service, stack.region, cdk.Aws.URL_SUFFIX));
    }
    toString() {
        return cdk.Token.asString(this, {
            displayHint: this.service,
        });
    }
    /**
     * JSON-ify the token
     *
     * Used when JSON.stringify() is called
     */
    toJSON() {
        return `<${this.service}>`;
    }
}
//# sourceMappingURL=data:application/json;base64,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