"""
    用于预处理库的中文数字字符映射
"""
data: dict = {
    "零": "零",
    "一": "一",
    "二": "二",
    "三": "三",
    "四": "四",
    "五": "五",
    "六": "六",
    "七": "七",
    "八": "八",
    "九": "九",
    "〇": "零",
    "壹": "一",
    "贰": "二",
    "叁": "三",
    "肆": "四",
    "伍": "五",
    "柒": "七",
    "捌": "八",
    "玖": "九",
    "佰": "百",
    "仟": "千",
    "俩": "二",
    "两": "二",
    "仨": "三",
}

data_numerical: dict = {
    "零": "0",
    "一": "1",
    "二": "2",
    "三": "3",
    "四": "4",
    "五": "5",
    "六": "6",
    "七": "7",
    "八": "8",
    "九": "9",
}

# 可能存在歧义替换
data_ambiguous: dict = {
    "陆": "六",
    "拾": "十",
}

data_precise: dict = {
    r"(?=[\d一二三四五六七八九十拾陆百千万亿])拾": "十",
    r"拾(?=[\d一二三四五六七八九十拾陆百千万亿])": "十",
    r"(?<=[\d一二三四五六七八九十拾陆百千万亿])陆": "六",
    r"陆(?=[\d一二三四五六七八九十拾陆百千万亿])": "六",
}
