# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ApplianceSingleLanArgs', 'ApplianceSingleLan']

@pulumi.input_type
class ApplianceSingleLanArgs:
    def __init__(__self__, *,
                 network_id: pulumi.Input[str],
                 appliance_ip: Optional[pulumi.Input[str]] = None,
                 ipv6: Optional[pulumi.Input['ApplianceSingleLanIpv6Args']] = None,
                 mandatory_dhcp: Optional[pulumi.Input['ApplianceSingleLanMandatoryDhcpArgs']] = None,
                 subnet: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a ApplianceSingleLan resource.
        :param pulumi.Input[str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[str] appliance_ip: The local IP of the appliance on the single LAN
        :param pulumi.Input['ApplianceSingleLanIpv6Args'] ipv6: IPv6 configuration on the single LAN
        :param pulumi.Input['ApplianceSingleLanMandatoryDhcpArgs'] mandatory_dhcp: Mandatory DHCP will enforce that clients connecting to this single LAN must use the IP address assigned by the DHCP server. Clients who use a static IP address won't be able to associate. Only available on firmware versions 17.0 and above
        :param pulumi.Input[str] subnet: The subnet of the single LAN
        """
        pulumi.set(__self__, "network_id", network_id)
        if appliance_ip is not None:
            pulumi.set(__self__, "appliance_ip", appliance_ip)
        if ipv6 is not None:
            pulumi.set(__self__, "ipv6", ipv6)
        if mandatory_dhcp is not None:
            pulumi.set(__self__, "mandatory_dhcp", mandatory_dhcp)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Input[str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter(name="applianceIp")
    def appliance_ip(self) -> Optional[pulumi.Input[str]]:
        """
        The local IP of the appliance on the single LAN
        """
        return pulumi.get(self, "appliance_ip")

    @appliance_ip.setter
    def appliance_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "appliance_ip", value)

    @property
    @pulumi.getter
    def ipv6(self) -> Optional[pulumi.Input['ApplianceSingleLanIpv6Args']]:
        """
        IPv6 configuration on the single LAN
        """
        return pulumi.get(self, "ipv6")

    @ipv6.setter
    def ipv6(self, value: Optional[pulumi.Input['ApplianceSingleLanIpv6Args']]):
        pulumi.set(self, "ipv6", value)

    @property
    @pulumi.getter(name="mandatoryDhcp")
    def mandatory_dhcp(self) -> Optional[pulumi.Input['ApplianceSingleLanMandatoryDhcpArgs']]:
        """
        Mandatory DHCP will enforce that clients connecting to this single LAN must use the IP address assigned by the DHCP server. Clients who use a static IP address won't be able to associate. Only available on firmware versions 17.0 and above
        """
        return pulumi.get(self, "mandatory_dhcp")

    @mandatory_dhcp.setter
    def mandatory_dhcp(self, value: Optional[pulumi.Input['ApplianceSingleLanMandatoryDhcpArgs']]):
        pulumi.set(self, "mandatory_dhcp", value)

    @property
    @pulumi.getter
    def subnet(self) -> Optional[pulumi.Input[str]]:
        """
        The subnet of the single LAN
        """
        return pulumi.get(self, "subnet")

    @subnet.setter
    def subnet(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet", value)


@pulumi.input_type
class _ApplianceSingleLanState:
    def __init__(__self__, *,
                 appliance_ip: Optional[pulumi.Input[str]] = None,
                 ipv6: Optional[pulumi.Input['ApplianceSingleLanIpv6Args']] = None,
                 mandatory_dhcp: Optional[pulumi.Input['ApplianceSingleLanMandatoryDhcpArgs']] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 subnet: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ApplianceSingleLan resources.
        :param pulumi.Input[str] appliance_ip: The local IP of the appliance on the single LAN
        :param pulumi.Input['ApplianceSingleLanIpv6Args'] ipv6: IPv6 configuration on the single LAN
        :param pulumi.Input['ApplianceSingleLanMandatoryDhcpArgs'] mandatory_dhcp: Mandatory DHCP will enforce that clients connecting to this single LAN must use the IP address assigned by the DHCP server. Clients who use a static IP address won't be able to associate. Only available on firmware versions 17.0 and above
        :param pulumi.Input[str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[str] subnet: The subnet of the single LAN
        """
        if appliance_ip is not None:
            pulumi.set(__self__, "appliance_ip", appliance_ip)
        if ipv6 is not None:
            pulumi.set(__self__, "ipv6", ipv6)
        if mandatory_dhcp is not None:
            pulumi.set(__self__, "mandatory_dhcp", mandatory_dhcp)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)

    @property
    @pulumi.getter(name="applianceIp")
    def appliance_ip(self) -> Optional[pulumi.Input[str]]:
        """
        The local IP of the appliance on the single LAN
        """
        return pulumi.get(self, "appliance_ip")

    @appliance_ip.setter
    def appliance_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "appliance_ip", value)

    @property
    @pulumi.getter
    def ipv6(self) -> Optional[pulumi.Input['ApplianceSingleLanIpv6Args']]:
        """
        IPv6 configuration on the single LAN
        """
        return pulumi.get(self, "ipv6")

    @ipv6.setter
    def ipv6(self, value: Optional[pulumi.Input['ApplianceSingleLanIpv6Args']]):
        pulumi.set(self, "ipv6", value)

    @property
    @pulumi.getter(name="mandatoryDhcp")
    def mandatory_dhcp(self) -> Optional[pulumi.Input['ApplianceSingleLanMandatoryDhcpArgs']]:
        """
        Mandatory DHCP will enforce that clients connecting to this single LAN must use the IP address assigned by the DHCP server. Clients who use a static IP address won't be able to associate. Only available on firmware versions 17.0 and above
        """
        return pulumi.get(self, "mandatory_dhcp")

    @mandatory_dhcp.setter
    def mandatory_dhcp(self, value: Optional[pulumi.Input['ApplianceSingleLanMandatoryDhcpArgs']]):
        pulumi.set(self, "mandatory_dhcp", value)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[str]]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter
    def subnet(self) -> Optional[pulumi.Input[str]]:
        """
        The subnet of the single LAN
        """
        return pulumi.get(self, "subnet")

    @subnet.setter
    def subnet(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet", value)


class ApplianceSingleLan(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 appliance_ip: Optional[pulumi.Input[str]] = None,
                 ipv6: Optional[pulumi.Input[Union['ApplianceSingleLanIpv6Args', 'ApplianceSingleLanIpv6ArgsDict']]] = None,
                 mandatory_dhcp: Optional[pulumi.Input[Union['ApplianceSingleLanMandatoryDhcpArgs', 'ApplianceSingleLanMandatoryDhcpArgsDict']]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 subnet: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import meraki:networks/applianceSingleLan:ApplianceSingleLan example "network_id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] appliance_ip: The local IP of the appliance on the single LAN
        :param pulumi.Input[Union['ApplianceSingleLanIpv6Args', 'ApplianceSingleLanIpv6ArgsDict']] ipv6: IPv6 configuration on the single LAN
        :param pulumi.Input[Union['ApplianceSingleLanMandatoryDhcpArgs', 'ApplianceSingleLanMandatoryDhcpArgsDict']] mandatory_dhcp: Mandatory DHCP will enforce that clients connecting to this single LAN must use the IP address assigned by the DHCP server. Clients who use a static IP address won't be able to associate. Only available on firmware versions 17.0 and above
        :param pulumi.Input[str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[str] subnet: The subnet of the single LAN
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ApplianceSingleLanArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import meraki:networks/applianceSingleLan:ApplianceSingleLan example "network_id"
        ```

        :param str resource_name: The name of the resource.
        :param ApplianceSingleLanArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ApplianceSingleLanArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 appliance_ip: Optional[pulumi.Input[str]] = None,
                 ipv6: Optional[pulumi.Input[Union['ApplianceSingleLanIpv6Args', 'ApplianceSingleLanIpv6ArgsDict']]] = None,
                 mandatory_dhcp: Optional[pulumi.Input[Union['ApplianceSingleLanMandatoryDhcpArgs', 'ApplianceSingleLanMandatoryDhcpArgsDict']]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 subnet: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ApplianceSingleLanArgs.__new__(ApplianceSingleLanArgs)

            __props__.__dict__["appliance_ip"] = appliance_ip
            __props__.__dict__["ipv6"] = ipv6
            __props__.__dict__["mandatory_dhcp"] = mandatory_dhcp
            if network_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_id'")
            __props__.__dict__["network_id"] = network_id
            __props__.__dict__["subnet"] = subnet
        super(ApplianceSingleLan, __self__).__init__(
            'meraki:networks/applianceSingleLan:ApplianceSingleLan',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            appliance_ip: Optional[pulumi.Input[str]] = None,
            ipv6: Optional[pulumi.Input[Union['ApplianceSingleLanIpv6Args', 'ApplianceSingleLanIpv6ArgsDict']]] = None,
            mandatory_dhcp: Optional[pulumi.Input[Union['ApplianceSingleLanMandatoryDhcpArgs', 'ApplianceSingleLanMandatoryDhcpArgsDict']]] = None,
            network_id: Optional[pulumi.Input[str]] = None,
            subnet: Optional[pulumi.Input[str]] = None) -> 'ApplianceSingleLan':
        """
        Get an existing ApplianceSingleLan resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] appliance_ip: The local IP of the appliance on the single LAN
        :param pulumi.Input[Union['ApplianceSingleLanIpv6Args', 'ApplianceSingleLanIpv6ArgsDict']] ipv6: IPv6 configuration on the single LAN
        :param pulumi.Input[Union['ApplianceSingleLanMandatoryDhcpArgs', 'ApplianceSingleLanMandatoryDhcpArgsDict']] mandatory_dhcp: Mandatory DHCP will enforce that clients connecting to this single LAN must use the IP address assigned by the DHCP server. Clients who use a static IP address won't be able to associate. Only available on firmware versions 17.0 and above
        :param pulumi.Input[str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[str] subnet: The subnet of the single LAN
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ApplianceSingleLanState.__new__(_ApplianceSingleLanState)

        __props__.__dict__["appliance_ip"] = appliance_ip
        __props__.__dict__["ipv6"] = ipv6
        __props__.__dict__["mandatory_dhcp"] = mandatory_dhcp
        __props__.__dict__["network_id"] = network_id
        __props__.__dict__["subnet"] = subnet
        return ApplianceSingleLan(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="applianceIp")
    def appliance_ip(self) -> pulumi.Output[str]:
        """
        The local IP of the appliance on the single LAN
        """
        return pulumi.get(self, "appliance_ip")

    @property
    @pulumi.getter
    def ipv6(self) -> pulumi.Output['outputs.ApplianceSingleLanIpv6']:
        """
        IPv6 configuration on the single LAN
        """
        return pulumi.get(self, "ipv6")

    @property
    @pulumi.getter(name="mandatoryDhcp")
    def mandatory_dhcp(self) -> pulumi.Output['outputs.ApplianceSingleLanMandatoryDhcp']:
        """
        Mandatory DHCP will enforce that clients connecting to this single LAN must use the IP address assigned by the DHCP server. Clients who use a static IP address won't be able to associate. Only available on firmware versions 17.0 and above
        """
        return pulumi.get(self, "mandatory_dhcp")

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Output[str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @property
    @pulumi.getter
    def subnet(self) -> pulumi.Output[str]:
        """
        The subnet of the single LAN
        """
        return pulumi.get(self, "subnet")

