# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SwitchSettingsArgs', 'SwitchSettings']

@pulumi.input_type
class SwitchSettingsArgs:
    def __init__(__self__, *,
                 network_id: pulumi.Input[str],
                 mac_blocklist: Optional[pulumi.Input['SwitchSettingsMacBlocklistArgs']] = None,
                 power_exceptions: Optional[pulumi.Input[Sequence[pulumi.Input['SwitchSettingsPowerExceptionArgs']]]] = None,
                 uplink_client_sampling: Optional[pulumi.Input['SwitchSettingsUplinkClientSamplingArgs']] = None,
                 use_combined_power: Optional[pulumi.Input[bool]] = None,
                 vlan: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a SwitchSettings resource.
        :param pulumi.Input[str] network_id: networkId path parameter. Network ID
        :param pulumi.Input['SwitchSettingsMacBlocklistArgs'] mac_blocklist: MAC blocklist
        :param pulumi.Input[Sequence[pulumi.Input['SwitchSettingsPowerExceptionArgs']]] power_exceptions: Exceptions on a per switch basis to "useCombinedPower"
        :param pulumi.Input['SwitchSettingsUplinkClientSamplingArgs'] uplink_client_sampling: Uplink client sampling
        :param pulumi.Input[bool] use_combined_power: The use Combined Power as the default behavior of secondary power supplies on supported devices.
        :param pulumi.Input[int] vlan: Management VLAN
        """
        pulumi.set(__self__, "network_id", network_id)
        if mac_blocklist is not None:
            pulumi.set(__self__, "mac_blocklist", mac_blocklist)
        if power_exceptions is not None:
            pulumi.set(__self__, "power_exceptions", power_exceptions)
        if uplink_client_sampling is not None:
            pulumi.set(__self__, "uplink_client_sampling", uplink_client_sampling)
        if use_combined_power is not None:
            pulumi.set(__self__, "use_combined_power", use_combined_power)
        if vlan is not None:
            pulumi.set(__self__, "vlan", vlan)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Input[str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter(name="macBlocklist")
    def mac_blocklist(self) -> Optional[pulumi.Input['SwitchSettingsMacBlocklistArgs']]:
        """
        MAC blocklist
        """
        return pulumi.get(self, "mac_blocklist")

    @mac_blocklist.setter
    def mac_blocklist(self, value: Optional[pulumi.Input['SwitchSettingsMacBlocklistArgs']]):
        pulumi.set(self, "mac_blocklist", value)

    @property
    @pulumi.getter(name="powerExceptions")
    def power_exceptions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SwitchSettingsPowerExceptionArgs']]]]:
        """
        Exceptions on a per switch basis to "useCombinedPower"
        """
        return pulumi.get(self, "power_exceptions")

    @power_exceptions.setter
    def power_exceptions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SwitchSettingsPowerExceptionArgs']]]]):
        pulumi.set(self, "power_exceptions", value)

    @property
    @pulumi.getter(name="uplinkClientSampling")
    def uplink_client_sampling(self) -> Optional[pulumi.Input['SwitchSettingsUplinkClientSamplingArgs']]:
        """
        Uplink client sampling
        """
        return pulumi.get(self, "uplink_client_sampling")

    @uplink_client_sampling.setter
    def uplink_client_sampling(self, value: Optional[pulumi.Input['SwitchSettingsUplinkClientSamplingArgs']]):
        pulumi.set(self, "uplink_client_sampling", value)

    @property
    @pulumi.getter(name="useCombinedPower")
    def use_combined_power(self) -> Optional[pulumi.Input[bool]]:
        """
        The use Combined Power as the default behavior of secondary power supplies on supported devices.
        """
        return pulumi.get(self, "use_combined_power")

    @use_combined_power.setter
    def use_combined_power(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_combined_power", value)

    @property
    @pulumi.getter
    def vlan(self) -> Optional[pulumi.Input[int]]:
        """
        Management VLAN
        """
        return pulumi.get(self, "vlan")

    @vlan.setter
    def vlan(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "vlan", value)


@pulumi.input_type
class _SwitchSettingsState:
    def __init__(__self__, *,
                 mac_blocklist: Optional[pulumi.Input['SwitchSettingsMacBlocklistArgs']] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 power_exceptions: Optional[pulumi.Input[Sequence[pulumi.Input['SwitchSettingsPowerExceptionArgs']]]] = None,
                 uplink_client_sampling: Optional[pulumi.Input['SwitchSettingsUplinkClientSamplingArgs']] = None,
                 use_combined_power: Optional[pulumi.Input[bool]] = None,
                 vlan: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering SwitchSettings resources.
        :param pulumi.Input['SwitchSettingsMacBlocklistArgs'] mac_blocklist: MAC blocklist
        :param pulumi.Input[str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[Sequence[pulumi.Input['SwitchSettingsPowerExceptionArgs']]] power_exceptions: Exceptions on a per switch basis to "useCombinedPower"
        :param pulumi.Input['SwitchSettingsUplinkClientSamplingArgs'] uplink_client_sampling: Uplink client sampling
        :param pulumi.Input[bool] use_combined_power: The use Combined Power as the default behavior of secondary power supplies on supported devices.
        :param pulumi.Input[int] vlan: Management VLAN
        """
        if mac_blocklist is not None:
            pulumi.set(__self__, "mac_blocklist", mac_blocklist)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if power_exceptions is not None:
            pulumi.set(__self__, "power_exceptions", power_exceptions)
        if uplink_client_sampling is not None:
            pulumi.set(__self__, "uplink_client_sampling", uplink_client_sampling)
        if use_combined_power is not None:
            pulumi.set(__self__, "use_combined_power", use_combined_power)
        if vlan is not None:
            pulumi.set(__self__, "vlan", vlan)

    @property
    @pulumi.getter(name="macBlocklist")
    def mac_blocklist(self) -> Optional[pulumi.Input['SwitchSettingsMacBlocklistArgs']]:
        """
        MAC blocklist
        """
        return pulumi.get(self, "mac_blocklist")

    @mac_blocklist.setter
    def mac_blocklist(self, value: Optional[pulumi.Input['SwitchSettingsMacBlocklistArgs']]):
        pulumi.set(self, "mac_blocklist", value)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[str]]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter(name="powerExceptions")
    def power_exceptions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SwitchSettingsPowerExceptionArgs']]]]:
        """
        Exceptions on a per switch basis to "useCombinedPower"
        """
        return pulumi.get(self, "power_exceptions")

    @power_exceptions.setter
    def power_exceptions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SwitchSettingsPowerExceptionArgs']]]]):
        pulumi.set(self, "power_exceptions", value)

    @property
    @pulumi.getter(name="uplinkClientSampling")
    def uplink_client_sampling(self) -> Optional[pulumi.Input['SwitchSettingsUplinkClientSamplingArgs']]:
        """
        Uplink client sampling
        """
        return pulumi.get(self, "uplink_client_sampling")

    @uplink_client_sampling.setter
    def uplink_client_sampling(self, value: Optional[pulumi.Input['SwitchSettingsUplinkClientSamplingArgs']]):
        pulumi.set(self, "uplink_client_sampling", value)

    @property
    @pulumi.getter(name="useCombinedPower")
    def use_combined_power(self) -> Optional[pulumi.Input[bool]]:
        """
        The use Combined Power as the default behavior of secondary power supplies on supported devices.
        """
        return pulumi.get(self, "use_combined_power")

    @use_combined_power.setter
    def use_combined_power(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_combined_power", value)

    @property
    @pulumi.getter
    def vlan(self) -> Optional[pulumi.Input[int]]:
        """
        Management VLAN
        """
        return pulumi.get(self, "vlan")

    @vlan.setter
    def vlan(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "vlan", value)


class SwitchSettings(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 mac_blocklist: Optional[pulumi.Input[Union['SwitchSettingsMacBlocklistArgs', 'SwitchSettingsMacBlocklistArgsDict']]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 power_exceptions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SwitchSettingsPowerExceptionArgs', 'SwitchSettingsPowerExceptionArgsDict']]]]] = None,
                 uplink_client_sampling: Optional[pulumi.Input[Union['SwitchSettingsUplinkClientSamplingArgs', 'SwitchSettingsUplinkClientSamplingArgsDict']]] = None,
                 use_combined_power: Optional[pulumi.Input[bool]] = None,
                 vlan: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import meraki:networks/switchSettings:SwitchSettings example "network_id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['SwitchSettingsMacBlocklistArgs', 'SwitchSettingsMacBlocklistArgsDict']] mac_blocklist: MAC blocklist
        :param pulumi.Input[str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[Sequence[pulumi.Input[Union['SwitchSettingsPowerExceptionArgs', 'SwitchSettingsPowerExceptionArgsDict']]]] power_exceptions: Exceptions on a per switch basis to "useCombinedPower"
        :param pulumi.Input[Union['SwitchSettingsUplinkClientSamplingArgs', 'SwitchSettingsUplinkClientSamplingArgsDict']] uplink_client_sampling: Uplink client sampling
        :param pulumi.Input[bool] use_combined_power: The use Combined Power as the default behavior of secondary power supplies on supported devices.
        :param pulumi.Input[int] vlan: Management VLAN
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SwitchSettingsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import meraki:networks/switchSettings:SwitchSettings example "network_id"
        ```

        :param str resource_name: The name of the resource.
        :param SwitchSettingsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SwitchSettingsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 mac_blocklist: Optional[pulumi.Input[Union['SwitchSettingsMacBlocklistArgs', 'SwitchSettingsMacBlocklistArgsDict']]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 power_exceptions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SwitchSettingsPowerExceptionArgs', 'SwitchSettingsPowerExceptionArgsDict']]]]] = None,
                 uplink_client_sampling: Optional[pulumi.Input[Union['SwitchSettingsUplinkClientSamplingArgs', 'SwitchSettingsUplinkClientSamplingArgsDict']]] = None,
                 use_combined_power: Optional[pulumi.Input[bool]] = None,
                 vlan: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SwitchSettingsArgs.__new__(SwitchSettingsArgs)

            __props__.__dict__["mac_blocklist"] = mac_blocklist
            if network_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_id'")
            __props__.__dict__["network_id"] = network_id
            __props__.__dict__["power_exceptions"] = power_exceptions
            __props__.__dict__["uplink_client_sampling"] = uplink_client_sampling
            __props__.__dict__["use_combined_power"] = use_combined_power
            __props__.__dict__["vlan"] = vlan
        super(SwitchSettings, __self__).__init__(
            'meraki:networks/switchSettings:SwitchSettings',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            mac_blocklist: Optional[pulumi.Input[Union['SwitchSettingsMacBlocklistArgs', 'SwitchSettingsMacBlocklistArgsDict']]] = None,
            network_id: Optional[pulumi.Input[str]] = None,
            power_exceptions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SwitchSettingsPowerExceptionArgs', 'SwitchSettingsPowerExceptionArgsDict']]]]] = None,
            uplink_client_sampling: Optional[pulumi.Input[Union['SwitchSettingsUplinkClientSamplingArgs', 'SwitchSettingsUplinkClientSamplingArgsDict']]] = None,
            use_combined_power: Optional[pulumi.Input[bool]] = None,
            vlan: Optional[pulumi.Input[int]] = None) -> 'SwitchSettings':
        """
        Get an existing SwitchSettings resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['SwitchSettingsMacBlocklistArgs', 'SwitchSettingsMacBlocklistArgsDict']] mac_blocklist: MAC blocklist
        :param pulumi.Input[str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[Sequence[pulumi.Input[Union['SwitchSettingsPowerExceptionArgs', 'SwitchSettingsPowerExceptionArgsDict']]]] power_exceptions: Exceptions on a per switch basis to "useCombinedPower"
        :param pulumi.Input[Union['SwitchSettingsUplinkClientSamplingArgs', 'SwitchSettingsUplinkClientSamplingArgsDict']] uplink_client_sampling: Uplink client sampling
        :param pulumi.Input[bool] use_combined_power: The use Combined Power as the default behavior of secondary power supplies on supported devices.
        :param pulumi.Input[int] vlan: Management VLAN
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SwitchSettingsState.__new__(_SwitchSettingsState)

        __props__.__dict__["mac_blocklist"] = mac_blocklist
        __props__.__dict__["network_id"] = network_id
        __props__.__dict__["power_exceptions"] = power_exceptions
        __props__.__dict__["uplink_client_sampling"] = uplink_client_sampling
        __props__.__dict__["use_combined_power"] = use_combined_power
        __props__.__dict__["vlan"] = vlan
        return SwitchSettings(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="macBlocklist")
    def mac_blocklist(self) -> pulumi.Output['outputs.SwitchSettingsMacBlocklist']:
        """
        MAC blocklist
        """
        return pulumi.get(self, "mac_blocklist")

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Output[str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @property
    @pulumi.getter(name="powerExceptions")
    def power_exceptions(self) -> pulumi.Output[Sequence['outputs.SwitchSettingsPowerException']]:
        """
        Exceptions on a per switch basis to "useCombinedPower"
        """
        return pulumi.get(self, "power_exceptions")

    @property
    @pulumi.getter(name="uplinkClientSampling")
    def uplink_client_sampling(self) -> pulumi.Output['outputs.SwitchSettingsUplinkClientSampling']:
        """
        Uplink client sampling
        """
        return pulumi.get(self, "uplink_client_sampling")

    @property
    @pulumi.getter(name="useCombinedPower")
    def use_combined_power(self) -> pulumi.Output[bool]:
        """
        The use Combined Power as the default behavior of secondary power supplies on supported devices.
        """
        return pulumi.get(self, "use_combined_power")

    @property
    @pulumi.getter
    def vlan(self) -> pulumi.Output[int]:
        """
        Management VLAN
        """
        return pulumi.get(self, "vlan")

