"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Storage class to move an object to
 */
class StorageClass {
    constructor(value) {
        this.value = value;
    }
    toString() { return this.value; }
}
/**
 * Storage class for data that is accessed less frequently, but requires rapid
 * access when needed.
 *
 * Has lower availability than Standard storage.
 */
StorageClass.INFREQUENT_ACCESS = new StorageClass('STANDARD_IA');
/**
 * Infrequent Access that's only stored in one availability zone.
 *
 * Has lower availability than standard InfrequentAccess.
 */
StorageClass.ONE_ZONE_INFREQUENT_ACCESS = new StorageClass('ONEZONE_IA');
/**
 * Storage class for long-term archival that can take between minutes and
 * hours to access.
 *
 * Use for archives where portions of the data might need to be retrieved in
 * minutes. Data stored in the GLACIER storage class has a minimum storage
 * duration period of 90 days and can be accessed in as little as 1-5 minutes
 * using expedited retrieval. If you delete an object before the 90-day
 * minimum, you are charged for 90 days.
 */
StorageClass.GLACIER = new StorageClass('GLACIER');
/**
 * Use for archiving data that rarely needs to be accessed. Data stored in the
 * DEEP_ARCHIVE storage class has a minimum storage duration period of 180
 * days and a default retrieval time of 12 hours. If you delete an object
 * before the 180-day minimum, you are charged for 180 days. For pricing
 * information, see Amazon S3 Pricing.
 */
StorageClass.DEEP_ARCHIVE = new StorageClass('DEEP_ARCHIVE');
/**
 * The INTELLIGENT_TIERING storage class is designed to optimize storage costs
 * by automatically moving data to the most cost-effective storage access
 * tier, without performance impact or operational overhead.
 * INTELLIGENT_TIERING delivers automatic cost savings by moving data on a
 * granular object level between two access tiers, a frequent access tier and
 * a lower-cost infrequent access tier, when access patterns change. The
 * INTELLIGENT_TIERING storage class is ideal if you want to optimize storage
 * costs automatically for long-lived data when access patterns are unknown or
 * unpredictable.
 */
StorageClass.INTELLIGENT_TIERING = new StorageClass('INTELLIGENT_TIERING');
exports.StorageClass = StorageClass;
//# sourceMappingURL=data:application/json;base64,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