"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/// !cdk-integ *
const iam = require("@aws-cdk/aws-iam");
const cdk = require("@aws-cdk/core");
const s3 = require("../lib");
const app = new cdk.App();
/// !show
/**
 * Stack that defines the bucket
 */
class Producer extends cdk.Stack {
    constructor(scope, id, props) {
        super(scope, id, props);
        const bucket = new s3.Bucket(this, 'MyBucket', {
            removalPolicy: cdk.RemovalPolicy.DESTROY
        });
        this.myBucket = bucket;
    }
}
/**
 * Stack that consumes the bucket
 */
class Consumer extends cdk.Stack {
    constructor(scope, id, props) {
        super(scope, id, props);
        const user = new iam.User(this, 'MyUser');
        props.userBucket.grantReadWrite(user);
    }
}
const producer = new Producer(app, 'ProducerStack');
new Consumer(app, 'ConsumerStack', { userBucket: producer.myBucket });
/// !hide
app.synth();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcuYnVja2V0LXNoYXJpbmcubGl0LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiaW50ZWcuYnVja2V0LXNoYXJpbmcubGl0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUEsZ0JBQWdCO0FBQ2hCLHdDQUF5QztBQUN6QyxxQ0FBc0M7QUFDdEMsNkJBQThCO0FBRTlCLE1BQU0sR0FBRyxHQUFHLElBQUksR0FBRyxDQUFDLEdBQUcsRUFBRSxDQUFDO0FBRTFCLFNBQVM7QUFFVDs7R0FFRztBQUNILE1BQU0sUUFBUyxTQUFRLEdBQUcsQ0FBQyxLQUFLO0lBRzVCLFlBQVksS0FBYyxFQUFFLEVBQVUsRUFBRSxLQUFzQjtRQUMxRCxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRSxLQUFLLENBQUMsQ0FBQztRQUV4QixNQUFNLE1BQU0sR0FBRyxJQUFJLEVBQUUsQ0FBQyxNQUFNLENBQUMsSUFBSSxFQUFFLFVBQVUsRUFBRTtZQUM3QyxhQUFhLEVBQUUsR0FBRyxDQUFDLGFBQWEsQ0FBQyxPQUFPO1NBQ3pDLENBQUMsQ0FBQztRQUNILElBQUksQ0FBQyxRQUFRLEdBQUcsTUFBTSxDQUFDO0lBQzNCLENBQUM7Q0FDSjtBQU1EOztHQUVHO0FBQ0gsTUFBTSxRQUFTLFNBQVEsR0FBRyxDQUFDLEtBQUs7SUFDNUIsWUFBWSxLQUFjLEVBQUUsRUFBVSxFQUFFLEtBQW9CO1FBQ3hELEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFLEtBQUssQ0FBQyxDQUFDO1FBRXhCLE1BQU0sSUFBSSxHQUFHLElBQUksR0FBRyxDQUFDLElBQUksQ0FBQyxJQUFJLEVBQUUsUUFBUSxDQUFDLENBQUM7UUFDMUMsS0FBSyxDQUFDLFVBQVUsQ0FBQyxjQUFjLENBQUMsSUFBSSxDQUFDLENBQUM7SUFDMUMsQ0FBQztDQUNKO0FBRUQsTUFBTSxRQUFRLEdBQUcsSUFBSSxRQUFRLENBQUMsR0FBRyxFQUFFLGVBQWUsQ0FBQyxDQUFDO0FBQ3BELElBQUksUUFBUSxDQUFDLEdBQUcsRUFBRSxlQUFlLEVBQUUsRUFBRSxVQUFVLEVBQUUsUUFBUSxDQUFDLFFBQVEsRUFBRSxDQUFDLENBQUM7QUFDdEUsU0FBUztBQUVULEdBQUcsQ0FBQyxLQUFLLEVBQUUsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbIi8vLyAhY2RrLWludGVnICpcbmltcG9ydCBpYW0gPSByZXF1aXJlKCdAYXdzLWNkay9hd3MtaWFtJyk7XG5pbXBvcnQgY2RrID0gcmVxdWlyZSgnQGF3cy1jZGsvY29yZScpO1xuaW1wb3J0IHMzID0gcmVxdWlyZSgnLi4vbGliJyk7XG5cbmNvbnN0IGFwcCA9IG5ldyBjZGsuQXBwKCk7XG5cbi8vLyAhc2hvd1xuXG4vKipcbiAqIFN0YWNrIHRoYXQgZGVmaW5lcyB0aGUgYnVja2V0XG4gKi9cbmNsYXNzIFByb2R1Y2VyIGV4dGVuZHMgY2RrLlN0YWNrIHtcbiAgICBwdWJsaWMgcmVhZG9ubHkgbXlCdWNrZXQ6IHMzLkJ1Y2tldDtcblxuICAgIGNvbnN0cnVjdG9yKHNjb3BlOiBjZGsuQXBwLCBpZDogc3RyaW5nLCBwcm9wcz86IGNkay5TdGFja1Byb3BzKSB7XG4gICAgICAgIHN1cGVyKHNjb3BlLCBpZCwgcHJvcHMpO1xuXG4gICAgICAgIGNvbnN0IGJ1Y2tldCA9IG5ldyBzMy5CdWNrZXQodGhpcywgJ015QnVja2V0Jywge1xuICAgICAgICAgIHJlbW92YWxQb2xpY3k6IGNkay5SZW1vdmFsUG9saWN5LkRFU1RST1lcbiAgICAgICAgfSk7XG4gICAgICAgIHRoaXMubXlCdWNrZXQgPSBidWNrZXQ7XG4gICAgfVxufVxuXG5pbnRlcmZhY2UgQ29uc3VtZXJQcm9wcyBleHRlbmRzIGNkay5TdGFja1Byb3BzIHtcbiAgICB1c2VyQnVja2V0OiBzMy5JQnVja2V0O1xufVxuXG4vKipcbiAqIFN0YWNrIHRoYXQgY29uc3VtZXMgdGhlIGJ1Y2tldFxuICovXG5jbGFzcyBDb25zdW1lciBleHRlbmRzIGNkay5TdGFjayB7XG4gICAgY29uc3RydWN0b3Ioc2NvcGU6IGNkay5BcHAsIGlkOiBzdHJpbmcsIHByb3BzOiBDb25zdW1lclByb3BzKSB7XG4gICAgICAgIHN1cGVyKHNjb3BlLCBpZCwgcHJvcHMpO1xuXG4gICAgICAgIGNvbnN0IHVzZXIgPSBuZXcgaWFtLlVzZXIodGhpcywgJ015VXNlcicpO1xuICAgICAgICBwcm9wcy51c2VyQnVja2V0LmdyYW50UmVhZFdyaXRlKHVzZXIpO1xuICAgIH1cbn1cblxuY29uc3QgcHJvZHVjZXIgPSBuZXcgUHJvZHVjZXIoYXBwLCAnUHJvZHVjZXJTdGFjaycpO1xubmV3IENvbnN1bWVyKGFwcCwgJ0NvbnN1bWVyU3RhY2snLCB7IHVzZXJCdWNrZXQ6IHByb2R1Y2VyLm15QnVja2V0IH0pO1xuLy8vICFoaWRlXG5cbmFwcC5zeW50aCgpO1xuIl19