# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetMonitorsResult',
    'AwaitableGetMonitorsResult',
    'get_monitors',
    'get_monitors_output',
]

@pulumi.output_type
class GetMonitorsResult:
    """
    A collection of values returned by getMonitors.
    """
    def __init__(__self__, apm_domain_id=None, display_name=None, filters=None, id=None, is_maintenance_window_active=None, is_maintenance_window_set=None, monitor_collections=None, monitor_type=None, script_id=None, status=None, vantage_point=None):
        if apm_domain_id and not isinstance(apm_domain_id, str):
            raise TypeError("Expected argument 'apm_domain_id' to be a str")
        pulumi.set(__self__, "apm_domain_id", apm_domain_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_maintenance_window_active and not isinstance(is_maintenance_window_active, bool):
            raise TypeError("Expected argument 'is_maintenance_window_active' to be a bool")
        pulumi.set(__self__, "is_maintenance_window_active", is_maintenance_window_active)
        if is_maintenance_window_set and not isinstance(is_maintenance_window_set, bool):
            raise TypeError("Expected argument 'is_maintenance_window_set' to be a bool")
        pulumi.set(__self__, "is_maintenance_window_set", is_maintenance_window_set)
        if monitor_collections and not isinstance(monitor_collections, list):
            raise TypeError("Expected argument 'monitor_collections' to be a list")
        pulumi.set(__self__, "monitor_collections", monitor_collections)
        if monitor_type and not isinstance(monitor_type, str):
            raise TypeError("Expected argument 'monitor_type' to be a str")
        pulumi.set(__self__, "monitor_type", monitor_type)
        if script_id and not isinstance(script_id, str):
            raise TypeError("Expected argument 'script_id' to be a str")
        pulumi.set(__self__, "script_id", script_id)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if vantage_point and not isinstance(vantage_point, str):
            raise TypeError("Expected argument 'vantage_point' to be a str")
        pulumi.set(__self__, "vantage_point", vantage_point)

    @property
    @pulumi.getter(name="apmDomainId")
    def apm_domain_id(self) -> str:
        return pulumi.get(self, "apm_domain_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        Unique name that can be edited. The name should not contain any confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetMonitorsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isMaintenanceWindowActive")
    def is_maintenance_window_active(self) -> Optional[bool]:
        return pulumi.get(self, "is_maintenance_window_active")

    @property
    @pulumi.getter(name="isMaintenanceWindowSet")
    def is_maintenance_window_set(self) -> Optional[bool]:
        return pulumi.get(self, "is_maintenance_window_set")

    @property
    @pulumi.getter(name="monitorCollections")
    def monitor_collections(self) -> Sequence['outputs.GetMonitorsMonitorCollectionResult']:
        """
        The list of monitor_collection.
        """
        return pulumi.get(self, "monitor_collections")

    @property
    @pulumi.getter(name="monitorType")
    def monitor_type(self) -> Optional[str]:
        """
        Type of monitor.
        """
        return pulumi.get(self, "monitor_type")

    @property
    @pulumi.getter(name="scriptId")
    def script_id(self) -> Optional[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the script. scriptId is mandatory for creation of SCRIPTED_BROWSER and SCRIPTED_REST monitor types. For other monitor types, it should be set to null.
        """
        return pulumi.get(self, "script_id")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        Enables or disables the monitor.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="vantagePoint")
    def vantage_point(self) -> Optional[str]:
        return pulumi.get(self, "vantage_point")


class AwaitableGetMonitorsResult(GetMonitorsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMonitorsResult(
            apm_domain_id=self.apm_domain_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            is_maintenance_window_active=self.is_maintenance_window_active,
            is_maintenance_window_set=self.is_maintenance_window_set,
            monitor_collections=self.monitor_collections,
            monitor_type=self.monitor_type,
            script_id=self.script_id,
            status=self.status,
            vantage_point=self.vantage_point)


def get_monitors(apm_domain_id: Optional[str] = None,
                 display_name: Optional[str] = None,
                 filters: Optional[Sequence[pulumi.InputType['GetMonitorsFilterArgs']]] = None,
                 is_maintenance_window_active: Optional[bool] = None,
                 is_maintenance_window_set: Optional[bool] = None,
                 monitor_type: Optional[str] = None,
                 script_id: Optional[str] = None,
                 status: Optional[str] = None,
                 vantage_point: Optional[str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMonitorsResult:
    """
    This data source provides the list of Monitors in Oracle Cloud Infrastructure Apm Synthetics service.

    Returns a list of monitors.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_monitors = oci.ApmSynthetics.get_monitors(apm_domain_id=oci_apm_synthetics_apm_domain["test_apm_domain"]["id"],
        display_name=var["monitor_display_name"],
        is_maintenance_window_active=var["monitor_is_maintenance_window_active"],
        is_maintenance_window_set=var["monitor_is_maintenance_window_set"],
        monitor_type=var["monitor_monitor_type"],
        script_id=oci_apm_synthetics_script["test_script"]["id"],
        status=var["monitor_status"],
        vantage_point=var["monitor_vantage_point"])
    ```
    <!--End PulumiCodeChooser -->


    :param str apm_domain_id: The APM domain ID the request is intended for.
    :param str display_name: A filter to return only the resources that match the entire display name.
    :param bool is_maintenance_window_active: A filter to return the monitors whose maintenance window is currently active.
    :param bool is_maintenance_window_set: A filter to return the monitors whose maintenance window is set.
    :param str monitor_type: A filter to return only monitors that match the given monitor type. Supported values are SCRIPTED_BROWSER, BROWSER, SCRIPTED_REST, REST and NETWORK.
    :param str script_id: A filter to return only monitors using scriptId.
    :param str status: A filter to return only monitors that match the status given.
    :param str vantage_point: The name of the public or dedicated vantage point.
    """
    __args__ = dict()
    __args__['apmDomainId'] = apm_domain_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['isMaintenanceWindowActive'] = is_maintenance_window_active
    __args__['isMaintenanceWindowSet'] = is_maintenance_window_set
    __args__['monitorType'] = monitor_type
    __args__['scriptId'] = script_id
    __args__['status'] = status
    __args__['vantagePoint'] = vantage_point
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:ApmSynthetics/getMonitors:getMonitors', __args__, opts=opts, typ=GetMonitorsResult).value

    return AwaitableGetMonitorsResult(
        apm_domain_id=pulumi.get(__ret__, 'apm_domain_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        is_maintenance_window_active=pulumi.get(__ret__, 'is_maintenance_window_active'),
        is_maintenance_window_set=pulumi.get(__ret__, 'is_maintenance_window_set'),
        monitor_collections=pulumi.get(__ret__, 'monitor_collections'),
        monitor_type=pulumi.get(__ret__, 'monitor_type'),
        script_id=pulumi.get(__ret__, 'script_id'),
        status=pulumi.get(__ret__, 'status'),
        vantage_point=pulumi.get(__ret__, 'vantage_point'))


@_utilities.lift_output_func(get_monitors)
def get_monitors_output(apm_domain_id: Optional[pulumi.Input[str]] = None,
                        display_name: Optional[pulumi.Input[Optional[str]]] = None,
                        filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetMonitorsFilterArgs']]]]] = None,
                        is_maintenance_window_active: Optional[pulumi.Input[Optional[bool]]] = None,
                        is_maintenance_window_set: Optional[pulumi.Input[Optional[bool]]] = None,
                        monitor_type: Optional[pulumi.Input[Optional[str]]] = None,
                        script_id: Optional[pulumi.Input[Optional[str]]] = None,
                        status: Optional[pulumi.Input[Optional[str]]] = None,
                        vantage_point: Optional[pulumi.Input[Optional[str]]] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetMonitorsResult]:
    """
    This data source provides the list of Monitors in Oracle Cloud Infrastructure Apm Synthetics service.

    Returns a list of monitors.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_monitors = oci.ApmSynthetics.get_monitors(apm_domain_id=oci_apm_synthetics_apm_domain["test_apm_domain"]["id"],
        display_name=var["monitor_display_name"],
        is_maintenance_window_active=var["monitor_is_maintenance_window_active"],
        is_maintenance_window_set=var["monitor_is_maintenance_window_set"],
        monitor_type=var["monitor_monitor_type"],
        script_id=oci_apm_synthetics_script["test_script"]["id"],
        status=var["monitor_status"],
        vantage_point=var["monitor_vantage_point"])
    ```
    <!--End PulumiCodeChooser -->


    :param str apm_domain_id: The APM domain ID the request is intended for.
    :param str display_name: A filter to return only the resources that match the entire display name.
    :param bool is_maintenance_window_active: A filter to return the monitors whose maintenance window is currently active.
    :param bool is_maintenance_window_set: A filter to return the monitors whose maintenance window is set.
    :param str monitor_type: A filter to return only monitors that match the given monitor type. Supported values are SCRIPTED_BROWSER, BROWSER, SCRIPTED_REST, REST and NETWORK.
    :param str script_id: A filter to return only monitors using scriptId.
    :param str status: A filter to return only monitors that match the status given.
    :param str vantage_point: The name of the public or dedicated vantage point.
    """
    ...
