# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ExternalContainerDatabaseArgs', 'ExternalContainerDatabase']

@pulumi.input_type
class ExternalContainerDatabaseArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[str],
                 display_name: pulumi.Input[str],
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None):
        """
        The set of arguments for constructing a ExternalContainerDatabase resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[str] display_name: (Updatable) The user-friendly name for the external database. The name does not have to be unique.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "display_name", display_name)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[str]:
        """
        (Updatable) The user-friendly name for the external database. The name does not have to be unique.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)


@pulumi.input_type
class _ExternalContainerDatabaseState:
    def __init__(__self__, *,
                 character_set: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 database_configuration: Optional[pulumi.Input[str]] = None,
                 database_edition: Optional[pulumi.Input[str]] = None,
                 database_management_configs: Optional[pulumi.Input[Sequence[pulumi.Input['ExternalContainerDatabaseDatabaseManagementConfigArgs']]]] = None,
                 database_version: Optional[pulumi.Input[str]] = None,
                 db_id: Optional[pulumi.Input[str]] = None,
                 db_packs: Optional[pulumi.Input[str]] = None,
                 db_unique_name: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 lifecycle_details: Optional[pulumi.Input[str]] = None,
                 ncharacter_set: Optional[pulumi.Input[str]] = None,
                 stack_monitoring_configs: Optional[pulumi.Input[Sequence[pulumi.Input['ExternalContainerDatabaseStackMonitoringConfigArgs']]]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_zone: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ExternalContainerDatabase resources.
        :param pulumi.Input[str] character_set: The character set of the external database.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[str] database_configuration: The Oracle Database configuration
        :param pulumi.Input[str] database_edition: The Oracle Database edition.
        :param pulumi.Input[Sequence[pulumi.Input['ExternalContainerDatabaseDatabaseManagementConfigArgs']]] database_management_configs: The configuration of the Database Management service.
        :param pulumi.Input[str] database_version: The Oracle Database version.
        :param pulumi.Input[str] db_id: The Oracle Database ID, which identifies an Oracle Database located outside of Oracle Cloud.
        :param pulumi.Input[str] db_packs: The database packs licensed for the external Oracle Database.
        :param pulumi.Input[str] db_unique_name: The `DB_UNIQUE_NAME` of the external database.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[str] display_name: (Updatable) The user-friendly name for the external database. The name does not have to be unique.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] lifecycle_details: Additional information about the current lifecycle state.
        :param pulumi.Input[str] ncharacter_set: The national character of the external database.
        :param pulumi.Input[Sequence[pulumi.Input['ExternalContainerDatabaseStackMonitoringConfigArgs']]] stack_monitoring_configs: The configuration of Stack Monitoring for the external database.
        :param pulumi.Input[str] state: The current state of the Oracle Cloud Infrastructure external database resource.
        :param pulumi.Input[str] time_created: The date and time the database was created.
        :param pulumi.Input[str] time_zone: The time zone of the external database. It is a time zone offset (a character type in the format '[+|-]TZH:TZM') or a time zone region name, depending on how the time zone value was specified when the database was created / last altered.
        """
        if character_set is not None:
            pulumi.set(__self__, "character_set", character_set)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if database_configuration is not None:
            pulumi.set(__self__, "database_configuration", database_configuration)
        if database_edition is not None:
            pulumi.set(__self__, "database_edition", database_edition)
        if database_management_configs is not None:
            pulumi.set(__self__, "database_management_configs", database_management_configs)
        if database_version is not None:
            pulumi.set(__self__, "database_version", database_version)
        if db_id is not None:
            pulumi.set(__self__, "db_id", db_id)
        if db_packs is not None:
            pulumi.set(__self__, "db_packs", db_packs)
        if db_unique_name is not None:
            pulumi.set(__self__, "db_unique_name", db_unique_name)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if ncharacter_set is not None:
            pulumi.set(__self__, "ncharacter_set", ncharacter_set)
        if stack_monitoring_configs is not None:
            pulumi.set(__self__, "stack_monitoring_configs", stack_monitoring_configs)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)

    @property
    @pulumi.getter(name="characterSet")
    def character_set(self) -> Optional[pulumi.Input[str]]:
        """
        The character set of the external database.
        """
        return pulumi.get(self, "character_set")

    @character_set.setter
    def character_set(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "character_set", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="databaseConfiguration")
    def database_configuration(self) -> Optional[pulumi.Input[str]]:
        """
        The Oracle Database configuration
        """
        return pulumi.get(self, "database_configuration")

    @database_configuration.setter
    def database_configuration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_configuration", value)

    @property
    @pulumi.getter(name="databaseEdition")
    def database_edition(self) -> Optional[pulumi.Input[str]]:
        """
        The Oracle Database edition.
        """
        return pulumi.get(self, "database_edition")

    @database_edition.setter
    def database_edition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_edition", value)

    @property
    @pulumi.getter(name="databaseManagementConfigs")
    def database_management_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ExternalContainerDatabaseDatabaseManagementConfigArgs']]]]:
        """
        The configuration of the Database Management service.
        """
        return pulumi.get(self, "database_management_configs")

    @database_management_configs.setter
    def database_management_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ExternalContainerDatabaseDatabaseManagementConfigArgs']]]]):
        pulumi.set(self, "database_management_configs", value)

    @property
    @pulumi.getter(name="databaseVersion")
    def database_version(self) -> Optional[pulumi.Input[str]]:
        """
        The Oracle Database version.
        """
        return pulumi.get(self, "database_version")

    @database_version.setter
    def database_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_version", value)

    @property
    @pulumi.getter(name="dbId")
    def db_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Oracle Database ID, which identifies an Oracle Database located outside of Oracle Cloud.
        """
        return pulumi.get(self, "db_id")

    @db_id.setter
    def db_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_id", value)

    @property
    @pulumi.getter(name="dbPacks")
    def db_packs(self) -> Optional[pulumi.Input[str]]:
        """
        The database packs licensed for the external Oracle Database.
        """
        return pulumi.get(self, "db_packs")

    @db_packs.setter
    def db_packs(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_packs", value)

    @property
    @pulumi.getter(name="dbUniqueName")
    def db_unique_name(self) -> Optional[pulumi.Input[str]]:
        """
        The `DB_UNIQUE_NAME` of the external database.
        """
        return pulumi.get(self, "db_unique_name")

    @db_unique_name.setter
    def db_unique_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_unique_name", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The user-friendly name for the external database. The name does not have to be unique.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[str]]:
        """
        Additional information about the current lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="ncharacterSet")
    def ncharacter_set(self) -> Optional[pulumi.Input[str]]:
        """
        The national character of the external database.
        """
        return pulumi.get(self, "ncharacter_set")

    @ncharacter_set.setter
    def ncharacter_set(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ncharacter_set", value)

    @property
    @pulumi.getter(name="stackMonitoringConfigs")
    def stack_monitoring_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ExternalContainerDatabaseStackMonitoringConfigArgs']]]]:
        """
        The configuration of Stack Monitoring for the external database.
        """
        return pulumi.get(self, "stack_monitoring_configs")

    @stack_monitoring_configs.setter
    def stack_monitoring_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ExternalContainerDatabaseStackMonitoringConfigArgs']]]]):
        pulumi.set(self, "stack_monitoring_configs", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the Oracle Cloud Infrastructure external database resource.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the database was created.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[str]]:
        """
        The time zone of the external database. It is a time zone offset (a character type in the format '[+|-]TZH:TZM') or a time zone region name, depending on how the time zone value was specified when the database was created / last altered.
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_zone", value)


class ExternalContainerDatabase(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 __props__=None):
        """
        This resource provides the External Container Database resource in Oracle Cloud Infrastructure Database service.

        Creates a new external container database resource.

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_oci as oci

        test_external_container_database = oci.database.ExternalContainerDatabase("testExternalContainerDatabase",
            compartment_id=var["compartment_id"],
            display_name=var["external_container_database_display_name"],
            defined_tags=var["external_container_database_defined_tags"],
            freeform_tags={
                "Department": "Finance",
            })
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        ExternalContainerDatabases can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Database/externalContainerDatabase:ExternalContainerDatabase test_external_container_database "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[str] display_name: (Updatable) The user-friendly name for the external database. The name does not have to be unique.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ExternalContainerDatabaseArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the External Container Database resource in Oracle Cloud Infrastructure Database service.

        Creates a new external container database resource.

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_oci as oci

        test_external_container_database = oci.database.ExternalContainerDatabase("testExternalContainerDatabase",
            compartment_id=var["compartment_id"],
            display_name=var["external_container_database_display_name"],
            defined_tags=var["external_container_database_defined_tags"],
            freeform_tags={
                "Department": "Finance",
            })
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        ExternalContainerDatabases can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Database/externalContainerDatabase:ExternalContainerDatabase test_external_container_database "id"
        ```

        :param str resource_name: The name of the resource.
        :param ExternalContainerDatabaseArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ExternalContainerDatabaseArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ExternalContainerDatabaseArgs.__new__(ExternalContainerDatabaseArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["character_set"] = None
            __props__.__dict__["database_configuration"] = None
            __props__.__dict__["database_edition"] = None
            __props__.__dict__["database_management_configs"] = None
            __props__.__dict__["database_version"] = None
            __props__.__dict__["db_id"] = None
            __props__.__dict__["db_packs"] = None
            __props__.__dict__["db_unique_name"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["ncharacter_set"] = None
            __props__.__dict__["stack_monitoring_configs"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_zone"] = None
        super(ExternalContainerDatabase, __self__).__init__(
            'oci:Database/externalContainerDatabase:ExternalContainerDatabase',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            character_set: Optional[pulumi.Input[str]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            database_configuration: Optional[pulumi.Input[str]] = None,
            database_edition: Optional[pulumi.Input[str]] = None,
            database_management_configs: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ExternalContainerDatabaseDatabaseManagementConfigArgs']]]]] = None,
            database_version: Optional[pulumi.Input[str]] = None,
            db_id: Optional[pulumi.Input[str]] = None,
            db_packs: Optional[pulumi.Input[str]] = None,
            db_unique_name: Optional[pulumi.Input[str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            lifecycle_details: Optional[pulumi.Input[str]] = None,
            ncharacter_set: Optional[pulumi.Input[str]] = None,
            stack_monitoring_configs: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ExternalContainerDatabaseStackMonitoringConfigArgs']]]]] = None,
            state: Optional[pulumi.Input[str]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_zone: Optional[pulumi.Input[str]] = None) -> 'ExternalContainerDatabase':
        """
        Get an existing ExternalContainerDatabase resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] character_set: The character set of the external database.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[str] database_configuration: The Oracle Database configuration
        :param pulumi.Input[str] database_edition: The Oracle Database edition.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ExternalContainerDatabaseDatabaseManagementConfigArgs']]]] database_management_configs: The configuration of the Database Management service.
        :param pulumi.Input[str] database_version: The Oracle Database version.
        :param pulumi.Input[str] db_id: The Oracle Database ID, which identifies an Oracle Database located outside of Oracle Cloud.
        :param pulumi.Input[str] db_packs: The database packs licensed for the external Oracle Database.
        :param pulumi.Input[str] db_unique_name: The `DB_UNIQUE_NAME` of the external database.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[str] display_name: (Updatable) The user-friendly name for the external database. The name does not have to be unique.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] lifecycle_details: Additional information about the current lifecycle state.
        :param pulumi.Input[str] ncharacter_set: The national character of the external database.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ExternalContainerDatabaseStackMonitoringConfigArgs']]]] stack_monitoring_configs: The configuration of Stack Monitoring for the external database.
        :param pulumi.Input[str] state: The current state of the Oracle Cloud Infrastructure external database resource.
        :param pulumi.Input[str] time_created: The date and time the database was created.
        :param pulumi.Input[str] time_zone: The time zone of the external database. It is a time zone offset (a character type in the format '[+|-]TZH:TZM') or a time zone region name, depending on how the time zone value was specified when the database was created / last altered.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ExternalContainerDatabaseState.__new__(_ExternalContainerDatabaseState)

        __props__.__dict__["character_set"] = character_set
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["database_configuration"] = database_configuration
        __props__.__dict__["database_edition"] = database_edition
        __props__.__dict__["database_management_configs"] = database_management_configs
        __props__.__dict__["database_version"] = database_version
        __props__.__dict__["db_id"] = db_id
        __props__.__dict__["db_packs"] = db_packs
        __props__.__dict__["db_unique_name"] = db_unique_name
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["ncharacter_set"] = ncharacter_set
        __props__.__dict__["stack_monitoring_configs"] = stack_monitoring_configs
        __props__.__dict__["state"] = state
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_zone"] = time_zone
        return ExternalContainerDatabase(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="characterSet")
    def character_set(self) -> pulumi.Output[str]:
        """
        The character set of the external database.
        """
        return pulumi.get(self, "character_set")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="databaseConfiguration")
    def database_configuration(self) -> pulumi.Output[str]:
        """
        The Oracle Database configuration
        """
        return pulumi.get(self, "database_configuration")

    @property
    @pulumi.getter(name="databaseEdition")
    def database_edition(self) -> pulumi.Output[str]:
        """
        The Oracle Database edition.
        """
        return pulumi.get(self, "database_edition")

    @property
    @pulumi.getter(name="databaseManagementConfigs")
    def database_management_configs(self) -> pulumi.Output[Sequence['outputs.ExternalContainerDatabaseDatabaseManagementConfig']]:
        """
        The configuration of the Database Management service.
        """
        return pulumi.get(self, "database_management_configs")

    @property
    @pulumi.getter(name="databaseVersion")
    def database_version(self) -> pulumi.Output[str]:
        """
        The Oracle Database version.
        """
        return pulumi.get(self, "database_version")

    @property
    @pulumi.getter(name="dbId")
    def db_id(self) -> pulumi.Output[str]:
        """
        The Oracle Database ID, which identifies an Oracle Database located outside of Oracle Cloud.
        """
        return pulumi.get(self, "db_id")

    @property
    @pulumi.getter(name="dbPacks")
    def db_packs(self) -> pulumi.Output[str]:
        """
        The database packs licensed for the external Oracle Database.
        """
        return pulumi.get(self, "db_packs")

    @property
    @pulumi.getter(name="dbUniqueName")
    def db_unique_name(self) -> pulumi.Output[str]:
        """
        The `DB_UNIQUE_NAME` of the external database.
        """
        return pulumi.get(self, "db_unique_name")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) The user-friendly name for the external database. The name does not have to be unique.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[str]:
        """
        Additional information about the current lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="ncharacterSet")
    def ncharacter_set(self) -> pulumi.Output[str]:
        """
        The national character of the external database.
        """
        return pulumi.get(self, "ncharacter_set")

    @property
    @pulumi.getter(name="stackMonitoringConfigs")
    def stack_monitoring_configs(self) -> pulumi.Output[Sequence['outputs.ExternalContainerDatabaseStackMonitoringConfig']]:
        """
        The configuration of Stack Monitoring for the external database.
        """
        return pulumi.get(self, "stack_monitoring_configs")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of the Oracle Cloud Infrastructure external database resource.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The date and time the database was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> pulumi.Output[str]:
        """
        The time zone of the external database. It is a time zone offset (a character type in the format '[+|-]TZH:TZM') or a time zone region name, depending on how the time zone value was specified when the database was created / last altered.
        """
        return pulumi.get(self, "time_zone")

