# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetApplicationVipsResult',
    'AwaitableGetApplicationVipsResult',
    'get_application_vips',
    'get_application_vips_output',
]

@pulumi.output_type
class GetApplicationVipsResult:
    """
    A collection of values returned by getApplicationVips.
    """
    def __init__(__self__, application_vips=None, cloud_vm_cluster_id=None, compartment_id=None, filters=None, id=None, state=None):
        if application_vips and not isinstance(application_vips, list):
            raise TypeError("Expected argument 'application_vips' to be a list")
        pulumi.set(__self__, "application_vips", application_vips)
        if cloud_vm_cluster_id and not isinstance(cloud_vm_cluster_id, str):
            raise TypeError("Expected argument 'cloud_vm_cluster_id' to be a str")
        pulumi.set(__self__, "cloud_vm_cluster_id", cloud_vm_cluster_id)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="applicationVips")
    def application_vips(self) -> Sequence['outputs.GetApplicationVipsApplicationVipResult']:
        """
        The list of application_vips.
        """
        return pulumi.get(self, "application_vips")

    @property
    @pulumi.getter(name="cloudVmClusterId")
    def cloud_vm_cluster_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cloud VM cluster associated with the application virtual IP (VIP) address.
        """
        return pulumi.get(self, "cloud_vm_cluster_id")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetApplicationVipsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current lifecycle state of the application virtual IP (VIP) address.
        """
        return pulumi.get(self, "state")


class AwaitableGetApplicationVipsResult(GetApplicationVipsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetApplicationVipsResult(
            application_vips=self.application_vips,
            cloud_vm_cluster_id=self.cloud_vm_cluster_id,
            compartment_id=self.compartment_id,
            filters=self.filters,
            id=self.id,
            state=self.state)


def get_application_vips(cloud_vm_cluster_id: Optional[str] = None,
                         compartment_id: Optional[str] = None,
                         filters: Optional[Sequence[pulumi.InputType['GetApplicationVipsFilterArgs']]] = None,
                         state: Optional[str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetApplicationVipsResult:
    """
    This data source provides the list of Application Vips in Oracle Cloud Infrastructure Database service.

    Gets a list of application virtual IP (VIP) addresses on a cloud VM cluster.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_application_vips = oci.Database.get_application_vips(cloud_vm_cluster_id=oci_database_cloud_vm_cluster["test_cloud_vm_cluster"]["id"],
        compartment_id=var["compartment_id"],
        state=var["application_vip_state"])
    ```
    <!--End PulumiCodeChooser -->


    :param str cloud_vm_cluster_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cloud VM cluster associated with the application virtual IP (VIP) address.
    :param str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param str state: A filter to return only resources that match the given lifecycle state exactly.
    """
    __args__ = dict()
    __args__['cloudVmClusterId'] = cloud_vm_cluster_id
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getApplicationVips:getApplicationVips', __args__, opts=opts, typ=GetApplicationVipsResult).value

    return AwaitableGetApplicationVipsResult(
        application_vips=pulumi.get(__ret__, 'application_vips'),
        cloud_vm_cluster_id=pulumi.get(__ret__, 'cloud_vm_cluster_id'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'))


@_utilities.lift_output_func(get_application_vips)
def get_application_vips_output(cloud_vm_cluster_id: Optional[pulumi.Input[str]] = None,
                                compartment_id: Optional[pulumi.Input[str]] = None,
                                filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetApplicationVipsFilterArgs']]]]] = None,
                                state: Optional[pulumi.Input[Optional[str]]] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetApplicationVipsResult]:
    """
    This data source provides the list of Application Vips in Oracle Cloud Infrastructure Database service.

    Gets a list of application virtual IP (VIP) addresses on a cloud VM cluster.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_application_vips = oci.Database.get_application_vips(cloud_vm_cluster_id=oci_database_cloud_vm_cluster["test_cloud_vm_cluster"]["id"],
        compartment_id=var["compartment_id"],
        state=var["application_vip_state"])
    ```
    <!--End PulumiCodeChooser -->


    :param str cloud_vm_cluster_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cloud VM cluster associated with the application virtual IP (VIP) address.
    :param str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param str state: A filter to return only resources that match the given lifecycle state exactly.
    """
    ...
