# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetCloudExadataInfrastructureResult',
    'AwaitableGetCloudExadataInfrastructureResult',
    'get_cloud_exadata_infrastructure',
    'get_cloud_exadata_infrastructure_output',
]

@pulumi.output_type
class GetCloudExadataInfrastructureResult:
    """
    A collection of values returned by getCloudExadataInfrastructure.
    """
    def __init__(__self__, activated_storage_count=None, additional_storage_count=None, availability_domain=None, available_storage_size_in_gbs=None, cloud_exadata_infrastructure_id=None, cluster_placement_group_id=None, compartment_id=None, compute_count=None, cpu_count=None, customer_contacts=None, data_storage_size_in_tbs=None, db_node_storage_size_in_gbs=None, db_server_version=None, defined_tags=None, display_name=None, freeform_tags=None, id=None, last_maintenance_run_id=None, lifecycle_details=None, maintenance_windows=None, max_cpu_count=None, max_data_storage_in_tbs=None, max_db_node_storage_in_gbs=None, max_memory_in_gbs=None, memory_size_in_gbs=None, monthly_db_server_version=None, monthly_storage_server_version=None, next_maintenance_run_id=None, shape=None, state=None, storage_count=None, storage_server_version=None, system_tags=None, time_created=None, total_storage_size_in_gbs=None):
        if activated_storage_count and not isinstance(activated_storage_count, int):
            raise TypeError("Expected argument 'activated_storage_count' to be a int")
        pulumi.set(__self__, "activated_storage_count", activated_storage_count)
        if additional_storage_count and not isinstance(additional_storage_count, int):
            raise TypeError("Expected argument 'additional_storage_count' to be a int")
        pulumi.set(__self__, "additional_storage_count", additional_storage_count)
        if availability_domain and not isinstance(availability_domain, str):
            raise TypeError("Expected argument 'availability_domain' to be a str")
        pulumi.set(__self__, "availability_domain", availability_domain)
        if available_storage_size_in_gbs and not isinstance(available_storage_size_in_gbs, int):
            raise TypeError("Expected argument 'available_storage_size_in_gbs' to be a int")
        pulumi.set(__self__, "available_storage_size_in_gbs", available_storage_size_in_gbs)
        if cloud_exadata_infrastructure_id and not isinstance(cloud_exadata_infrastructure_id, str):
            raise TypeError("Expected argument 'cloud_exadata_infrastructure_id' to be a str")
        pulumi.set(__self__, "cloud_exadata_infrastructure_id", cloud_exadata_infrastructure_id)
        if cluster_placement_group_id and not isinstance(cluster_placement_group_id, str):
            raise TypeError("Expected argument 'cluster_placement_group_id' to be a str")
        pulumi.set(__self__, "cluster_placement_group_id", cluster_placement_group_id)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if compute_count and not isinstance(compute_count, int):
            raise TypeError("Expected argument 'compute_count' to be a int")
        pulumi.set(__self__, "compute_count", compute_count)
        if cpu_count and not isinstance(cpu_count, int):
            raise TypeError("Expected argument 'cpu_count' to be a int")
        pulumi.set(__self__, "cpu_count", cpu_count)
        if customer_contacts and not isinstance(customer_contacts, list):
            raise TypeError("Expected argument 'customer_contacts' to be a list")
        pulumi.set(__self__, "customer_contacts", customer_contacts)
        if data_storage_size_in_tbs and not isinstance(data_storage_size_in_tbs, float):
            raise TypeError("Expected argument 'data_storage_size_in_tbs' to be a float")
        pulumi.set(__self__, "data_storage_size_in_tbs", data_storage_size_in_tbs)
        if db_node_storage_size_in_gbs and not isinstance(db_node_storage_size_in_gbs, int):
            raise TypeError("Expected argument 'db_node_storage_size_in_gbs' to be a int")
        pulumi.set(__self__, "db_node_storage_size_in_gbs", db_node_storage_size_in_gbs)
        if db_server_version and not isinstance(db_server_version, str):
            raise TypeError("Expected argument 'db_server_version' to be a str")
        pulumi.set(__self__, "db_server_version", db_server_version)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if last_maintenance_run_id and not isinstance(last_maintenance_run_id, str):
            raise TypeError("Expected argument 'last_maintenance_run_id' to be a str")
        pulumi.set(__self__, "last_maintenance_run_id", last_maintenance_run_id)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if maintenance_windows and not isinstance(maintenance_windows, list):
            raise TypeError("Expected argument 'maintenance_windows' to be a list")
        pulumi.set(__self__, "maintenance_windows", maintenance_windows)
        if max_cpu_count and not isinstance(max_cpu_count, int):
            raise TypeError("Expected argument 'max_cpu_count' to be a int")
        pulumi.set(__self__, "max_cpu_count", max_cpu_count)
        if max_data_storage_in_tbs and not isinstance(max_data_storage_in_tbs, float):
            raise TypeError("Expected argument 'max_data_storage_in_tbs' to be a float")
        pulumi.set(__self__, "max_data_storage_in_tbs", max_data_storage_in_tbs)
        if max_db_node_storage_in_gbs and not isinstance(max_db_node_storage_in_gbs, int):
            raise TypeError("Expected argument 'max_db_node_storage_in_gbs' to be a int")
        pulumi.set(__self__, "max_db_node_storage_in_gbs", max_db_node_storage_in_gbs)
        if max_memory_in_gbs and not isinstance(max_memory_in_gbs, int):
            raise TypeError("Expected argument 'max_memory_in_gbs' to be a int")
        pulumi.set(__self__, "max_memory_in_gbs", max_memory_in_gbs)
        if memory_size_in_gbs and not isinstance(memory_size_in_gbs, int):
            raise TypeError("Expected argument 'memory_size_in_gbs' to be a int")
        pulumi.set(__self__, "memory_size_in_gbs", memory_size_in_gbs)
        if monthly_db_server_version and not isinstance(monthly_db_server_version, str):
            raise TypeError("Expected argument 'monthly_db_server_version' to be a str")
        pulumi.set(__self__, "monthly_db_server_version", monthly_db_server_version)
        if monthly_storage_server_version and not isinstance(monthly_storage_server_version, str):
            raise TypeError("Expected argument 'monthly_storage_server_version' to be a str")
        pulumi.set(__self__, "monthly_storage_server_version", monthly_storage_server_version)
        if next_maintenance_run_id and not isinstance(next_maintenance_run_id, str):
            raise TypeError("Expected argument 'next_maintenance_run_id' to be a str")
        pulumi.set(__self__, "next_maintenance_run_id", next_maintenance_run_id)
        if shape and not isinstance(shape, str):
            raise TypeError("Expected argument 'shape' to be a str")
        pulumi.set(__self__, "shape", shape)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if storage_count and not isinstance(storage_count, int):
            raise TypeError("Expected argument 'storage_count' to be a int")
        pulumi.set(__self__, "storage_count", storage_count)
        if storage_server_version and not isinstance(storage_server_version, str):
            raise TypeError("Expected argument 'storage_server_version' to be a str")
        pulumi.set(__self__, "storage_server_version", storage_server_version)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if total_storage_size_in_gbs and not isinstance(total_storage_size_in_gbs, int):
            raise TypeError("Expected argument 'total_storage_size_in_gbs' to be a int")
        pulumi.set(__self__, "total_storage_size_in_gbs", total_storage_size_in_gbs)

    @property
    @pulumi.getter(name="activatedStorageCount")
    def activated_storage_count(self) -> int:
        """
        The requested number of additional storage servers activated for the Exadata infrastructure.
        """
        return pulumi.get(self, "activated_storage_count")

    @property
    @pulumi.getter(name="additionalStorageCount")
    def additional_storage_count(self) -> int:
        """
        The requested number of additional storage servers for the Exadata infrastructure.
        """
        return pulumi.get(self, "additional_storage_count")

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> str:
        """
        The name of the availability domain that the cloud Exadata infrastructure resource is located in.
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter(name="availableStorageSizeInGbs")
    def available_storage_size_in_gbs(self) -> int:
        """
        The available storage can be allocated to the cloud Exadata infrastructure resource, in gigabytes (GB).
        """
        return pulumi.get(self, "available_storage_size_in_gbs")

    @property
    @pulumi.getter(name="cloudExadataInfrastructureId")
    def cloud_exadata_infrastructure_id(self) -> str:
        return pulumi.get(self, "cloud_exadata_infrastructure_id")

    @property
    @pulumi.getter(name="clusterPlacementGroupId")
    def cluster_placement_group_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cluster placement group of the Exadata Infrastructure.
        """
        return pulumi.get(self, "cluster_placement_group_id")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="computeCount")
    def compute_count(self) -> int:
        """
        The number of compute servers for the cloud Exadata infrastructure.
        """
        return pulumi.get(self, "compute_count")

    @property
    @pulumi.getter(name="cpuCount")
    def cpu_count(self) -> int:
        """
        The total number of CPU cores allocated.
        """
        return pulumi.get(self, "cpu_count")

    @property
    @pulumi.getter(name="customerContacts")
    def customer_contacts(self) -> Sequence['outputs.GetCloudExadataInfrastructureCustomerContactResult']:
        """
        The list of customer email addresses that receive information from Oracle about the specified Oracle Cloud Infrastructure Database service resource. Oracle uses these email addresses to send notifications about planned and unplanned software maintenance updates, information about system hardware, and other information needed by administrators. Up to 10 email addresses can be added to the customer contacts for a cloud Exadata infrastructure instance.
        """
        return pulumi.get(self, "customer_contacts")

    @property
    @pulumi.getter(name="dataStorageSizeInTbs")
    def data_storage_size_in_tbs(self) -> float:
        """
        Size, in terabytes, of the DATA disk group.
        """
        return pulumi.get(self, "data_storage_size_in_tbs")

    @property
    @pulumi.getter(name="dbNodeStorageSizeInGbs")
    def db_node_storage_size_in_gbs(self) -> int:
        """
        The local node storage allocated in GBs.
        """
        return pulumi.get(self, "db_node_storage_size_in_gbs")

    @property
    @pulumi.getter(name="dbServerVersion")
    def db_server_version(self) -> str:
        """
        The software version of the database servers (dom0) in the cloud Exadata infrastructure. Example: 20.1.15
        """
        return pulumi.get(self, "db_server_version")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The user-friendly name for the cloud Exadata infrastructure resource. The name does not need to be unique.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cloud Exadata infrastructure resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lastMaintenanceRunId")
    def last_maintenance_run_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the last maintenance run.
        """
        return pulumi.get(self, "last_maintenance_run_id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        Additional information about the current lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="maintenanceWindows")
    def maintenance_windows(self) -> Sequence['outputs.GetCloudExadataInfrastructureMaintenanceWindowResult']:
        """
        The scheduling details for the quarterly maintenance window. Patching and system updates take place during the maintenance window.
        """
        return pulumi.get(self, "maintenance_windows")

    @property
    @pulumi.getter(name="maxCpuCount")
    def max_cpu_count(self) -> int:
        """
        The total number of CPU cores available.
        """
        return pulumi.get(self, "max_cpu_count")

    @property
    @pulumi.getter(name="maxDataStorageInTbs")
    def max_data_storage_in_tbs(self) -> float:
        """
        The total available DATA disk group size.
        """
        return pulumi.get(self, "max_data_storage_in_tbs")

    @property
    @pulumi.getter(name="maxDbNodeStorageInGbs")
    def max_db_node_storage_in_gbs(self) -> int:
        """
        The total local node storage available in GBs.
        """
        return pulumi.get(self, "max_db_node_storage_in_gbs")

    @property
    @pulumi.getter(name="maxMemoryInGbs")
    def max_memory_in_gbs(self) -> int:
        """
        The total memory available in GBs.
        """
        return pulumi.get(self, "max_memory_in_gbs")

    @property
    @pulumi.getter(name="memorySizeInGbs")
    def memory_size_in_gbs(self) -> int:
        """
        The memory allocated in GBs.
        """
        return pulumi.get(self, "memory_size_in_gbs")

    @property
    @pulumi.getter(name="monthlyDbServerVersion")
    def monthly_db_server_version(self) -> str:
        """
        The monthly software version of the database servers (dom0) in the cloud Exadata infrastructure. Example: 20.1.15
        """
        return pulumi.get(self, "monthly_db_server_version")

    @property
    @pulumi.getter(name="monthlyStorageServerVersion")
    def monthly_storage_server_version(self) -> str:
        """
        The monthly software version of the storage servers (cells) in the cloud Exadata infrastructure. Example: 20.1.15
        """
        return pulumi.get(self, "monthly_storage_server_version")

    @property
    @pulumi.getter(name="nextMaintenanceRunId")
    def next_maintenance_run_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the next maintenance run.
        """
        return pulumi.get(self, "next_maintenance_run_id")

    @property
    @pulumi.getter
    def shape(self) -> str:
        """
        The model name of the cloud Exadata infrastructure resource.
        """
        return pulumi.get(self, "shape")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current lifecycle state of the cloud Exadata infrastructure resource.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="storageCount")
    def storage_count(self) -> int:
        """
        The number of storage servers for the cloud Exadata infrastructure.
        """
        return pulumi.get(self, "storage_count")

    @property
    @pulumi.getter(name="storageServerVersion")
    def storage_server_version(self) -> str:
        """
        The software version of the storage servers (cells) in the cloud Exadata infrastructure. Example: 20.1.15
        """
        return pulumi.get(self, "storage_server_version")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, Any]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the cloud Exadata infrastructure resource was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="totalStorageSizeInGbs")
    def total_storage_size_in_gbs(self) -> int:
        """
        The total storage allocated to the cloud Exadata infrastructure resource, in gigabytes (GB).
        """
        return pulumi.get(self, "total_storage_size_in_gbs")


class AwaitableGetCloudExadataInfrastructureResult(GetCloudExadataInfrastructureResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCloudExadataInfrastructureResult(
            activated_storage_count=self.activated_storage_count,
            additional_storage_count=self.additional_storage_count,
            availability_domain=self.availability_domain,
            available_storage_size_in_gbs=self.available_storage_size_in_gbs,
            cloud_exadata_infrastructure_id=self.cloud_exadata_infrastructure_id,
            cluster_placement_group_id=self.cluster_placement_group_id,
            compartment_id=self.compartment_id,
            compute_count=self.compute_count,
            cpu_count=self.cpu_count,
            customer_contacts=self.customer_contacts,
            data_storage_size_in_tbs=self.data_storage_size_in_tbs,
            db_node_storage_size_in_gbs=self.db_node_storage_size_in_gbs,
            db_server_version=self.db_server_version,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            last_maintenance_run_id=self.last_maintenance_run_id,
            lifecycle_details=self.lifecycle_details,
            maintenance_windows=self.maintenance_windows,
            max_cpu_count=self.max_cpu_count,
            max_data_storage_in_tbs=self.max_data_storage_in_tbs,
            max_db_node_storage_in_gbs=self.max_db_node_storage_in_gbs,
            max_memory_in_gbs=self.max_memory_in_gbs,
            memory_size_in_gbs=self.memory_size_in_gbs,
            monthly_db_server_version=self.monthly_db_server_version,
            monthly_storage_server_version=self.monthly_storage_server_version,
            next_maintenance_run_id=self.next_maintenance_run_id,
            shape=self.shape,
            state=self.state,
            storage_count=self.storage_count,
            storage_server_version=self.storage_server_version,
            system_tags=self.system_tags,
            time_created=self.time_created,
            total_storage_size_in_gbs=self.total_storage_size_in_gbs)


def get_cloud_exadata_infrastructure(cloud_exadata_infrastructure_id: Optional[str] = None,
                                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCloudExadataInfrastructureResult:
    """
    This data source provides details about a specific Cloud Exadata Infrastructure resource in Oracle Cloud Infrastructure Database service.

    Gets information about the specified cloud Exadata infrastructure resource. Applies to Exadata Cloud Service instances and Autonomous Database on dedicated Exadata infrastructure only.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_cloud_exadata_infrastructure = oci.Database.get_cloud_exadata_infrastructure(cloud_exadata_infrastructure_id=oci_database_cloud_exadata_infrastructure["test_cloud_exadata_infrastructure"]["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str cloud_exadata_infrastructure_id: The cloud Exadata infrastructure [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    __args__ = dict()
    __args__['cloudExadataInfrastructureId'] = cloud_exadata_infrastructure_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getCloudExadataInfrastructure:getCloudExadataInfrastructure', __args__, opts=opts, typ=GetCloudExadataInfrastructureResult).value

    return AwaitableGetCloudExadataInfrastructureResult(
        activated_storage_count=pulumi.get(__ret__, 'activated_storage_count'),
        additional_storage_count=pulumi.get(__ret__, 'additional_storage_count'),
        availability_domain=pulumi.get(__ret__, 'availability_domain'),
        available_storage_size_in_gbs=pulumi.get(__ret__, 'available_storage_size_in_gbs'),
        cloud_exadata_infrastructure_id=pulumi.get(__ret__, 'cloud_exadata_infrastructure_id'),
        cluster_placement_group_id=pulumi.get(__ret__, 'cluster_placement_group_id'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        compute_count=pulumi.get(__ret__, 'compute_count'),
        cpu_count=pulumi.get(__ret__, 'cpu_count'),
        customer_contacts=pulumi.get(__ret__, 'customer_contacts'),
        data_storage_size_in_tbs=pulumi.get(__ret__, 'data_storage_size_in_tbs'),
        db_node_storage_size_in_gbs=pulumi.get(__ret__, 'db_node_storage_size_in_gbs'),
        db_server_version=pulumi.get(__ret__, 'db_server_version'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        last_maintenance_run_id=pulumi.get(__ret__, 'last_maintenance_run_id'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        maintenance_windows=pulumi.get(__ret__, 'maintenance_windows'),
        max_cpu_count=pulumi.get(__ret__, 'max_cpu_count'),
        max_data_storage_in_tbs=pulumi.get(__ret__, 'max_data_storage_in_tbs'),
        max_db_node_storage_in_gbs=pulumi.get(__ret__, 'max_db_node_storage_in_gbs'),
        max_memory_in_gbs=pulumi.get(__ret__, 'max_memory_in_gbs'),
        memory_size_in_gbs=pulumi.get(__ret__, 'memory_size_in_gbs'),
        monthly_db_server_version=pulumi.get(__ret__, 'monthly_db_server_version'),
        monthly_storage_server_version=pulumi.get(__ret__, 'monthly_storage_server_version'),
        next_maintenance_run_id=pulumi.get(__ret__, 'next_maintenance_run_id'),
        shape=pulumi.get(__ret__, 'shape'),
        state=pulumi.get(__ret__, 'state'),
        storage_count=pulumi.get(__ret__, 'storage_count'),
        storage_server_version=pulumi.get(__ret__, 'storage_server_version'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        total_storage_size_in_gbs=pulumi.get(__ret__, 'total_storage_size_in_gbs'))


@_utilities.lift_output_func(get_cloud_exadata_infrastructure)
def get_cloud_exadata_infrastructure_output(cloud_exadata_infrastructure_id: Optional[pulumi.Input[str]] = None,
                                            opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetCloudExadataInfrastructureResult]:
    """
    This data source provides details about a specific Cloud Exadata Infrastructure resource in Oracle Cloud Infrastructure Database service.

    Gets information about the specified cloud Exadata infrastructure resource. Applies to Exadata Cloud Service instances and Autonomous Database on dedicated Exadata infrastructure only.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_cloud_exadata_infrastructure = oci.Database.get_cloud_exadata_infrastructure(cloud_exadata_infrastructure_id=oci_database_cloud_exadata_infrastructure["test_cloud_exadata_infrastructure"]["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str cloud_exadata_infrastructure_id: The cloud Exadata infrastructure [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    ...
