# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetExternalPluggableDatabasesResult',
    'AwaitableGetExternalPluggableDatabasesResult',
    'get_external_pluggable_databases',
    'get_external_pluggable_databases_output',
]

@pulumi.output_type
class GetExternalPluggableDatabasesResult:
    """
    A collection of values returned by getExternalPluggableDatabases.
    """
    def __init__(__self__, compartment_id=None, display_name=None, external_container_database_id=None, external_pluggable_databases=None, filters=None, id=None, state=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if external_container_database_id and not isinstance(external_container_database_id, str):
            raise TypeError("Expected argument 'external_container_database_id' to be a str")
        pulumi.set(__self__, "external_container_database_id", external_container_database_id)
        if external_pluggable_databases and not isinstance(external_pluggable_databases, list):
            raise TypeError("Expected argument 'external_pluggable_databases' to be a list")
        pulumi.set(__self__, "external_pluggable_databases", external_pluggable_databases)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        The user-friendly name for the external database. The name does not have to be unique.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="externalContainerDatabaseId")
    def external_container_database_id(self) -> Optional[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the [external container database](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/datatypes/CreateExternalContainerDatabaseDetails) that contains the specified [external pluggable database](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/datatypes/CreateExternalPluggableDatabaseDetails) resource.
        """
        return pulumi.get(self, "external_container_database_id")

    @property
    @pulumi.getter(name="externalPluggableDatabases")
    def external_pluggable_databases(self) -> Sequence['outputs.GetExternalPluggableDatabasesExternalPluggableDatabaseResult']:
        """
        The list of external_pluggable_databases.
        """
        return pulumi.get(self, "external_pluggable_databases")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetExternalPluggableDatabasesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of the Oracle Cloud Infrastructure external database resource.
        """
        return pulumi.get(self, "state")


class AwaitableGetExternalPluggableDatabasesResult(GetExternalPluggableDatabasesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetExternalPluggableDatabasesResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            external_container_database_id=self.external_container_database_id,
            external_pluggable_databases=self.external_pluggable_databases,
            filters=self.filters,
            id=self.id,
            state=self.state)


def get_external_pluggable_databases(compartment_id: Optional[str] = None,
                                     display_name: Optional[str] = None,
                                     external_container_database_id: Optional[str] = None,
                                     filters: Optional[Sequence[pulumi.InputType['GetExternalPluggableDatabasesFilterArgs']]] = None,
                                     state: Optional[str] = None,
                                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetExternalPluggableDatabasesResult:
    """
    This data source provides the list of External Pluggable Databases in Oracle Cloud Infrastructure Database service.

    Gets a list of the [ExternalPluggableDatabase](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/datatypes/CreateExternalPluggableDatabaseDetails)
    resources in the specified compartment.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_external_pluggable_databases = oci.Database.get_external_pluggable_databases(compartment_id=var["compartment_id"],
        display_name=var["external_pluggable_database_display_name"],
        external_container_database_id=oci_database_external_container_database["test_external_container_database"]["id"],
        state=var["external_pluggable_database_state"])
    ```
    <!--End PulumiCodeChooser -->


    :param str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param str display_name: A filter to return only resources that match the entire display name given. The match is not case sensitive.
    :param str external_container_database_id: The ExternalContainerDatabase [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param str state: A filter to return only resources that match the specified lifecycle state.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['externalContainerDatabaseId'] = external_container_database_id
    __args__['filters'] = filters
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getExternalPluggableDatabases:getExternalPluggableDatabases', __args__, opts=opts, typ=GetExternalPluggableDatabasesResult).value

    return AwaitableGetExternalPluggableDatabasesResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        external_container_database_id=pulumi.get(__ret__, 'external_container_database_id'),
        external_pluggable_databases=pulumi.get(__ret__, 'external_pluggable_databases'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'))


@_utilities.lift_output_func(get_external_pluggable_databases)
def get_external_pluggable_databases_output(compartment_id: Optional[pulumi.Input[str]] = None,
                                            display_name: Optional[pulumi.Input[Optional[str]]] = None,
                                            external_container_database_id: Optional[pulumi.Input[Optional[str]]] = None,
                                            filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetExternalPluggableDatabasesFilterArgs']]]]] = None,
                                            state: Optional[pulumi.Input[Optional[str]]] = None,
                                            opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetExternalPluggableDatabasesResult]:
    """
    This data source provides the list of External Pluggable Databases in Oracle Cloud Infrastructure Database service.

    Gets a list of the [ExternalPluggableDatabase](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/datatypes/CreateExternalPluggableDatabaseDetails)
    resources in the specified compartment.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_external_pluggable_databases = oci.Database.get_external_pluggable_databases(compartment_id=var["compartment_id"],
        display_name=var["external_pluggable_database_display_name"],
        external_container_database_id=oci_database_external_container_database["test_external_container_database"]["id"],
        state=var["external_pluggable_database_state"])
    ```
    <!--End PulumiCodeChooser -->


    :param str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param str display_name: A filter to return only resources that match the entire display name given. The match is not case sensitive.
    :param str external_container_database_id: The ExternalContainerDatabase [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param str state: A filter to return only resources that match the specified lifecycle state.
    """
    ...
