# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetDbManagementPrivateEndpointAssociatedDatabasesResult',
    'AwaitableGetDbManagementPrivateEndpointAssociatedDatabasesResult',
    'get_db_management_private_endpoint_associated_databases',
    'get_db_management_private_endpoint_associated_databases_output',
]

@pulumi.output_type
class GetDbManagementPrivateEndpointAssociatedDatabasesResult:
    """
    A collection of values returned by getDbManagementPrivateEndpointAssociatedDatabases.
    """
    def __init__(__self__, associated_database_collections=None, compartment_id=None, db_management_private_endpoint_id=None, filters=None, id=None):
        if associated_database_collections and not isinstance(associated_database_collections, list):
            raise TypeError("Expected argument 'associated_database_collections' to be a list")
        pulumi.set(__self__, "associated_database_collections", associated_database_collections)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if db_management_private_endpoint_id and not isinstance(db_management_private_endpoint_id, str):
            raise TypeError("Expected argument 'db_management_private_endpoint_id' to be a str")
        pulumi.set(__self__, "db_management_private_endpoint_id", db_management_private_endpoint_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter(name="associatedDatabaseCollections")
    def associated_database_collections(self) -> Sequence['outputs.GetDbManagementPrivateEndpointAssociatedDatabasesAssociatedDatabaseCollectionResult']:
        """
        The list of associated_database_collection.
        """
        return pulumi.get(self, "associated_database_collections")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the database.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="dbManagementPrivateEndpointId")
    def db_management_private_endpoint_id(self) -> str:
        return pulumi.get(self, "db_management_private_endpoint_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetDbManagementPrivateEndpointAssociatedDatabasesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")


class AwaitableGetDbManagementPrivateEndpointAssociatedDatabasesResult(GetDbManagementPrivateEndpointAssociatedDatabasesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDbManagementPrivateEndpointAssociatedDatabasesResult(
            associated_database_collections=self.associated_database_collections,
            compartment_id=self.compartment_id,
            db_management_private_endpoint_id=self.db_management_private_endpoint_id,
            filters=self.filters,
            id=self.id)


def get_db_management_private_endpoint_associated_databases(compartment_id: Optional[str] = None,
                                                            db_management_private_endpoint_id: Optional[str] = None,
                                                            filters: Optional[Sequence[pulumi.InputType['GetDbManagementPrivateEndpointAssociatedDatabasesFilterArgs']]] = None,
                                                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDbManagementPrivateEndpointAssociatedDatabasesResult:
    """
    This data source provides the list of Db Management Private Endpoint Associated Databases in Oracle Cloud Infrastructure Database Management service.

    Gets the list of databases using a specific Database Management private endpoint.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_db_management_private_endpoint_associated_databases = oci.DatabaseManagement.get_db_management_private_endpoint_associated_databases(compartment_id=var["compartment_id"],
        db_management_private_endpoint_id=oci_database_management_db_management_private_endpoint["test_db_management_private_endpoint"]["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param str db_management_private_endpoint_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Database Management private endpoint.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['dbManagementPrivateEndpointId'] = db_management_private_endpoint_id
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DatabaseManagement/getDbManagementPrivateEndpointAssociatedDatabases:getDbManagementPrivateEndpointAssociatedDatabases', __args__, opts=opts, typ=GetDbManagementPrivateEndpointAssociatedDatabasesResult).value

    return AwaitableGetDbManagementPrivateEndpointAssociatedDatabasesResult(
        associated_database_collections=pulumi.get(__ret__, 'associated_database_collections'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        db_management_private_endpoint_id=pulumi.get(__ret__, 'db_management_private_endpoint_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'))


@_utilities.lift_output_func(get_db_management_private_endpoint_associated_databases)
def get_db_management_private_endpoint_associated_databases_output(compartment_id: Optional[pulumi.Input[str]] = None,
                                                                   db_management_private_endpoint_id: Optional[pulumi.Input[str]] = None,
                                                                   filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetDbManagementPrivateEndpointAssociatedDatabasesFilterArgs']]]]] = None,
                                                                   opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDbManagementPrivateEndpointAssociatedDatabasesResult]:
    """
    This data source provides the list of Db Management Private Endpoint Associated Databases in Oracle Cloud Infrastructure Database Management service.

    Gets the list of databases using a specific Database Management private endpoint.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_db_management_private_endpoint_associated_databases = oci.DatabaseManagement.get_db_management_private_endpoint_associated_databases(compartment_id=var["compartment_id"],
        db_management_private_endpoint_id=oci_database_management_db_management_private_endpoint["test_db_management_private_endpoint"]["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param str db_management_private_endpoint_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Database Management private endpoint.
    """
    ...
