# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetCatalogTypeResult',
    'AwaitableGetCatalogTypeResult',
    'get_catalog_type',
    'get_catalog_type_output',
]

@pulumi.output_type
class GetCatalogTypeResult:
    """
    A collection of values returned by getCatalogType.
    """
    def __init__(__self__, catalog_id=None, description=None, external_type_name=None, fields=None, id=None, is_approved=None, is_internal=None, is_tag=None, key=None, name=None, properties=None, state=None, type_category=None, type_key=None, uri=None):
        if catalog_id and not isinstance(catalog_id, str):
            raise TypeError("Expected argument 'catalog_id' to be a str")
        pulumi.set(__self__, "catalog_id", catalog_id)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if external_type_name and not isinstance(external_type_name, str):
            raise TypeError("Expected argument 'external_type_name' to be a str")
        pulumi.set(__self__, "external_type_name", external_type_name)
        if fields and not isinstance(fields, list):
            raise TypeError("Expected argument 'fields' to be a list")
        pulumi.set(__self__, "fields", fields)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_approved and not isinstance(is_approved, bool):
            raise TypeError("Expected argument 'is_approved' to be a bool")
        pulumi.set(__self__, "is_approved", is_approved)
        if is_internal and not isinstance(is_internal, bool):
            raise TypeError("Expected argument 'is_internal' to be a bool")
        pulumi.set(__self__, "is_internal", is_internal)
        if is_tag and not isinstance(is_tag, bool):
            raise TypeError("Expected argument 'is_tag' to be a bool")
        pulumi.set(__self__, "is_tag", is_tag)
        if key and not isinstance(key, str):
            raise TypeError("Expected argument 'key' to be a str")
        pulumi.set(__self__, "key", key)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if properties and not isinstance(properties, dict):
            raise TypeError("Expected argument 'properties' to be a dict")
        pulumi.set(__self__, "properties", properties)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if type_category and not isinstance(type_category, str):
            raise TypeError("Expected argument 'type_category' to be a str")
        pulumi.set(__self__, "type_category", type_category)
        if type_key and not isinstance(type_key, str):
            raise TypeError("Expected argument 'type_key' to be a str")
        pulumi.set(__self__, "type_key", type_key)
        if uri and not isinstance(uri, str):
            raise TypeError("Expected argument 'uri' to be a str")
        pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> str:
        """
        The data catalog's OCID.
        """
        return pulumi.get(self, "catalog_id")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Detailed description of the type.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="externalTypeName")
    def external_type_name(self) -> str:
        """
        Mapping type equivalence in the external system.
        """
        return pulumi.get(self, "external_type_name")

    @property
    @pulumi.getter
    def fields(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "fields")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isApproved")
    def is_approved(self) -> bool:
        """
        Indicates whether the type is approved for use as a classifying object.
        """
        return pulumi.get(self, "is_approved")

    @property
    @pulumi.getter(name="isInternal")
    def is_internal(self) -> bool:
        """
        Indicates whether the type is internal, making it unavailable for use by metadata elements.
        """
        return pulumi.get(self, "is_internal")

    @property
    @pulumi.getter(name="isTag")
    def is_tag(self) -> bool:
        """
        Indicates whether the type can be used for tagging metadata elements.
        """
        return pulumi.get(self, "is_tag")

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Unique type key that is immutable.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The immutable name of the type.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def properties(self) -> Mapping[str, Any]:
        """
        A map of arrays which defines the type specific properties, both required and optional. The map keys are category names and the values are arrays contiaing all property details. Every property is contained inside of a category. Most types have required properties within the "default" category. Example: `{ "properties": { "default": { "attributes:": [ { "name": "host", "type": "string", "isRequired": true, "isUpdatable": false }, ... ] } } }`
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the type.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="typeCategory")
    def type_category(self) -> str:
        """
        Indicates the category this type belongs to. For instance, data assets, connections.
        """
        return pulumi.get(self, "type_category")

    @property
    @pulumi.getter(name="typeKey")
    def type_key(self) -> str:
        return pulumi.get(self, "type_key")

    @property
    @pulumi.getter
    def uri(self) -> str:
        """
        URI to the type instance in the API.
        """
        return pulumi.get(self, "uri")


class AwaitableGetCatalogTypeResult(GetCatalogTypeResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCatalogTypeResult(
            catalog_id=self.catalog_id,
            description=self.description,
            external_type_name=self.external_type_name,
            fields=self.fields,
            id=self.id,
            is_approved=self.is_approved,
            is_internal=self.is_internal,
            is_tag=self.is_tag,
            key=self.key,
            name=self.name,
            properties=self.properties,
            state=self.state,
            type_category=self.type_category,
            type_key=self.type_key,
            uri=self.uri)


def get_catalog_type(catalog_id: Optional[str] = None,
                     fields: Optional[Sequence[str]] = None,
                     type_key: Optional[str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCatalogTypeResult:
    """
    This data source provides details about a specific Catalog Type resource in Oracle Cloud Infrastructure Data Catalog service.

    Gets a specific type by key within a data catalog.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_catalog_type = oci.DataCatalog.get_catalog_type(catalog_id=oci_datacatalog_catalog["test_catalog"]["id"],
        type_key=var["catalog_type_type_key"],
        fields=var["catalog_type_fields"])
    ```
    <!--End PulumiCodeChooser -->


    :param str catalog_id: Unique catalog identifier.
    :param Sequence[str] fields: Specifies the fields to return in a type response.
    :param str type_key: Unique type key.
    """
    __args__ = dict()
    __args__['catalogId'] = catalog_id
    __args__['fields'] = fields
    __args__['typeKey'] = type_key
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataCatalog/getCatalogType:getCatalogType', __args__, opts=opts, typ=GetCatalogTypeResult).value

    return AwaitableGetCatalogTypeResult(
        catalog_id=pulumi.get(__ret__, 'catalog_id'),
        description=pulumi.get(__ret__, 'description'),
        external_type_name=pulumi.get(__ret__, 'external_type_name'),
        fields=pulumi.get(__ret__, 'fields'),
        id=pulumi.get(__ret__, 'id'),
        is_approved=pulumi.get(__ret__, 'is_approved'),
        is_internal=pulumi.get(__ret__, 'is_internal'),
        is_tag=pulumi.get(__ret__, 'is_tag'),
        key=pulumi.get(__ret__, 'key'),
        name=pulumi.get(__ret__, 'name'),
        properties=pulumi.get(__ret__, 'properties'),
        state=pulumi.get(__ret__, 'state'),
        type_category=pulumi.get(__ret__, 'type_category'),
        type_key=pulumi.get(__ret__, 'type_key'),
        uri=pulumi.get(__ret__, 'uri'))


@_utilities.lift_output_func(get_catalog_type)
def get_catalog_type_output(catalog_id: Optional[pulumi.Input[str]] = None,
                            fields: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                            type_key: Optional[pulumi.Input[str]] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetCatalogTypeResult]:
    """
    This data source provides details about a specific Catalog Type resource in Oracle Cloud Infrastructure Data Catalog service.

    Gets a specific type by key within a data catalog.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_catalog_type = oci.DataCatalog.get_catalog_type(catalog_id=oci_datacatalog_catalog["test_catalog"]["id"],
        type_key=var["catalog_type_type_key"],
        fields=var["catalog_type_fields"])
    ```
    <!--End PulumiCodeChooser -->


    :param str catalog_id: Unique catalog identifier.
    :param Sequence[str] fields: Specifies the fields to return in a type response.
    :param str type_key: Unique type key.
    """
    ...
