# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetAlertPolicyRulesResult',
    'AwaitableGetAlertPolicyRulesResult',
    'get_alert_policy_rules',
    'get_alert_policy_rules_output',
]

@pulumi.output_type
class GetAlertPolicyRulesResult:
    """
    A collection of values returned by getAlertPolicyRules.
    """
    def __init__(__self__, alert_policy_id=None, alert_policy_rule_collections=None, filters=None, id=None):
        if alert_policy_id and not isinstance(alert_policy_id, str):
            raise TypeError("Expected argument 'alert_policy_id' to be a str")
        pulumi.set(__self__, "alert_policy_id", alert_policy_id)
        if alert_policy_rule_collections and not isinstance(alert_policy_rule_collections, list):
            raise TypeError("Expected argument 'alert_policy_rule_collections' to be a list")
        pulumi.set(__self__, "alert_policy_rule_collections", alert_policy_rule_collections)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter(name="alertPolicyId")
    def alert_policy_id(self) -> str:
        return pulumi.get(self, "alert_policy_id")

    @property
    @pulumi.getter(name="alertPolicyRuleCollections")
    def alert_policy_rule_collections(self) -> Sequence['outputs.GetAlertPolicyRulesAlertPolicyRuleCollectionResult']:
        """
        The list of alert_policy_rule_collection.
        """
        return pulumi.get(self, "alert_policy_rule_collections")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetAlertPolicyRulesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")


class AwaitableGetAlertPolicyRulesResult(GetAlertPolicyRulesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAlertPolicyRulesResult(
            alert_policy_id=self.alert_policy_id,
            alert_policy_rule_collections=self.alert_policy_rule_collections,
            filters=self.filters,
            id=self.id)


def get_alert_policy_rules(alert_policy_id: Optional[str] = None,
                           filters: Optional[Sequence[pulumi.InputType['GetAlertPolicyRulesFilterArgs']]] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAlertPolicyRulesResult:
    """
    This data source provides the list of Alert Policy Rules in Oracle Cloud Infrastructure Data Safe service.

    Lists the rules of the specified alert policy. The alert policy is said to be satisfied when all rules in the policy evaulate to true.
    If there are three rules: rule1,rule2 and rule3, the policy is satisfied if rule1 AND rule2 AND rule3 is True.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_alert_policy_rules = oci.DataSafe.get_alert_policy_rules(alert_policy_id=oci_data_safe_alert_policy["test_alert_policy"]["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str alert_policy_id: The OCID of the alert policy.
    """
    __args__ = dict()
    __args__['alertPolicyId'] = alert_policy_id
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataSafe/getAlertPolicyRules:getAlertPolicyRules', __args__, opts=opts, typ=GetAlertPolicyRulesResult).value

    return AwaitableGetAlertPolicyRulesResult(
        alert_policy_id=pulumi.get(__ret__, 'alert_policy_id'),
        alert_policy_rule_collections=pulumi.get(__ret__, 'alert_policy_rule_collections'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'))


@_utilities.lift_output_func(get_alert_policy_rules)
def get_alert_policy_rules_output(alert_policy_id: Optional[pulumi.Input[str]] = None,
                                  filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetAlertPolicyRulesFilterArgs']]]]] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAlertPolicyRulesResult]:
    """
    This data source provides the list of Alert Policy Rules in Oracle Cloud Infrastructure Data Safe service.

    Lists the rules of the specified alert policy. The alert policy is said to be satisfied when all rules in the policy evaulate to true.
    If there are three rules: rule1,rule2 and rule3, the policy is satisfied if rule1 AND rule2 AND rule3 is True.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_alert_policy_rules = oci.DataSafe.get_alert_policy_rules(alert_policy_id=oci_data_safe_alert_policy["test_alert_policy"]["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str alert_policy_id: The OCID of the alert policy.
    """
    ...
